/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.FieldType;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.realspace.spatialanalyst.GridMatchAnalystNative;
import com.supermap.realspace.spatialanalyst.InternalDatasetGrid;
import com.supermap.realspace.spatialanalyst.InternalDatasets;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import java.util.ArrayList;
import java.util.Vector;

public class GridMatchAnalyst {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private GridMatchAnalyst() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static DatasetGrid gridMatch(DatasetGrid sourceDatasetGrid, DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, String altiFieldName, double radius, double exp) {
        Object object;
        long l;
        GridMatchAnalyst.verifyLicense();
        if (null == sourceDatasetGrid) {
            String string = InternalResource.loadString("sourceDatasetGrid", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetGrid);
        if (null == sourceDatasetVector) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        if (null == targetDatasource) {
            targetDatasource = sourceDatasetGrid.getDatasource();
        }
        if (0L == (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource))) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "Global_DatasetNameInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!altiFieldName.isEmpty()) {
            if (sourceDatasetVector.getFieldInfos().indexOf(altiFieldName) == -1) {
                String string = InternalResource.loadString("altiFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst3d_resources");
                throw new IllegalArgumentException(string);
            }
            object = sourceDatasetVector.getFieldInfos().get(altiFieldName);
            if (object == null || object.getType() != FieldType.DOUBLE && object.getType() != FieldType.INT16 && object.getType() != FieldType.INT32 && object.getType() != FieldType.SINGLE) {
                String string = InternalResource.loadString("altiFieldName", "GridMatch_UnsupportedFieldType", "spatialanalyst3d_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (radius < 0.0) {
            radius = 0.0;
        }
        if (exp < 0.0) {
            object = InternalResource.loadString("exp", "GridMatch_ArgumentOutOfRange", "spatialanalyst3d_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = null;
        long l4 = GridMatchAnalystNative.jni_GridMatch(l2, l3, l, targetDatasetName, altiFieldName, radius, exp);
        if (l4 != 0L) {
            object = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)object);
        }
        return object;
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "GridMatch";
        boolean bl = InternalToolkitSpatialAnalyst3D.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        GridMatchAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst3D.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

