/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.tilestorage;

import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.tilestorage.InternalEnum;
import com.supermap.tilestorage.InternalResource;
import com.supermap.tilestorage.TileContent;
import com.supermap.tilestorage.TileContentInfo;
import com.supermap.tilestorage.TileStorageConnection;
import com.supermap.tilestorage.TileStorageInfo;
import com.supermap.tilestorage.TileStorageManagerNative;
import com.supermap.tilestorage.TileStorageMiniInfo;
import com.supermap.tilestorage.TileStorageType;
import com.supermap.tilestorage.TileVersion;

public class TileStorageManager
extends InternalHandleDisposable {
    private long m_HandleTileStorage = 0L;
    private String m_Connection = "";
    private long m_HandleTileStorageInfo = 0L;

    public long getTileStorageHandle() {
        return this.m_HandleTileStorage;
    }

    public boolean create(TileStorageConnection conn) {
        if (this.m_HandleTileStorageInfo == 0L) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        if (conn == null) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[]{this.m_HandleTileStorage, this.m_HandleTileStorageInfo};
        if (TileStorageManagerNative.jni_Create(lArray, InternalHandle.getHandle((InternalHandle)conn))) {
            this.m_HandleTileStorage = lArray[0];
            return true;
        }
        if (lArray[0] != 0L) {
            this.m_HandleTileStorage = lArray[0];
        }
        return false;
    }

    public static boolean createTileStorage(TileStorageConnection conn) {
        if (conn == null) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)conn);
        if (l == 0L) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileStorageManagerNative.jni_Create2(l);
    }

    public boolean createTileVersion(TileVersion tileversion) {
        if (this.m_HandleTileStorage == 0L) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[]{this.m_HandleTileStorage, this.m_HandleTileStorageInfo};
        if (TileStorageManagerNative.jni_CreateVersion(lArray, InternalHandle.getHandle((InternalHandle)tileversion))) {
            this.m_HandleTileStorage = lArray[0];
            return true;
        }
        if (lArray[0] != 0L) {
            this.m_HandleTileStorage = lArray[0];
        }
        return false;
    }

    public boolean open(TileStorageConnection conn) {
        if (conn == null) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[]{this.m_HandleTileStorage};
        if (TileStorageManagerNative.jni_Open(lArray, InternalHandle.getHandle((InternalHandle)conn))) {
            this.m_HandleTileStorage = lArray[0];
            return true;
        }
        if (lArray[0] != 0L) {
            this.m_HandleTileStorage = lArray[0];
        }
        return false;
    }

    public boolean isOpen() {
        return TileStorageManagerNative.jni_IsOpen(this.m_HandleTileStorage);
    }

    public boolean close() {
        return TileStorageManagerNative.jni_Close(this.m_HandleTileStorage);
    }

    public boolean saveTile(int level, int row, int col, TileContent tileContent) {
        if (this.m_HandleTileStorage == 0L) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileStorageManagerNative.jni_SaveTile(this.m_HandleTileStorage, level, row, col, InternalHandle.getHandle((InternalHandle)tileContent));
    }

    public boolean saveTile(TileContentInfo info, TileContent tileContent) {
        if (this.m_HandleTileStorage == 0L) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileStorageManagerNative.jni_SaveTileVersion(this.m_HandleTileStorage, InternalHandle.getHandle((InternalHandle)info), InternalHandle.getHandle((InternalHandle)tileContent));
    }

    public TileContent loadTile(int level, int row, int column) {
        if (this.m_HandleTileStorage == 0L) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        long l = TileStorageManagerNative.jni_LoadTile(this.m_HandleTileStorage, level, row, column);
        if (l == 0L) {
            return null;
        }
        return new TileContent(l);
    }

    public TileContent loadTile(TileContentInfo info) {
        if (this.m_HandleTileStorage == 0L) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        long l = TileStorageManagerNative.jni_LoadTileVersion(this.m_HandleTileStorage, InternalHandle.getHandle((InternalHandle)info));
        if (l == 0L) {
            return null;
        }
        return new TileContent(l);
    }

    public boolean AppendTileVersionInfo(double[] resolutions, double[] bounds, String VersionName) {
        if (this.m_HandleTileStorage == 0L) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileStorageManagerNative.jni_AppendTileVersion(this.m_HandleTileStorage, resolutions, resolutions.length, bounds, VersionName);
    }

    public boolean saveData(String key, TileContent tileContent) {
        if (this.m_HandleTileStorage == 0L) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileStorageManagerNative.jni_SaveData(this.m_HandleTileStorage, key, InternalHandle.getHandle((InternalHandle)tileContent));
    }

    public TileContent loadData(String key) {
        if (this.m_HandleTileStorage == 0L) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        long l = TileStorageManagerNative.jni_LoadData(this.m_HandleTileStorage, key);
        if (l == 0L) {
            return null;
        }
        return new TileContent(l);
    }

    public TileStorageInfo getInfo() {
        if (this.m_HandleTileStorage == 0L) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        long l = TileStorageManagerNative.jni_GetInfo(this.m_HandleTileStorage);
        if (l == 0L) {
            return null;
        }
        return new TileStorageInfo(l);
    }

    public boolean updateInfo(TileStorageInfo storageInfo) {
        if (storageInfo == null) {
            String string = InternalResource.loadString("UpdateInfo()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[]{this.m_HandleTileStorage, this.m_HandleTileStorageInfo};
        if (TileStorageManagerNative.jni_UpdateInfo(lArray, InternalHandle.getHandle((InternalHandle)storageInfo))) {
            this.m_HandleTileStorageInfo = lArray[1];
            return true;
        }
        this.m_HandleTileStorageInfo = lArray[1];
        return false;
    }

    public String[] getTileStorageNames(TileStorageConnection conn) {
        if (conn == null) {
            String string = InternalResource.loadString("getTileStorageNames()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileStorageManagerNative.jni_GetTileStorageNames(InternalHandle.getHandle((InternalHandle)conn));
    }

    public static TileStorageMiniInfo[] getMongoTileStorageMiniInfo(String server, String database, String user, String password) {
        long[] lArray = new long[1];
        int n = TileStorageManagerNative.jni_GetMGTSMiniInfoCount(server, database, user, password, lArray);
        int[] nArray = new int[n];
        String[] stringArray = new String[n];
        TileStorageManagerNative.jni_GetMGTSMiniInfo(lArray[0], nArray, stringArray);
        TileStorageMiniInfo[] tileStorageMiniInfoArray = new TileStorageMiniInfo[n];
        for (int i = 0; i < n; ++i) {
            tileStorageMiniInfoArray[i] = new TileStorageMiniInfo();
            tileStorageMiniInfoArray[i].setStorageType((TileStorageType)InternalEnum.parseUGCValue(TileStorageType.class, nArray[i]));
            tileStorageMiniInfoArray[i].setName(stringArray[i]);
        }
        return tileStorageMiniInfoArray;
    }

    public TileVersion[] getVersions() {
        if (this.m_HandleTileStorage == 0L) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = TileStorageManagerNative.jni_GetVersions(this.m_HandleTileStorage);
        if (lArray == null) {
            return null;
        }
        TileVersion[] tileVersionArray = new TileVersion[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            tileVersionArray[i] = TileVersion.createInstance(lArray[i]);
        }
        return tileVersionArray;
    }

    public static String[] getOSGTilesetNames(TileStorageConnection conn) {
        if (conn == null) {
            String string = InternalResource.loadString("TileStorageManager", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalArgumentException(string);
        }
        return TileStorageManagerNative.jni_GetOSGTilesetNames(InternalHandle.getHandle((InternalHandle)conn));
    }

    public static boolean deleteTileStorage(TileStorageConnection conn) {
        if (conn == null) {
            String string = InternalResource.loadString("deleteTileStorage(TileStorageConnection)", "Global_OwnerHasBeenDisposed", "tilestorage_resources");
            throw new IllegalArgumentException(string);
        }
        return TileStorageManagerNative.jni_DeleteTileStorage(InternalHandle.getHandle((InternalHandle)conn));
    }

    public String getConnectInfo() {
        return this.m_Connection;
    }

    public void dispose() {
    }
}

