/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.tilestorage;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.tilestorage.InternalResource;
import com.supermap.tilestorage.TileContentNative;

public class TileContent
extends InternalHandleDisposable {
    TileContent(long handle) {
        this.setHandle(handle, true);
    }

    public TileContent() {
        long l = TileContentNative.jni_New();
        this.setHandle(l, true);
    }

    public TileContent(byte[] data) {
        long l = TileContentNative.jni_New();
        this.setHandle(l, true);
        int n = data.length;
        TileContentNative.jni_SetData(this.getHandle(), data, n);
    }

    public String getKey() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getKey()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileContentNative.jni_GetKey(this.getHandle());
    }

    public void setKey(String key) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setKey()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        TileContentNative.jni_SetKey(this.getHandle(), key);
    }

    public byte[] getData() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getData()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileContentNative.jni_GetData(this.getHandle());
    }

    public void setData(byte[] data) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setData()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        if (data == null) {
            String string = InternalResource.loadString("setData()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalArgumentException(string);
        }
        int n = data.length;
        TileContentNative.jni_SetData(this.getHandle(), data, n);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "tilestorage_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TileContentNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }
}

