/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.NetworkEdge;
import com.supermap.analyst.spatialanalyst.NetworkEdgeID;
import com.supermap.analyst.spatialanalyst.NetworkNode;
import com.supermap.analyst.spatialanalyst.TopologicalSchemaNative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;

public abstract class TopologicalSchema
extends InternalHandleDisposable {
    private Datasource m_outputDatasource = null;
    private String m_strOupputDatasetName = null;

    protected TopologicalSchema() {
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "spatialanalyst_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TopologicalSchemaNative.jni_DeleteHandle(this.getHandle());
            this.clearHandle();
        }
    }

    public Datasource getOutputDatasource() {
        return this.m_outputDatasource;
    }

    public void setOutputDatasource(Datasource value) {
        if (value == null) {
            String string = InternalResource.loadString("setOutputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("setOutputDatasource()", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_outputDatasource = value;
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)value);
        TopologicalSchemaNative.jni_SetOuptputDatasource(l, l2);
    }

    public String getOutputDatasetName() {
        return this.m_strOupputDatasetName;
    }

    public void setOutputDatasetName(String value) {
        if (value == null) {
            String string = InternalResource.loadString("setOutputDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("setOutputDatasetName()", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_strOupputDatasetName = value;
        TopologicalSchemaNative.jni_SetOutputDatasetName(l, value);
    }

    public DatasetVector build(NetworkEdgeID[] networkEdgeIDs) {
        if (networkEdgeIDs == null || networkEdgeIDs.length < 1) {
            String string = InternalResource.loadString("networkEdgeIDs", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < networkEdgeIDs.length; ++i) {
            if (networkEdgeIDs[i] != null) continue;
            String string = String.format("networkEdgeIDs[%d]", i);
            String string2 = InternalResource.loadString(string, "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (this.m_outputDatasource == null) {
            String string = InternalResource.loadString("m_outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (this.m_strOupputDatasetName == null) {
            String string = InternalResource.loadString("m_strOupputDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!this.m_outputDatasource.getDatasets().isAvailableDatasetName(this.m_strOupputDatasetName)) {
            String string = InternalResource.loadString("m_strOupputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[networkEdgeIDs.length];
        int[] nArray2 = new int[networkEdgeIDs.length];
        int[] nArray3 = new int[networkEdgeIDs.length];
        for (int i = 0; i < networkEdgeIDs.length; ++i) {
            nArray[i] = networkEdgeIDs[i].getEdgeID();
            nArray2[i] = networkEdgeIDs[i].getFromNodeID();
            nArray3[i] = networkEdgeIDs[i].getToNodeID();
        }
        String[] stringArray = new String[1];
        long l2 = TopologicalSchemaNative.jni_Build1(l, nArray, nArray2, nArray3, stringArray);
        DatasetVector datasetVector = null;
        if (l2 > 0L) {
            datasetVector = InternalDatasetVector.createInstance(l2, this.m_outputDatasource);
            InternalDatasets.add(this.m_outputDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return datasetVector;
    }

    public DatasetVector build(DatasetVector networkDataset) {
        if (this.m_outputDatasource == null) {
            String string = InternalResource.loadString("m_outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (this.m_strOupputDatasetName == null) {
            String string = InternalResource.loadString("m_strOupputDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!this.m_outputDatasource.getDatasets().isAvailableDatasetName(this.m_strOupputDatasetName)) {
            String string = InternalResource.loadString("m_strOupputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (networkDataset == null) {
            String string = InternalResource.loadString("networkDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (networkDataset.getType() != DatasetType.NETWORK) {
            String string = InternalResource.loadString("networkDataset", "DatasetTypeMustBeNetwork", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)networkDataset);
        String[] stringArray = new String[1];
        long l3 = TopologicalSchemaNative.jni_Build2(l, l2, stringArray);
        DatasetVector datasetVector = null;
        if (l3 > 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, this.m_outputDatasource);
            InternalDatasets.add(this.m_outputDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return datasetVector;
    }

    public DatasetVector build(NetworkEdge[] networkEdges, NetworkNode[] networkNodes, boolean isMerge, double tolerance) {
        int n;
        if (networkEdges == null || networkEdges.length < 1) {
            String string = InternalResource.loadString("networkEdges", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "MustEqualsOrGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < networkEdges.length; ++n) {
            if (networkEdges[n] == null) {
                String string = String.format("networkEdges[%d]", n);
                String string2 = InternalResource.loadString(string, "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string2);
            }
            if (networkEdges[n].getEdge() == null) {
                String string = String.format("networkEdges[%d].getEdge", n);
                String string3 = InternalResource.loadString(string, "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            if (networkEdges[n].getEdge().getType() == GeometryType.GEOLINE) continue;
            String string = String.format("networkEdges[%d].getEdge", n);
            String string4 = InternalResource.loadString(string, "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (networkNodes == null || networkNodes.length < 1) {
            String string = InternalResource.loadString("networkNodes", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        for (n = 0; n < networkNodes.length; ++n) {
            if (networkNodes[n] != null) continue;
            String string = String.format("networkNodes[%d]", n);
            String string5 = InternalResource.loadString(string, "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (this.m_outputDatasource == null) {
            String string = InternalResource.loadString("m_outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (this.m_strOupputDatasetName == null) {
            String string = InternalResource.loadString("m_strOupputDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!this.m_outputDatasource.getDatasets().isAvailableDatasetName(this.m_strOupputDatasetName)) {
            String string = InternalResource.loadString("m_strOupputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = this.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[networkEdges.length];
        int[] nArray2 = new int[networkEdges.length];
        int[] nArray3 = new int[networkEdges.length];
        long[] lArray = new long[networkEdges.length];
        for (int i = 0; i < networkEdges.length; ++i) {
            nArray[i] = networkEdges[i].getNetworkEdgeID().getEdgeID();
            nArray2[i] = networkEdges[i].getNetworkEdgeID().getFromNodeID();
            nArray3[i] = networkEdges[i].getNetworkEdgeID().getToNodeID();
            lArray[i] = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)networkEdges[i].getEdge());
        }
        int[] nArray4 = new int[networkNodes.length];
        long[] lArray2 = new long[networkNodes.length];
        for (int i = 0; i < networkNodes.length; ++i) {
            nArray4[i] = networkNodes[i].getNodeID();
            lArray2[i] = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)networkNodes[i].getNode());
        }
        String[] stringArray = new String[1];
        long l2 = TopologicalSchemaNative.jni_Build3(l, nArray, nArray2, nArray3, lArray, nArray4, lArray2, isMerge, tolerance, stringArray);
        DatasetVector datasetVector = null;
        if (l2 > 0L) {
            datasetVector = InternalDatasetVector.createInstance(l2, this.m_outputDatasource);
            InternalDatasets.add(this.m_outputDatasource.getDatasets(), (Dataset)datasetVector);
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return datasetVector;
    }
}

