/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.TerrainBuilderNative;
import com.supermap.analyst.spatialanalyst.TerrainBuilderParameter;
import com.supermap.analyst.spatialanalyst.TerrainInterpolateType;
import com.supermap.analyst.spatialanalyst.TerrainStatisticType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.PixelFormat;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class TerrainBuilder {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private TerrainBuilder() {
    }

    @Deprecated
    public static DatasetGrid buildTerrain(DatasetVector sourceDatasetVector, String altitudeField, TerrainInterpolateType terrainInterpolateType, TerrainStatisticType terrainStatisticType, double cellSize, double zFactor, PixelFormat pixelFormat, EncodeType enCodeType, Datasource outputDatasource, String outputDatasetName) {
        TerrainBuilder.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource) == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        int n = InternalEnum.getUGCValue(terrainInterpolateType);
        int n2 = InternalEnum.getUGCValue(terrainStatisticType);
        int n3 = InternalEnum.getUGCValue((Enum)pixelFormat);
        int n4 = InternalEnum.getUGCValue((Enum)enCodeType);
        long l3 = TerrainBuilderNative.jni_BuildTerrain(l, altitudeField, n, n2, cellSize, zFactor, n3, n4, false, l2, outputDatasetName);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    @Deprecated
    public static DatasetGrid buildTerrain(DatasetVector sourcePointDataset, String altitudePointField, DatasetVector sourceLineDataset, String altitudeLineField, TerrainInterpolateType terrainInterpolateType, TerrainStatisticType terrainStatisticType, double cellSize, double zFactor, PixelFormat pixelFormat, EncodeType enCodeType, Datasource outputDatasource, String outputDatasetName) {
        TerrainBuilder.verifyLicense();
        if (sourceLineDataset == null && sourcePointDataset == null) {
            String string = InternalResource.loadString("sourcePointDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourcePointDataset != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)sourcePointDataset) == 0L) {
            String string = InternalResource.loadString("sourcePointDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceLineDataset != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceLineDataset) == 0L) {
            String string = InternalResource.loadString("sourceLineDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource) == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        long l2 = 0L;
        if (sourcePointDataset != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourcePointDataset);
        }
        if (sourceLineDataset != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceLineDataset);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        int n = InternalEnum.getUGCValue(terrainInterpolateType);
        int n2 = InternalEnum.getUGCValue(terrainStatisticType);
        int n3 = InternalEnum.getUGCValue((Enum)pixelFormat);
        int n4 = InternalEnum.getUGCValue((Enum)enCodeType);
        long[] lArray = null;
        long[] lArray2 = null;
        if (l != 0L) {
            lArray = new long[]{l};
        } else {
            lArray = new long[]{};
            if (altitudePointField != null) {
                altitudePointField = "";
            }
        }
        if (l2 != 0L) {
            lArray2 = new long[]{l2};
        } else {
            lArray2 = new long[]{};
            if (altitudeLineField != null) {
                altitudeLineField = "";
            }
        }
        long l4 = TerrainBuilderNative.jni_BuilTerrain2(lArray, altitudePointField, lArray2, altitudeLineField, 0L, 0L, 0L, null, n, n2, cellSize, 0.0, zFactor, l3, outputDatasetName, n3, n4, false);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static DatasetGrid buildTerrain(TerrainBuilderParameter parameter, Datasource targetDatasource, String targetDatasetName) {
        int n;
        TerrainBuilder.verifyLicense();
        int n2 = 0;
        String[] stringArray = parameter.getPointAltitudeFileds();
        String[] stringArray2 = parameter.getLineAltitudeFileds();
        if (!(stringArray != null && stringArray.length != 0 || stringArray2 != null && stringArray2.length != 0)) {
            String string = InternalResource.loadString("Altitude Fields", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        DatasetVector[] datasetVectorArray = parameter.getPointDatasets();
        DatasetVector[] datasetVectorArray2 = parameter.getLineDatasets();
        if (!(datasetVectorArray != null && datasetVectorArray.length != 0 || datasetVectorArray2 != null && datasetVectorArray2.length != 0)) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (datasetVectorArray != null) {
            if (datasetVectorArray.length != stringArray.length) {
                String string = InternalResource.loadString("sourceDataset", "Count_of_Vector_Not_Equal_Count_of_Field", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            for (n2 = 0; n2 < datasetVectorArray.length; ++n2) {
                if (datasetVectorArray[n2] == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray[n2]) == 0L) {
                    String string = InternalResource.loadString("pntDatasets", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new NullPointerException(string);
                }
                if (stringArray[n2] != null && !stringArray[n2].isEmpty()) continue;
                String string = InternalResource.loadString("PointAltitudeFiled", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (datasetVectorArray2 != null) {
            if (datasetVectorArray2.length != stringArray2.length) {
                String string = InternalResource.loadString("sourceDataset", "Count_of_Vector_Not_Equal_Count_of_Field", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            for (n2 = 0; n2 < datasetVectorArray2.length; ++n2) {
                if (datasetVectorArray2[n2] == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray2[n2]) == 0L) {
                    String string = InternalResource.loadString("lineDatasets", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new NullPointerException(string);
                }
                if (stringArray2[n2] != null && !stringArray2[n2].isEmpty()) continue;
                String string = InternalResource.loadString("LineAltitudeFiled", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVectorArray2 == null) {
            for (n2 = 0; n2 < datasetVectorArray.length; ++n2) {
                for (n = n2 + 1; n < datasetVectorArray.length; ++n) {
                    if (datasetVectorArray[n2].getPrjCoordSys().getType() == datasetVectorArray[n].getPrjCoordSys().getType()) continue;
                    String string = InternalResource.loadString("PointDatasets", "GeoCoordSys_MustNotBe_Different", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
            }
        } else {
            for (n2 = 0; n2 < datasetVectorArray2.length; ++n2) {
                for (n = n2 + 1; n < datasetVectorArray2.length; ++n) {
                    if (datasetVectorArray2[n2].getPrjCoordSys().getType() == datasetVectorArray2[n].getPrjCoordSys().getType()) continue;
                    String string = InternalResource.loadString("LineDatasets", "GeoCoordSys_MustNotBe_Different", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                if (datasetVectorArray == null) continue;
                for (n = 0; n < datasetVectorArray.length; ++n) {
                    if (datasetVectorArray2[n2].getPrjCoordSys().getType() == datasetVectorArray[n].getPrjCoordSys().getType()) continue;
                    String string = InternalResource.loadString("LineDatasets,PointDatasets", "GeoCoordSys_MustNotBe_Different", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
            }
        }
        String string = "";
        String string2 = "";
        long[] lArray = null;
        if (datasetVectorArray2 != null) {
            lArray = new long[datasetVectorArray2.length];
            for (n2 = 0; n2 < datasetVectorArray2.length; ++n2) {
                lArray[n2] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray2[n2]);
                string = string + stringArray2[n2] + ",";
            }
        } else {
            lArray = new long[]{};
        }
        long[] lArray2 = null;
        if (datasetVectorArray != null) {
            lArray2 = new long[datasetVectorArray.length];
            for (n2 = 0; n2 < datasetVectorArray.length; ++n2) {
                lArray2[n2] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectorArray[n2]);
                string2 = string2 + stringArray[n2] + ",";
            }
        } else {
            lArray2 = new long[]{};
        }
        String string3 = "";
        String string4 = "";
        if (string2.length() > 0) {
            string3 = string2.substring(0, string2.length() - 1);
        }
        if (string.length() > 0) {
            string4 = string.substring(0, string.length() - 1);
        }
        long l = 0L;
        if (parameter.getClipDataset() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getClipDataset());
        }
        long l2 = 0L;
        if (parameter.getEraseDataset() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getEraseDataset());
        }
        long l3 = 0L;
        if (parameter.getLakeDataset() != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getLakeDataset());
            if (parameter.getLakeAltitudeFiled() == null || parameter.getLakeAltitudeFiled().length() == 0) {
                String string5 = InternalResource.loadString("LakeAltitudeFiled", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
        }
        String string6 = parameter.getLakeAltitudeFiled();
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int n3 = InternalEnum.getUGCValue(parameter.getInterpolateType());
        int n4 = InternalEnum.getUGCValue(parameter.getStatisticType());
        double d = parameter.getCellSize();
        double d2 = parameter.getResampleLen();
        double d3 = parameter.getZFactor();
        int n5 = InternalEnum.getUGCValue((Enum)parameter.getPixelFormat());
        int n6 = InternalEnum.getUGCValue((Enum)parameter.getEncodeType());
        boolean bl = parameter.isProcessFlatArea();
        long l5 = TerrainBuilderNative.jni_BuilTerrain2(lArray2, string3, lArray, string4, l, l2, l3, string6, n3, n4, d, d2, d3, l4, targetDatasetName, n5, n6, bl);
        DatasetGrid datasetGrid = null;
        if (l5 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l5, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static boolean buildLake(DatasetGrid demDatasetGrid, DatasetVector lakeDatasetVector, String lakeField) {
        return TerrainBuilder.buildLake(demDatasetGrid, lakeDatasetVector, lakeField, false, 0.0);
    }

    public static boolean buildLake(DatasetGrid demDatasetGrid, DatasetVector lakeDatasetVector, double elevation) {
        return TerrainBuilder.buildLake(demDatasetGrid, lakeDatasetVector, "", true, elevation);
    }

    private static boolean buildLake(DatasetGrid demDatasetGrid, DatasetVector lakeDatasetVector, String lakeField, boolean useDigital, double elevation) {
        TerrainBuilder.verifyLicense();
        if (demDatasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)demDatasetGrid) == 0L) {
            String string = InternalResource.loadString("demDatasetGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (lakeDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)lakeDatasetVector) == 0L) {
            String string = InternalResource.loadString("lakeDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)demDatasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)lakeDatasetVector);
        return TerrainBuilderNative.jni_BuildLake(l, l2, lakeField, useDigital, elevation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "TerrainBuilder";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        TerrainBuilder.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

