/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.DistanceAnalystNative;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.MathAnalystNative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class MathAnalyst {
    private static transient Vector m_steppedListeners;
    private static License m_license;
    private static GridAnalystSetting m_gridAnalystSetting;

    private MathAnalyst() {
        m_gridAnalystSetting = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return m_gridAnalystSetting;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            m_gridAnalystSetting = null;
            return;
        }
        if (m_gridAnalystSetting == null) {
            m_gridAnalystSetting = new GridAnalystSetting();
        }
        m_gridAnalystSetting.setBounds(gridAnalystSetting.getBounds());
        m_gridAnalystSetting.setBoundsType(gridAnalystSetting.getBoundsType());
        m_gridAnalystSetting.setCellSizeType(gridAnalystSetting.getCellSizeType());
        m_gridAnalystSetting.setCellSize(gridAnalystSetting.getCellSize());
        m_gridAnalystSetting.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        m_gridAnalystSetting.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        m_gridAnalystSetting.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        m_gridAnalystSetting.setValidRegion(gridAnalystSetting.getValidRegion());
        m_gridAnalystSetting.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static DatasetGrid plus(DatasetGrid firstOperand, DatasetGrid secondOperand, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName) {
        MathAnalyst.verifyLicense();
        if (firstOperand == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)firstOperand) == 0L) {
            String string = InternalResource.loadString("firstOperand", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (secondOperand == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)secondOperand) == 0L) {
            String string = InternalResource.loadString("secondOperand", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : firstOperand.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (userRegion != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)userRegion);
        } else if (m_gridAnalystSetting != null && m_gridAnalystSetting.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_gridAnalystSetting.getValidRegion());
        }
        long l2 = MathAnalystNative.jni_New();
        if (l2 == 0L) {
            return null;
        }
        boolean bl = false;
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
            Rectangle2D rectangle2D = m_gridAnalystSetting.getBounds();
            DistanceAnalystNative.jni_SetTargetBounds(l2, m_gridAnalystSetting.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)firstOperand);
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)secondOperand);
        long l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l6 = MathAnalystNative.jni_Plus(l2, l3, l4, l, l5, targetDatasetName, bl);
        MathAnalystNative.jni_Delete(l2);
        DatasetGrid datasetGrid = null;
        if (l6 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l6, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
        return datasetGrid;
    }

    public static DatasetGrid minus(DatasetGrid firstOperand, DatasetGrid secondOperand, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName) {
        MathAnalyst.verifyLicense();
        if (firstOperand == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)firstOperand) == 0L) {
            String string = InternalResource.loadString("firstOperand", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (secondOperand == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)secondOperand) == 0L) {
            String string = InternalResource.loadString("secondOperand", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : firstOperand.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (userRegion != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)userRegion);
        } else if (m_gridAnalystSetting != null && m_gridAnalystSetting.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_gridAnalystSetting.getValidRegion());
        }
        long l2 = MathAnalystNative.jni_New();
        if (l2 == 0L) {
            return null;
        }
        boolean bl = false;
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
            Rectangle2D rectangle2D = m_gridAnalystSetting.getBounds();
            DistanceAnalystNative.jni_SetTargetBounds(l2, m_gridAnalystSetting.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)firstOperand);
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)secondOperand);
        long l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l6 = MathAnalystNative.jni_Mius(l2, l3, l4, l, l5, targetDatasetName, bl);
        MathAnalystNative.jni_Delete(l2);
        DatasetGrid datasetGrid = null;
        if (l6 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l6, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
        return datasetGrid;
    }

    public static DatasetGrid multiply(DatasetGrid firstOperand, DatasetGrid secondOperand, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName) {
        MathAnalyst.verifyLicense();
        if (firstOperand == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)firstOperand) == 0L) {
            String string = InternalResource.loadString("firstOperand", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (secondOperand == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)secondOperand) == 0L) {
            String string = InternalResource.loadString("secondOperand", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : firstOperand.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (userRegion != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)userRegion);
        } else if (m_gridAnalystSetting != null && m_gridAnalystSetting.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_gridAnalystSetting.getValidRegion());
        }
        long l2 = MathAnalystNative.jni_New();
        if (l2 == 0L) {
            return null;
        }
        boolean bl = false;
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
            Rectangle2D rectangle2D = m_gridAnalystSetting.getBounds();
            DistanceAnalystNative.jni_SetTargetBounds(l2, m_gridAnalystSetting.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)firstOperand);
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)secondOperand);
        long l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l6 = MathAnalystNative.jni_Multiply(l2, l3, l4, l, l5, targetDatasetName, bl);
        MathAnalystNative.jni_Delete(l2);
        DatasetGrid datasetGrid = null;
        if (l6 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l6, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
        return datasetGrid;
    }

    public static DatasetGrid divide(DatasetGrid firstOperand, DatasetGrid secondOperand, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName) {
        MathAnalyst.verifyLicense();
        if (firstOperand == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)firstOperand) == 0L) {
            String string = InternalResource.loadString("firstOperand", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (secondOperand == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)secondOperand) == 0L) {
            String string = InternalResource.loadString("secondOperand", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : firstOperand.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (userRegion != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)userRegion);
        } else if (m_gridAnalystSetting != null && m_gridAnalystSetting.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_gridAnalystSetting.getValidRegion());
        }
        long l2 = MathAnalystNative.jni_New();
        if (l2 == 0L) {
            return null;
        }
        boolean bl = false;
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
            Rectangle2D rectangle2D = m_gridAnalystSetting.getBounds();
            DistanceAnalystNative.jni_SetTargetBounds(l2, m_gridAnalystSetting.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)firstOperand);
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)secondOperand);
        long l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l6 = MathAnalystNative.jni_Divide(l2, l3, l4, l, l5, targetDatasetName, bl);
        MathAnalystNative.jni_Delete(l2);
        DatasetGrid datasetGrid = null;
        if (l6 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l6, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
        return datasetGrid;
    }

    public static DatasetGrid execute(String expression, GeoRegion userRegion, PixelFormat pixelFormat, boolean isZip, boolean isIgnoreNoValue, Datasource targetDatasource, String targetDatasetName) {
        MathAnalyst.verifyLicense();
        if (expression == null || expression.length() == 0) {
            String string = InternalResource.loadString("expression", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            if (m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null) {
                targetDatasource = m_gridAnalystSetting.getOutputDatasource();
            } else {
                String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (userRegion != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)userRegion);
        } else if (m_gridAnalystSetting != null && m_gridAnalystSetting.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_gridAnalystSetting.getValidRegion());
        }
        long l2 = MathAnalystNative.jni_New();
        if (l2 == 0L) {
            return null;
        }
        boolean bl = false;
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
            Rectangle2D rectangle2D = m_gridAnalystSetting.getBounds();
            DistanceAnalystNative.jni_SetTargetBounds(l2, m_gridAnalystSetting.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int n = InternalEnum.getUGCValue((Enum)pixelFormat);
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource.getWorkspace());
        long l5 = MathAnalystNative.jni_Execute(l2, expression, l4, l, n, isZip, isIgnoreNoValue, l3, targetDatasetName, bl);
        MathAnalystNative.jni_Delete(l2);
        DatasetGrid datasetGrid = null;
        if (l5 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l5, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
        return datasetGrid;
    }

    public static DatasetGrid execute(String expression, GeoRegion userRegion, PixelFormat pixelFormat, boolean isZip, boolean isIgnoreNoValue, Datasource[] sourceDatasources, Datasource targetDatasource, String targetDatasetName) {
        if (expression == null || expression.length() == 0) {
            String string = InternalResource.loadString("expression", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            if (m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null) {
                targetDatasource = m_gridAnalystSetting.getOutputDatasource();
            } else {
                String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = sourceDatasources.length;
        for (int i = 0; i < n; ++i) {
            if (null != sourceDatasources[i] && InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasources[i]) != 0L) continue;
            String string = InternalResource.loadString("sourceDatasources[" + i + "]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasources[i]);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (userRegion != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)userRegion);
        } else if (m_gridAnalystSetting != null && m_gridAnalystSetting.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_gridAnalystSetting.getValidRegion());
        }
        long l2 = MathAnalystNative.jni_New();
        if (l2 == 0L) {
            return null;
        }
        boolean bl = false;
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
            Rectangle2D rectangle2D = m_gridAnalystSetting.getBounds();
            DistanceAnalystNative.jni_SetTargetBounds(l2, m_gridAnalystSetting.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int n2 = InternalEnum.getUGCValue((Enum)pixelFormat);
        long l4 = MathAnalystNative.jni_GPExecute(l2, expression, l, n2, isZip, isIgnoreNoValue, lArray, l3, targetDatasetName, bl);
        MathAnalystNative.jni_Delete(l2);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
        return datasetGrid;
    }

    public static DatasetGrid toInt(DatasetGrid sourceDataset, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName) {
        MathAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (userRegion != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)userRegion);
        } else if (m_gridAnalystSetting != null && m_gridAnalystSetting.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_gridAnalystSetting.getValidRegion());
        }
        long l2 = MathAnalystNative.jni_New();
        if (l2 == 0L) {
            return null;
        }
        boolean bl = false;
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
            Rectangle2D rectangle2D = m_gridAnalystSetting.getBounds();
            DistanceAnalystNative.jni_SetTargetBounds(l2, m_gridAnalystSetting.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l5 = MathAnalystNative.jni_Int(l2, l3, l, l4, targetDatasetName, bl);
        MathAnalystNative.jni_Delete(l2);
        DatasetGrid datasetGrid = null;
        if (l5 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l5, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
        return datasetGrid;
    }

    public static DatasetGrid toFloat(DatasetGrid sourceDataset, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName) {
        MathAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (userRegion != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)userRegion);
        } else if (m_gridAnalystSetting != null && m_gridAnalystSetting.getValidRegion() != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)m_gridAnalystSetting.getValidRegion());
        }
        long l2 = MathAnalystNative.jni_New();
        if (l2 == 0L) {
            return null;
        }
        boolean bl = false;
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
            Rectangle2D rectangle2D = m_gridAnalystSetting.getBounds();
            DistanceAnalystNative.jni_SetTargetBounds(l2, m_gridAnalystSetting.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l5 = MathAnalystNative.jni_Float(l2, l3, l, l4, targetDatasetName, bl);
        MathAnalystNative.jni_Delete(l2);
        DatasetGrid datasetGrid = null;
        if (l5 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l5, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
        return datasetGrid;
    }

    public static DatasetGrid executeFromXML(String xmlFileName, Datasource targetDatasource, String targetDatasetName) {
        MathAnalyst.verifyLicense();
        if (xmlFileName == null || xmlFileName.length() == 0) {
            String string = InternalResource.loadString("xmlFileName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            if (m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null) {
                targetDatasource = m_gridAnalystSetting.getOutputDatasource();
            } else {
                String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = MathAnalystNative.jni_New();
        if (l == 0L) {
            return null;
        }
        boolean bl = false;
        if (null != m_gridAnalystSetting) {
            bl = m_gridAnalystSetting.isShowProgress();
            Rectangle2D rectangle2D = m_gridAnalystSetting.getBounds();
            DistanceAnalystNative.jni_SetTargetBounds(l, m_gridAnalystSetting.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource.getWorkspace());
        long l4 = MathAnalystNative.jni_ExecuteFromXML(l, xmlFileName, l3, l2, targetDatasetName, bl);
        MathAnalystNative.jni_Delete(l);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static boolean toXMLFile(String xmlFileName, String expression, GeoRegion userRegion, PixelFormat pixelFormat, boolean isZip, boolean isIgnoreNoValue) {
        if (xmlFileName == null || xmlFileName.length() == 0) {
            String string = InternalResource.loadString("xmlFileName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (expression == null || expression.length() == 0) {
            String string = InternalResource.loadString("expression", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = 0L;
        if (userRegion != null) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)userRegion);
        }
        int n = InternalEnum.getUGCValue((Enum)pixelFormat);
        boolean bl = MathAnalystNative.jni_ToXMLFile(xmlFileName, expression, l, n, isZip, isIgnoreNoValue);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
        return bl;
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "MathAnalyst";
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        MathAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

