/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.data.CalibrateMode;
import com.supermap.data.Unit;

public class CalibrateOptions {
    private CalibrateMode m_calibrateMode;
    private double m_tolerance;
    private boolean m_interpolating;
    private boolean m_extrapolatingForward;
    private boolean m_extrapolatingBackward;
    private boolean m_ignoringGaps;
    private boolean m_retainingAllRoutes;
    private Unit m_unitType;
    private String m_fieldError;

    public CalibrateOptions() {
        this.m_calibrateMode = CalibrateMode.BYDISTANCE;
        this.m_tolerance = 1.0E-10;
        this.m_interpolating = true;
        this.m_extrapolatingForward = true;
        this.m_extrapolatingBackward = true;
        this.m_ignoringGaps = true;
        this.m_retainingAllRoutes = true;
        this.m_unitType = Unit.METER;
    }

    public CalibrateOptions(CalibrateMode mode, double tolerance) {
        this.m_calibrateMode = mode;
        this.m_tolerance = tolerance;
        this.m_interpolating = true;
        this.m_extrapolatingForward = true;
        this.m_extrapolatingBackward = true;
        this.m_ignoringGaps = true;
        this.m_retainingAllRoutes = true;
    }

    public void enableAll() {
        this.m_interpolating = true;
        this.m_extrapolatingForward = true;
        this.m_extrapolatingBackward = true;
        this.m_ignoringGaps = true;
        this.m_retainingAllRoutes = true;
    }

    public void disableAll() {
        this.m_interpolating = false;
        this.m_extrapolatingForward = false;
        this.m_extrapolatingBackward = false;
        this.m_ignoringGaps = false;
        this.m_retainingAllRoutes = false;
    }

    public CalibrateMode getRouteCalibrationMode() {
        return this.m_calibrateMode;
    }

    public void setRouteCalibrationMode(CalibrateMode value) {
        this.m_calibrateMode = value;
    }

    public double getTolerance() {
        return this.m_tolerance;
    }

    public void setTolerance(double value) {
        this.m_tolerance = value;
    }

    public boolean getIgnoringGaps() {
        return this.m_ignoringGaps;
    }

    public void setIgnoringGaps(boolean value) {
        this.m_ignoringGaps = value;
    }

    public boolean getRetainingAllRoutes() {
        return this.m_retainingAllRoutes;
    }

    public void setRetainingAllRoutes(boolean value) {
        this.m_retainingAllRoutes = value;
    }

    public Unit getToleranceUnit() {
        return this.m_unitType;
    }

    public void setToleranceUnit(Unit value) {
        this.m_unitType = value;
    }

    public String getErrorInfoField() {
        return this.m_fieldError;
    }

    public void setErrorInfoField(String value) {
        this.m_fieldError = value;
    }
}

