/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.networkanalyst;

import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.realspace.networkanalyst.InternalResource;
import com.supermap.realspace.networkanalyst.WeightFieldInfo3D;
import com.supermap.realspace.networkanalyst.WeightFieldInfos3D;

public class TransportationAnalystSetting3D {
    private DatasetVector m_networkDataset = null;
    private WeightFieldInfos3D m_weightFieldInfos = null;
    private String m_nodeIDField = "SmNodeID";
    private String m_edgeIDField = "SmEdgeID";
    private String m_fNodeIDField = "SmFNode";
    private String m_tNodeIDField = "SmTNode";
    private double m_tolerance = 0.0;
    private int[] m_barrierNodes = null;
    private int[] m_barrierEdges = null;
    private DatasetVector m_turnDataset = null;
    private String m_turnNodeIDField = "";
    private String m_turnFEdgeIDField = "";
    private String m_turnTEdgeIDField = "";
    private String m_nodeNameField = "";
    private String m_edgeNameField = "";
    private String[] m_turnWeightFields = null;
    private String m_ruleField = "";
    private String[] m_FTSingleWayRuleValues = null;
    private String[] m_TFSingleWayRuleValues = null;
    private String[] m_prohibitedWayRuleValues = null;
    private String[] m_twoWayRuleValues = null;
    private boolean m_needSet = true;
    private boolean m_needLoadModel = true;
    private boolean m_needLoadTurnModel = true;
    private String m_edgeFilter = "";

    public TransportationAnalystSetting3D() {
        this.m_weightFieldInfos = new WeightFieldInfos3D();
        WeightFieldInfo3D weightFieldInfo3D = new WeightFieldInfo3D();
        weightFieldInfo3D.setName("Length");
        weightFieldInfo3D.setFTWeightField("SmLength");
        weightFieldInfo3D.setTFWeightField("SmLength");
        this.m_weightFieldInfos.add(weightFieldInfo3D);
        this.m_weightFieldInfos.setOwner(this);
    }

    public TransportationAnalystSetting3D(TransportationAnalystSetting3D networkAnalystSetting) {
        if (networkAnalystSetting == null) {
            String string = InternalResource.loadString("networkAnalystSetting", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        this.m_weightFieldInfos = new WeightFieldInfos3D();
        this.m_weightFieldInfos.setOwner(this);
        this.copyFrom(networkAnalystSetting);
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public DatasetVector getNetworkDataset() {
        return this.m_networkDataset;
    }

    public void setNetworkDataset(DatasetVector value) {
        if (value != null && value.getType() != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("value", "TransportationAnalyst_DatasetTypeMustBeNetwork", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_networkDataset = value;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String getNodeIDField() {
        return this.m_nodeIDField;
    }

    public void setNodeIDField(String value) {
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nodeIDField = value;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String getEdgeIDField() {
        return this.m_edgeIDField;
    }

    public void setEdgeIDField(String value) {
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_edgeIDField = value;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String getFNodeIDField() {
        return this.m_fNodeIDField;
    }

    public void setFNodeIDField(String value) {
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_fNodeIDField = value;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String getTNodeIDField() {
        return this.m_tNodeIDField;
    }

    public void setTNodeIDField(String value) {
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_tNodeIDField = value;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public WeightFieldInfos3D getWeightFieldInfos() {
        return this.m_weightFieldInfos;
    }

    public void setWeightFieldInfos(WeightFieldInfos3D value) {
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (value.getCount() <= 0) {
            String string = InternalResource.loadString("value", "TransportationAnalystSetting_WeightFieldInfoCountShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_weightFieldInfos.copyFrom(value);
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public double getTolerance() {
        return this.m_tolerance;
    }

    public void setTolerance(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "TransportationAnalystSetting_ToleranceShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_tolerance = value;
        this.m_needSet = true;
    }

    public int[] getBarrierNodes() {
        if (this.m_barrierNodes != null) {
            return (int[])this.m_barrierNodes.clone();
        }
        return null;
    }

    public void setBarrierNodes(int[] value) {
        if (value == null) {
            this.m_barrierNodes = null;
        } else {
            int n = value.length;
            this.m_barrierNodes = new int[n];
            for (int i = 0; i < n; ++i) {
                if (value[i] <= 0) {
                    String string = InternalResource.loadString("value[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
                    throw new IllegalArgumentException(string);
                }
                this.m_barrierNodes[i] = value[i];
            }
        }
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public int[] getBarrierEdges() {
        if (this.m_barrierEdges != null) {
            return (int[])this.m_barrierEdges.clone();
        }
        return null;
    }

    public void setBarrierEdges(int[] value) {
        if (value == null) {
            this.m_barrierEdges = null;
        } else {
            int n = value.length;
            this.m_barrierEdges = new int[n];
            for (int i = 0; i < n; ++i) {
                if (value[i] <= 0) {
                    String string = InternalResource.loadString("value[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
                    throw new IllegalArgumentException(string);
                }
                this.m_barrierEdges[i] = value[i];
            }
        }
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    protected DatasetVector getTurnDataset() {
        return this.m_turnDataset;
    }

    protected void setTurnDataset(DatasetVector value) {
        if (value != null && value.getType() != DatasetType.TABULAR) {
            String string = InternalResource.loadString("value", "TransportationAnalyst_DatasetTypeMustBeTabular", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_turnDataset = value;
        this.m_needSet = true;
        this.m_needLoadTurnModel = true;
    }

    protected String getTurnNodeIDField() {
        return this.m_turnNodeIDField;
    }

    protected void setTurnNodeIDField(String value) {
        this.m_turnNodeIDField = value;
        this.m_needSet = true;
        this.m_needLoadTurnModel = true;
    }

    protected String getTurnFEdgeIDField() {
        return this.m_turnFEdgeIDField;
    }

    protected void setTurnFEdgeIDField(String value) {
        this.m_turnFEdgeIDField = value;
        this.m_needSet = true;
        this.m_needLoadTurnModel = true;
    }

    protected String getTurnTEdgeIDField() {
        return this.m_turnTEdgeIDField;
    }

    protected void setTurnTEdgeIDField(String value) {
        this.m_turnTEdgeIDField = value;
        this.m_needSet = true;
        this.m_needLoadTurnModel = true;
    }

    protected String[] getTurnWeightFields() {
        if (this.m_turnWeightFields != null) {
            return (String[])this.m_turnWeightFields.clone();
        }
        return null;
    }

    protected void setTurnWeightFields(String[] value) {
        if (value == null) {
            this.m_turnWeightFields = null;
        } else {
            int n = value.length;
            this.m_turnWeightFields = new String[n];
            for (int i = 0; i < n; ++i) {
                this.m_turnWeightFields[i] = value[i];
            }
        }
        this.m_needSet = true;
        this.m_needLoadTurnModel = true;
    }

    public String getNodeNameField() {
        return this.m_nodeNameField;
    }

    public void setNodeNameField(String value) {
        this.m_nodeNameField = value;
        this.m_needSet = true;
    }

    public String getEdgeNameField() {
        return this.m_edgeNameField;
    }

    public void setEdgeNameField(String value) {
        this.m_edgeNameField = value;
        this.m_needSet = true;
    }

    public String getRuleField() {
        return this.m_ruleField;
    }

    public void setRuleField(String value) {
        this.m_ruleField = value;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String[] getFTSingleWayRuleValues() {
        String[] stringArray = null;
        if (this.m_FTSingleWayRuleValues != null) {
            stringArray = (String[])this.m_FTSingleWayRuleValues.clone();
        }
        return stringArray;
    }

    public void setFTSingleWayRuleValues(String[] values) {
        if (values == null) {
            this.m_FTSingleWayRuleValues = null;
        } else {
            int n = values.length;
            this.m_FTSingleWayRuleValues = new String[n];
            for (int i = 0; i < n; ++i) {
                this.m_FTSingleWayRuleValues[i] = values[i];
            }
        }
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String[] getTFSingleWayRuleValues() {
        String[] stringArray = null;
        if (this.m_TFSingleWayRuleValues != null) {
            stringArray = (String[])this.m_TFSingleWayRuleValues.clone();
        }
        return stringArray;
    }

    public void setTFSingleWayRuleValues(String[] values) {
        if (values == null) {
            this.m_TFSingleWayRuleValues = null;
        } else {
            int n = values.length;
            this.m_TFSingleWayRuleValues = new String[n];
            for (int i = 0; i < n; ++i) {
                this.m_TFSingleWayRuleValues[i] = values[i];
            }
        }
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String[] getProhibitedWayRuleValues() {
        String[] stringArray = null;
        if (this.m_prohibitedWayRuleValues != null) {
            stringArray = (String[])this.m_prohibitedWayRuleValues.clone();
        }
        return stringArray;
    }

    public void setProhibitedWayRuleValues(String[] values) {
        if (values == null) {
            this.m_prohibitedWayRuleValues = null;
        } else {
            int n = values.length;
            this.m_prohibitedWayRuleValues = new String[n];
            for (int i = 0; i < n; ++i) {
                this.m_prohibitedWayRuleValues[i] = values[i];
            }
        }
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String[] getTwoWayRuleValues() {
        String[] stringArray = null;
        if (this.m_twoWayRuleValues != null) {
            stringArray = (String[])this.m_twoWayRuleValues.clone();
        }
        return stringArray;
    }

    public void setTwoWayRuleValues(String[] values) {
        if (values == null) {
            this.m_twoWayRuleValues = null;
        } else {
            int n = values.length;
            this.m_twoWayRuleValues = new String[n];
            for (int i = 0; i < n; ++i) {
                this.m_twoWayRuleValues[i] = values[i];
            }
        }
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String getEdgeFilter() {
        return this.m_edgeFilter;
    }

    public void setEdgeFilter(String filter) {
        this.m_edgeFilter = filter;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    void copyFrom(TransportationAnalystSetting3D value) {
        if (value != null && !this.equals(value)) {
            this.setNetworkDataset(value.getNetworkDataset());
            this.setNodeIDField(value.getNodeIDField());
            this.setEdgeIDField(value.getEdgeIDField());
            this.setEdgeNameField(value.getEdgeNameField());
            this.setNodeNameField(value.getNodeNameField());
            this.setFNodeIDField(value.getFNodeIDField());
            this.setTNodeIDField(value.getTNodeIDField());
            this.setWeightFieldInfos(value.getWeightFieldInfos());
            this.setTolerance(value.getTolerance());
            this.setBarrierNodes(value.getBarrierNodes());
            this.setBarrierEdges(value.getBarrierEdges());
            this.setTurnDataset(value.getTurnDataset());
            this.setTurnNodeIDField(value.getTurnNodeIDField());
            this.setTurnFEdgeIDField(value.getTurnFEdgeIDField());
            this.setTurnTEdgeIDField(value.getTurnTEdgeIDField());
            this.setTurnWeightFields(value.getTurnWeightFields());
            this.setRuleField(value.getRuleField());
            this.setFTSingleWayRuleValues(value.getFTSingleWayRuleValues());
            this.setTFSingleWayRuleValues(value.getTFSingleWayRuleValues());
            this.setProhibitedWayRuleValues(value.getProhibitedWayRuleValues());
            this.setTwoWayRuleValues(value.getTwoWayRuleValues());
            this.setEdgeFilter(value.getEdgeFilter());
            this.m_needSet = true;
            this.m_needLoadModel = true;
        }
    }

    boolean getNeedSet() {
        return this.m_needSet;
    }

    void setNeedSet(boolean value) {
        this.m_needSet = value;
    }

    boolean getNeedLoadModel() {
        return this.m_needLoadModel;
    }

    void setNeedLoadModel(boolean value) {
        this.m_needLoadModel = value;
    }

    boolean getNeedLoadTurnModel() {
        return this.m_needLoadTurnModel;
    }

    void setNeedLoadTurnModel(boolean value) {
        this.m_needLoadTurnModel = value;
    }
}

