/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.networkanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.FieldInfos;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.data.Toolkit;
import com.supermap.realspace.networkanalyst.BurstAnalyse3DResult;
import com.supermap.realspace.networkanalyst.FacilityAnalyst3DNative;
import com.supermap.realspace.networkanalyst.FacilityAnalystCheckResult3D;
import com.supermap.realspace.networkanalyst.FacilityAnalystResult3D;
import com.supermap.realspace.networkanalyst.FacilityAnalystSetting3D;
import com.supermap.realspace.networkanalyst.InternalHandle;
import com.supermap.realspace.networkanalyst.InternalHandleDisposable;
import com.supermap.realspace.networkanalyst.InternalResource;
import com.supermap.realspace.networkanalyst.InternalToolkitNetworkAnalyst3D;
import com.supermap.realspace.networkanalyst.WeightFieldInfos3D;
import java.util.ArrayList;
import java.util.HashMap;

public class FacilityAnalyst3D
extends InternalHandleDisposable {
    private FacilityAnalystSetting3D m_analystSetting = null;
    private License m_license;
    private boolean m_modelLoaded = false;

    public FacilityAnalyst3D() {
        this.checkLicense();
        long l = FacilityAnalyst3DNative.jni_New();
        this.setHandle(l, true);
        this.m_analystSetting = new FacilityAnalystSetting3D();
        this.m_modelLoaded = false;
    }

    public FacilityAnalystSetting3D getAnalystSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnalystSetting()", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_analystSetting;
    }

    public void setAnalystSetting(FacilityAnalystSetting3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnalystSetting(FacilityAnalystSetting value)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setAnalystSetting(FacilityAnalystSetting value)", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (!this.getAnalystSetting().equals(value)) {
            this.m_analystSetting.copyFrom(value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean load() {
        boolean bl;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("load()", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        boolean bl2 = true;
        if (this.m_analystSetting.getNeedSet()) {
            this.setAnalsytSettingToUGC();
        }
        if (!(bl = this.m_analystSetting.getNeedLoadModel())) {
            this.m_modelLoaded = true;
            return bl2;
        }
        Toolkit.clearErrors();
        bl2 = FacilityAnalyst3DNative.jni_LoadModel(this.getHandle());
        if (bl2) {
            this.m_analystSetting.setNeedLoadModel(false);
            this.m_modelLoaded = true;
            return bl2;
        }
        this.m_analystSetting.setNeedLoadModel(true);
        this.m_modelLoaded = false;
        String string = Toolkit.getLastError();
        throw new IllegalArgumentException(string);
    }

    public FacilityAnalystCheckResult3D check() {
        int n;
        int n2;
        int n3;
        int[] nArray;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Check(List<Integer> arcErrorInfos, List<Integer> nodeErrorInfos)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_analystSetting.getNeedSet()) {
            this.setAnalsytSettingToUGC();
        }
        if ((nArray = FacilityAnalyst3DNative.jni_Check(this.getHandle())) == null || nArray.length < 2) {
            return null;
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        if (nArray.length == 2) {
            return new FacilityAnalystCheckResult3D(hashMap2, hashMap);
        }
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = 2;
        int n7 = n6 + n4;
        for (n3 = n6; n3 < n7; n3 += 2) {
            n2 = nArray[n3];
            n = nArray[n3 + 1];
            hashMap2.put(n2, n);
        }
        n6 = 2 + n4;
        n7 = n6 + n5;
        for (n3 = n6; n3 < n7; n3 += 2) {
            n2 = nArray[n3];
            n = nArray[n3 + 1];
            hashMap.put(n2, n);
        }
        return new FacilityAnalystCheckResult3D(hashMap2, hashMap);
    }

    private int[] findLoopsFromNodes(int[] nodeIDs) {
        boolean bl;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findLoopsFromNodes(int[] ids)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (nodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < nodeIDs.length; bl += 1) {
            if (nodeIDs[bl] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        bl = true;
        return FacilityAnalyst3DNative.jni_FindLoops(this.getHandle(), nodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
    }

    private int[] findLoopsFromEdges(int[] edgeIDs) {
        boolean bl;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findLoopsFromEdges(int[] edgeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (edgeIDs == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < edgeIDs.length; bl += 1) {
            if (edgeIDs[bl] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        bl = false;
        return FacilityAnalyst3DNative.jni_FindLoops(this.getHandle(), edgeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
    }

    private int[] findConnectedEdgesFromNodes(int[] nodeIDs) {
        boolean bl;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findConnectedEdgesFromNodes(int[] nodeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (nodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < nodeIDs.length; bl += 1) {
            if (nodeIDs[bl] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        bl = true;
        boolean bl2 = true;
        return FacilityAnalyst3DNative.jni_FindConnectedEdges(this.getHandle(), nodeIDs, bl, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl2);
    }

    private int[] findConnectedEdgesFromEdges(int[] edgeIDs) {
        boolean bl;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findConnectedEdgesFromEdges(int[] edgeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (edgeIDs == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < edgeIDs.length; bl += 1) {
            if (edgeIDs[bl] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        bl = true;
        boolean bl2 = false;
        return FacilityAnalyst3DNative.jni_FindConnectedEdges(this.getHandle(), edgeIDs, bl, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl2);
    }

    private int[] findUnconnectedEdgesFromNodes(int[] nodeIDs) {
        boolean bl;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findUnconnectedEdgesFromNodes(int[] nodeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (nodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < nodeIDs.length; bl += 1) {
            if (nodeIDs[bl] > 0) continue;
            String string = InternalResource.loadString("nodeIDs" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        bl = false;
        boolean bl2 = true;
        return FacilityAnalyst3DNative.jni_FindConnectedEdges(this.getHandle(), nodeIDs, bl, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl2);
    }

    private int[] findUnconnectedEdgesFromEdges(int[] edgeIDs) {
        boolean bl;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findUnconnectedEdges(int[] edgeIDs)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (edgeIDs == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        for (bl = false; bl < edgeIDs.length; bl += 1) {
            if (edgeIDs[bl] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + (int)(bl ? 1 : 0) + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        bl = false;
        boolean bl2 = false;
        return FacilityAnalyst3DNative.jni_FindConnectedEdges(this.getHandle(), edgeIDs, bl, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl2);
    }

    private int[] findCommonAncestorsFromNodes(int[] nodeIDs, boolean isUncertainDirectionValid) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCommonAncestorsFromNodes(int[] nodeIDs, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (nodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < nodeIDs.length; ++i) {
            if (nodeIDs[i] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        int n = 0;
        boolean bl = true;
        return FacilityAnalyst3DNative.jni_FindCommonAncestors(this.getHandle(), nodeIDs, string, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
    }

    private int[] findCommonAncestorsFromEdges(int[] edgeIDs, boolean isUncertainDirectionValid) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCommonAncestorsFromNodes(int[] edgeIDs, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (edgeIDs == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < edgeIDs.length; ++i) {
            if (edgeIDs[i] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        int n = 0;
        boolean bl = false;
        return FacilityAnalyst3DNative.jni_FindCommonAncestors(this.getHandle(), edgeIDs, string, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
    }

    private int[] findCommonCatchmentsFromNodes(int[] nodeIDs, boolean isUncertainDirectionValid) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCommonCatchmentsFromNodes(int[] nodeIDs, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (nodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < nodeIDs.length; ++i) {
            if (nodeIDs[i] > 0) continue;
            String string = InternalResource.loadString("nodeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        int n = 1;
        boolean bl = true;
        return FacilityAnalyst3DNative.jni_FindCommonAncestors(this.getHandle(), nodeIDs, string, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
    }

    private int[] findCommonCatchmentsFromEdges(int[] edgeIDs, boolean isUncertainDirectionValid) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCommonCatchmentsFromEdges(int[] edges, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (edgeIDs == null) {
            String string = InternalResource.loadString("edgeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < edgeIDs.length; ++i) {
            if (edgeIDs[i] > 0) continue;
            String string = InternalResource.loadString("edgeIDs[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        int n = 1;
        boolean bl = false;
        return FacilityAnalyst3DNative.jni_FindCommonAncestors(this.getHandle(), edgeIDs, string, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
    }

    public FacilityAnalystResult3D findSourceFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSourceFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        boolean bl = true;
        int[][] nArray = FacilityAnalyst3DNative.jni_FindSource(this.getHandle(), nodeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalyst3DNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, d);
            return facilityAnalystResult3D;
        }
        return null;
    }

    public FacilityAnalystResult3D findSourceFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSourceFromNode(int edgeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        boolean bl = false;
        int[][] nArray = FacilityAnalyst3DNative.jni_FindSource(this.getHandle(), edgeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalyst3DNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, d);
            return facilityAnalystResult3D;
        }
        return null;
    }

    public FacilityAnalystResult3D findSinkFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSinkFromNode(int id, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 1;
        boolean bl = true;
        int[][] nArray = FacilityAnalyst3DNative.jni_FindSource(this.getHandle(), nodeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalyst3DNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, d);
            return facilityAnalystResult3D;
        }
        return null;
    }

    public FacilityAnalystResult3D findSinkFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSinkFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 1;
        boolean bl = false;
        int[][] nArray = FacilityAnalyst3DNative.jni_FindSource(this.getHandle(), edgeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalyst3DNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, d);
            return facilityAnalystResult3D;
        }
        return null;
    }

    public FacilityAnalystResult3D traceUpFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("traceUpFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        boolean bl = true;
        int[][] nArray = FacilityAnalyst3DNative.jni_TraceUp(this.getHandle(), nodeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalyst3DNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, d);
            return facilityAnalystResult3D;
        }
        return null;
    }

    public FacilityAnalystResult3D traceUpFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("traceUpFromNode(int edgeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        boolean bl = false;
        int[][] nArray = FacilityAnalyst3DNative.jni_TraceUp(this.getHandle(), edgeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalyst3DNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, d);
            return facilityAnalystResult3D;
        }
        return null;
    }

    public FacilityAnalystResult3D traceDownFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("traceDownFromNode(int nodeID, String weightName, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 1;
        boolean bl = true;
        int[][] nArray = FacilityAnalyst3DNative.jni_TraceUp(this.getHandle(), nodeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalyst3DNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, d);
            return facilityAnalystResult3D;
        }
        return null;
    }

    public FacilityAnalystResult3D traceDownFromEdge(int edgeID, String weightName, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("traceDownFromNode(int id, String weightName, boolean isUncertainDirectionValid, boolean isNodeID)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 1;
        boolean bl = false;
        int[][] nArray = FacilityAnalyst3DNative.jni_TraceUp(this.getHandle(), edgeID, weightName, isUncertainDirectionValid, n, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalyst3DNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, d);
            return facilityAnalystResult3D;
        }
        return null;
    }

    private int[] checkLoops() {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("checkLoops()", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return FacilityAnalyst3DNative.jni_CheckLoops(this.getHandle(), this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes());
    }

    private FacilityAnalystResult3D findPathFromNode(int startNodeID, int endNodeID, String weightName) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPathFromNode(int startNodeID, int endNodeID, String weightName)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (startNodeID <= 0) {
            String string = InternalResource.loadString("startNodeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (endNodeID <= 0) {
            String string = InternalResource.loadString("endNodeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int[][] nArray = FacilityAnalyst3DNative.jni_FindPath(this.getHandle(), startNodeID, endNodeID, weightName, true, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalyst3DNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, d);
            return facilityAnalystResult3D;
        }
        return null;
    }

    private FacilityAnalystResult3D findPathFromEdge(int startEdgeID, int endEdgeID, String weightName) {
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPathFromEdge(int startEdgeID, int endEdgeID, String weightName)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (startEdgeID <= 0) {
            String string = InternalResource.loadString("startEdgeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (endEdgeID <= 0) {
            String string = InternalResource.loadString("endEdgeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightName == null || weightName.trim().length() == 0) {
            weightName = this.m_analystSetting.getWeightFieldInfos().get(0).getName();
        } else if (this.m_analystSetting.getWeightFieldInfos().indexOf(weightName) == -1) {
            String string = InternalResource.loadString("weightName", "FacilityAnalyst_SpecifiedWeightNameNotExist", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int[][] nArray = FacilityAnalyst3DNative.jni_FindPath(this.getHandle(), startEdgeID, endEdgeID, weightName, true, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), bl);
        int[] nArray2 = nArray[0];
        int[] nArray3 = nArray[1];
        double d = FacilityAnalyst3DNative.jni_GetCost(this.getHandle());
        if (nArray2.length != 0 && nArray3.length != 0) {
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, d);
            return facilityAnalystResult3D;
        }
        return null;
    }

    public FacilityAnalystResult3D findCriticalFacilitiesUpFromNode(int[] sourceNodeIDs, int nodeID, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalFacilitiesUpFromNode(int[] nodeIDs, int nodeID, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (sourceNodeIDs == null) {
            String string = InternalResource.loadString("sourceNodeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceNodeIDs.length == 0) {
            String string = InternalResource.loadString("sourceNodeIDs", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int[] nArray = FacilityAnalyst3DNative.jni_FindCriticalFacilities(this.getHandle(), nodeID, sourceNodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid, bl, 0);
        if (nArray.length > 2) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = 0;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n2];
            int n4 = n + 2;
            for (n3 = 2; n3 < n4; ++n3) {
                nArray2[n3 - 2] = nArray[n3];
            }
            n4 = n + n2 + 2;
            while (n3 < n4) {
                nArray3[n3 - 2 - n] = nArray[n3];
                ++n3;
            }
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, 0.0);
            return facilityAnalystResult3D;
        }
        return null;
    }

    public FacilityAnalystResult3D findCriticalFacilitiesUpFromEdge(int[] sourceNodeIDs, int edgeID, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalFacilitiesUpFromEdge(int[] nodeIDs, int nodeID, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (sourceNodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceNodeIDs.length == 0) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int[] nArray = FacilityAnalyst3DNative.jni_FindCriticalFacilities(this.getHandle(), edgeID, sourceNodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid, bl, 0);
        if (nArray.length > 2) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = 0;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n2];
            int n4 = n + 2;
            for (n3 = 2; n3 < n4; ++n3) {
                nArray2[n3 - 2] = nArray[n3];
            }
            n4 = n + n2 + 2;
            while (n3 < n4) {
                nArray3[n3 - 2 - n] = nArray[n3];
                ++n3;
            }
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, 0.0);
            return facilityAnalystResult3D;
        }
        return null;
    }

    public FacilityAnalystResult3D findCriticalFacilitiesDownFromNode(int[] sourceNodeIDs, int nodeID, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalFacilitiesUpFromNode(int[] nodeIDs, int nodeID, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (sourceNodeIDs == null) {
            String string = InternalResource.loadString("sourceNodeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceNodeIDs.length == 0) {
            String string = InternalResource.loadString("sourceNodeIDs", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int[] nArray = FacilityAnalyst3DNative.jni_FindCriticalFacilities(this.getHandle(), nodeID, sourceNodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid, bl, 1);
        if (nArray.length > 2) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = 0;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n2];
            int n4 = n + 2;
            for (n3 = 2; n3 < n4; ++n3) {
                nArray2[n3 - 2] = nArray[n3];
            }
            n4 = n + n2 + 2;
            while (n3 < n4) {
                nArray3[n3 - 2 - n] = nArray[n3];
                ++n3;
            }
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, 0.0);
            return facilityAnalystResult3D;
        }
        return null;
    }

    public FacilityAnalystResult3D findCriticalFacilitiesDownFromEdge(int[] sourceNodeIDs, int edgeID, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalFacilitiesUpFromEdge(int[] nodeIDs, int nodeID, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (sourceNodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceNodeIDs.length == 0) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int[] nArray = FacilityAnalyst3DNative.jni_FindCriticalFacilities(this.getHandle(), edgeID, sourceNodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid, bl, 1);
        if (nArray.length > 2) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = 0;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n2];
            int n4 = n + 2;
            for (n3 = 2; n3 < n4; ++n3) {
                nArray2[n3 - 2] = nArray[n3];
            }
            n4 = n + n2 + 2;
            while (n3 < n4) {
                nArray3[n3 - 2 - n] = nArray[n3];
                ++n3;
            }
            FacilityAnalystResult3D facilityAnalystResult3D = new FacilityAnalystResult3D(nArray2, nArray3, 0.0);
            return facilityAnalystResult3D;
        }
        return null;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "networkanalyst3d_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            FacilityAnalyst3DNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
        this.unLoadLicense();
    }

    void setAnalsytSettingToUGC() {
        DatasetType datasetType;
        if (!this.m_analystSetting.getNeedSet()) {
            return;
        }
        DatasetVector datasetVector = this.m_analystSetting.getNetworkDataset();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset()", "FacilityAnalyst_NetworkDatasetHasNotBeenSet", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (!datasetVector.isOpen()) {
            datasetVector.open();
        }
        if ((datasetType = datasetVector.getType()) != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset().getType()", "FacilityAnalyst_DatasetTypeMustBeNetwork", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        String[] stringArray = new String[]{this.m_analystSetting.getNodeIDField(), this.m_analystSetting.getEdgeIDField(), this.m_analystSetting.getFNodeIDField(), this.m_analystSetting.getTNodeIDField()};
        if (!FacilityAnalyst3D.isNetworkFieldsAllRight(stringArray, datasetVector)) {
            String string = InternalResource.loadString("fields", "FacilityAnalystSetting_FieldIsNotInNetworkDataset", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        WeightFieldInfos3D weightFieldInfos3D = this.m_analystSetting.getWeightFieldInfos();
        if (weightFieldInfos3D == null || weightFieldInfos3D.getCount() <= 0) {
            String string = InternalResource.loadString("m_analystSetting.getWeightFieldInfos()", "FacilityAnalystSetting_WeightFieldInfoCountShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        int n = weightFieldInfos3D.getCount();
        stringArray2 = new String[n];
        stringArray3 = new String[n];
        stringArray4 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = weightFieldInfos3D.get(i).getName();
            stringArray3[i] = weightFieldInfos3D.get(i).getFTWeightField();
            stringArray4[i] = weightFieldInfos3D.get(i).getTFWeightField();
        }
        int[] nArray = this.m_analystSetting.getBarrierEdges();
        int[] nArray2 = this.m_analystSetting.getBarrierNodes();
        double d = this.m_analystSetting.getTolerance();
        String string = this.m_analystSetting.getDirectionField();
        FacilityAnalyst3DNative.jni_SetAnalystSettingToUGC(this.getHandle(), l, stringArray, string, stringArray2, stringArray3, stringArray4, nArray2, nArray, d);
        this.m_analystSetting.setNeedSet(false);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    private boolean isLoadModelNeeded() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLoadModelNeeded()", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_analystSetting.getNeedSet() || !this.m_modelLoaded;
    }

    private static boolean isNetworkFieldsAllRight(String[] fields, DatasetVector networkDataset) {
        boolean bl = true;
        if (!networkDataset.open()) {
            networkDataset.open();
        }
        if (networkDataset.getChildDataset().isAvailableFieldName(fields[0])) {
            return false;
        }
        int n = fields.length;
        for (int i = 1; i < n; ++i) {
            if (!networkDataset.isAvailableFieldName(fields[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    boolean checkWeightField() {
        QueryParameter queryParameter = new QueryParameter();
        queryParameter.setCursorType(CursorType.STATIC);
        queryParameter.setHasGeometry(false);
        queryParameter.setAttributeFilter("1<0");
        DatasetVector datasetVector = this.m_analystSetting.getNetworkDataset();
        if (datasetVector == null) {
            return false;
        }
        for (int i = 0; i < this.m_analystSetting.getWeightFieldInfos().getCount(); ++i) {
            int n;
            String string = this.m_analystSetting.getWeightFieldInfos().get(i).getFTWeightField();
            String string2 = this.m_analystSetting.getWeightFieldInfos().get(i).getTFWeightField();
            queryParameter.setResultFields(new String[]{string});
            Recordset recordset = datasetVector.query(queryParameter);
            FieldInfos fieldInfos = recordset.getFieldInfos();
            int n2 = fieldInfos.getCount();
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                String string3 = fieldInfos.get(n).getName();
                if (!string3.equalsIgnoreCase(string)) continue;
                bl = true;
            }
            if (!bl) {
                String string4 = InternalResource.loadString(string, "Global_EnumValueIsError", "networkanalyst3d_resources");
                throw new IllegalArgumentException(string4);
            }
            recordset.dispose();
            queryParameter.setResultFields(new String[]{string2});
            recordset = this.m_analystSetting.getNetworkDataset().query(queryParameter);
            fieldInfos = recordset.getFieldInfos();
            n2 = fieldInfos.getCount();
            n = 0;
            for (int j = 0; j < n2; ++j) {
                String string5 = fieldInfos.get(j).getName();
                if (!string5.equalsIgnoreCase(string2)) continue;
                n = 1;
            }
            if (n == 0) {
                String string6 = InternalResource.loadString(string2, "Global_EnumValueIsError", "networkanalyst3d_resources");
                throw new IllegalArgumentException(string6);
            }
            recordset.dispose();
        }
        return true;
    }

    private void checkLicense() {
        ArrayList<ProductType> arrayList = InternalToolkitNetworkAnalyst3D.managerProducts(InternalToolkitNetworkAnalyst3D.getRealspaceNetworkAnalystProducts());
        this.m_license = InternalToolkitNetworkAnalyst3D.verifyLicense(arrayList);
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    private void verifyLicense() {
        int n = this.m_license.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    public BurstAnalyse3DResult burstAnalyseFromNode(int[] sourceNodeIDs, int nodeID, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("burstAnalyseFromNode(int[] nodeIDs, int nodeID, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (sourceNodeIDs == null) {
            String string = InternalResource.loadString("sourceNodeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceNodeIDs.length == 0) {
            String string = InternalResource.loadString("sourceNodeIDs", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (nodeID <= 0) {
            String string = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int[] nArray = FacilityAnalyst3DNative.jni_BurstAnalyse(this.getHandle(), nodeID, sourceNodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid, bl);
        if (nArray.length > 2) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            int n4 = 0;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n3];
            int n5 = n + 3;
            int n6 = 0;
            for (n4 = 3; n4 < n5; ++n4) {
                nArray2[n6++] = nArray[n4];
            }
            n5 += n2;
            n6 = 0;
            while (n4 < n5) {
                nArray3[n6++] = nArray[n4];
                ++n4;
            }
            n5 += n3;
            n6 = 0;
            while (n4 < n5) {
                nArray4[n6++] = nArray[n4];
                ++n4;
            }
            BurstAnalyse3DResult burstAnalyse3DResult = new BurstAnalyse3DResult(nArray2, nArray3, nArray4);
            return burstAnalyse3DResult;
        }
        return null;
    }

    public BurstAnalyse3DResult burstAnalyseFromEdge(int[] sourceNodeIDs, int edgeID, boolean isUncertainDirectionValid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("burstAnalyseFromEdge(int[] nodeIDs, int nodeID, boolean isUncertainDirectionValid)", "Handle_ObjectHasBeenDisposed", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (sourceNodeIDs == null) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArgumentNull", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceNodeIDs.length == 0) {
            String string = InternalResource.loadString("nodeIDs", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isLoadModelNeeded()) {
            String string = InternalResource.loadString("", "FacilityAnalyst_LoadModelNeeded", "networkanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (edgeID <= 0) {
            String string = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        int[] nArray = FacilityAnalyst3DNative.jni_BurstAnalyse(this.getHandle(), edgeID, sourceNodeIDs, this.m_analystSetting.getBarrierEdges(), this.m_analystSetting.getBarrierNodes(), isUncertainDirectionValid, bl);
        if (nArray.length > 3) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            int n4 = 0;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n3];
            int n5 = n + 3;
            int n6 = 0;
            for (n4 = 3; n4 < n5; ++n4) {
                nArray2[n6++] = nArray[n4];
            }
            n5 += n2;
            n6 = 0;
            while (n4 < n5) {
                nArray3[n6++] = nArray[n4];
                ++n4;
            }
            n5 += n3;
            n6 = 0;
            while (n4 < n5) {
                nArray4[n6++] = nArray[n4];
                ++n4;
            }
            BurstAnalyse3DResult burstAnalyse3DResult = new BurstAnalyse3DResult(nArray2, nArray3, nArray4);
            return burstAnalyse3DResult;
        }
        return null;
    }
}

