/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.trafficanalyst.InternalDatasetVector;
import com.supermap.analyst.trafficanalyst.InternalDatasets;
import com.supermap.analyst.trafficanalyst.InternalHandle;
import com.supermap.analyst.trafficanalyst.InternalHandleDisposable;
import com.supermap.analyst.trafficanalyst.InternalResource;
import com.supermap.analyst.trafficanalyst.InternalToolkitTrafficAnalyst;
import com.supermap.analyst.trafficanalyst.LineInfo;
import com.supermap.analyst.trafficanalyst.LineSetting;
import com.supermap.analyst.trafficanalyst.LineSettings;
import com.supermap.analyst.trafficanalyst.RelationSetting;
import com.supermap.analyst.trafficanalyst.RelationSettings;
import com.supermap.analyst.trafficanalyst.StopInfo;
import com.supermap.analyst.trafficanalyst.StopSetting;
import com.supermap.analyst.trafficanalyst.StopSettings;
import com.supermap.analyst.trafficanalyst.TransferAnalystNative;
import com.supermap.analyst.trafficanalyst.TransferAnalystParameter;
import com.supermap.analyst.trafficanalyst.TransferAnalystResult;
import com.supermap.analyst.trafficanalyst.TransferAnalystResultNative;
import com.supermap.analyst.trafficanalyst.TransferAnalystSetting;
import com.supermap.analyst.trafficanalyst.TransferGuide;
import com.supermap.analyst.trafficanalyst.TransferLine;
import com.supermap.analyst.trafficanalyst.TransferSolutions;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Point2D;
import com.supermap.data.Unit;
import java.util.ArrayList;

public class TransferAnalyst
extends InternalHandleDisposable {
    private boolean m_load;
    private DatasetVector m_Dataset;
    private long analystSettingHanlde;
    private License m_license;
    private TransferAnalystSetting m_transferAnalystSetting;

    public TransferAnalyst() {
        this.checkLicense();
        this.m_load = false;
        this.setHandle(TransferAnalystNative.jni_New(), true);
    }

    DatasetVector buildTransferModel(TransferAnalystSetting TransferAnalystSetting2, Datasource outputDatasource, String outputModelDatasetName) {
        this.verifyLicense();
        if (TransferAnalystSetting2 == null) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource) == 0L) {
            outputDatasource = TransferAnalystSetting2.getLineSettings().get(0).getDataset().getDatasource();
        }
        if (outputDatasource.getDatasets().contains(outputModelDatasetName)) {
            String string = InternalResource.loadString("outputDatasource", "Datasource_DatasetNameIsInvalid", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        long l2 = TransferAnalystSetting2.setToUGC();
        long l3 = TransferAnalystNative.jni_BuildTransferModel(l2, l, outputModelDatasetName);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public boolean load(LineSetting lineSetting, StopSetting stopSetting, RelationSetting relationSetting) {
        if (this.m_load) {
            return true;
        }
        if (lineSetting == null) {
            String string = InternalResource.loadString("transferLineSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        if (stopSetting == null) {
            String string = InternalResource.loadString("transferStopSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        if (relationSetting == null) {
            String string = InternalResource.loadString("transferRelationSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        LineSettings lineSettings = new LineSettings();
        lineSettings.add(lineSetting);
        StopSettings stopSettings = new StopSettings();
        stopSettings.add(stopSetting);
        RelationSettings relationSettings = new RelationSettings();
        relationSettings.add(relationSetting);
        long l = this.getHandle();
        long l2 = lineSettings.setToUGC();
        long l3 = stopSettings.setToUGC();
        long l4 = relationSettings.setRelationToUGC();
        Unit unit = Unit.METER;
        double d = (double)unit.value() * 1.0 / (double)lineSettings.get(0).getDataset().getPrjCoordSys().getCoordUnit().value();
        double d2 = 10.0 * d;
        double d3 = 500.0 * d;
        double d4 = 1000.0 * d;
        boolean bl = false;
        this.m_load = bl = TransferAnalystNative.jni_LoadBasicModel(l, l2, l3, l4, d2, d3, d4);
        return bl;
    }

    public boolean load(TransferAnalystSetting transferAnalystSetting) {
        this.verifyLicense();
        if (this.m_load) {
            return true;
        }
        if (transferAnalystSetting == null) {
            String string = InternalResource.loadString("TransferAnalystSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_transferAnalystSetting = transferAnalystSetting;
        long l = this.getHandle();
        long l2 = transferAnalystSetting.setToUGC();
        boolean bl = false;
        this.m_load = bl = TransferAnalystNative.jni_LoadAdvancedModel(l, l2);
        return bl;
    }

    public boolean check(TransferAnalystSetting transferAnalystSetting) {
        if (this.m_load) {
            return true;
        }
        this.verifyLicense();
        if (transferAnalystSetting == null) {
            String string = InternalResource.loadString("TransferAnalystSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_transferAnalystSetting = transferAnalystSetting;
        long l = transferAnalystSetting.setToUGC();
        boolean bl = true;
        bl = TransferAnalystNative.jni_CheckSetting(l);
        return bl;
    }

    public TransferAnalystResult findTransferLines(TransferAnalystParameter parameter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findTransferPath(TransferAnalystParameter parameter)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this.m_load) {
            String string = InternalResource.loadString("findTransferLines( TransferAnalystParameter parameter)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        parameter.setSolutionCount(5);
        TransferAnalystResult transferAnalystResult = null;
        long l = TransferAnalystNative.jni_FindTransferLines(this.getHandle(), parameter.setToUGC());
        if (l != 0L) {
            transferAnalystResult = new TransferAnalystResult(l);
        }
        return transferAnalystResult;
    }

    public TransferSolutions findTransferSolutions(TransferAnalystParameter parameter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findTransferPath(TransferAnalystParameter parameter)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this.m_load) {
            String string = InternalResource.loadString("findTransferLines( TransferAnalystParameter parameter)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        long l = parameter.setToUGC();
        int n = TransferAnalystNative.jni_CheckStartEndDistance(this.getHandle(), l);
        if (n == 1) {
            String string = InternalResource.loadString("findTransferSolutions( TransferAnalystParameter parameter)", "TransferAnalyst_StartEndPointTooClose", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (n == 2) {
            String string = InternalResource.loadString("findTransferSolutions( TransferAnalystParameter parameter)", "TransferAnalyst_StartOrEndIDNotExist", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        TransferSolutions transferSolutions = null;
        long l2 = TransferAnalystNative.jni_FindTransferSolutions(this.getHandle(), l);
        if (l2 != 0L) {
            transferSolutions = new TransferSolutions(l2);
        }
        return transferSolutions;
    }

    public LineInfo[] findLinesByStop(long stopID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findLines(DatasetVector stopDataset,int stopID)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this.m_load) {
            String string = InternalResource.loadString("findLinesByStop(long stopID)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = null;
        lArray = TransferAnalystNative.jni_FindLinesByStop(this.getHandle(), stopID);
        int n = lArray.length;
        LineInfo[] lineInfoArray = new LineInfo[n];
        for (int i = 0; i < n; ++i) {
            lineInfoArray[i] = new LineInfo(lArray[i], this);
        }
        return lineInfoArray;
    }

    public StopInfo[] findStopsByLine(long lineID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findStopsByLine(long lineID)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this.m_load) {
            String string = InternalResource.loadString("findStopsByLine(long lineID)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = null;
        lArray = TransferAnalystNative.jni_FindStopsByLine(this.getHandle(), lineID);
        int n = lArray.length;
        StopInfo[] stopInfoArray = new StopInfo[n];
        for (int i = 0; i < n; ++i) {
            stopInfoArray[i] = new StopInfo(lArray[i], this);
        }
        return stopInfoArray;
    }

    public TransferGuide getDetailInfo(long startID, long endID, TransferLine[] transferLines) {
        Object[] objectArray;
        Object object;
        int n = 0;
        long l = 0L;
        if (transferLines == null) {
            l = TransferAnalystNative.jni_GetIDDetail(this.getHandle(), startID, endID, null, null, null);
        } else {
            n = transferLines.length;
            if (n < 1) {
                return null;
            }
            object = new long[n];
            objectArray = new int[n];
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                TransferLine transferLine = transferLines[i];
                object[i] = transferLine.getLineID();
                objectArray[i] = transferLine.getStartIndex();
                nArray[i] = transferLine.getEndIndex();
            }
            l = TransferAnalystNative.jni_GetIDDetail(this.getHandle(), startID, endID, object, objectArray, nArray);
        }
        if (l == 0L) {
            return null;
        }
        object = null;
        n = TransferAnalystResultNative.jni_GetTransferGuideCount(l);
        if (n > 0) {
            objectArray = new long[n];
            TransferAnalystResultNative.jni_GetTransferGuideHandles(l, objectArray);
            object = new TransferGuide(objectArray[0]);
            TransferAnalystResultNative.jni_Delete(l);
        }
        return object;
    }

    public TransferGuide getDetailInfo(Point2D startPoint, Point2D endPoint, TransferLine[] transferLines) {
        Object[] objectArray;
        Object object;
        int n = 0;
        long l = 0L;
        if (transferLines == null) {
            l = TransferAnalystNative.jni_GetPointDetail(this.getHandle(), startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY(), null, null, null);
        } else {
            n = transferLines.length;
            if (n < 1) {
                return null;
            }
            object = new long[n];
            objectArray = new int[n];
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                TransferLine transferLine = transferLines[i];
                object[i] = transferLine.getLineID();
                objectArray[i] = transferLine.getStartIndex();
                nArray[i] = transferLine.getEndIndex();
            }
            l = TransferAnalystNative.jni_GetPointDetail(this.getHandle(), startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY(), object, objectArray, nArray);
        }
        if (l == 0L) {
            return null;
        }
        object = null;
        n = TransferAnalystResultNative.jni_GetTransferGuideCount(l);
        if (n > 0) {
            objectArray = new long[n];
            TransferAnalystResultNative.jni_GetTransferGuideHandles(l, objectArray);
            object = new TransferGuide(objectArray[0]);
            TransferAnalystResultNative.jni_Delete(l);
        }
        return object;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "trafficanalyst_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            if (this.m_transferAnalystSetting != null) {
                this.m_transferAnalystSetting.dispose();
            }
            TransferAnalystNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
        this.m_load = false;
        this.unLoadLicense();
    }

    private void checkLicense() {
        ArrayList<ProductType> arrayList = InternalToolkitTrafficAnalyst.managerProducts(InternalToolkitTrafficAnalyst.getTrafficAnalystProducts());
        this.m_license = InternalToolkitTrafficAnalyst.verifyLicense(arrayList);
    }

    private void unLoadLicense() {
        if (this.m_license != null) {
            this.m_license.disconnect();
            this.m_license.dispose();
            this.m_license = null;
        }
    }

    private void verifyLicense() {
        int n = this.m_license.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }
}

