/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalGeometry;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.PathGuide;
import com.supermap.analyst.networkanalyst.TransportationAnalystResultNative;
import com.supermap.data.GeoLineM;

public class TransportationAnalystResult
extends InternalHandleDisposable {
    private GeoLineM[] m_routes = null;
    private int[][] m_nodes = null;
    private int[][] m_edges = null;
    private int[][] m_stops = null;
    private PathGuide[] m_pathGuides = null;
    private double[] m_weights = null;
    private double[][] m_stopWeights = null;
    private GeoLineM[] m_altRoutes = null;
    private PathGuide[][] m_altPathGuides = null;

    TransportationAnalystResult(long handle) {
        this.setHandle(handle, true);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            TransportationAnalystResultNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public GeoLineM[] getRoutes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRoutes()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_routes == null) {
            int n = TransportationAnalystResultNative.jni_GetRouteCount(this.getHandle());
            if (n > 0) {
                long[] lArray = new long[n];
                TransportationAnalystResultNative.jni_GetRouteHandles(this.getHandle(), lArray);
                this.m_routes = new GeoLineM[n];
                for (int i = 0; i < n; ++i) {
                    if (lArray[i] == 0L) continue;
                    this.m_routes[i] = (GeoLineM)InternalGeometry.createInstance(lArray[i]);
                    InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_routes[i], false);
                }
            } else {
                this.m_routes = new GeoLineM[0];
            }
        }
        return this.m_routes;
    }

    public int[][] getNodes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNodes()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_nodes == null) {
            int n = TransportationAnalystResultNative.jni_GetNodeCount(this.getHandle());
            if (n > 0) {
                this.m_nodes = new int[n][];
                int[] nArray = new int[n];
                TransportationAnalystResultNative.jni_GetNodeCounts(this.getHandle(), nArray);
                for (int i = 0; i < n; ++i) {
                    this.m_nodes[i] = new int[nArray[i]];
                }
                TransportationAnalystResultNative.jni_GetNodes(this.getHandle(), this.m_nodes);
            } else {
                this.m_nodes = new int[0][0];
            }
        }
        return this.m_nodes;
    }

    public int[][] getEdges() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEdges()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_edges == null) {
            int n = TransportationAnalystResultNative.jni_GetEdgeCount(this.getHandle());
            if (n > 0) {
                this.m_edges = new int[n][];
                int[] nArray = new int[n];
                TransportationAnalystResultNative.jni_GetEdgeCounts(this.getHandle(), nArray);
                for (int i = 0; i < n; ++i) {
                    this.m_edges[i] = new int[nArray[i]];
                }
                TransportationAnalystResultNative.jni_GetEdges(this.getHandle(), this.m_edges);
            } else {
                this.m_edges = new int[0][0];
            }
        }
        return this.m_edges;
    }

    public int[][] getStopIndexes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStops()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_stops == null) {
            int n = TransportationAnalystResultNative.jni_GetStopCount(this.getHandle());
            if (n > 0) {
                this.m_stops = new int[n][];
                int[] nArray = new int[n];
                TransportationAnalystResultNative.jni_GetStopCounts(this.getHandle(), nArray);
                for (int i = 0; i < n; ++i) {
                    this.m_stops[i] = new int[nArray[i]];
                }
                TransportationAnalystResultNative.jni_GetStops(this.getHandle(), this.m_stops);
            } else {
                this.m_stops = new int[0][0];
            }
        }
        return this.m_stops;
    }

    public double[][] getStopWeights() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStopWeights()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_stopWeights == null) {
            this.m_stopWeights = TransportationAnalystResultNative.jni_GetStopWeights(this.getHandle());
        }
        return this.m_stopWeights;
    }

    public PathGuide[] getPathGuides() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPathGuides()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_pathGuides == null) {
            int n = TransportationAnalystResultNative.jni_GetPathGuideCount(this.getHandle());
            if (n > 0) {
                long[] lArray = new long[n];
                TransportationAnalystResultNative.jni_GetPathGuideHandles(this.getHandle(), lArray);
                this.m_pathGuides = new PathGuide[n];
                for (int i = 0; i < n; ++i) {
                    this.m_pathGuides[i] = new PathGuide(lArray[i]);
                }
            } else {
                this.m_pathGuides = new PathGuide[0];
            }
        }
        return this.m_pathGuides;
    }

    public double[] getWeights() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWeights()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_weights == null) {
            int n = TransportationAnalystResultNative.jni_GetWeightCount(this.getHandle());
            if (n > 0) {
                this.m_weights = new double[n];
                TransportationAnalystResultNative.jni_GetWeights(this.getHandle(), this.m_weights);
            } else {
                this.m_weights = new double[0];
            }
        }
        return this.m_weights;
    }

    private GeoLineM[] getAltRoutes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRoutes()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_altRoutes == null) {
            int n = 2;
            if (n > 0) {
                long[] lArray = new long[n];
                TransportationAnalystResultNative.jni_GetAltRouteHandles(this.getHandle(), lArray);
                this.m_altRoutes = new GeoLineM[n];
                for (int i = 0; i < n; ++i) {
                    if (lArray[i] == 0L) continue;
                    this.m_altRoutes[i] = (GeoLineM)InternalGeometry.createInstance(lArray[i]);
                    InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_altRoutes[i], false);
                }
            } else {
                this.m_altRoutes = new GeoLineM[0];
            }
        }
        return this.m_altRoutes;
    }

    private PathGuide[][] getAltPathGuides() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPathGuides()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_altPathGuides == null) {
            this.m_altPathGuides = new PathGuide[2][];
            for (int i = 0; i < 2; ++i) {
                int n = TransportationAnalystResultNative.jni_GetAltPathGuideCount(this.getHandle(), i);
                if (n > 0) {
                    long[] lArray = new long[n];
                    TransportationAnalystResultNative.jni_GetAltPathGuideHandles(this.getHandle(), i, lArray);
                    this.m_altPathGuides[i] = new PathGuide[n];
                    for (int j = 0; j < n; ++j) {
                        this.m_altPathGuides[i][j] = new PathGuide(lArray[j]);
                    }
                    continue;
                }
                this.m_altPathGuides = null;
            }
        }
        return this.m_altPathGuides;
    }
}

