/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.TrackPoint;
import com.supermap.analyst.networkanalyst.TrajectoryPreprocessingNative;
import com.supermap.analyst.networkanalyst.TrajectoryPreprocessingResult;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.FieldType;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TrajectoryPreprocessing
extends InternalHandleDisposable {
    private DatasetVector m_datasetValidRegion = null;
    private PrjCoordSys m_prjCoordSys = null;

    public TrajectoryPreprocessing() {
        long l = TrajectoryPreprocessingNative.jni_New();
        if (l != 0L) {
            this.setHandle(l, true);
        }
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            TrajectoryPreprocessingNative.jni_Delete(this.getHandle());
        }
        this.setHandle(0L);
    }

    public TrajectoryPreprocessing setMeasurementError(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInterval()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (value > 0.0) {
            TrajectoryPreprocessingNative.jni_SetMeasurementError(this.getHandle(), value);
            return this;
        }
        String string = InternalResource.loadString("interval", "MustBeGreaterThanZero", "networkanalyst_resources");
        throw new IllegalArgumentException(string);
    }

    public double getMeasurementError() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMeasurementError()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return TrajectoryPreprocessingNative.jni_GetMeasurementError(this.getHandle());
    }

    public TrajectoryPreprocessing setPrjCoordSys(PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (prjCoordSys == null) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordSys) == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_prjCoordSys = prjCoordSys;
        TrajectoryPreprocessingNative.jni_SetPrjCoordSys(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordSys));
        return this;
    }

    public PrjCoordSys getPrjCoordSys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_prjCoordSys;
    }

    public TrajectoryPreprocessing setValidRegion(DatasetVector datasetValidRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setValidRegion()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetValidRegion != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetValidRegion) == 0L) {
                String string = InternalResource.loadString("datasetValidRegion", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (datasetValidRegion.getType() != DatasetType.REGION) {
                String string = InternalResource.loadString("datasetValidRegion", "DatasetTypeMustBeRegion", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            TrajectoryPreprocessingNative.jni_SetValidRegion(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetValidRegion));
        } else {
            TrajectoryPreprocessingNative.jni_SetValidRegion(this.getHandle(), 0L);
        }
        this.m_datasetValidRegion = datasetValidRegion;
        return this;
    }

    public DatasetVector getValidRegion() {
        return this.m_datasetValidRegion;
    }

    public TrajectoryPreprocessing setSharpAngle(double sharpAngle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSharpAngle()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        TrajectoryPreprocessingNative.jni_SetSharpAngle(this.getHandle(), sharpAngle);
        return this;
    }

    public double getSharpAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSharpAngle()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return TrajectoryPreprocessingNative.jni_GetSharpAngle(this.getHandle());
    }

    public TrajectoryPreprocessing setRemoveRedundantPoints(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRemoveRedundantPoints()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        TrajectoryPreprocessingNative.jni_SetRemoveRedundantPoints(this.getHandle(), value);
        return this;
    }

    public boolean isRemoveRedundantPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRemoveRedundantPoints()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return TrajectoryPreprocessingNative.jni_IsRemoveRedundantPoints(this.getHandle());
    }

    public TrajectoryPreprocessingResult rectify(TrackPoint[] points) {
        Object object;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rectity", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (points.length < 3) {
            String string = InternalResource.loadString("points", "PointsCountMustBeGreaterThanTwo", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[points.length];
        double[] dArray2 = new double[points.length];
        long[] lArray = new long[points.length];
        for (int i = 0; i < points.length; ++i) {
            dArray[i] = points[i].getPoint().x;
            dArray2[i] = points[i].getPoint().y;
            object = points[i].getTime();
            if (object == null) continue;
            lArray[i] = ((Date)object).getTime();
        }
        if (TrajectoryPreprocessingNative.jni_Rectify(this.getHandle(), dArray, dArray2, lArray)) {
            double[] dArray3 = TrajectoryPreprocessingNative.jni_GetResultChangedPoints(this.getHandle());
            object = TrajectoryPreprocessingNative.jni_GetResultChangedIndexes(this.getHandle());
            int[] nArray = TrajectoryPreprocessingNative.jni_GetResultRemovedIndexes(this.getHandle());
            Point2D[] point2DArray = new Point2D[dArray3.length / 2];
            for (int i = 0; i < point2DArray.length; ++i) {
                point2DArray[i] = new Point2D(dArray3[2 * i], dArray3[2 * i + 1]);
            }
            return new TrajectoryPreprocessingResult(point2DArray, (int[])object, nArray, points);
        }
        return null;
    }

    public DatasetVector rectify(DatasetVector sourceDataset, String idField, String timeField, double splitTimeMilliseconds, Datasource outputDatasource, String outputDatasetName, String resultTrackIndexField) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rectifyDataset", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceDataset.getFieldInfos().indexOf(timeField) == -1) {
            String string = InternalResource.loadString("timeField", "FieldNotInDatasetVector", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        FieldType fieldType = sourceDataset.getFieldInfos().get(timeField).getType();
        if (fieldType != FieldType.TIME && fieldType != FieldType.DATETIME) {
            String string = InternalResource.loadString("timeField", "FieldType_UnSupport", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (splitTimeMilliseconds <= 0.0) {
            String string = InternalResource.loadString("splitTimeMilliseconds", "MustBeGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (outputDatasetName == null) {
            String string = InternalResource.loadString("outputDatasetName", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "Datasource_DatasetNameIsInvalid", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVector datasetVector = (DatasetVector)outputDatasource.getDatasets().createFromTemplate(outputDatasetName, (Dataset)sourceDataset);
        if (datasetVector == null) {
            return null;
        }
        if (TrajectoryPreprocessingNative.jni_Rectify2(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset), idField, timeField, splitTimeMilliseconds, InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector), resultTrackIndexField)) {
            return datasetVector;
        }
        outputDatasource.getDatasets().delete(datasetVector.getName());
        return null;
    }

    public static List<TrackPoint[]> splitTrack(TrackPoint[] points, double splitTimeMilliseconds) {
        Cloneable cloneable;
        if (points == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (points.length < 3) {
            String string = InternalResource.loadString("points", "PointsCountMustBeGreaterThanTwo", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (splitTimeMilliseconds <= 0.0) {
            String string = InternalResource.loadString("splitTimeMilliseconds", "MustBeGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[points.length];
        double[] dArray2 = new double[points.length];
        long[] lArray = new long[points.length];
        for (int i = 0; i < points.length; ++i) {
            dArray[i] = points[i].getPoint().x;
            dArray2[i] = points[i].getPoint().y;
            cloneable = points[i].getTime();
            if (cloneable == null) continue;
            lArray[i] = ((Date)cloneable).getTime();
        }
        int[] nArray = TrajectoryPreprocessingNative.jni_SplitTrack(dArray, dArray2, lArray, splitTimeMilliseconds);
        cloneable = new ArrayList();
        if (nArray == null || nArray.length == 0) {
            TrackPoint[] trackPointArray = new TrackPoint[points.length];
            for (int i = 0; i < points.length; ++i) {
                trackPointArray[i] = new TrackPoint(points[i]);
            }
            cloneable.add((TrackPoint[])trackPointArray);
        } else {
            int n;
            for (int i = 0; i < nArray.length; i += n + 1) {
                n = nArray[i];
                TrackPoint[] trackPointArray = new TrackPoint[n];
                for (int j = 0; j < n; ++j) {
                    trackPointArray[j] = new TrackPoint(points[nArray[i + 1 + j]]);
                }
                cloneable.add((TrackPoint[])trackPointArray);
            }
        }
        return cloneable;
    }
}

