/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.GroupAnalystResultItem;
import com.supermap.analyst.networkanalyst.GroupAnalystResultNative;
import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalResource;

public class GroupAnalystResult
extends InternalHandle {
    private GroupAnalystResultItem[] m_items = null;
    private int[] m_errors = null;

    GroupAnalystResult(long handle) {
        this.setHandle(handle);
    }

    public int[] getErrors() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getErrors()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_errors == null) {
            int n = GroupAnalystResultNative.jni_GetErrorCount(this.getHandle());
            if (n > 0) {
                this.m_errors = new int[n];
                GroupAnalystResultNative.jni_GetErrors(this.getHandle(), this.m_errors);
            } else {
                this.m_errors = new int[0];
            }
        }
        return this.m_errors;
    }

    public GroupAnalystResultItem[] getGroupAnalystResultItems() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GroupAnalystResultItem()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_items == null) {
            int n = GroupAnalystResultNative.jni_GetItemCount(this.getHandle());
            if (n > 0) {
                long[] lArray = new long[n];
                GroupAnalystResultNative.jni_GetItems(this.getHandle(), lArray);
                this.m_items = new GroupAnalystResultItem[n];
                for (int i = 0; i < n; ++i) {
                    this.m_items[i] = new GroupAnalystResultItem(lArray[i]);
                }
            } else {
                this.m_items = new GroupAnalystResultItem[0];
            }
        }
        return this.m_items;
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            GroupAnalystResultNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

