/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.AllocationAnalystParameterNative;
import com.supermap.analyst.networkanalyst.AllocationDemandType;
import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.SupplyCenters;

public class AllocationAnalystParameter
extends InternalHandleDisposable {
    private SupplyCenters m_supplyCenters = null;
    private AllocationDemandType m_demandType = AllocationDemandType.BOTH;
    private String m_nodeDemandField = "NodeDemand";
    private String m_edgeDemandField = "EdgeDemand";
    private boolean m_isFromCenter;
    private boolean m_isConnected;
    private String m_turnWeightField;
    private String m_weightName;
    private boolean m_isDisposed = false;

    public AllocationAnalystParameter() {
        long l = AllocationAnalystParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    public AllocationAnalystParameter(AllocationAnalystParameter parameter) {
        if (parameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter);
        if (l == 0L) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.reset();
        this.copyFrom(parameter);
    }

    public void setSupplyCenters(SupplyCenters value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setSupplyCenters(SupplyCenters value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_supplyCenters = new SupplyCenters(value);
    }

    public SupplyCenters getSupplyCenters() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("getSupplyCenters()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_supplyCenters;
    }

    public AllocationDemandType getDemandType() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("getDemandType()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_demandType;
    }

    public void setDemandType(AllocationDemandType value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setDemandType(AllocationDemandType value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_demandType = value;
    }

    public String getNodeDemandField() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("GetNodeDemandField()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_nodeDemandField;
    }

    public void setNodeDemandField(String value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setNodeDemandField(String value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_nodeDemandField = value;
    }

    public String getEdgeDemandField() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("GetEdgeDemandField()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_edgeDemandField;
    }

    public void setEdgeDemandField(String value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setEdgeDemandField(String value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_edgeDemandField = value;
    }

    public boolean isFromCenter() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("isFromCenter()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_isFromCenter;
    }

    public void setFromCenter(boolean value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setFromCenter(boolean value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_isFromCenter = value;
    }

    public void setTurnWeightField(String value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setTurnWeightField(String value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_turnWeightField = value;
    }

    public String getTurnWeightField() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("getTurnWeightField()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_turnWeightField;
    }

    public void setWeightName(String value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setWeightName(String value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_weightName = value;
    }

    public String getWeightName() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("getWeightName()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_weightName;
    }

    public boolean isConnected() {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("isConnected()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this.m_isConnected;
    }

    public void setConnected(boolean value) {
        if (this.m_isDisposed) {
            String string = InternalResource.loadString("setConnected(boolean value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        this.m_isConnected = value;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "networkanalyst_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            AllocationAnalystParameterNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.m_isDisposed = true;
        }
    }

    void reset() {
        long l = super.getHandle();
        if (l != 0L) {
            AllocationAnalystParameterNative.jni_Reset(l);
        }
        this.m_isFromCenter = true;
        this.m_isConnected = true;
        this.m_weightName = "";
        this.m_turnWeightField = "";
        this.m_demandType = AllocationDemandType.BOTH;
        this.m_nodeDemandField = "NodeDemand";
        this.m_edgeDemandField = "EdgeDemand";
        this.m_supplyCenters = new SupplyCenters();
    }

    void copyFrom(AllocationAnalystParameter value) {
        if (value != null) {
            this.setDemandType(value.getDemandType());
            this.setNodeDemandField(value.getNodeDemandField());
            this.setEdgeDemandField(value.getEdgeDemandField());
            this.setTurnWeightField(value.getTurnWeightField());
            this.setWeightName(value.getWeightName());
            this.setFromCenter(value.isFromCenter());
            this.setConnected(value.isConnected());
            this.setSupplyCenters(new SupplyCenters(value.getSupplyCenters()));
        }
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            AllocationAnalystParameterNative.jni_SetConnected(l, this.m_isConnected);
            AllocationAnalystParameterNative.jni_SetFromCenter(l, this.m_isFromCenter);
            AllocationAnalystParameterNative.jni_SetTurnWeightField(l, this.m_turnWeightField);
            AllocationAnalystParameterNative.jni_SetWeightName(l, this.m_weightName);
            AllocationAnalystParameterNative.jni_SetDemandType(l, this.m_demandType.value());
        }
        return l;
    }
}

