/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing.cache;

import com.supermap.data.CoordSysTransMethod;
import com.supermap.data.CoordSysTransParameter;
import com.supermap.data.CoordSysTranslator;
import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EngineType;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.ProjectionType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.data.processing.CacheWriter;
import com.supermap.data.processing.MapCacheBuilder;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.TileFormat;
import com.supermap.tilestorage.TileStorageConnection;
import com.supermap.tilestorage.TileStorageManager;
import com.supermap.tilestorage.TileStorageType;
import com.supermap.tilestorage.TileVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class TaskBuilder {
    public static final int BundleSize = 128;

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] args) throws Exception {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        File file;
        if (args.length < 2) {
            System.out.println("input style: sciFile targetFolder listCount(1) canudb(0) versionName");
            return;
        }
        String string = args[0];
        String string2 = args[1] + "/task";
        int n = 1;
        if (args.length > 2) {
            n = Integer.valueOf(args[2]);
        }
        int n2 = 0;
        if (args.length > 3) {
            n2 = Integer.valueOf(args[3]);
        }
        String string3 = "";
        if (args.length > 4) {
            string3 = args[4];
        }
        if (!(file = new File(string)).exists()) {
            System.out.println(string + " not exist!");
            return;
        }
        Workspace workspace = null;
        Datasource datasource = null;
        if (n2 > 0) {
            object5 = "cache";
            object4 = args[1] + "/udb/" + (String)object5 + ".udb";
            object3 = new File((String)object4);
            if (((File)object3).exists()) {
                System.out.println((String)object4 + " is exists!");
                return;
            }
            ((File)object3).getParentFile().mkdirs();
            object2 = new DatasourceConnectionInfo();
            object2.setServer((String)object4);
            object2.setAlias((String)object5);
            object2.setEngineType(EngineType.UDB);
            workspace = new Workspace();
            datasource = workspace.getDatasources().create((DatasourceConnectionInfo)object2);
        }
        object5 = new CacheWriter();
        ((CacheWriter)object5).FromConfigFile(string);
        if (((CacheWriter)object5).getStorageType() == StorageType.MongoDB) {
            object4 = new TileStorageConnection();
            object3 = ((CacheWriter)object5).getMongoConnectionInfo();
            object4.setStorageType(TileStorageType.MONGO);
            object4.setServer((String)object3[0]);
            object4.setDatabase((String)object3[1]);
            object4.setName((String)object3[2]);
            object2 = new TileStorageManager();
            if (!object2.open((TileStorageConnection)object4) || !string3.isEmpty()) {
                Object object6;
                MapCacheBuilder mapCacheBuilder = new MapCacheBuilder();
                if (!mapCacheBuilder.fromConfigFile(string)) {
                    System.out.println("open sci file filed!");
                    return;
                }
                if (!string3.isEmpty()) {
                    object6 = new TileVersion();
                    object6.setDesc(string3);
                    mapCacheBuilder.setVersionInfo((TileVersion)object6);
                }
                if (!mapCacheBuilder.createMongoDB()) {
                    System.out.println("create mongodb failed!");
                    return;
                }
                object6 = new File(string);
                String string4 = mapCacheBuilder.getCacheName() + "_mongo.sci";
                object = new File(((File)object6).getParent() + "/" + string4);
                string = ((File)object).getAbsolutePath();
                ((CacheWriter)object5).FromConfigFile(string);
                System.out.println("create mongodb success!");
                System.out.println(string4 + " created!");
            }
            object2.close();
        }
        if (!((File)(object4 = new File(string2))).exists()) {
            ((File)object4).mkdirs();
        }
        object3 = string2 + "/allTask.list";
        object2 = new File((String)object3);
        Object var13_14 = null;
        if (!((File)object2).exists() && !(bl = ((File)object2).createNewFile())) {
            System.out.println("create Failed!");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object2), "UTF-8");
        HashMap<Double, String> hashMap = new HashMap<Double, String>(((CacheWriter)object5).getCacheScaleCaptions());
        Rectangle2D rectangle2D = ((CacheWriter)object5).getCacheBounds();
        object = ((CacheWriter)object5).getIndexBounds();
        Set<Double> set = hashMap.keySet();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.addAll(set);
        if (((CacheWriter)object5).isbuildFromOriginalResolution().booleanValue()) {
            Collections.sort(arrayList, Collections.reverseOrder());
        } else {
            Collections.sort(arrayList);
        }
        Rectangle2D rectangle2D2 = object;
        if (((CacheWriter)object5).getTileFormat() == TileFormat.PBF) {
            // empty if block
        }
        Iterator iterator = arrayList.iterator();
        while (true) {
            double d;
            double d2;
            double d3;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            Object object7;
            Recordset.BatchEditor batchEditor;
            Recordset recordset;
            String string5;
            if (iterator.hasNext()) {
                int n8;
                double d4;
                double d5;
                double d6 = (Double)iterator.next();
                double d7 = ((CacheWriter)object5).getTileResolustion(d6);
                HashMap<Double, String> hashMap2 = new HashMap<Double, String>();
                string5 = hashMap.get(d6);
                hashMap2.put(d6, string5);
                ((CacheWriter)object5).setCacheScaleCaptions(hashMap2);
                recordset = null;
                batchEditor = null;
                if (n2 > 0) {
                    object7 = "L" + string5 + "_S" + Math.round(1.0 / d6);
                    DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo((String)object7, DatasetType.REGION);
                    DatasetVector datasetVector = datasource.getDatasets().create(datasetVectorInfo);
                    FieldInfo fieldInfo = new FieldInfo("tiletype", FieldType.INT32);
                    FieldInfo fieldInfo2 = new FieldInfo("tilerow", FieldType.INT32);
                    FieldInfo fieldInfo3 = new FieldInfo("tilecol", FieldType.INT32);
                    FieldInfo fieldInfo4 = new FieldInfo("errortype", FieldType.INT32);
                    FieldInfo fieldInfo5 = new FieldInfo("errordesc", FieldType.TEXT);
                    datasetVector.getFieldInfos().add(fieldInfo);
                    datasetVector.getFieldInfos().add(fieldInfo2);
                    datasetVector.getFieldInfos().add(fieldInfo3);
                    datasetVector.getFieldInfos().add(fieldInfo4);
                    datasetVector.getFieldInfos().add(fieldInfo5);
                    recordset = datasetVector.getRecordset(false, CursorType.DYNAMIC);
                    batchEditor = recordset.getBatch();
                    batchEditor.setMaxRecordCount(10);
                    batchEditor.begin();
                }
                if (((CacheWriter)object5).getTileFormat() == TileFormat.PBF) {
                    int n9;
                    n7 = Integer.valueOf(string5);
                    n6 = 1;
                    d5 = rectangle2D2.getWidth() / (double)(n6 <<= n7);
                    d4 = rectangle2D2.getHeight() / (double)n6;
                    n5 = (int)Math.floor((rectangle2D.getLeft() - rectangle2D2.getLeft()) / d5);
                    n4 = (int)Math.floor((rectangle2D.getRight() - rectangle2D2.getLeft()) / d5);
                    n8 = (int)Math.floor(-(rectangle2D.getTop() - rectangle2D2.getTop()) / d4);
                    n3 = (int)Math.floor(-(rectangle2D.getBottom() - rectangle2D2.getTop()) / d4);
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n5 >= n6) {
                        n5 = n6 - 1;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n4 >= n6) {
                        n4 = n6 - 1;
                    }
                    if (n8 < 0) {
                        n8 = 0;
                    }
                    if (n8 >= n6) {
                        n8 = n6 - 1;
                    }
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (n3 >= n6) {
                        n3 = n6 - 1;
                    }
                    if (n5 > n4) {
                        n9 = n5;
                        n5 = n4;
                        n4 = n9;
                    }
                    if (n8 > n3) {
                        n9 = n8;
                        n8 = n3;
                        n3 = n9;
                    }
                    d3 = d5 / (double)((CacheWriter)object5).getTileSize().value();
                    object7 = rectangle2D2;
                    d2 = d5;
                    d = d4;
                } else {
                    double d8;
                    d3 = d7 / (double)((CacheWriter)object5).getTileSize().value();
                    double d9 = (rectangle2D.getLeft() - object.getLeft()) / d7 + 1.0E-8;
                    n5 = (int)Math.floor(d9);
                    d5 = -(rectangle2D.getTop() - object.getTop()) / d7 + 1.0E-8;
                    n8 = (int)Math.floor(d5);
                    d4 = (rectangle2D.getRight() - object.getLeft()) / d7 + 1.0E-8;
                    if ((d4 - (double)(n4 = (int)Math.floor(d4))) * d7 < d3) {
                        --n4;
                    }
                    if (((d8 = -(rectangle2D.getBottom() - object.getTop()) / d7 + 1.0E-8) - (double)(n3 = (int)Math.floor(d8))) * d7 < d3) {
                        --n3;
                    }
                    object7 = object;
                    d2 = d7;
                    d = d7;
                }
                n7 = n8;
            } else {
                outputStreamWriter.close();
                if (n2 > 0) {
                    datasource.close();
                    workspace.close();
                    workspace.dispose();
                }
                if (n2 < 2) {
                    TaskBuilder.splitList((String)object3, n);
                }
                return;
            }
            while (n7 <= n3) {
                n6 = n7 / 128;
                int n10 = Math.min(n3, (n6 + 1) * 128 - 1);
                int n11 = n5;
                while (n11 <= n4) {
                    int n12 = n11 / 128;
                    int n13 = Math.min(n4, (n12 + 1) * 128 - 1);
                    double d10 = object7.getLeft() + (double)n11 * d2;
                    double d11 = object7.getLeft() + (double)(n13 + 1) * d2;
                    double d12 = object7.getTop() - (double)n7 * d;
                    double d13 = object7.getTop() - (double)(n10 + 1) * d;
                    if (d11 - d10 > d3 && Math.abs(d13 - d12) > d3) {
                        String string6;
                        Point2Ds point2Ds;
                        if (n2 < 2) {
                            point2Ds = new Rectangle2D(d10, d13, d11, d12);
                            ((CacheWriter)object5).setCacheBounds((Rectangle2D)point2Ds);
                            string6 = String.format("%s/L%s_R%d_C%d.sci", string2, string5, n6, n12);
                            TaskBuilder.wirteOneSci((CacheWriter)object5, string6, outputStreamWriter);
                        }
                        if (n2 > 0) {
                            point2Ds = new Point2Ds();
                            point2Ds.add(new Point2D(d10, d13));
                            point2Ds.add(new Point2D(d10, d12));
                            point2Ds.add(new Point2D(d11, d12));
                            point2Ds.add(new Point2D(d11, d13));
                            string6 = new GeoRegion(point2Ds);
                            HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
                            hashMap3.put("tiletype", 1);
                            hashMap3.put("tilerow", n6);
                            hashMap3.put("tilecol", n12);
                            recordset.addNew((Geometry)string6, hashMap3);
                        }
                    }
                    n11 = n13 + 1;
                }
                n7 = n10 + 1;
            }
            if (n2 > 0) {
                batchEditor.update();
                recordset.close();
                recordset.dispose();
            }
            ((CacheWriter)object5).setCacheScaleCaptions(hashMap);
            ((CacheWriter)object5).setCacheBounds(rectangle2D);
        }
    }

    public static void splitList(String allListFileName, int splitCount) throws Exception {
        String string;
        if (splitCount < 2) {
            return;
        }
        File file = new File(allListFileName);
        ArrayList<String> arrayList = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            arrayList = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
        }
        int n = arrayList.size() / splitCount;
        int n2 = 0;
        string = file.getParent() + "/" + file.getName().replaceAll(".list", "");
        for (int i = 0; i < splitCount; ++i) {
            File file2 = new File(string + "_" + i + ".list");
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");){
                if ((double)(arrayList.size() - n2) * 1.0 / (double)n < 2.0) {
                    n = arrayList.size() - n2;
                }
                for (int j = 0; j < n; ++j) {
                    outputStreamWriter.write((String)arrayList.get(n2) + "\n");
                    ++n2;
                }
                continue;
            }
        }
    }

    public static void wirteOneSci(CacheWriter writer, String sciName, OutputStreamWriter listWriter) throws Exception {
        boolean bl = writer.ToConfigFile(sciName);
        if (bl) {
            listWriter.write(new File(sciName).getName() + "\n");
        }
    }

    private static Rectangle2D getBounds(PrjCoordSys desprj) {
        Rectangle2D rectangle2D = new Rectangle2D(-180.0, -90.0, 180.0, 90.0);
        if (desprj.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE) {
            if (desprj.getProjection().getType() == ProjectionType.PRJ_MERCATOR || desprj.getProjection().getType() == ProjectionType.PRJ_SPHERE_MERCATOR) {
                rectangle2D.setLeft(-2.00489661040146E7);
                rectangle2D.setTop(2.00489661040146E7);
                rectangle2D.setRight(2.00489661040146E7);
                rectangle2D.setBottom(-2.00489661040146E7);
            } else {
                int n;
                Point2Ds point2Ds;
                int n2;
                PrjCoordSys prjCoordSys = new PrjCoordSys(PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE);
                GeoLine geoLine = new GeoLine();
                for (n2 = 90; n2 >= -90; n2 -= 2) {
                    point2Ds = new Point2Ds();
                    for (n = -180; n <= 180; n += 2) {
                        point2Ds.add(new Point2D((double)n, (double)n2));
                    }
                    geoLine.addPart(point2Ds);
                }
                for (n2 = -180; n2 <= 180; n2 += 2) {
                    point2Ds = new Point2Ds();
                    for (n = 90; n >= -90; n -= 2) {
                        point2Ds.add(new Point2D((double)n2, (double)n));
                    }
                    geoLine.addPart(point2Ds);
                }
                CoordSysTranslator.convert((Geometry)geoLine, (PrjCoordSys)prjCoordSys, (PrjCoordSys)desprj, (CoordSysTransParameter)new CoordSysTransParameter(), (CoordSysTransMethod)CoordSysTransMethod.MTH_GEOCENTRIC_TRANSLATION);
                rectangle2D = geoLine.getBounds();
            }
        }
        double d = Math.max(rectangle2D.getWidth(), Math.abs(rectangle2D.getHeight()));
        rectangle2D.setRight(rectangle2D.getRight() + (d - rectangle2D.getWidth()));
        rectangle2D.setBottom(rectangle2D.getBottom() - (d - Math.abs(rectangle2D.getHeight())));
        return rectangle2D;
    }
}

