/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing.cache;

import com.supermap.data.processing.cache.ProcessBuildEvent;
import com.supermap.data.processing.cache.ProcessBuildingListener;
import com.supermap.data.processing.cache.SubprocessThread;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class MultiProcessManager {
    transient Vector m_ProcessBuildingListeners;
    private int m_processCount;
    private Object m_classObject;
    private long m_timeout;
    private String m_customClasspath;
    private String m_classpathJar;

    public synchronized void addProcessBuildingListener(ProcessBuildingListener l) {
        if (this.m_ProcessBuildingListeners == null) {
            this.m_ProcessBuildingListeners = new Vector();
        }
        if (!this.m_ProcessBuildingListeners.contains(l)) {
            this.m_ProcessBuildingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeProcessBuildingListener(ProcessBuildingListener l) {
        if (this.m_ProcessBuildingListeners != null && this.m_ProcessBuildingListeners.contains(l)) {
            this.m_ProcessBuildingListeners.remove(l);
        }
    }

    protected void fireProcessBuilding(ProcessBuildEvent event) {
        if (this.m_ProcessBuildingListeners != null) {
            Vector vector = this.m_ProcessBuildingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ProcessBuildingListener)vector.elementAt(i)).ProcessBuilding(event);
            }
        }
    }

    public MultiProcessManager(Object object, int count) {
        this.m_processCount = count;
        this.m_classObject = object;
        this.m_timeout = SubprocessThread.TimeOutMS;
        this.m_customClasspath = "";
        this.m_classpathJar = "";
    }

    public MultiProcessManager(Object object, int count, String customClasspath) {
        this.m_processCount = count;
        this.m_classObject = object;
        this.m_timeout = SubprocessThread.TimeOutMS;
        this.m_customClasspath = customClasspath;
        this.m_classpathJar = "";
    }

    public int getProcessCount() {
        return this.m_processCount;
    }

    public void setProcessCount(int count) {
        this.m_processCount = count;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public void Run() {
        if (this.m_processCount == 0) {
            System.out.println("ProcessCount is zero!");
            return;
        }
        System.out.println(this.m_processCount);
        SubprocessThread.TimeOutMS = this.m_timeout;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> list = runtimeMXBean.getInputArguments();
        String string = this.m_classObject.getClass().getName();
        List<SubprocessThread> list2 = Collections.synchronizedList(new ArrayList());
        if (this.m_customClasspath == null || this.m_customClasspath.isEmpty()) {
            this.m_classpathJar = MultiProcessManager.createClasspathTempJar();
        }
        while (true) {
            Object object;
            if (list2.size() < this.m_processCount) {
                ProcessBuildEvent processBuildEvent = new ProcessBuildEvent(this);
                this.fireProcessBuilding(processBuildEvent);
                if (processBuildEvent.getActive()) {
                    object = new ArrayList();
                    ((ArrayList)object).add("java");
                    ((ArrayList)object).add("-cp");
                    if (this.m_customClasspath != null && !this.m_customClasspath.isEmpty()) {
                        ((ArrayList)object).add(this.m_customClasspath);
                    } else {
                        ((ArrayList)object).add(this.m_classpathJar);
                    }
                    ((ArrayList)object).add(string);
                    if (processBuildEvent.getArgs().size() > 0) {
                        for (int i = 0; i < processBuildEvent.getArgs().size(); ++i) {
                            ((ArrayList)object).add(processBuildEvent.getArgs().get(i));
                        }
                    }
                    SubprocessThread subprocessThread = new SubprocessThread((ArrayList<String>)object);
                    list2.add(subprocessThread);
                    subprocessThread.start();
                } else if (list2.size() == 0) break;
            }
            for (int i = list2.size() - 1; i > -1; --i) {
                object = (SubprocessThread)list2.get(i);
                ((SubprocessThread)object).timeout();
                if (!((SubprocessThread)object).isExit) continue;
                list2.remove(i);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException.getMessage());
            }
        }
        if (!this.m_classpathJar.isEmpty()) {
            new File(this.m_classpathJar).deleteOnExit();
        }
    }

    private static String createClasspathTempJar() {
        String string = System.getProperty("java.class.path");
        String[] stringArray = string.split(File.pathSeparator);
        StringBuilder stringBuilder = new StringBuilder();
        for (String object : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            try {
                stringBuilder.append(MultiProcessManager.toUrl(new File(object)));
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println(malformedURLException.getMessage());
            }
        }
        string = stringBuilder.toString();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        manifest.getMainAttributes().putValue(Attributes.Name.CLASS_PATH.toString(), string);
        manifest.getMainAttributes().putValue("Created-By", "SuperMap");
        String string2 = "";
        File file = null;
        try {
            file = File.createTempFile("mpmcp", ".jar");
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(file), manifest);){
            jarOutputStream.setLevel(9);
            jarOutputStream.flush();
            jarOutputStream.close();
            if (file != null) {
                string2 = file.getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        return string2;
    }

    private static URL toUrl(File classpathElement) throws MalformedURLException {
        URL uRL;
        try {
            uRL = classpathElement.toURI().toURL();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            uRL = classpathElement.toURL();
        }
        uRL = new URL("file", uRL.getHost(), uRL.getPort(), uRL.getFile());
        return uRL;
    }
}

