/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.chart;

import com.supermap.chart.InternalEnum;
import com.supermap.chart.InternalHandleDisposable;
import com.supermap.chart.InternalResource;
import com.supermap.chart.S57DatasetExtInfoNative;
import com.supermap.chart.S57DatasetType;
import com.supermap.data.Dataset;
import com.supermap.data.InternalHandle;

public class S57DatasetExtInfo
extends InternalHandleDisposable {
    private Dataset m_dataset;

    public S57DatasetExtInfo(Dataset dataset) {
        if (dataset == null) {
            String string = InternalResource.loadString("S57DatasetExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)dataset);
        this.setHandle(S57DatasetExtInfoNative.jni_New(l), true);
        this.setDataset(dataset);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            S57DatasetExtInfoNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public Dataset getDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_dataset;
    }

    public void setDataset(Dataset dataset) {
        if (dataset == null) {
            String string = InternalResource.loadString("S57DatasetExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dataset = dataset;
        if (dataset != null) {
            long l = InternalHandle.getHandle((InternalHandle)dataset);
            S57DatasetExtInfoNative.jni_setDataset(this.getHandle(), l);
        }
    }

    public S57DatasetType getS57DatasetType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = S57DatasetExtInfoNative.jni_getS57DatasetType(this.getHandle());
        return (S57DatasetType)InternalEnum.parseUGCValue(S57DatasetType.class, n);
    }

    public void setS57DatasetType(S57DatasetType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        S57DatasetExtInfoNative.jni_setS57DatasetType(this.getHandle(), value.value());
    }

    public String getFeatureAcronym() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return S57DatasetExtInfoNative.jni_getFeatureAcronym(this.getHandle());
    }

    public void setFeatureAcronym(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        S57DatasetExtInfoNative.jni_setFeatureAcronym(this.getHandle(), value);
    }

    public int getFeatureCode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return S57DatasetExtInfoNative.jni_getFeatureCode(this.getHandle());
    }

    public void setFeatureCode(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        S57DatasetExtInfoNative.jni_setFeatureCode(this.getHandle(), value);
    }

    public boolean update() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return S57DatasetExtInfoNative.jni_update(this.getHandle());
    }

    public boolean isChartDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return S57DatasetExtInfoNative.jni_isChartDataset(this.getHandle());
    }
}

