/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.DataImportNative;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.ImportDataInfo;
import com.supermap.data.conversion.ImportDataInfoECW;
import com.supermap.data.conversion.ImportDataInfoGRIB;
import com.supermap.data.conversion.ImportDataInfoIMG;
import com.supermap.data.conversion.ImportDataInfoJP2;
import com.supermap.data.conversion.ImportDataInfoMrSID;
import com.supermap.data.conversion.ImportDataInfoNetCDF;
import com.supermap.data.conversion.ImportDataInfoSIT;
import com.supermap.data.conversion.ImportDataInfoTIF;
import com.supermap.data.conversion.ImportDataInfoVRT;
import com.supermap.data.conversion.ImportDataInfoWOR;
import com.supermap.data.conversion.ImportDataInfos;
import com.supermap.data.conversion.ImportMode;
import com.supermap.data.conversion.ImportResult;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingECW;
import com.supermap.data.conversion.ImportSettingGRIB;
import com.supermap.data.conversion.ImportSettingIMG;
import com.supermap.data.conversion.ImportSettingJP2;
import com.supermap.data.conversion.ImportSettingMrSID;
import com.supermap.data.conversion.ImportSettingNetCDF;
import com.supermap.data.conversion.ImportSettingSIT;
import com.supermap.data.conversion.ImportSettingTIF;
import com.supermap.data.conversion.ImportSettingVRT;
import com.supermap.data.conversion.ImportSettingWOR;
import com.supermap.data.conversion.ImportSettingWORNative;
import com.supermap.data.conversion.ImportSettings;
import com.supermap.data.conversion.ImportSteppedEvent;
import com.supermap.data.conversion.ImportSteppedListener;
import com.supermap.data.conversion.InternalDataset;
import com.supermap.data.conversion.InternalDatasets;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.InternalToolkiConversion;
import com.supermap.data.conversion.InternalWorkspace;
import com.supermap.data.conversion.MultiBandImportMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class DataImport
extends InternalHandleDisposable {
    private static License m_license;
    private ImportSettings m_importSettings = new ImportSettings();
    transient Vector m_steppedListeners;
    private int m_completed = 0;
    private long m_selfEventHandle;

    public DataImport() {
        this.setHandle(DataImportNative.jni_New(), true);
    }

    private String getValidName(String targetName) {
        boolean bl;
        char c = targetName.charAt(0);
        boolean bl2 = c < '\u0080';
        boolean bl3 = c >= '0' && c <= '9';
        boolean bl4 = bl = c == '_';
        if (bl2 && (bl3 || bl)) {
            targetName = String.format("T%s", targetName);
        }
        for (int i = 0; i < targetName.length(); ++i) {
            boolean bl5;
            c = targetName.charAt(i);
            bl2 = c < '\u0080';
            bl3 = c >= '0' && c <= '9';
            bl = c == '_';
            boolean bl6 = bl5 = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
            if (!bl2 || bl5 || bl3 || bl) continue;
            targetName = targetName.replace(String.valueOf(c), "_");
        }
        return targetName;
    }

    private String[] getValidNames(ImportSetting setting) {
        String[] stringArray;
        ImportDataInfos importDataInfos = setting.getTargetDataInfos("");
        FileType fileType = setting.getSourceFileType();
        if (setting.getDataType() == DataType.RASTER) {
            ImportDataInfo importDataInfo;
            Object object;
            ImportDataInfo importDataInfo2 = importDataInfos.get(0);
            int n = 1;
            MultiBandImportMode multiBandImportMode = MultiBandImportMode.COMPOSITE;
            if (fileType == FileType.TIF) {
                object = (ImportSettingTIF)setting;
                multiBandImportMode = ((ImportSettingTIF)((Object)object)).getMultiBandImportMode();
                importDataInfo = (ImportDataInfoTIF)importDataInfo2;
                n = ((ImportDataInfoTIF)importDataInfo).getBandCount();
            } else if (fileType == FileType.IMG) {
                object = (ImportSettingIMG)setting;
                multiBandImportMode = ((ImportSettingIMG)((Object)object)).getMultiBandImportMode();
                importDataInfo = (ImportDataInfoIMG)importDataInfo2;
                n = ((ImportDataInfoIMG)importDataInfo).getBandCount();
            } else if (fileType == FileType.GRIB) {
                object = (ImportSettingGRIB)setting;
                multiBandImportMode = ((ImportSettingGRIB)((Object)object)).getMultiBandImportMode();
                importDataInfo = (ImportDataInfoGRIB)importDataInfo2;
                n = ((ImportDataInfoGRIB)importDataInfo).getBandCount();
            } else if (fileType == FileType.ECW) {
                object = (ImportSettingECW)setting;
                multiBandImportMode = ((ImportSettingECW)((Object)object)).getMultiBandImportMode();
                importDataInfo = (ImportDataInfoECW)importDataInfo2;
                n = ((ImportDataInfoECW)importDataInfo).getBandCount();
            } else if (fileType == FileType.JP2) {
                object = (ImportSettingJP2)setting;
                multiBandImportMode = ((ImportSettingJP2)((Object)object)).getMultiBandImportMode();
                importDataInfo = (ImportDataInfoJP2)importDataInfo2;
                n = ((ImportDataInfoJP2)importDataInfo).getBandCount();
            } else if (fileType == FileType.MrSID) {
                object = (ImportSettingMrSID)setting;
                multiBandImportMode = ((ImportSettingMrSID)((Object)object)).getMultiBandImportMode();
                importDataInfo = (ImportDataInfoMrSID)importDataInfo2;
                n = ((ImportDataInfoMrSID)importDataInfo).getBandCount();
            } else if (fileType == FileType.NetCDF) {
                object = (ImportSettingNetCDF)setting;
                multiBandImportMode = ((ImportSettingNetCDF)((Object)object)).getMultiBandImportMode();
                importDataInfo = (ImportDataInfoNetCDF)importDataInfo2;
                n = ((ImportDataInfoNetCDF)importDataInfo).getBandCount();
            } else if (fileType == FileType.SIT) {
                object = (ImportSettingSIT)setting;
                multiBandImportMode = ((ImportSettingSIT)((Object)object)).getMultiBandImportMode();
                importDataInfo = (ImportDataInfoSIT)importDataInfo2;
                n = ((ImportDataInfoSIT)importDataInfo).getBandCount();
            } else if (fileType == FileType.VRT) {
                object = (ImportSettingVRT)setting;
                multiBandImportMode = ((ImportSettingVRT)((Object)object)).getMultiBandImportMode();
                importDataInfo = (ImportDataInfoVRT)importDataInfo2;
                n = ((ImportDataInfoVRT)importDataInfo).getBandCount();
            }
            object = this.getValidName(importDataInfo2.getTargetName());
            if (multiBandImportMode == MultiBandImportMode.SINGLEBAND && n > 1) {
                if (fileType == FileType.GRIB) {
                    importDataInfo = (ImportDataInfoGRIB)importDataInfo2;
                    stringArray = ((ImportDataInfoGRIB)importDataInfo).getBandNames();
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = String.format("%s_%s", object, stringArray[i]);
                    }
                } else {
                    stringArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = String.format("%s_band_%d", object, i);
                    }
                }
            } else {
                stringArray = new String[]{object};
            }
        } else {
            stringArray = new String[importDataInfos.getCount()];
            for (int i = 0; i < importDataInfos.getCount(); ++i) {
                ImportDataInfo importDataInfo = importDataInfos.get(i);
                stringArray[i] = this.getValidName(importDataInfo.getTargetName());
            }
        }
        return stringArray;
    }

    private DatasetType toDatasetType(int type) {
        DatasetType datasetType;
        try {
            datasetType = (DatasetType)InternalEnum.parseUGCValue(DatasetType.class, type);
        }
        catch (RuntimeException runtimeException) {
            datasetType = type == 88 ? DatasetType.IMAGE : (type == 89 ? DatasetType.GRID : (type == 90 ? DatasetType.GRID : (type == 84 ? DatasetType.GRID : DatasetType.UNKNOWN)));
        }
        return datasetType;
    }

    /*
     * WARNING - void declaration
     */
    private boolean importWOR(ImportSettingWOR settingWor, int[] values) {
        ImportDataInfoWOR importDataInfoWOR = (ImportDataInfoWOR)settingWor.getTargetDataInfos("").get(0);
        String[] stringArray = new String[importDataInfoWOR.getDatasetNames().size()];
        String[] stringArray2 = new String[importDataInfoWOR.getDatasetNames().size()];
        String[] stringArray3 = new String[importDataInfoWOR.getMapNames().size()];
        String[] stringArray4 = new String[importDataInfoWOR.getMapNames().size()];
        Set<String> set = importDataInfoWOR.getDatasetNames().keySet();
        int n = 0;
        if (set.size() > 0) {
            for (Object e : set) {
                stringArray[n] = (String)e;
                stringArray2[n] = importDataInfoWOR.getDatasetNames().get(stringArray[n]);
                ++n;
            }
        }
        Set<String> set2 = importDataInfoWOR.getMapNames().keySet();
        boolean n2 = false;
        if (set2.size() > 0) {
            Iterator bl = set2.iterator();
            while (bl.hasNext()) {
                void var11_13;
                Object n3 = bl.next();
                stringArray3[var11_13] = (String)n3;
                stringArray4[var11_13] = importDataInfoWOR.getMapNames().get(stringArray3[var11_13]);
                ++var11_13;
            }
        }
        boolean bl = false;
        DataImportNative.jni_SetMapsAndDatasets(com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)settingWor), stringArray, stringArray2, stringArray3, stringArray4);
        if (settingWor.getTargetWorkspaceConnectionInfo() != null && settingWor.getTargetDatasourceConnectionInfo() != null) {
            ImportSettingWORNative.jni_setWsInfo(com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)settingWor), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)settingWor.getTargetWorkspaceConnectionInfo()));
            bl = DataImportNative.jni_ImportData(this.getHandle(), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)settingWor), settingWor.getDataType().value(), values, com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)settingWor.getTargetDatasourceConnectionInfo()));
        }
        if (settingWor.getTargetWorkspace() != null && settingWor.getTargetDatasourceConnectionInfo() != null) {
            bl = DataImportNative.jni_ImportData2(this.getHandle(), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)settingWor), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)settingWor.getTargetWorkspace()), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)settingWor.getTargetDatasourceConnectionInfo()));
            InternalWorkspace.refresh(settingWor.getTargetWorkspace());
        }
        if (settingWor.getTargetWorkspace() != null && settingWor.getTargetDatasource() != null) {
            int n3 = settingWor.getTargetWorkspace().getDatasources().getCount();
            for (int datasource = 0; datasource < n3; ++datasource) {
                if (!settingWor.getTargetWorkspace().getDatasources().get(datasource).equals(settingWor.getTargetDatasource())) continue;
                bl = true;
                break;
            }
            if (bl) {
                Datasource datasource = settingWor.getTargetDatasource();
                Dataset dataset = null;
                if (settingWor.getImportMode() == ImportMode.OVERWRITE) {
                    for (String string : stringArray2) {
                        datasource.getDatasets().delete(string);
                    }
                } else if (settingWor.getImportMode() == ImportMode.APPEND) {
                    dataset = new String[datasource.getDatasets().getCount()];
                    for (int i = 0; i < ((String[])dataset).length; ++i) {
                        dataset[i] = datasource.getDatasets().get(i).getName();
                    }
                }
                if (bl = DataImportNative.jni_ImportData3(this.getHandle(), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)settingWor), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)settingWor.getTargetWorkspace()), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)settingWor.getTargetDatasource()))) {
                    String[] i = this.getSucImportDtNames();
                    int n4 = i.length;
                    long[] lArray = new long[n4];
                    int[] nArray = new int[n4];
                    DataImportNative.jni_GetSucImportDatasets(this.getHandle(), lArray, nArray);
                    for (int j = 0; j < n4; ++j) {
                        DatasetType datasetType;
                        if (lArray[j] == 0L) continue;
                        if (settingWor.getImportMode() == ImportMode.APPEND) {
                            boolean bl2 = false;
                            if (dataset != null) {
                                for (String string : dataset) {
                                    if (!i[j].equals(string)) continue;
                                    bl2 = true;
                                    break;
                                }
                            }
                            if (bl2) continue;
                        }
                        if ((datasetType = this.toDatasetType(nArray[j])) == DatasetType.UNKNOWN) continue;
                        try {
                            Dataset dataset2 = InternalDataset.createInstance(lArray[j], datasetType, datasource);
                            if (dataset2 == null) continue;
                            InternalDatasets.add(datasource.getDatasets(), dataset2);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                InternalWorkspace.refresh(settingWor.getTargetWorkspace());
            }
        }
        return bl;
    }

    public ImportResult run() {
        Object object;
        this.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("importData()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_selfEventHandle = DataImportNative.jni_NewSelfEventHandle(this.getHandle(), this);
        this.m_completed = 0;
        int n = this.m_importSettings.getCount();
        ArrayList<ImportSetting> arrayList = new ArrayList<ImportSetting>();
        ArrayList<ImportSetting> arrayList2 = new ArrayList<ImportSetting>();
        ArrayList<String[]> arrayList3 = new ArrayList<String[]>();
        ArrayList<String[]> arrayList4 = new ArrayList<String[]>();
        for (int i = 0; i < n; ++i) {
            Object object2;
            Object object3;
            int n2;
            object = this.m_importSettings.get(i).getStates();
            if (object == null) {
                object = new ArrayList();
            }
            int[] nArray = new int[((ArrayList)object).size()];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = (Boolean)((ArrayList)object).get(n2) != false ? 1 : 0;
            }
            n2 = 0;
            ImportSetting importSetting = this.m_importSettings.get(i);
            if (importSetting.getDataType().equals((Object)DataType.WOR)) {
                if (!(((ImportSettingWOR)importSetting).getTargetWorkspaceConnectionInfo() == null && ((ImportSettingWOR)importSetting).getTargetWorkspace() == null || importSetting.getTargetDatasourceConnectionInfo() == null && importSetting.getTargetDatasource() == null)) {
                    n2 = this.importWOR((ImportSettingWOR)importSetting, nArray) ? 1 : 0;
                }
            } else if (importSetting.getTargetDatasourceConnectionInfo() != null) {
                n2 = DataImportNative.jni_ImportData(this.getHandle(), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSetting), importSetting.getDataType().value(), nArray, com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSetting.getTargetDatasourceConnectionInfo())) ? 1 : 0;
            } else if (importSetting.getTargetDatasource() != null) {
                Datasource datasource = importSetting.getTargetDatasource();
                object3 = null;
                if (importSetting.getImportMode() == ImportMode.OVERWRITE) {
                    object2 = this.getValidNames(importSetting);
                    for (String string : object2) {
                        datasource.getDatasets().delete(string);
                    }
                } else if (importSetting.getImportMode() == ImportMode.APPEND) {
                    object3 = new String[datasource.getDatasets().getCount()];
                    for (int j = 0; j < ((String[])object3).length; ++j) {
                        object3[j] = datasource.getDatasets().get(j).getName();
                    }
                }
                if ((n2 = (int)(DataImportNative.jni_ImportData4(this.getHandle(), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSetting), importSetting.getDataType().value(), nArray, com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSetting.getTargetDatasource())) ? 1 : 0)) != 0) {
                    object2 = this.getSucImportDtNames();
                    int n3 = ((String[])object2).length;
                    long[] lArray = new long[n3];
                    int[] nArray2 = new int[n3];
                    DataImportNative.jni_GetSucImportDatasets(this.getHandle(), lArray, nArray2);
                    for (int j = 0; j < n3; ++j) {
                        DatasetType datasetType;
                        if (lArray[j] == 0L) continue;
                        if (importSetting.getImportMode() == ImportMode.APPEND) {
                            boolean bl = false;
                            if (null == object3) continue;
                            for (String string : object3) {
                                if (!((String)object2[j]).equals(string)) continue;
                                bl = true;
                                break;
                            }
                            if (bl) continue;
                        }
                        if ((datasetType = this.toDatasetType(nArray2[j])) == DatasetType.UNKNOWN) continue;
                        try {
                            Dataset dataset = InternalDataset.createInstance(lArray[j], datasetType, datasource);
                            if (dataset == null) continue;
                            InternalDatasets.add(datasource.getDatasets(), dataset);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++this.m_completed;
            int n4 = this.m_completed * 100 / n;
            object3 = this.getImportSettings().get(this.m_completed - 1);
            object2 = new ImportSteppedEvent((Object)this, null, null, n4, 100, (ImportSetting)((Object)object3), n, false);
            this.fireStepped((ImportSteppedEvent)object2);
            if (((ImportSteppedEvent)object2).getCancel()) break;
            if (n2 != 0) {
                arrayList.add(importSetting);
                arrayList3.add(this.getSucImportDtNames());
                arrayList4.add(this.getSucImportMapNames());
                continue;
            }
            arrayList2.add(importSetting);
        }
        this.clearSelfEventHandle();
        ImportSetting[] importSettingArray = new ImportSetting[arrayList.size()];
        object = new ImportSetting[arrayList2.size()];
        arrayList.toArray(importSettingArray);
        arrayList2.toArray((T[])object);
        return new ImportResult(importSettingArray, (ImportSetting[])object, arrayList3, arrayList4);
    }

    private String[] getSucImportDtNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportSettings()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return DataImportNative.jni_GetSucImportDTNames(this.getHandle());
    }

    private String[] getSucImportMapNames() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportSettings()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return DataImportNative.jni_GetSucImportMapNames(this.getHandle());
    }

    public ImportSettings getImportSettings() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportSettings()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_importSettings;
    }

    public void setImportSettings(ImportSettings settings) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportSettings(ImportSettings settings)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this.m_importSettings = settings;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            DataImportNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
        this.clearSelfEventHandle();
    }

    public synchronized void addImportSteppedListener(ImportSteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public synchronized void removeImportSteppedListener(ImportSteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    protected void fireStepped(ImportSteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ImportSteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void importSteppedCallBack(DataImport dataImport, String title, String message, int nPercent, long cancelHandle) {
        int n = nPercent;
        int n2 = dataImport.getImportSettings().getCount();
        int n3 = dataImport.m_completed;
        ImportSetting importSetting = dataImport.getImportSettings().get(n3);
        int n4 = (n3 * 100 + n) / n2;
        Boolean bl = InternalToolkiConversion.getHandleBooleanValue(cancelHandle);
        ImportSteppedEvent importSteppedEvent = new ImportSteppedEvent((Object)dataImport, title, message, n4, n, importSetting, n2, bl);
        dataImport.fireStepped(importSteppedEvent);
        InternalToolkiConversion.setHandleBooleanValue(cancelHandle, importSteppedEvent.getCancel());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)dataImport));
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DataImportNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
        int n2 = this.m_importSettings.getCount();
        for (int i = 0; i < n2; ++i) {
            ImportSetting importSetting = this.m_importSettings.get(i);
            importSetting.CheakFMELicense();
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkiConversion.managerProducts(InternalToolkiConversion.getDataProducts());
        m_license = InternalToolkiConversion.verifyLicense(arrayList);
    }
}

