/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.edu.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfo {
    private String mac = "";
    private String name = "";
    private static SystemInfo systemInfo = new SystemInfo();
    private String[] windowsCommand = new String[]{"ipconfig", "/all"};
    private String[] linuxCommand = new String[]{"/sbin/ifconfig", "-a"};
    private Pattern macPattern = Pattern.compile(".*((:?[0-9a-f]{2}[-:]){5}[0-9a-f]{2}).*", 2);
    private Logger logger = LoggerFactory.getLogger(SystemInfo.class);

    private SystemInfo() {
        this.mac = this.getMacAddress();
        try {
            InetAddress address = InetAddress.getLocalHost();
            this.name = address.getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    public ArrayList<String> getMacAddressList() throws IOException {
        ArrayList<String> macAddressList = new ArrayList<String>();
        String os = System.getProperty("os.name");
        String[] command = null;
        if (os.startsWith("Windows")) {
            command = this.windowsCommand;
        } else if (os.startsWith("Linux")) {
            command = this.linuxCommand;
        } else {
            this.logger.warn("Unknow operating system:" + os);
        }
        if (command != null) {
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader bufReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = bufReader.readLine()) != null) {
                Matcher matcher = this.macPattern.matcher(line);
                if (!matcher.matches()) continue;
                macAddressList.add(matcher.group(1).replaceAll("[-:]", ""));
            }
            process.destroy();
            bufReader.close();
        }
        return macAddressList;
    }

    public String getMacAddress() {
        String macString = "";
        StringBuffer sb = new StringBuffer();
        try {
            ArrayList<String> macList = this.getMacAddressList();
            for (String amac : macList) {
                if (amac.equals("0000000000E0")) continue;
                sb.append(amac);
                break;
            }
            macString = sb.toString();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
        return macString;
    }

    public String toXml() {
        String xml = "<system>";
        xml = xml + "<mac>" + this.mac + "</mac>";
        xml = xml + "<name>" + this.name + "</name>";
        xml = xml + "</system>";
        return xml;
    }

    public static SystemInfo getSystemInfo() {
        return systemInfo;
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

