/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.edu.util;

import com.google.gson.Gson;
import com.supermap.data.edu.util.EduIpsResult;
import com.supermap.data.edu.util.EduLicenseInfo;
import com.supermap.data.edu.util.EduLicenseParam;
import com.supermap.data.edu.util.EduLicenseResult;
import com.supermap.data.edu.util.HttpRequest;
import com.supermap.data.edu.util.SystemInfo;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class EduLicenseService {
    private final String urlEduServerIp = "/edu/api/v1/external/eduServer";
    private final String urlEnd = "/edu/api/v1/external/licenseFile";
    private Gson gson = new Gson();
    private HttpRequest httpRequest = new HttpRequest();

    public void setHttpRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public EduLicenseResult apply(EduLicenseParam param) {
        EduLicenseResult result = new EduLicenseResult();
        SystemInfo systemInfo = SystemInfo.getSystemInfo();
        if (param.getUrl() != null && param.getProductType() != null && param.getVersion() != null) {
            if (systemInfo != null) {
                EduIpsResult resultIps;
                ArrayList<String> ips;
                String ipResult = this.httpRequest.sendPost(param.getUrl() + "/edu/api/v1/external/eduServer", "");
                if ("\u8fde\u63a5\u4e0d\u4e0a\u9ad8\u6821\u670d\u52a1\u5668".equals(ipResult)) {
                    result.setMessage("\u8fde\u63a5\u4e0d\u4e0a\u9ad8\u6821\u670d\u52a1\u5668");
                } else if (ipResult != null && !ipResult.isEmpty() && (ips = (resultIps = this.gson.fromJson(ipResult, EduIpsResult.class)).getIps()) != null && !ips.isEmpty()) {
                    EduLicenseInfo info = new EduLicenseInfo();
                    info.setProductId(param.getProductType().getId());
                    info.setVersion(param.getVersion().getName());
                    info.setMac(systemInfo.getMac());
                    info.setHostName(systemInfo.getName());
                    String json = this.gson.toJson((Object)info, (Type)((Object)EduLicenseInfo.class));
                    for (int i = 0; i < ips.size(); ++i) {
                        String urlRoot = (String)ips.get(i);
                        String response = this.httpRequest.sendPost(urlRoot + "/edu/api/v1/external/licenseFile", json);
                        if ("\u8fde\u63a5\u4e0d\u4e0a\u9ad8\u6821\u670d\u52a1\u5668".equals(response)) {
                            result.setMessage("\u8fde\u63a5\u4e0d\u4e0a\u9ad8\u6821\u670d\u52a1\u5668");
                            continue;
                        }
                        if (response == null || response.isEmpty()) continue;
                        result = this.gson.fromJson(response, EduLicenseResult.class);
                        break;
                    }
                }
            } else {
                result.setMessage("\u627e\u4e0d\u5230\u7cfb\u7edf\u4fe1\u606f");
            }
        } else if (param.getUrl() == null) {
            result.setMessage("\u8bf7\u8bbe\u7f6e\u8bb8\u53ef\u670d\u52a1\u5730\u5740");
        }
        return result;
    }
}

