/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.analyst.trafficanalyst.InternalResource;
import com.supermap.analyst.trafficanalyst.LineSetting;
import com.supermap.analyst.trafficanalyst.LineSettingsNatvie;
import com.supermap.data.Datasource;
import java.util.ArrayList;

class LineSettings {
    private ArrayList<LineSetting> m_settings = new ArrayList();

    public LineSettings() {
    }

    public LineSettings(LineSettings lineSettings) {
        LineSetting[] lineSettingArray = lineSettings.toArray();
        this.addRange(lineSettingArray);
    }

    public int getCount() {
        return this.m_settings.size();
    }

    public LineSetting get(int index) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_settings.get(index);
    }

    public void set(int index, LineSetting transferLineSetting) {
        if (transferLineSetting == null) {
            String string = InternalResource.loadString("transferLineSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this.m_settings.set(index, transferLineSetting);
    }

    public int add(LineSetting lineSetting) {
        if (lineSetting == null) {
            String string = InternalResource.loadString("transferLineSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_settings.add(lineSetting);
        return this.m_settings.size();
    }

    public int addRange(LineSetting[] lineSettings) {
        int n;
        if (lineSettings == null) {
            String string = InternalResource.loadString("transferLineSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        boolean bl = false;
        for (n = 0; n < lineSettings.length; ++n) {
            if (lineSettings[n] != null) continue;
            bl = true;
            break;
        }
        if (bl) {
            String string = InternalResource.loadString("transferLineSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        for (n = 0; n < lineSettings.length; ++n) {
            this.m_settings.add(lineSettings[n]);
        }
        return lineSettings.length;
    }

    public boolean remove(int index) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this.m_settings.remove(index);
        return true;
    }

    public int removeRange(int index, int count) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = index + count;
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index+count", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        for (int i = n - 1; i >= index; --i) {
            this.m_settings.remove(i);
        }
        return count;
    }

    public void clear() {
        this.m_settings.clear();
    }

    public LineSetting[] toArray() {
        int n = this.m_settings.size();
        LineSetting[] lineSettingArray = new LineSetting[n];
        for (int i = 0; i < lineSettingArray.length; ++i) {
            lineSettingArray[i] = new LineSetting(this.m_settings.get(i));
        }
        return lineSettingArray;
    }

    long setToUGC() {
        int n = this.m_settings.size();
        long l = LineSettingsNatvie.jni_New();
        for (int i = 0; i < n; ++i) {
            this.m_settings.get(i).setToUGC(l, i);
        }
        return l;
    }

    void getFromUGC(Datasource ds, long handle) {
        long[] lArray = LineSettingsNatvie.jni_GetHandls(handle);
        this.m_settings = new ArrayList();
        for (int i = 0; i < lArray.length; ++i) {
            LineSetting lineSetting = new LineSetting();
            lineSetting.getFromUGC(ds, lArray[i]);
            this.m_settings.add(lineSetting);
        }
    }
}

