/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.analyst.trafficanalyst.FareFieldInfo;
import com.supermap.analyst.trafficanalyst.InternalHandle;
import com.supermap.analyst.trafficanalyst.InternalResource;
import com.supermap.analyst.trafficanalyst.LineSettingNative;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasets;
import com.supermap.data.Datasource;
import com.supermap.data.FieldType;

public class LineSetting {
    private DatasetVector m_dataset;
    private String m_nameField;
    private String m_aliasField;
    private String m_firstTimeField;
    private String m_lastTimeField;
    private String m_intervalField;
    private String m_speedField;
    private String m_lineTypeField;
    private FareFieldInfo m_fareFieldInfo;
    private String m_lineIDField;
    private String m_lineLengthField;

    public LineSetting() {
        this.m_dataset = null;
        this.m_nameField = "";
        this.m_aliasField = "";
        this.m_firstTimeField = "";
        this.m_lastTimeField = "";
        this.m_intervalField = "";
        this.m_speedField = "";
        this.m_lineTypeField = "";
        this.m_lineIDField = "";
        this.m_lineLengthField = "";
        this.m_fareFieldInfo = new FareFieldInfo();
    }

    public LineSetting(LineSetting lineSetting) {
        this.setDataset(lineSetting.getDataset());
        this.setNameField(lineSetting.getNameField());
        if (lineSetting.getAliasField() != null && lineSetting.getAliasField().trim().length() != 0) {
            this.setAliasField(lineSetting.getAliasField());
        }
        if (lineSetting.getFirstTimeField() != null && lineSetting.getFirstTimeField().trim().length() != 0) {
            this.setFirstTimeField(lineSetting.getFirstTimeField());
        }
        if (lineSetting.getLastTimeField() != null && lineSetting.getLastTimeField().trim().length() != 0) {
            this.setLastTimeField(lineSetting.getLastTimeField());
        }
        if (lineSetting.getIntervalField() != null && lineSetting.getIntervalField().trim().length() != 0) {
            this.setIntervalField(lineSetting.getIntervalField());
        }
        if (lineSetting.getSpeedField() != null && lineSetting.getSpeedField().trim().length() != 0) {
            this.setSpeedField(lineSetting.getSpeedField());
        }
        if (lineSetting.getLineTypeField() != null && lineSetting.getLineTypeField().trim().length() != 0) {
            this.setLineTypeField(lineSetting.getLineTypeField());
        }
        this.setLineIDField(lineSetting.getLineIDField());
        this.setLengthField(lineSetting.getLengthField());
        this.m_fareFieldInfo = new FareFieldInfo(lineSetting.getFareFieldInfo());
    }

    public DatasetVector getDataset() {
        return this.m_dataset;
    }

    public void setDataset(DatasetVector datasetVector) {
        this.m_dataset = datasetVector;
    }

    public String getNameField() {
        return this.m_nameField;
    }

    public void setNameField(String value) {
        this.m_nameField = value;
    }

    public String getAliasField() {
        return this.m_aliasField;
    }

    public void setAliasField(String value) {
        this.m_aliasField = value;
    }

    public String getFirstTimeField() {
        return this.m_firstTimeField;
    }

    public void setFirstTimeField(String value) {
        this.m_firstTimeField = value;
    }

    public String getLastTimeField() {
        return this.m_lastTimeField;
    }

    public void setLastTimeField(String value) {
        this.m_lastTimeField = value;
    }

    public String getIntervalField() {
        return this.m_intervalField;
    }

    public void setIntervalField(String value) {
        this.m_intervalField = value;
    }

    public String getLineTypeField() {
        return this.m_lineTypeField;
    }

    public void setLineTypeField(String value) {
        this.m_lineTypeField = value;
    }

    public String getSpeedField() {
        return this.m_speedField;
    }

    public void setSpeedField(String value) {
        this.m_speedField = value;
    }

    public FareFieldInfo getFareFieldInfo() {
        return this.m_fareFieldInfo;
    }

    public void setLineIDField(String value) {
        this.m_lineIDField = value;
    }

    public String getLineIDField() {
        return this.m_lineIDField;
    }

    public void setLengthField(String value) {
        this.m_lineLengthField = value;
    }

    public String getLengthField() {
        return this.m_lineLengthField;
    }

    public void setFareFieldInfo(FareFieldInfo fareFieldInfo) {
        if (fareFieldInfo == null) {
            String string = InternalResource.loadString("fareFieldInfo", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_fareFieldInfo = fareFieldInfo;
    }

    void setToUGC(long settingHandles, int index) {
        this.check();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_dataset);
        LineSettingNative.jni_SetAllToUGC(settingHandles, l, this.m_lineIDField, this.m_nameField, this.m_aliasField, this.m_firstTimeField, this.m_lastTimeField, this.m_intervalField, this.m_speedField, this.m_lineTypeField, this.m_lineLengthField, this.m_fareFieldInfo.getFareTypeField(), this.m_fareFieldInfo.getStartFareRangeField(), this.m_fareFieldInfo.getStartFareField(), this.m_fareFieldInfo.getFareStepField(), this.m_fareFieldInfo.getFareStepRangeField());
    }

    void getFromUGC(Datasource ds, long settingHandle) {
        String string = LineSettingNative.jni_GetFieldsFromUGC(settingHandle);
        int n = -1;
        int n2 = string.indexOf(",", 0);
        this.m_lineIDField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        n2 = string.indexOf(",", n2 + 1);
        this.m_nameField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        n2 = string.indexOf(",", n2 + 1);
        this.m_aliasField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        n2 = string.indexOf(",", n2 + 1);
        this.m_firstTimeField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        n2 = string.indexOf(",", n2 + 1);
        this.m_lastTimeField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        n2 = string.indexOf(",", n2 + 1);
        this.m_intervalField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        n2 = string.indexOf(",", n2 + 1);
        this.m_speedField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        n2 = string.indexOf(",", n2 + 1);
        this.m_lineTypeField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        this.m_lineLengthField = string.substring(n + 1);
        long l = LineSettingNative.jni_GetDataset(settingHandle);
        Datasets datasets = ds.getDatasets();
        for (int i = 0; i < datasets.getCount(); ++i) {
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasets.get(i));
            if (l2 != l) continue;
            this.m_dataset = (DatasetVector)datasets.get(i);
            break;
        }
        this.m_fareFieldInfo = new FareFieldInfo();
        this.m_fareFieldInfo.getFromUGC(settingHandle);
    }

    void check() {
        if (this.m_dataset == null) {
            String string = InternalResource.loadString("m_dataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_dataset.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("datasetVector", "TransferAnalyst_DatasetTypeMustBeLine", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_lineIDField == null || this.m_lineIDField.trim().length() == 0) {
            String string = InternalResource.loadString("m_lineIDField", "Global_StringIsNullOrEmpty", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_dataset.getFieldInfos().indexOf(this.m_lineIDField) == -1) {
            String string = InternalResource.loadString("m_LineIDField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_dataset.getFieldInfos().get(this.m_lineIDField).getType() != FieldType.INT32 && this.m_dataset.getFieldInfos().get(this.m_lineIDField).getType() != FieldType.INT64) {
            String string = InternalResource.loadString("m_LineIDField", "FieldType_UnSupport", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_nameField == null || this.m_nameField.trim().length() == 0) {
            String string = InternalResource.loadString("m_nameField", "Global_StringIsNullOrEmpty", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_dataset.getFieldInfos().indexOf(this.m_nameField) == -1) {
            String string = InternalResource.loadString("m_nameField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_firstTimeField != null && this.m_firstTimeField.length() != 0) {
            if (this.m_dataset.getFieldInfos().indexOf(this.m_firstTimeField) == -1) {
                String string = InternalResource.loadString("FirstTimeField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.m_dataset.getFieldInfos().get(this.m_firstTimeField).getType() != FieldType.DATETIME) {
                String string = InternalResource.loadString("FirstTimeField", "FieldType_UnSupport", "trafficanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (this.m_lastTimeField != null && this.m_lastTimeField.length() != 0) {
            if (this.m_dataset.getFieldInfos().indexOf(this.m_lastTimeField) == -1) {
                String string = InternalResource.loadString("LastTimeField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.m_dataset.getFieldInfos().get(this.m_lastTimeField).getType() != FieldType.DATETIME) {
                String string = InternalResource.loadString("LastTimeField", "FieldType_UnSupport", "trafficanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (this.m_aliasField != null && this.m_aliasField.length() != 0 && this.m_dataset.getFieldInfos().indexOf(this.m_aliasField) == -1) {
            String string = InternalResource.loadString("AliasField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_intervalField != null && this.m_intervalField.length() != 0 && this.m_dataset.getFieldInfos().indexOf(this.m_intervalField) == -1) {
            String string = InternalResource.loadString("IntervalField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_lineTypeField != null && this.m_lineTypeField.length() != 0 && this.m_dataset.getFieldInfos().indexOf(this.m_lineTypeField) == -1) {
            String string = InternalResource.loadString("LineTypeField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_speedField != null && this.m_speedField.length() != 0 && this.m_dataset.getFieldInfos().indexOf(this.m_speedField) == -1) {
            String string = InternalResource.loadString("SpeedField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }
}

