/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.callpy;

import com.supermap.jsuperpy.ProcessInfo;
import com.supermap.jsuperpy.Tile;
import com.supermap.jsuperpy.callpy.Utils;
import com.supermap.jsuperpy.serializer.DataSerializers;
import com.supermap.jsuperpy.serializer.impl.MapSerializer;
import com.supermap.jsuperpy.serializer.impl.TileSerializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;

public class ProcessTilePipe {
    private Socket socket = null;
    private DataOutputStream out = null;
    private DataInputStream in = null;
    private String pyText;
    private String entryClassName;
    private TileSerializer tileSerializer = new TileSerializer();
    private MapSerializer mapSerializer = new MapSerializer();

    public ProcessTilePipe(String pyText, String entryClassName) {
        this.pyText = pyText;
        this.entryClassName = entryClassName;
    }

    public ProcessTilePipe setArgs(Map<String, Object> args) throws IOException {
        if (args != null && args.size() > 0) {
            if (this.in.readInt() == 6) {
                this.out.writeInt(7);
                Utils.writeBytesAndLength(this.mapSerializer.encode(args), this.out);
            } else {
                throw new RuntimeException("invalid command, required 6");
            }
        }
        return this;
    }

    public Map<Object, Object> getUpdateInfo() throws IOException {
        if (this.in.readInt() == 6) {
            this.out.writeInt(5);
            byte[] updateInfoBytes = Utils.readBytesAndLength(this.in);
            return new MapSerializer().decode(updateInfoBytes);
        }
        throw new RuntimeException("invalid command, required 6");
    }

    public ProcessTilePipe start() throws IOException {
        if (this.socket != null) {
            this.in.close();
            this.out.close();
            this.socket.close();
        }
        ServerSocket serverSocket = Utils.startPythonProcess();
        this.socket = serverSocket.accept();
        this.out = new DataOutputStream(this.socket.getOutputStream());
        this.in = new DataInputStream(this.socket.getInputStream());
        this.out.writeInt(20);
        this.out.flush();
        ProcessInfo processInfo = new ProcessInfo(this.pyText, this.entryClassName, null);
        byte[] processInfoBytes = DataSerializers.encode(processInfo);
        Utils.writeBytesAndLength(processInfoBytes, this.out);
        return this;
    }

    public void shutdown() {
        try {
            this.in.readInt();
            this.out.writeInt(-1);
            this.out.close();
            this.in.close();
            this.socket.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public Object process(Object args) throws IOException, RuntimeException {
        if (this.in.readInt() == 6) {
            this.out.writeInt(2);
            Utils.writeBytesAndLength(DataSerializers.serialize(args), this.out);
            return DataSerializers.deserialize(Utils.readBytesAndLength(this.in));
        }
        throw new RuntimeException("invalid command, required 6");
    }

    public Tile processTile(Tile tile) throws IOException, RuntimeException {
        if (this.in.readInt() == 6) {
            this.out.writeInt(31);
            Utils.writeBytesAndLength(this.tileSerializer.encode(tile), this.out);
            return this.tileSerializer.decode(Utils.readBytesAndLength(this.in));
        }
        throw new RuntimeException("invalid command, required 6");
    }

    public Tile processTiles(Tile[] tiles) throws IOException, RuntimeException {
        if (this.in.readInt() == 6) {
            this.out.writeInt(32);
            this.out.writeInt(tiles.length);
            for (Tile tile : tiles) {
                Utils.writeBytesAndLength(this.tileSerializer.encode(tile), this.out);
            }
            return this.tileSerializer.decode(Utils.readBytesAndLength(this.in));
        }
        throw new RuntimeException("invalid command, required 6");
    }
}

