/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing.cache;

import com.supermap.data.Rectangle2D;
import com.supermap.data.processing.CacheWriter;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.TileFormat;
import com.supermap.data.processing.cache.MergeCompactRunner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CacheMerge {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("args is missing, [src sci , des sci].");
            return;
        }
        int n = 4;
        if (args.length > 2) {
            n = Integer.valueOf(args[2]);
        }
        long l = System.currentTimeMillis();
        String string = args[0];
        String string2 = args[1];
        CacheWriter cacheWriter = new CacheWriter();
        CacheWriter cacheWriter2 = new CacheWriter();
        cacheWriter.FromConfigFile(string);
        cacheWriter2.FromConfigFile(string2);
        if (cacheWriter2.getStorageType() != StorageType.Compact || cacheWriter.getStorageType() != StorageType.Compact) {
            System.out.println("cache's strotage type is not Compact.");
            return;
        }
        Rectangle2D rectangle2D = cacheWriter.getIndexBounds();
        Rectangle2D rectangle2D2 = cacheWriter2.getIndexBounds();
        if (rectangle2D2.getLeft() != rectangle2D.getLeft() || rectangle2D2.getTop() != rectangle2D.getTop()) {
            System.out.println("cache's indexbounds is diffrent.");
            return;
        }
        if (cacheWriter2.getTileSize().value() != cacheWriter.getTileSize().value()) {
            System.out.println("cache's tile size is diffrent.");
            return;
        }
        Rectangle2D rectangle2D3 = cacheWriter.getCacheBounds();
        Rectangle2D rectangle2D4 = cacheWriter2.getCacheBounds();
        rectangle2D4.union(rectangle2D3);
        HashMap<Double, String> hashMap = cacheWriter.getCacheScaleCaptions();
        HashMap<Double, String> hashMap2 = cacheWriter2.getCacheScaleCaptions();
        File file = new File(string);
        File file2 = new File(string2);
        String string3 = CacheMerge.getCacheRootName(cacheWriter);
        String string4 = CacheMerge.getCacheRootName(cacheWriter2);
        File file3 = new File(file.getParentFile(), string3);
        File file4 = new File(file2.getParentFile(), string4);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        for (Double d : hashMap.keySet()) {
            Object object;
            System.out.println("merge scale: " + hashMap.get(d));
            boolean bl = false;
            for (Double d2 : hashMap2.keySet()) {
                if (!d2.equals(d)) continue;
                bl = true;
                break;
            }
            if (bl) {
                object = hashMap.get(d);
                String string5 = hashMap2.get(d);
                File file5 = new File(file3, (String)object);
                File file6 = new File(file4, string5);
                for (File file7 : file5.listFiles()) {
                    if (!file7.isDirectory()) continue;
                    String string6 = file7.getName();
                    System.out.println("merge row group: " + string6);
                    boolean bl2 = false;
                    for (File file8 : file6.listFiles()) {
                        if (!file8.isDirectory() || !file8.getName().equalsIgnoreCase(string6)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        File file9 = new File(file6, string6);
                        String[] stringArray = file9.list();
                        for (File file10 : file7.listFiles()) {
                            if (!file10.isFile()) continue;
                            String string7 = file10.getName();
                            boolean bl3 = false;
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (!stringArray[i].equalsIgnoreCase(string7)) continue;
                                bl3 = true;
                                break;
                            }
                            if (bl3) {
                                if (!string7.endsWith(".cf")) continue;
                                File file11 = new File(file9, string7);
                                threadPoolExecutor.execute(new MergeCompactRunner(file10, file11));
                                continue;
                            }
                            CacheMerge.copy(file10, file9);
                        }
                        continue;
                    }
                    CacheMerge.copy(file7, file6);
                }
                continue;
            }
            object = hashMap.get(d);
            File file12 = new File(file3, (String)object);
            CacheMerge.copy(file12, file4);
            hashMap2.put(d, (String)object);
        }
        String string7 = string2.replaceFirst(".sci", "") + "_merge.sci";
        cacheWriter2.ToConfigFile(string7);
        while (threadPoolExecutor.getActiveCount() != 0) {
            Thread.sleep(100L);
        }
        threadPoolExecutor.shutdown();
        System.out.println(String.format("merge over , cost(ms) %d.", System.currentTimeMillis() - l));
    }

    private static void copy(File src, File des) {
        if (!src.exists()) {
            return;
        }
        if (!des.exists()) {
            des.mkdirs();
        }
        if (src.isFile()) {
            CacheMerge.copyfile(src, des);
        } else {
            String string = src.getName();
            File file = new File(des, string);
            file.mkdirs();
            for (File file2 : src.listFiles()) {
                CacheMerge.copy(file2, file);
            }
        }
    }

    private static void copyfile(File src, File des) {
        if (!src.exists() || src.isDirectory()) {
            return;
        }
        if (!des.exists()) {
            des.mkdirs();
        }
        String string = src.getName();
        File file = new File(des, string);
        try (FileChannel fileChannel = new FileInputStream(src).getChannel();
             FileChannel fileChannel2 = new FileOutputStream(file).getChannel();){
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    private static void mergeCompact(File src, File des) {
        new MergeCompactRunner(src, des).run();
    }

    private static String getCacheRootName(CacheWriter cw) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CacheMerge.parseTileFormat(cw.getTileFormat()));
        stringBuilder.append("_");
        stringBuilder.append(cw.getTileSize().value());
        stringBuilder.append("_");
        stringBuilder.append(cw.getHashCode());
        return stringBuilder.toString();
    }

    public static String parseTileFormat(TileFormat format) {
        String string = "";
        switch (format.value()) {
            case 122: {
                string = "J";
                break;
            }
            case 123: {
                string = "P";
                break;
            }
            case 124: {
                string = "G";
                break;
            }
            case 147: {
                string = "JP";
                break;
            }
            case 8888: {
                string = "P8";
            }
        }
        return string;
    }
}

