/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalProcessingEnum;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.Tile;
import com.supermap.data.processing.Tiles;
import com.supermap.data.processing.VectorCacheFileNative;

public class VectorCacheFile
extends InternalHandleDisposable {
    public VectorCacheFile() {
        long l = VectorCacheFileNative.jni_New();
        this.setHandle(l, true);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            VectorCacheFileNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public boolean open(String fileName, String password) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("open()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null || fileName.length() == 0) {
            String string = InternalResource.loadString("open()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = VectorCacheFileNative.jni_Open(this.getHandle(), fileName, password);
        return bl;
    }

    public boolean openStream(byte[] SCVStream, String password) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("openStream()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (SCVStream == null || SCVStream.length == 0) {
            String string = InternalResource.loadString("openStream()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = VectorCacheFileNative.jni_OpenStream(this.getHandle(), SCVStream, password);
        return bl;
    }

    public boolean open(String fileName) {
        return this.open(fileName, "");
    }

    public String getTileFullName(double scale, int row, int col, String tileExtName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileFullName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (tileExtName == null) {
            String string = InternalResource.loadString("open()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorCacheFileNative.jni_GetTileFullName(this.getHandle(), scale, row, col, tileExtName);
    }

    public String extractCacheFile(double scale, int row, int col, String tileExtName, String targetFolderName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileFullName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (targetFolderName == null) {
            String string = InternalResource.loadString("open()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorCacheFileNative.jni_ExtractCacheFile(this.getHandle(), scale, row, col, tileExtName, targetFolderName);
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = VectorCacheFileNative.jni_GetStorageType(this.getHandle());
        return (StorageType)InternalProcessingEnum.parseUGCValue(StorageType.class, n);
    }

    public Tile[] computeTiles(double scale, Point2D[] centerPoints) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = centerPoints.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = centerPoints[i].getX();
            dArray2[i] = centerPoints[i].getY();
        }
        long l = VectorCacheFileNative.jni_ComputeTiles(this.getHandle(), scale, dArray, dArray2);
        Tiles tiles = new Tiles(l);
        if (tiles.getCount() == 0) {
            return null;
        }
        Tile[] tileArray = new Tile[tiles.getCount()];
        for (int i = 0; i < tiles.getCount(); ++i) {
            tileArray[i] = tiles.get(i);
        }
        return tileArray;
    }

    public boolean deleteGeometryTiles(Tile[] tiles) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteGeomertyTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = tiles.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = com.supermap.data.processing.InternalHandle.getHandle((InternalHandle)tiles[i]);
        }
        return VectorCacheFileNative.jni_DeleteGeometryTiles(this.getHandle(), lArray);
    }

    public boolean deleteAttributeTiles(Tile[] tiles) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteGeomertyTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = tiles.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = com.supermap.data.processing.InternalHandle.getHandle((InternalHandle)tiles[i]);
        }
        return VectorCacheFileNative.jni_DeleteAttributeTiles(this.getHandle(), lArray);
    }

    public Rectangle2D getTileBounds(double scale, int row, int col) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTileBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        VectorCacheFileNative.jni_GetTileBounds(this.getHandle(), scale, row, col, dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public long getRevisionNumber() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRevisionNumber", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorCacheFileNative.jni_GetRevisionNumber(this.getHandle());
    }

    public boolean updateRevisionNumber(long num) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRevisionNumber(int)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return VectorCacheFileNative.jni_UpdateRevisionNumber(this.getHandle(), num);
    }

    public double[] getScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = VectorCacheFileNative.jni_GetScales(this.getHandle());
        return dArray;
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        VectorCacheFileNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }
}

