/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.Tile;
import com.supermap.data.processing.TilesNative;

class Tiles
extends InternalHandleDisposable {
    public Tiles(long instance) {
        this.setHandle(instance, true);
    }

    int getCount() {
        return TilesNative.jni_GetCount(this.getHandle());
    }

    Tile get(int index) {
        if (this.getHandle() != 0L) {
            if (index < 0 || index >= this.getCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "processing_resources");
                throw new IndexOutOfBoundsException(string);
            }
            long l = TilesNative.jni_GetItem(this.getHandle(), index);
            Tile tile = new Tile(l, true);
            return tile;
        }
        return null;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TilesNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }
}

