/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.jsuperpy.serializer.DataSerializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class IntegerArraySerializer
extends DataSerializer {
    @Override
    public Class getValueClass() {
        return int[].class;
    }

    @Override
    public String getTypeName() {
        return "iL";
    }

    @Override
    public byte[] encode(Object value) {
        if (value instanceof int[]) {
            int[] values = (int[])value;
            int count = values.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(count * 4).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < count; ++i) {
                byteBuffer.putInt(values[i]);
            }
            return byteBuffer.array();
        }
        if (value instanceof Integer[]) {
            Integer[] values = (Integer[])value;
            int count = values.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(count * 4).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < count; ++i) {
                byteBuffer.putInt(values[i]);
            }
            return byteBuffer.array();
        }
        return new byte[0];
    }

    public int[] decode(byte[] bys) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bys);
        int[] values = new int[byteBuffer.limit() / 4];
        for (int i = 0; i < values.length; ++i) {
            values[i] = byteBuffer.getInt();
        }
        return values;
    }
}

