/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.jsuperpy.serializer.DataSerializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FloatArraySerializer
extends DataSerializer {
    @Override
    public Class getValueClass() {
        return float[].class;
    }

    @Override
    public String getTypeName() {
        return "fL";
    }

    @Override
    public byte[] encode(Object value) {
        if (value instanceof float[]) {
            float[] values = (float[])value;
            int count = values.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(count * 4).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < count; ++i) {
                byteBuffer.putFloat(values[i]);
            }
            return byteBuffer.array();
        }
        if (value instanceof Float[]) {
            Float[] values = (Float[])value;
            int count = values.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(count * 4).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < count; ++i) {
                byteBuffer.putFloat(values[i].floatValue());
            }
            return byteBuffer.array();
        }
        return new byte[0];
    }

    public float[] decode(byte[] bys) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bys);
        float[] values = new float[byteBuffer.limit() / 4];
        for (int i = 0; i < values.length; ++i) {
            values[i] = byteBuffer.getFloat();
        }
        return values;
    }
}

