/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer;

import com.supermap.data.FieldInfo;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.jsuperpy.JFeature;
import com.supermap.jsuperpy.ProcessInfo;
import com.supermap.jsuperpy.Tile;
import com.supermap.jsuperpy.serializer.DataSerializer;
import com.supermap.jsuperpy.serializer.impl.BooleanArraySerializer;
import com.supermap.jsuperpy.serializer.impl.BooleanSerializer;
import com.supermap.jsuperpy.serializer.impl.ByteArraySerializer;
import com.supermap.jsuperpy.serializer.impl.ByteSerializer;
import com.supermap.jsuperpy.serializer.impl.DateSerializer;
import com.supermap.jsuperpy.serializer.impl.DoubleArraySerializer;
import com.supermap.jsuperpy.serializer.impl.DoubleSerializer;
import com.supermap.jsuperpy.serializer.impl.EnumSerializer;
import com.supermap.jsuperpy.serializer.impl.FieldInfoSerializer;
import com.supermap.jsuperpy.serializer.impl.FloatArraySerializer;
import com.supermap.jsuperpy.serializer.impl.FloatSerializer;
import com.supermap.jsuperpy.serializer.impl.GeometrySerializer;
import com.supermap.jsuperpy.serializer.impl.IntegerArraySerializer;
import com.supermap.jsuperpy.serializer.impl.IntegerSerializer;
import com.supermap.jsuperpy.serializer.impl.JFeatureSerializer;
import com.supermap.jsuperpy.serializer.impl.LongArraySerializer;
import com.supermap.jsuperpy.serializer.impl.LongSerializer;
import com.supermap.jsuperpy.serializer.impl.MapSerializer;
import com.supermap.jsuperpy.serializer.impl.NullSerializer;
import com.supermap.jsuperpy.serializer.impl.ObjectArraySerializer;
import com.supermap.jsuperpy.serializer.impl.Point2DArraySerializer;
import com.supermap.jsuperpy.serializer.impl.Point2DSerializer;
import com.supermap.jsuperpy.serializer.impl.ProcessInfoSerializer;
import com.supermap.jsuperpy.serializer.impl.Rect2DSerializer;
import com.supermap.jsuperpy.serializer.impl.ShortArraySerializer;
import com.supermap.jsuperpy.serializer.impl.ShortSerializer;
import com.supermap.jsuperpy.serializer.impl.StringArraySerializer;
import com.supermap.jsuperpy.serializer.impl.StringSerializer;
import com.supermap.jsuperpy.serializer.impl.TileSerializer;
import com.supermap.jsuperpy.serializer.impl.TimestampSerializer;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public final class DataSerializers {
    private static ServiceLoader<DataSerializer> loader = ServiceLoader.load(DataSerializer.class);
    private static Map<String, Class> defaultNameLoader = new HashMap<String, Class>();
    private static Map<Class, Class> defaultValueClassLoader = new HashMap<Class, Class>();

    private DataSerializers() {
    }

    private static void registerEnums() {
        String[] enumClass = new String[]{"com.supermap.data.CursorType", "com.supermap.data.BlockSizeOption", "com.supermap.data.AreaUnit", "com.supermap.data.EngineType", "com.supermap.data.DatasetType", "com.supermap.data.GeometryType", "com.supermap.data.FieldType", "com.supermap.data.Unit", "com.supermap.analyst.spatialanalyst.BufferRadiusUnit", "com.supermap.data.Charset", "com.supermap.data.EncodeType", "com.supermap.data.PixelFormat", "com.supermap.data.WorkspaceType", "com.supermap.data.WorkspaceVersion", "com.supermap.data.SpatialIndexType", "com.supermap.data.PrjCoordSysType", "com.supermap.data.GeoCoordSysType", "com.supermap.data.ProjectionType", "com.supermap.data.GeoSpatialRefType", "com.supermap.analyst.spatialanalyst.BufferEndType", "com.supermap.analyst.spatialanalyst.DissolveType", "com.supermap.analyst.spatialanalyst.StatisticsType", "com.supermap.analyst.spatialanalyst.StatisticsFieldType", "com.supermap.data.ResampleType", "com.supermap.analyst.spatialanalyst.ResampleMode", "com.supermap.analyst.spatialanalyst.AggregationType", "com.supermap.data.topology.ArcAndVertexFilterMode", "com.supermap.data.TextAlignment", "com.supermap.data.StringAlignment", "com.supermap.data.SpatialQueryMode", "com.supermap.data.SpatialRelationType", "com.supermap.data.JoinType", "com.supermap.analyst.spatialanalyst.ReclassPixelFormat", "com.supermap.analyst.spatialanalyst.ReclassSegmentType", "com.supermap.analyst.spatialanalyst.ReclassType", "com.supermap.analyst.spatialanalyst.NeighbourShapeType", "com.supermap.analyst.spatialanalyst.SearchMode", "com.supermap.analyst.spatialanalyst.Exponent", "com.supermap.analyst.spatialanalyst.VariogramMode", "com.supermap.analyst.spatialanalyst.InterpolationAlgorithmType", "com.supermap.analyst.spatialanalyst.ComputeType", "com.supermap.analyst.spatialanalyst.SmoothMethod", "com.supermap.analyst.spatialanalyst.ShadowMode", "com.supermap.analyst.spatialanalyst.SlopeType", "com.supermap.data.StatisticMode", "com.supermap.data.conversion.ImportMode", "com.supermap.data.conversion.IgnoreMode", "com.supermap.data.conversion.MultiBandImportMode", "com.supermap.data.conversion.CADVersion", "com.supermap.data.TopologyRule", "com.supermap.data.GeoDatumType", "com.supermap.data.GeoSpheroidType", "com.supermap.data.GeoPrimeMeridianType", "com.supermap.data.CoordSysTransMethod", "com.supermap.data.ResamplingMethod", "com.supermap.data.ColorGradientType", "com.supermap.analyst.spatialanalyst.NeighbourUnitType", "com.supermap.data.GriddingLevel", "com.supermap.analyst.spatialanalyst.TerrainInterpolateType", "com.supermap.analyst.spatialanalyst.TerrainStatisticType", "com.supermap.analyst.terrainanalyst.StreamOrderType", "com.supermap.analyst.spatialstatistics.AggregationMethod", "com.supermap.analyst.spatialstatistics.KernelType", "com.supermap.analyst.spatialstatistics.BandWidthType", "com.supermap.analyst.spatialstatistics.KernelFunction", "com.supermap.analyst.spatialstatistics.StatisticsType", "com.supermap.analyst.spatialstatistics.DistanceMethod", "com.supermap.analyst.spatialstatistics.EllipseSize", "com.supermap.analyst.spatialanalyst.EliminateMode", "com.supermap.analyst.spatialanalyst.EdgeMatchMode", "com.supermap.analyst.spatialanalyst.FunctionType", "com.supermap.analyst.spatialanalyst.StatisticsCompareType", "com.supermap.analyst.spatialanalyst.GridStatisticsMode", "com.supermap.analyst.spatialstatistics.ConceptualizationModel", "com.supermap.data.conversion.VCTVersion", "com.supermap.analyst.spatialanalyst.RasterJoinType", "com.supermap.analyst.spatialanalyst.RasterJoinPixelFormat", "com.supermap.realspace.threeddesigner.ChamferStyle", "com.supermap.data.PlaneType", "com.supermap.realspace.threeddesigner.JoinType", "com.supermap.analyst.spatialanalyst.RasterClipFileType"};
        DataSerializers.registerEnums(enumClass);
    }

    public static void registerEnums(String[] names) {
        for (String name : names) {
            try {
                DataSerializers.registerEnum(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                System.out.println("[Waring]: " + e.getMessage() + " Class not found");
            }
        }
    }

    public static void registerEnums(Class[] enumClasses) {
        for (Class enumClass : enumClasses) {
            DataSerializers.registerEnum(enumClass);
        }
    }

    public static void registerEnum(Class enumClass) {
        EnumSerializer enumSerializer = new EnumSerializer(enumClass);
        defaultNameLoader.put(enumSerializer.getTypeName(), EnumSerializer.class);
        defaultValueClassLoader.put(enumClass, EnumSerializer.class);
    }

    public static void register(String typeName, Class valueClass, Class serClass) {
        defaultNameLoader.put(typeName, serClass);
        defaultValueClassLoader.put(valueClass, serClass);
    }

    public static Class get(String typeName) {
        return defaultNameLoader.get(typeName);
    }

    public static Class get(Class valueClass) {
        return defaultValueClassLoader.get(valueClass);
    }

    private static void registerAll() {
        defaultNameLoader.put("b", BooleanSerializer.class);
        defaultNameLoader.put("bL", BooleanArraySerializer.class);
        defaultNameLoader.put("B", ByteSerializer.class);
        defaultNameLoader.put("BL", ByteArraySerializer.class);
        defaultNameLoader.put("d", DoubleSerializer.class);
        defaultNameLoader.put("dL", DoubleArraySerializer.class);
        defaultNameLoader.put("f", FloatSerializer.class);
        defaultNameLoader.put("fL", FloatArraySerializer.class);
        defaultNameLoader.put("i", IntegerSerializer.class);
        defaultNameLoader.put("iL", IntegerArraySerializer.class);
        defaultNameLoader.put("l", LongSerializer.class);
        defaultNameLoader.put("lL", LongArraySerializer.class);
        defaultNameLoader.put("s", ShortSerializer.class);
        defaultNameLoader.put("sL", ShortArraySerializer.class);
        defaultNameLoader.put("S", StringSerializer.class);
        defaultNameLoader.put("D", DateSerializer.class);
        defaultNameLoader.put("G", GeometrySerializer.class);
        defaultNameLoader.put("F", JFeatureSerializer.class);
        defaultNameLoader.put("P2", Point2DSerializer.class);
        defaultNameLoader.put("P2L", Point2DArraySerializer.class);
        defaultNameLoader.put("R", Rect2DSerializer.class);
        defaultNameLoader.put("T", TimestampSerializer.class);
        defaultNameLoader.put("TI", TileSerializer.class);
        defaultNameLoader.put("FI", FieldInfoSerializer.class);
        defaultNameLoader.put("PI", ProcessInfoSerializer.class);
        defaultNameLoader.put("n", NullSerializer.class);
        defaultNameLoader.put("SL", StringArraySerializer.class);
        defaultNameLoader.put("OL", ObjectArraySerializer.class);
        defaultNameLoader.put("M", MapSerializer.class);
        defaultValueClassLoader.put(Boolean.class, BooleanSerializer.class);
        defaultValueClassLoader.put(boolean[].class, BooleanSerializer.class);
        defaultValueClassLoader.put(Boolean[].class, BooleanSerializer.class);
        defaultValueClassLoader.put(Byte.class, ByteSerializer.class);
        defaultValueClassLoader.put(byte[].class, ByteArraySerializer.class);
        defaultValueClassLoader.put(Double.class, DoubleSerializer.class);
        defaultValueClassLoader.put(double[].class, DoubleArraySerializer.class);
        defaultValueClassLoader.put(Double[].class, DoubleArraySerializer.class);
        defaultValueClassLoader.put(Float.class, FloatSerializer.class);
        defaultValueClassLoader.put(float[].class, FloatArraySerializer.class);
        defaultValueClassLoader.put(Float[].class, FloatArraySerializer.class);
        defaultValueClassLoader.put(Integer.class, IntegerSerializer.class);
        defaultValueClassLoader.put(int[].class, IntegerArraySerializer.class);
        defaultValueClassLoader.put(Integer[].class, IntegerArraySerializer.class);
        defaultValueClassLoader.put(Long.class, LongSerializer.class);
        defaultValueClassLoader.put(long[].class, LongArraySerializer.class);
        defaultValueClassLoader.put(Long[].class, LongArraySerializer.class);
        defaultValueClassLoader.put(Short.class, ShortSerializer.class);
        defaultValueClassLoader.put(Short[].class, ShortSerializer.class);
        defaultValueClassLoader.put(Point2D[].class, Point2DArraySerializer.class);
        defaultValueClassLoader.put(Point2Ds.class, Point2DArraySerializer.class);
        defaultValueClassLoader.put(String.class, StringSerializer.class);
        defaultValueClassLoader.put(Date.class, DateSerializer.class);
        defaultValueClassLoader.put(Geometry.class, GeometrySerializer.class);
        defaultValueClassLoader.put(GeoPoint.class, GeometrySerializer.class);
        defaultValueClassLoader.put(GeoRegion.class, GeometrySerializer.class);
        defaultValueClassLoader.put(GeoLine.class, GeometrySerializer.class);
        defaultValueClassLoader.put(JFeature.class, JFeatureSerializer.class);
        defaultValueClassLoader.put(Point2D.class, Point2DSerializer.class);
        defaultValueClassLoader.put(Rectangle2D.class, Rect2DSerializer.class);
        defaultValueClassLoader.put(Timestamp.class, TimestampSerializer.class);
        defaultValueClassLoader.put(FieldInfo.class, FieldInfoSerializer.class);
        defaultValueClassLoader.put(Tile.class, TileSerializer.class);
        defaultValueClassLoader.put(ProcessInfo.class, ProcessInfoSerializer.class);
        defaultValueClassLoader.put(String[].class, StringArraySerializer.class);
        defaultValueClassLoader.put(Object[].class, ObjectArraySerializer.class);
        defaultValueClassLoader.put(Map.class, MapSerializer.class);
        DataSerializers.registerEnums();
    }

    private static boolean isNull(String name) {
        return name.equals("n");
    }

    public static DataSerializer find(String name) {
        if (DataSerializers.isNull(name)) {
            return new NullSerializer();
        }
        Class<?> classSer = null;
        for (DataSerializer converter : loader) {
            if (!converter.getTypeName().equals(name)) continue;
            classSer = converter.getClass();
            break;
        }
        if (classSer == null) {
            classSer = defaultNameLoader.get(name);
        }
        if (classSer == null) {
            throw new IllegalArgumentException("Invalid type name " + name + ", cannot find valid Serializer");
        }
        try {
            DataSerializer dataSerializer = (DataSerializer)classSer.newInstance();
            if (dataSerializer != null && dataSerializer instanceof EnumSerializer) {
                EnumSerializer enumSerializer = (EnumSerializer)dataSerializer;
                enumSerializer.setEnumClass(dataSerializer.getClass().getClassLoader().loadClass(name));
            }
            return dataSerializer;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return new NullSerializer();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return new NullSerializer();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new NullSerializer();
        }
    }

    public static DataSerializer find(Class valueClass) {
        if (valueClass == null) {
            return new NullSerializer();
        }
        Class<?> classSer = null;
        for (DataSerializer converter : loader) {
            if (converter.getValueClass() == null || valueClass != converter.getValueClass() && !valueClass.isAssignableFrom(converter.getValueClass())) continue;
            classSer = converter.getClass();
            break;
        }
        if (classSer == null) {
            classSer = defaultValueClassLoader.get(valueClass);
        }
        if (classSer == null) {
            throw new IllegalArgumentException("Invalid valud class " + valueClass.toString() + ", cannot find valid Serializer");
        }
        try {
            DataSerializer dataSerializer = (DataSerializer)classSer.newInstance();
            if (dataSerializer != null && dataSerializer instanceof EnumSerializer) {
                EnumSerializer enumSerializer = (EnumSerializer)dataSerializer;
                enumSerializer.setEnumClass(valueClass);
            }
            return dataSerializer;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return new NullSerializer();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return new NullSerializer();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new NullSerializer();
        }
    }

    public static byte[] encode(Object value) {
        if (value == null) {
            return new byte[0];
        }
        return DataSerializers.find(value.getClass()).encode(value);
    }

    public static Object decode(String name, byte[] bys) {
        return DataSerializers.find(name).decode(bys);
    }

    public static Object decode(Class valueClass, byte[] bys) {
        return DataSerializers.find(valueClass).decode(bys);
    }

    public static byte[] serialize(Object value) {
        DataSerializer ser = null;
        ser = value == null ? new NullSerializer() : DataSerializers.find(value.getClass());
        return ser.serialize(value);
    }

    public static Object deserialize(byte[] bytes) {
        return DataSerializer.deserialize(bytes);
    }

    static {
        DataSerializers.registerAll();
    }
}

