/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.analyst.addressmatching.InternalHandle;
import com.supermap.analyst.addressmatching.InternalResource;
import com.supermap.data.DatasetVector;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class AddressMatchSetting {
    private ArrayList<DatasetVector> m_datasets;
    private ArrayList<String> m_fields;
    private String m_dictionaryFile;
    private boolean m_isChanged;
    private DatasetVector m_keyDT = null;
    private DatasetVector m_refDT = null;
    private ArrayList<String> m_arrRefName;
    private String m_strCLSAbField = null;
    private String m_strCLSWordField = null;
    private String m_strCLSTypeField = null;
    private int m_minMatchScore;
    private double m_offset;
    private double m_endOffset;

    public AddressMatchSetting() {
        this.m_datasets = new ArrayList();
        this.m_fields = new ArrayList();
        this.m_isChanged = true;
    }

    public AddressMatchSetting(AddressMatchSetting addressMatchSetting) {
        if (addressMatchSetting == null) {
            String string = InternalResource.loadString("addressMatchSetting", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_datasets = new ArrayList();
        this.m_fields = new ArrayList();
        this.copyFrom(addressMatchSetting);
        this.m_isChanged = true;
    }

    void copyFrom(AddressMatchSetting addressMatchSetting) {
        if (addressMatchSetting != null && !this.equals(addressMatchSetting)) {
            this.m_datasets.clear();
            this.m_fields.clear();
            int n = addressMatchSetting.getDatasets().length;
            for (int i = 0; i < n; ++i) {
                this.m_datasets.add(addressMatchSetting.getDatasets()[i]);
                this.m_fields.add(addressMatchSetting.getFields()[i]);
            }
            this.m_dictionaryFile = addressMatchSetting.m_dictionaryFile;
            this.m_isChanged = true;
        }
    }

    boolean isChanged() {
        return this.m_isChanged;
    }

    void setChanged(boolean value) {
        this.m_isChanged = value;
    }

    public DatasetVector[] getDatasets() {
        int n = this.m_datasets.size();
        DatasetVector[] datasetVectorArray = new DatasetVector[n];
        for (int i = 0; i < n; ++i) {
            datasetVectorArray[i] = this.m_datasets.get(i);
        }
        return datasetVectorArray;
    }

    public String[] getFields() {
        int n = this.m_fields.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_fields.get(i);
        }
        return stringArray;
    }

    public String getDictionaryFile() {
        return this.m_dictionaryFile;
    }

    public void setDictionaryFile(String value) throws FileNotFoundException {
        File file = new File(value);
        if (!file.exists()) {
            String string = InternalResource.loadString("value", "Global_FileNotFound", "addressmatching_resources");
            throw new FileNotFoundException(string);
        }
        this.m_dictionaryFile = value;
        this.m_isChanged = true;
    }

    public int addSearchData(DatasetVector dataset, String addressField) {
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        if (addressField == null || addressField.trim().length() == 0) {
            String string = InternalResource.loadString("addressField", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.m_datasets.size();
        for (int i = 0; i < n; ++i) {
            if (!dataset.equals(this.m_datasets.get(i)) || !addressField.equalsIgnoreCase(this.m_fields.get(i).toString())) continue;
            String string = InternalResource.loadString("dataset & addressField:", "AddressMatchSetting_SearchDataAlreadyExist", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_datasets.add(dataset);
        this.m_fields.add(addressField);
        this.m_isChanged = true;
        return this.m_datasets.size() - 1;
    }

    public boolean setSearchData(int index, DatasetVector dataset, String addressField) {
        boolean bl = false;
        boolean bl2 = true;
        if (index >= this.m_datasets.size() || index < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "addressmatching_resources");
            throw new ArrayIndexOutOfBoundsException(string);
        }
        if (dataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        if (addressField == null || addressField.trim().length() == 0) {
            String string = InternalResource.loadString("addressField", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.m_datasets.size();
        for (int i = 0; i < n; ++i) {
            if (!dataset.equals(this.m_datasets.get(i)) || !addressField.equalsIgnoreCase(this.m_fields.get(i).toString())) continue;
            if (i != index) {
                String string = InternalResource.loadString("dataset & addressField:", "AddressMatchSetting_SearchDataAlreadyExist", "addressmatching_resources");
                throw new IllegalArgumentException(string);
            }
            bl2 = false;
        }
        if (bl2) {
            this.m_datasets.set(index, dataset);
            this.m_fields.set(index, addressField);
            this.m_isChanged = true;
        }
        bl = true;
        return bl;
    }

    public boolean removeSearchData(int index) {
        boolean bl = false;
        if (index >= this.m_datasets.size() || index < 0) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "addressmatching_resources");
            throw new ArrayIndexOutOfBoundsException(string);
        }
        this.m_datasets.remove(index);
        this.m_fields.remove(index);
        bl = true;
        this.m_isChanged = true;
        return bl;
    }

    public void clearSearchData() {
        this.m_datasets.clear();
        this.m_fields.clear();
        this.m_isChanged = true;
    }

    protected void setKeyDT(DatasetVector value) {
        if (value == null) {
            String string = InternalResource.loadString("setKeyDT", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_keyDT = value;
    }

    protected DatasetVector getKeyDT() {
        return this.m_keyDT;
    }

    protected void setRefDT(DatasetVector value) {
        if (value == null) {
            String string = InternalResource.loadString("setRefDT", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_refDT = value;
    }

    protected DatasetVector getRefDT() {
        return this.m_refDT;
    }

    protected void setRefNames(String[] value) {
        if (value.length == 0) {
            String string = InternalResource.loadString("setRefName", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            this.m_arrRefName.add(value[i]);
        }
    }

    protected String[] getRefNames() {
        int n = this.m_arrRefName.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_arrRefName.get(i);
        }
        return stringArray;
    }

    protected void setCLSAbField(String value) {
        if (value == null) {
            String string = InternalResource.loadString("setCLSAbField", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_strCLSAbField = value;
    }

    protected String getCLSAbField() {
        return this.m_strCLSAbField;
    }

    protected void setCLSWordField(String value) {
        if (value == null) {
            String string = InternalResource.loadString("setCLSWordField", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_strCLSWordField = value;
    }

    protected String getCLSWordField() {
        return this.m_strCLSWordField;
    }

    protected void setCLSTypeField(String value) {
        if (value == null) {
            String string = InternalResource.loadString("setCLSTypeField", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        this.m_strCLSTypeField = value;
    }

    protected String getCLSTypeField() {
        return this.m_strCLSTypeField;
    }

    protected void setMinMatchScore(int value) {
        this.m_minMatchScore = value;
    }

    protected int getMinMatchScore() {
        return this.m_minMatchScore;
    }

    protected void setOffset(double value) {
        this.m_offset = value;
    }

    protected double getOffset() {
        return this.m_offset;
    }

    protected void setEndOffset(double value) {
        this.m_endOffset = value;
    }

    protected double getEndOffset() {
        return this.m_endOffset;
    }
}

