/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.analyst.addressmatching.AddressDictionaryNative;
import com.supermap.analyst.addressmatching.InternalDatasetVector;
import com.supermap.analyst.addressmatching.InternalDatasets;
import com.supermap.analyst.addressmatching.InternalHandle;
import com.supermap.analyst.addressmatching.InternalResource;
import com.supermap.analyst.addressmatching.InternalToolkitAddressMatching;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.InternalHandleDisposable;
import java.io.File;

public class AddressDictionary
extends InternalHandleDisposable {
    private String m_dictionaryFile = "";

    public AddressDictionary() {
        long l = AddressDictionaryNative.jni_New();
        this.setHandle(l, true);
    }

    public AddressDictionary(String dictionaryFile) {
        this();
        this.load(dictionaryFile);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            AddressDictionaryNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        return AddressDictionaryNative.jni_GetCount(this.getHandle());
    }

    public String get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("get(int index)", "Global_IndexOutOfBounds", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        return AddressDictionaryNative.jni_GetItem(this.getHandle(), index);
    }

    public boolean contains(String word) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("contains(String word)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (word != null && word.trim().length() > 0) {
            bl = AddressDictionaryNative.jni_Contains(this.getHandle(), word);
        }
        return bl;
    }

    public int indexOf(String word) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(String word)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (word != null && word.trim().length() > 0) {
            n = AddressDictionaryNative.jni_IndexOf(this.getHandle(), word);
        }
        return n;
    }

    public int add(String word) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(String word)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (this.contains(word)) {
            String string = InternalResource.loadString("add(String word)", "AddressDictionary_WordAlreadyExist", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        if (word != null && word.trim().length() > 0) {
            n = AddressDictionaryNative.jni_Add(this.getHandle(), word);
        }
        return n;
    }

    public boolean delete(String word) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("delete(String word)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (word != null && word.trim().length() > 0) {
            bl = AddressDictionaryNative.jni_DeleteWorld(this.getHandle(), word);
        }
        return bl;
    }

    public boolean delete(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("delete(int index)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.get(index);
        bl = this.delete(string);
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        long l = AddressDictionaryNative.jni_New();
        if (l != 0L) {
            long l2 = this.getHandle();
            AddressDictionaryNative.jni_Delete(l2);
            this.setHandle(0L);
            this.setHandle(l, true);
        }
    }

    public boolean load(String dictionaryFile) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("load(String dictionaryFile)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        File file = new File(dictionaryFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("load(String dictionaryFile)", "Global_FileNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (dictionaryFile != null && dictionaryFile.trim().length() > 0) {
            bl = AddressDictionaryNative.jni_Load(this.getHandle(), dictionaryFile);
        }
        if (bl) {
            this.m_dictionaryFile = dictionaryFile;
        }
        return bl;
    }

    public boolean save() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("save()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.m_dictionaryFile.trim().length() > 0) {
            bl = AddressDictionaryNative.jni_SaveAs(this.getHandle(), this.m_dictionaryFile);
        }
        return bl;
    }

    public boolean saveAs(String dictionaryFile) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("saveAs(String dictionaryFile)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (!InternalToolkitAddressMatching.isDirectoryExisted(dictionaryFile)) {
            String string = InternalResource.loadString("dictionaryFile", "GlobalDirectoryNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (dictionaryFile != null && dictionaryFile.trim().length() > 0) {
            bl = AddressDictionaryNative.jni_SaveAs(this.getHandle(), dictionaryFile);
        }
        if (bl) {
            this.m_dictionaryFile = dictionaryFile;
        }
        return bl;
    }

    public static boolean textToDictionary(String textFile, String dictionaryFile) {
        File file = new File(textFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("textFile", "Global_FileNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (dictionaryFile == null || dictionaryFile.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("dictionaryFile", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (!InternalToolkitAddressMatching.isDirectoryExisted(dictionaryFile)) {
            String string = InternalResource.loadString("dictionaryFile", "GlobalDirectoryNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = AddressDictionaryNative.jni_TextToDictionary(textFile, dictionaryFile);
        return bl;
    }

    public static boolean dictionaryToText(String dictionaryFile, String textFile) {
        File file = new File(dictionaryFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("dictionaryFile", "Global_FileNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (!InternalToolkitAddressMatching.isDirectoryExisted(textFile)) {
            String string = InternalResource.loadString("textFile", "GlobalDirectoryNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = AddressDictionaryNative.jni_DictionaryToText(dictionaryFile, textFile);
        return bl;
    }

    public static boolean mergeDictionary(String dictionaryFile1, String dictionaryFile2, String dictionaryFileResult) {
        File file = new File(dictionaryFile1);
        if (!file.exists()) {
            String string = InternalResource.loadString("dictionaryFile1", "Global_FileNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        File file2 = new File(dictionaryFile2);
        if (!file2.exists()) {
            String string = InternalResource.loadString("dictionaryFile2", "Global_FileNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (!InternalToolkitAddressMatching.isDirectoryExisted(dictionaryFileResult)) {
            String string = InternalResource.loadString("dictionaryFileResult", "GlobalDirectoryNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = AddressDictionaryNative.jni_MergeDictionary(dictionaryFile1, dictionaryFile2, dictionaryFileResult);
        return bl;
    }

    public static DatasetVector dictionaryToTabular(String dictionaryFile, Datasource targetDatasource, String targetDatasetName) {
        File file = new File(dictionaryFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("dictionaryFile", "Global_FileNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l2 = AddressDictionaryNative.jni_dictionaryToTabular(dictionaryFile, l, targetDatasetName);
        DatasetVector datasetVector = null;
        if (l2 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l2, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)l);
        return datasetVector;
    }

    public static boolean tabularToDictionary(DatasetVector sourceDataset, String wordFieldName, String frequencyFieldName, String dictionaryFile) {
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        if (sourceDataset.getType() != DatasetType.TABULAR) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "addressmatching_resources");
            throw new NullPointerException(string);
        }
        if (wordFieldName == null || wordFieldName.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("wordFieldName", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (frequencyFieldName == null || frequencyFieldName.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("frequencyFieldName", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getFieldInfos().indexOf(wordFieldName) == -1) {
            String string = InternalResource.loadString("wordFieldName", "GlobalSpecifiedNameNotExists", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getFieldInfos().indexOf(frequencyFieldName) == -1) {
            String string = InternalResource.loadString("frequencyFieldName", "GlobalSpecifiedNameNotExists", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        FieldInfo fieldInfo = sourceDataset.getFieldInfos().get(frequencyFieldName);
        if (fieldInfo == null || fieldInfo.getType() != FieldType.INT16 && fieldInfo.getType() != FieldType.INT32 && fieldInfo.getType() != FieldType.INT64) {
            String string = InternalResource.loadString("frequencyFieldName", "Global_ArgumentTypeInvalid", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        fieldInfo = sourceDataset.getFieldInfos().get(wordFieldName);
        if (fieldInfo == null || fieldInfo.getType() != FieldType.TEXT && fieldInfo.getType() != FieldType.WTEXT) {
            String string = InternalResource.loadString("wordFieldName", "Global_ArgumentTypeInvalid", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (dictionaryFile == null || dictionaryFile.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("dictionaryFile", "Global_StringIsNullOrEmpty", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (!InternalToolkitAddressMatching.isDirectoryExisted(dictionaryFile)) {
            String string = InternalResource.loadString("dictionaryFile", "GlobalDirectoryNotFound", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        boolean bl = false;
        bl = AddressDictionaryNative.jni_tabularToDictionary(l, wordFieldName, frequencyFieldName, dictionaryFile);
        return bl;
    }

    public int add(String word, int frequency) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(String word, int frequency)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (this.contains(word)) {
            String string = InternalResource.loadString("word", "AddressDictionary_WordAlreadyExist", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (frequency <= 0) {
            String string = InternalResource.loadString("frequency", "Global_ShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        if (word != null && word.trim().length() > 0) {
            n = AddressDictionaryNative.jni_Add2(this.getHandle(), word, frequency);
        }
        return n;
    }

    public boolean modifyFrequency(String word, int frequency) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("modifyFrequency(String word, int frequency)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (!this.contains(word)) {
            String string = InternalResource.loadString("word", "AddressDictionary_WordNotExist", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        if (frequency <= 0) {
            String string = InternalResource.loadString("frequency", "Global_ShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (word != null && word.trim().length() > 0) {
            bl = AddressDictionaryNative.jni_modifyFrequency(this.getHandle(), word, frequency);
        }
        return bl;
    }
}

