/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.GeoModel3D;
import com.supermap.data.Point3D;
import com.supermap.realspace.Scene;
import com.supermap.realspace.spatialanalyst.AnalysisQuality;
import com.supermap.realspace.spatialanalyst.InternalEnum;
import com.supermap.realspace.spatialanalyst.InternalGeometry;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalHandleDisposable;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import com.supermap.realspace.spatialanalyst.Viewshed3DNative;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;

public class Viewshed3D
extends InternalHandleDisposable {
    private static License m_license;
    private Scene m_scene;
    private Point3D m_viewerPosition = new Point3D(0.0, 0.0, 0.0);
    private double m_horizontalFov = 90.0;
    private double m_verticalFov = 60.0;
    private Color m_visibleAreaColor = Color.GREEN;
    private Color m_hiddenAreaColor = Color.RED;
    private Color m_hintLineColor = Color.WHITE;
    private AnalysisQuality m_quality = AnalysisQuality.MEDIUM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public Viewshed3D(Scene scene) {
        Viewshed3D.verifyLicense();
        this.m_scene = scene;
        long l = Viewshed3DNative.jni_New("");
        this.setHandle(l, true);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            Viewshed3DNative.jni_Delete(this.getHandle());
        }
        this.setHandle(0L);
    }

    public Point3D getViewerPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewerPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_viewerPosition;
    }

    public void setViewerPosition(Point3D position) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setViewerPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Viewshed3DNative.jni_SetViewerPosition(this.getHandle(), position.getX(), position.getY(), position.getZ());
        this.m_viewerPosition = position;
    }

    public double getDirection() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDirection()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return Viewshed3DNative.jni_GetDirection(this.getHandle());
    }

    public void setDirection(double direction) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDirection()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Viewshed3DNative.jni_SetDirection(this.getHandle(), direction);
    }

    public double getPitch() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHiddenColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return Viewshed3DNative.jni_GetPitch(this.getHandle());
    }

    public void setPitch(double pitch) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPitch()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Viewshed3DNative.jni_SetPitch(this.getHandle(), pitch);
    }

    public double getHorizontalFov() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHorizontalFov()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_horizontalFov;
    }

    public void setHorizontalFov(double horizontalFov) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHorizontalFov()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Viewshed3DNative.jni_SetHorizontalFov(this.getHandle(), horizontalFov);
        this.m_horizontalFov = horizontalFov;
    }

    public double getVerticalFov() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVerticalFov()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_verticalFov;
    }

    public void setVerticalFov(double verticalFov) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVerticalFov()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Viewshed3DNative.jni_SetVerticalFov(this.getHandle(), verticalFov);
        this.m_verticalFov = verticalFov;
    }

    public double getDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDistance()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return Viewshed3DNative.jni_GetDistance(this.getHandle());
    }

    public void setDistance(double distance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDistance()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Viewshed3DNative.jni_SetDistance(this.getHandle(), distance);
    }

    public Color getVisibleAreaColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleAreaColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_visibleAreaColor;
    }

    public void setVisibleAreaColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleAreaColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Viewshed3DNative.jni_SetVisibleAreaColor(this.getHandle(), color.getRGB());
        this.m_visibleAreaColor = color;
    }

    public Color getHiddenAreaColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHiddenAreaColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_hiddenAreaColor;
    }

    public void setHiddenAreaColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHiddenAreaColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Viewshed3DNative.jni_SetHiddenAreaColor(this.getHandle(), color.getRGB());
        this.m_hiddenAreaColor = color;
    }

    public Color getHintLineColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHintLineColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_hintLineColor;
    }

    public void setHintLineColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHintLineColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Viewshed3DNative.jni_SetHintLineColor(this.getHandle(), color.getRGB());
        this.m_hintLineColor = color;
    }

    public AnalysisQuality getQuality() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnalysisQuality()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_quality;
    }

    public void setQuality(AnalysisQuality quality) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnalysisQuality()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(quality);
        Viewshed3DNative.jni_SetAnalysisQuality(this.getHandle(), n);
        this.m_quality = quality;
    }

    public void setDistDirByPoint(Point3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDistDirByPoint()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Viewshed3DNative.jni_SetDistDirByPoint(this.getHandle(), value.getX(), value.getY(), value.getZ());
    }

    public int getInViewport() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Viewshed3D", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return Viewshed3DNative.jni_GetInViewport(this.getHandle());
    }

    public void setInViewport(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Viewshed3D", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Viewshed3DNative.jni_SetInViewport(this.getHandle(), value);
    }

    public void getObjsVisible(HashMap<String, int[]> value) {
        if (this.m_scene == null) {
            String string = InternalResource.loadString("Viewshed3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L || this.getHandle() == 0L) {
            String string = InternalResource.loadString("Viewshed3D", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.m_scene.getTrackingLayer() != null) {
            bl = this.m_scene.getTrackingLayer().isVisible();
            this.m_scene.getTrackingLayer().setVisible(false);
        }
        int[] nArray = new int[1];
        long l2 = Viewshed3DNative.jni_GetObjsVisibleLength(this.getHandle(), l, nArray);
        String[] stringArray = new String[nArray[0]];
        Object[] objectArray = new Object[nArray[0]];
        Viewshed3DNative.jni_GetObjsVisible(l, l2, stringArray, objectArray);
        if (this.m_scene.getTrackingLayer() != null) {
            this.m_scene.getTrackingLayer().setVisible(bl);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].equals("")) continue;
            value.put(stringArray[i], (int[])objectArray[i]);
        }
    }

    public GeoModel3D getVisibleBody() {
        if (this.m_scene == null) {
            String string = InternalResource.loadString("Viewshed3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L || this.getHandle() == 0L) {
            String string = InternalResource.loadString("Viewshed3D", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3D geoModel3D = null;
        long l2 = Viewshed3DNative.jni_GetVisibleBody(this.getHandle());
        if (l2 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l2);
        }
        return geoModel3D;
    }

    public GeoModel3D getFrustumBody() {
        if (this.m_scene == null) {
            String string = InternalResource.loadString("Viewshed3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L || this.getHandle() == 0L) {
            String string = InternalResource.loadString("Viewshed3D", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3D geoModel3D = null;
        long l2 = Viewshed3DNative.jni_GetFrustumBody(this.getHandle());
        if (l2 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l2);
        }
        return geoModel3D;
    }

    public GeoModel3D getHiddenBody() {
        if (this.m_scene == null) {
            String string = InternalResource.loadString("Viewshed3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L || this.getHandle() == 0L) {
            String string = InternalResource.loadString("Viewshed3D", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3D geoModel3D = null;
        long l2 = Viewshed3DNative.jni_GetHiddenBody(this.getHandle());
        if (l2 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l2);
        }
        return geoModel3D;
    }

    public GeoModel3D getVisibleInterface() {
        if (this.m_scene == null) {
            String string = InternalResource.loadString("Viewshed3D", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L || this.getHandle() == 0L) {
            String string = InternalResource.loadString("Viewshed3D", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3D geoModel3D = null;
        long l2 = Viewshed3DNative.jni_GetVisibleInterface(this.getHandle());
        if (l2 != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l2);
        }
        return geoModel3D;
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return Viewshed3DNative.jni_Build(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Viewshed3DNative.jni_Clear(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

