/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InterpolationAlgorithmType;
import com.supermap.realspace.spatialanalyst.InterpolationParameter3D;
import com.supermap.realspace.spatialanalyst.InterpolationParameter3DNative;
import com.supermap.realspace.spatialanalyst.SearchMode;

public class InterpolationIDWParameter3D
extends InterpolationParameter3D {
    public InterpolationIDWParameter3D() {
        super(InterpolationAlgorithmType.IDW);
    }

    public InterpolationIDWParameter3D(double resolution, SearchMode mode, double searchRadius, int expectedCount) {
        super(InterpolationAlgorithmType.IDW, resolution, mode, searchRadius, expectedCount);
    }

    public InterpolationIDWParameter3D(double resolution, SearchMode mode, double searchRadius, int expectedCount, int power) {
        this(resolution, mode, searchRadius, expectedCount);
        this.setPower(power);
    }

    @Override
    public InterpolationAlgorithmType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationAlgorithmType.IDW;
    }

    public int getPower() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPower()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameter3DNative.jni_GetPower(this.getHandle());
    }

    public void setPower(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPower(int value)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (value <= 0) {
            String string = InternalResource.loadString("value", "GlobalGreaterThanZero", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        InterpolationParameter3DNative.jni_SetPower(this.getHandle(), value);
    }

    @Override
    public void setSearchMode(SearchMode searchMode) {
        if (searchMode.equals((Object)SearchMode.QUADTREE)) {
            String string = InternalResource.loadString("searchMode", "GlobalUnsportedType", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        super.setSearchMode(searchMode);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(",Power=");
        stringBuffer.append(this.getPower());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

