/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.InternalHandle;
import com.supermap.data.Rectangle2D;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.MapCacheFile;
import com.supermap.data.processing.MapCacheProviderNative;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.Tile;
import com.supermap.data.processing.TileFormat;
import com.supermap.data.processing.TileSize;
import com.supermap.data.processing.Tiles;
import com.supermap.mapping.Map;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MapCacheProvider
extends InternalHandleDisposable {
    private Map m_map = null;
    private List<MapCacheFile> m_mapCacheFilesList = new ArrayList<MapCacheFile>();

    public MapCacheProvider() {
        this.setHandle(MapCacheProviderNative.jni_New(), true);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            MapCacheProviderNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheProviderNative.jni_GetName(this.getHandle());
    }

    public void setName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            String string = InternalResource.loadString("setName()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (name.length() == 0) {
            String string = InternalResource.loadString("setName()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheProviderNative.jni_SetName(this.getHandle(), name);
    }

    public boolean fromConfigFile(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (fileName == null) {
            String string = InternalResource.loadString("fromConfigFile()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (fileName.length() == 0) {
            String string = InternalResource.loadString("fromConfigFile()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = MapCacheProviderNative.jni_FromConfigFile(this.getHandle(), fileName);
        return bl;
    }

    public Map getMap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_map;
    }

    public void setMap(Map map) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (map != null && com.supermap.data.processing.InternalHandle.getHandle((InternalHandle)map) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_map = map;
        if (this.m_map != null) {
            MapCacheProviderNative.jni_SetMap(this.getHandle(), com.supermap.data.processing.InternalHandle.getHandle((InternalHandle)map));
        } else {
            MapCacheProviderNative.jni_SetMap(this.getHandle(), 0L);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)map);
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheProviderNative.jni_GetOutputFolder(this.getHandle());
    }

    public void setOutputFolder(String outputFolder) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (outputFolder.trim().length() == 0) {
            String string = InternalResource.loadString("setOutputFolder()", "OutputFolderNotExists", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheProviderNative.jni_SetOutputFolder(this.getHandle(), outputFolder);
    }

    public boolean toConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = this.computeProviderConfigFileName();
        return MapCacheProviderNative.jni_ToConfigFile(this.getHandle(), string);
    }

    private boolean addMapCache(File sciFile, String password) {
        int n = -1;
        File file = sciFile.getParentFile();
        for (File file2 : file.listFiles()) {
            File file3;
            if (!file2.isDirectory() || !(file3 = new File(file2, file2.getName() + ".inf")).exists()) continue;
            try {
                String string = file3.getCanonicalPath();
                boolean bl = MapCacheProviderNative.jni_AddMapCache(this.getHandle(), string, password);
                if (!bl) {
                    n = 0;
                    continue;
                }
                if (n == 0) continue;
                n = 1;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n == 1;
    }

    public boolean addMapCache(String cacheConfigPathName, String password) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addMapCache()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        File file = new File(cacheConfigPathName);
        if (file.exists()) {
            return this.addMapCache(file, password);
        }
        return false;
    }

    public boolean removeMapCache(String cacheConfigPathName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeMapCache()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        File file = new File(cacheConfigPathName);
        if (!file.exists()) {
            return false;
        }
        File file2 = file.getParentFile();
        for (File file3 : file2.listFiles()) {
            File file4;
            if (!file3.isDirectory() || !(file4 = new File(file3, file3.getName() + ".inf")).exists()) continue;
            try {
                String string = file4.getCanonicalPath();
                MapCacheProviderNative.jni_RemoveMapCache(this.getHandle(), string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    public Tile[] getTiles(Rectangle2D bounds, double scale, boolean transparent, TileSize tileSize, TileFormat tileFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Tile[] tileArray = new Tile[]{};
        if (bounds.isEmpty()) {
            return tileArray;
        }
        if (scale <= 0.0 || scale > 1.0) {
            return tileArray;
        }
        Tiles tiles = null;
        long l = MapCacheProviderNative.jni_GetTiles(this.getHandle(), bounds.getLeft(), bounds.getTop(), bounds.getRight(), bounds.getBottom(), scale, transparent, InternalEnum.getUGCValue(tileSize), InternalEnum.getUGCValue(tileFormat));
        tiles = new Tiles(l);
        tileArray = new Tile[tiles.getCount()];
        for (int i = 0; i < tiles.getCount(); ++i) {
            tileArray[i] = tiles.get(i);
        }
        return tileArray;
    }

    public Tile[] getTiles(Rectangle2D bounds, double scale, boolean transparent, TileSize tileSize, TileFormat tileFormat, boolean isPreciseMatch) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTilesEx()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Tile[] tileArray = new Tile[]{};
        if (bounds.isEmpty()) {
            return tileArray;
        }
        if (scale <= 0.0 || scale > 1.0) {
            return tileArray;
        }
        Tiles tiles = null;
        long l = MapCacheProviderNative.jni_GetTilesEx(this.getHandle(), bounds.getLeft(), bounds.getTop(), bounds.getRight(), bounds.getBottom(), scale, transparent, InternalEnum.getUGCValue(tileSize), InternalEnum.getUGCValue(tileFormat), isPreciseMatch);
        tiles = new Tiles(l);
        tileArray = new Tile[tiles.getCount()];
        for (int i = 0; i < tiles.getCount(); ++i) {
            tileArray[i] = tiles.get(i);
        }
        return tileArray;
    }

    public Tile[] getMixedTiles(Rectangle2D bounds, double scale, boolean transparent, TileSize tileSize, TileFormat tileFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMixedTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Tile[] tileArray = new Tile[]{};
        if (bounds.isEmpty()) {
            return tileArray;
        }
        if (scale <= 0.0 || scale > 1.0) {
            return tileArray;
        }
        Tiles tiles = null;
        long l = MapCacheProviderNative.jni_GetMixedTiles(this.getHandle(), bounds.getLeft(), bounds.getTop(), bounds.getRight(), bounds.getBottom(), scale, transparent, InternalEnum.getUGCValue(tileSize), InternalEnum.getUGCValue(tileFormat));
        tiles = new Tiles(l);
        tileArray = new Tile[tiles.getCount()];
        for (int i = 0; i < tiles.getCount(); ++i) {
            tileArray[i] = tiles.get(i);
        }
        return tileArray;
    }

    public String[] getCacheFiles() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheFiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCacheProviderNative.jni_GetCacheFiles(this.getHandle());
        String[] stringArray = string.split(";");
        return stringArray;
    }

    public Rectangle2D getIndexBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIndexBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapCacheProviderNative.jni_GetIndexBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[3], dArray[2], dArray[1]);
        return rectangle2D;
    }

    public void setIndexBounds(Rectangle2D indexBounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIndexBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheProviderNative.jni_SetIndexBounds(this.getHandle(), indexBounds.getLeft(), indexBounds.getTop(), indexBounds.getRight(), indexBounds.getBottom());
    }

    public boolean clear(Rectangle2D bounds, boolean isDeletingStaticCache) {
        return this.clear("", bounds, isDeletingStaticCache);
    }

    public boolean clear(String cacheName, Rectangle2D bounds, boolean isDeletingStaticCache) {
        if (isDeletingStaticCache) {
            this.clearStaticCache(cacheName, bounds);
        }
        return this.clearDynamicCache(cacheName, bounds);
    }

    private void clearStaticCache(String cacheName, Rectangle2D bounds) {
        for (int i = 0; i < this.m_mapCacheFilesList.size(); ++i) {
            double[] dArray;
            if (!cacheName.isEmpty() && this.m_mapCacheFilesList.get(i).getCacheName().compareTo(cacheName) != 0) continue;
            for (double d : dArray = this.m_mapCacheFilesList.get(i).getScales()) {
                this.m_mapCacheFilesList.get(i).clear(d, bounds);
            }
        }
    }

    private boolean clearDynamicCache(String cacheName, Rectangle2D bounds) {
        MapCacheProviderNative.jni_ClearDynamicCache(this.getHandle(), bounds.getLeft(), bounds.getTop(), bounds.getRight(), bounds.getBottom(), cacheName);
        return true;
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheProviderNative.jni_GetStorageType(this.getHandle());
        return (StorageType)InternalEnum.parseUGCValue(StorageType.class, n);
    }

    public void setStorageType(StorageType storageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheProviderNative.jni_SetStorageType(this.getHandle(), InternalEnum.getUGCValue(storageType));
    }

    public void setHashCodeIgnored(boolean enable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHashCodeIgnored()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheProviderNative.jni_SetHashCodeIgnored(this.getHandle(), enable);
    }

    public boolean isHashCodeIgnored() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isHashCodeIgnored()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheProviderNative.jni_IsHashCodeIgnored(this.getHandle());
    }

    private String computeProviderConfigFileName() {
        String string = "";
        string = this.getOutputFolder().isEmpty() ? "./" : this.getOutputFolder();
        if (!string.endsWith("/") || !string.endsWith("\\")) {
            string = string + "/";
        }
        string = string + this.getFinalProviderName();
        string = string + ".xml";
        return string;
    }

    private String getFinalProviderName() {
        String string = "";
        string = !this.getName().isEmpty() ? this.getName() : (this.m_map != null ? this.m_map.getName() : "Provider");
        return string;
    }
}

