/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.RasterClipFileType;
import com.supermap.analyst.spatialanalyst.RasterClipNative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class RasterClip {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private RasterClip() {
    }

    @Deprecated
    public static Dataset clipDatasetRaster(Dataset sourceDataset, GeoRegion userRegion, boolean isClipInRegion, boolean isExactClip, Datasource targetDatasource, String targetDatasetName) {
        return RasterClip.clip(sourceDataset, userRegion, isClipInRegion, isExactClip, targetDatasource, targetDatasetName);
    }

    public static Dataset eraseAndReplace(Dataset sourceDataset, GeoRegion userRegion, Datasource targetDatasource, String targetDatasetName, double replaceValue) {
        RasterClip.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = 0L;
        if (userRegion != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)userRegion);
        }
        long l4 = RasterClipNative.jni_Erase(l, l3, l2, targetDatasetName, replaceValue);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
        if (l4 != 0L) {
            if (sourceDataset.getType() == DatasetType.IMAGE) {
                DatasetImage datasetImage = InternalDatasetImage.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage);
                return datasetImage;
            }
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            return datasetGrid;
        }
        return null;
    }

    public static Dataset clip(Dataset sourceDataset, GeoRegion userRegion, boolean isClipInRegion, boolean isExactClip, Datasource targetDatasource, String targetDatasetName) {
        RasterClip.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = 0L;
        if (userRegion != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)userRegion);
        }
        long l4 = RasterClipNative.jni_ClipDatasetRaster(l, l3, l2, targetDatasetName, isClipInRegion, isExactClip);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
        if (l4 != 0L) {
            if (sourceDataset.getType() == DatasetType.IMAGE) {
                DatasetImage datasetImage = InternalDatasetImage.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage);
                return datasetImage;
            }
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            return datasetGrid;
        }
        return null;
    }

    public static boolean clip(DatasetImage sourceDataset, GeoRegion userRegion, boolean isClipInRegion, String targetFileName, RasterClipFileType targetFileType) {
        RasterClip.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (userRegion == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)userRegion) == 0L) {
            String string = InternalResource.loadString("userRegion", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetFileName == null || targetFileName.trim().length() == 0) {
            String string = InternalResource.loadString("targetFileName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!RasterClip.isDirectoryExisted(targetFileName)) {
            String string = InternalResource.loadString("targetFileName:" + targetFileName, "Global_PathIsNotValid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = "";
        if (targetFileType.equals((Object)RasterClipFileType.TIF)) {
            string = ".tif";
        } else if (targetFileType.equals((Object)RasterClipFileType.IMG)) {
            string = ".img";
        } else if (targetFileType.equals((Object)RasterClipFileType.SIT)) {
            string = ".sit";
        } else if (targetFileType.equals((Object)RasterClipFileType.BMP)) {
            string = ".bmp";
        } else if (targetFileType.equals((Object)RasterClipFileType.JPG)) {
            string = ".jpg";
        } else if (targetFileType.equals((Object)RasterClipFileType.PNG)) {
            string = ".png";
        } else if (targetFileType.equals((Object)RasterClipFileType.GIF)) {
            string = ".gif";
        } else {
            String string2 = InternalResource.loadString("targetFileType:", "Global_EnumInvalidDerivedClass", "spatialanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        targetFileName = RasterClip.getFileNameWithSuffix(targetFileName, string);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = 0L;
        if (userRegion != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)userRegion);
        }
        int n = InternalEnum.getUGCValue(targetFileType);
        int n2 = RasterClipNative.jni_ClipDatasetRasterImage(l, l2, targetFileName, n, isClipInRegion);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)userRegion);
        return n2 > 0;
    }

    public static boolean split(Dataset sourceDataset, GeoLine splitLine, Datasource targetDatasource, String targetLeftRasterName, String targetRightDatasetName) {
        RasterClip.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceDataset.getType() != DatasetType.IMAGE && sourceDataset.getType() != DatasetType.GRID) {
            String string = InternalResource.loadString("sourceDataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetLeftRasterName)) {
            String string = InternalResource.loadString("targetLeftRasterName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetRightDatasetName)) {
            String string = InternalResource.loadString("targetRightDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetRightDatasetName.equals(targetLeftRasterName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)splitLine);
        long[] lArray = RasterClipNative.jni_Split(l, l3, l2, targetLeftRasterName, targetRightDatasetName);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)splitLine);
        if (lArray != null && lArray.length == 2) {
            DatasetImage datasetImage;
            DatasetImage datasetImage2;
            if (sourceDataset.getType() == DatasetType.IMAGE) {
                datasetImage2 = InternalDatasetImage.createInstance(lArray[0], targetDatasource);
                datasetImage = InternalDatasetImage.createInstance(lArray[1], targetDatasource);
                if (datasetImage2 != null && datasetImage != null) {
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage2);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage);
                    return true;
                }
            }
            if (sourceDataset.getType() == DatasetType.GRID) {
                datasetImage2 = InternalDatasetGrid.createInstance(lArray[0], targetDatasource);
                datasetImage = InternalDatasetGrid.createInstance(lArray[1], targetDatasource);
                if (datasetImage2 != null && datasetImage != null) {
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage2);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage);
                    return true;
                }
            }
        }
        return false;
    }

    private static String getFileNameWithSuffix(String fileName, String suffix) {
        String string = null;
        if (fileName.toLowerCase().endsWith(suffix)) {
            int n = fileName.toLowerCase().lastIndexOf(suffix);
            string = fileName.substring(0, n) + suffix;
        } else {
            string = fileName + suffix;
        }
        return string;
    }

    private static boolean isDirectoryExisted(String fileName) {
        File file = new File(fileName);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "RasterClip";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        RasterClip.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

