/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.google.gson.Gson;
import com.supermap.data.CloudLicenseError;
import com.supermap.data.ContentType;
import com.supermap.data.FormalLicPostResponse;
import com.supermap.data.FormalLicenseResponseLicInfo;
import com.supermap.data.FormalLicenseResponseResult;
import com.supermap.data.HttpRequestMethod;
import com.supermap.data.HttpUtils;
import com.supermap.data.HttpsUtils;
import com.supermap.data.License;
import com.supermap.data.RequestParas;
import com.supermap.data.ReturnResponseData;
import com.supermap.data.TrialLicPostResponse;
import com.supermap.data.TrialLicenseResponseResult;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CloudLicense {
    private static final String SSO_URL = "https://sso.supermap.com";
    private static final String SSO_HTML_URL = "https://sso.supermap.com/login?service=http://www.supermapol.com/shiro-cas";
    private static final String LICENSE_URL = "https://license.supermapol.com/api/web/v1/ilicense/license";
    private static final String LICENSE_FORMAL_URL = "https://license.supermapol.com/api/web/v1/ilicense/license/formal";
    private static final String LICENSE_GET_FORMAL_URL = "https://license.supermapol.com/api/web/v1/ilicense/license/formal/ids/%s/returns";
    private static final String LICENSE_RETURN_FORMAL_URL = "https://license.supermapol.com/api/web/v1/ilicense/license/formal/ids/%s/returns/ids/%s";
    private static final String LICENSE_TRIAL_URL = "https://license.supermapol.com/api/web/v1/ilicense/license/trial";
    private static final String LICENSE_GET_TRIAL_URL = "https://license.supermapol.com/api/web/v1/ilicense/license/trial/ids";
    private static final String LICENSE_RETURN_TRIAL_URL = "https://license.supermapol.com/api/web/v1/ilicense/license/trial/ids/returns/ids/%s";
    private static final String LICENSE_APPKEY = "appKey=b373b3f803964459ae43af8abc1976bd";
    static String UGO_TYPE_DEFINE = "60000";
    static String VERSION_DEFINE = "9D";
    private static final String LICENSE_APPKEY_PRODUCTTYPE = "appKey=b373b3f803964459ae43af8abc1976bd&productType=" + UGO_TYPE_DEFINE + "&version=" + VERSION_DEFINE;
    private static String _STR_LOGIN_PARA = "username=%s&password=%s";
    private static String g_licenseActiveCookie = "";
    private static String g_formalLicID = "";
    private static String g_formalLicReturnID = "";
    private static Gson g_gson = new Gson();
    private static String _user = "";
    private static String _password = "";
    private static boolean _isTrialOnly = false;
    private static long _autoUpdateInterval = 3600000L;
    private static ScheduledExecutorService _scheduExec = Executors.newScheduledThreadPool(1);
    private static Runnable _loginRunnable = null;

    public static void main(String[] args) {
        String mail = "test@supermap.com";
        String password = "test";
        CloudLicense.login(mail, password);
        License lic = new License();
        int code = lic.connect(10002);
        System.out.println("code = " + code + ", isCloudLicense " + lic.isCloudLicense());
        CloudLicense.logout(mail, password);
        code = lic.connect(10002);
        System.out.println("code = " + code + ", isCloudLicense " + lic.isCloudLicense());
        System.out.println("end");
    }

    public static void setAutoUpdateInterval(long milliseconds) {
        _autoUpdateInterval = milliseconds;
        if (_loginRunnable != null) {
            _scheduExec.scheduleAtFixedRate(_loginRunnable, _autoUpdateInterval, _autoUpdateInterval, TimeUnit.MILLISECONDS);
        }
    }

    public static boolean login(String user, String password) {
        return CloudLicense.runLogin(user, password, false);
    }

    public static boolean login(String user, String password, boolean isTrialOnly) {
        return CloudLicense.runLogin(user, password, isTrialOnly);
    }

    public static boolean logout(String user, String password) {
        _user = user;
        _password = password;
        boolean result = false;
        if (g_licenseActiveCookie != null && g_licenseActiveCookie.isEmpty() && !(result = CloudLicense.connectServerAndLogin())) {
            _scheduExec.shutdown();
            return result;
        }
        result = CloudLicense.cancelNetLicense();
        _scheduExec.shutdown();
        return result;
    }

    private static boolean runLogin(String user, String password, boolean isTrialOnly) {
        _user = user;
        _password = password;
        _isTrialOnly = isTrialOnly;
        _loginRunnable = new Runnable(){

            @Override
            public void run() {
                boolean isSuccess = CloudLicense.loginInternal(_user, _password, _isTrialOnly);
                System.out.println("run");
                if (!isSuccess) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("autoupdate login error");
                    sb.append("user:" + _user);
                    CloudLicenseError.setLastError(sb.toString());
                }
            }
        };
        _scheduExec.scheduleAtFixedRate(_loginRunnable, _autoUpdateInterval, _autoUpdateInterval, TimeUnit.MILLISECONDS);
        return CloudLicense.loginInternal(_user, _password, _isTrialOnly);
    }

    private static boolean loginInternal(String user, String password, boolean isTrialOnly) {
        boolean result = false;
        result = CloudLicense.connectServerAndLogin();
        if (!result) {
            return result;
        }
        result = CloudLicense.getNetLicense(isTrialOnly);
        return result;
    }

    private static boolean connectServerAndLogin() {
        try {
            HttpsUtils getHtmlConnection = new HttpsUtils();
            getHtmlConnection.createHttpsConnction(SSO_HTML_URL, HttpRequestMethod.Get, ContentType.WWW, true, "");
            String ssoHtml = getHtmlConnection.get();
            String ltPrefix = "<input type=\"hidden\" name=\"lt\" value=\"";
            String loginPrefix = "form id=\"fm1\" action=\"";
            String postfix = "\"";
            String login = CloudLicense.getContext(ssoHtml, loginPrefix, postfix);
            String ltContext = CloudLicense.getContext(ssoHtml, ltPrefix, postfix);
            String request = "lt=";
            request = request + ltContext;
            request = request + "&";
            request = request + String.format(_STR_LOGIN_PARA, _user, _password);
            request = request + "&execution=e1s1&_eventId=submit&submit=%E7%99%BB%E5%BD%95";
            String loginURL = SSO_URL + login;
            HttpsUtils getTicketConnection = new HttpsUtils();
            getTicketConnection.createHttpsConnction(loginURL, HttpRequestMethod.Post, ContentType.WWW, true, "");
            String ticketURL = getTicketConnection.getTicket(request);
            HttpUtils getCookieConnection = new HttpUtils();
            getCookieConnection.createHttpsConnction(ticketURL, HttpRequestMethod.Get, ContentType.WWW, false, "");
            g_licenseActiveCookie = getCookieConnection.getCookie("JSESSIONID");
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("connectServerAndLogin exception");
            sb.append(e);
            CloudLicenseError.setLastError(sb.toString());
            return false;
        }
        return true;
    }

    private static boolean getNetLicense(boolean isTrialOnly) {
        if (isTrialOnly) {
            return CloudLicense.getTrialLicense();
        }
        if (!CloudLicense.getFormalLicense()) {
            return CloudLicense.getTrialLicense();
        }
        return true;
    }

    private static boolean getFormalLicense() {
        return CloudLicense.requestLicense(false);
    }

    private static List<FormalLicenseResponseLicInfo> getFormalLicenseInfos() {
        String url = "https://license.supermapol.com/api/web/v1/ilicense/license/formal?" + LICENSE_APPKEY_PRODUCTTYPE;
        try {
            HttpsUtils queryFormalLicRequest = new HttpsUtils();
            queryFormalLicRequest.createHttpsConnction(url, HttpRequestMethod.Get, ContentType.JSON, true, g_licenseActiveCookie);
            String strResponse = queryFormalLicRequest.get();
            FormalLicenseResponseResult responseRes = g_gson.fromJson(strResponse, FormalLicenseResponseResult.class);
            if (responseRes.code == 0 && responseRes.data.licenseCount > 0) {
                return responseRes.data.licenses;
            }
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("getFormalLicenseInfos exception");
            sb.append(e);
            CloudLicenseError.setLastError(sb.toString());
        }
        return null;
    }

    private static boolean getTrialLicenseInfo() {
        String url = "https://license.supermapol.com/api/web/v1/ilicense/license/trial?" + LICENSE_APPKEY_PRODUCTTYPE;
        try {
            HttpsUtils queryFormalLicRequest = new HttpsUtils();
            queryFormalLicRequest.createHttpsConnction(url, HttpRequestMethod.Get, ContentType.JSON, true, g_licenseActiveCookie);
            String strResponse = queryFormalLicRequest.get();
            TrialLicenseResponseResult trialResult = g_gson.fromJson(strResponse, TrialLicenseResponseResult.class);
            if (trialResult.code == 0 && trialResult.data.trial) {
                return true;
            }
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("getTrialLicenseInfo exception");
            sb.append(e);
            CloudLicenseError.setLastError(sb.toString());
        }
        return false;
    }

    private static boolean requestLicense(boolean isTrial) {
        boolean canRequest = false;
        String getLicenseURL = "";
        if (isTrial) {
            if (CloudLicense.getTrialLicenseInfo()) {
                getLicenseURL = LICENSE_GET_TRIAL_URL;
                canRequest = true;
            }
        } else {
            List<FormalLicenseResponseLicInfo> formLicInfos = CloudLicense.getFormalLicenseInfos();
            if (formLicInfos.size() > 0) {
                g_formalLicID = formLicInfos.get((int)0).id;
                getLicenseURL = LICENSE_GET_FORMAL_URL;
                getLicenseURL = String.format(getLicenseURL, g_formalLicID);
                canRequest = true;
            }
        }
        if (canRequest) {
            getLicenseURL = getLicenseURL + "?";
            getLicenseURL = getLicenseURL + LICENSE_APPKEY;
            String postStr = RequestParas.buildGetLicensePost();
            HttpsUtils getFormalLicRequest = new HttpsUtils();
            getFormalLicRequest.createHttpsConnction(getLicenseURL, HttpRequestMethod.Post, ContentType.JSON, true, g_licenseActiveCookie);
            String strResponse = getFormalLicRequest.post(postStr);
            if (strResponse != null && !strResponse.isEmpty()) {
                if (isTrial) {
                    TrialLicPostResponse response = g_gson.fromJson(strResponse, TrialLicPostResponse.class);
                    if (response != null && response.code == 0) {
                        CloudLicense.setLicense(response.data.license);
                        g_formalLicReturnID = response.data.returnId;
                        return true;
                    }
                    CloudLicenseError.setLastError("Get trial license context failed...");
                } else {
                    FormalLicPostResponse response = g_gson.fromJson(strResponse, FormalLicPostResponse.class);
                    if (response != null && response.code == 0) {
                        CloudLicense.setLicense(response.data.license);
                        g_formalLicReturnID = response.data.returnId;
                        return true;
                    }
                    CloudLicenseError.setLastError("Get formal license context failed...");
                }
            } else {
                CloudLicenseError.setLastError("Request license failed...");
            }
        }
        return false;
    }

    private static boolean getTrialLicense() {
        return CloudLicense.requestLicense(true);
    }

    private static void setLicense(String licenseXML) {
        License.setSpecifyLicenseXML((String)licenseXML);
    }

    private static boolean cancelNetLicense() {
        if (!CloudLicense.cancelFormalLicense()) {
            return CloudLicense.cancelTrialLicense();
        }
        return true;
    }

    private static boolean cancelFormalLicense() {
        return CloudLicense.cancelLicense(false);
    }

    private static boolean cancelTrialLicense() {
        return CloudLicense.cancelLicense(true);
    }

    private static boolean cancelLicense(boolean isTrail) {
        boolean result;
        String returnLicenseURL = "";
        returnLicenseURL = isTrail ? String.format(LICENSE_RETURN_TRIAL_URL, g_formalLicReturnID) : String.format(LICENSE_RETURN_FORMAL_URL, g_formalLicID, g_formalLicReturnID);
        returnLicenseURL = returnLicenseURL + "?";
        returnLicenseURL = returnLicenseURL + LICENSE_APPKEY;
        HttpUtils httpUtils = new HttpUtils();
        httpUtils.createHttpsConnction(returnLicenseURL, HttpRequestMethod.Put, ContentType.JSON, true, g_licenseActiveCookie);
        String respose = httpUtils.get();
        ReturnResponseData responseRes = g_gson.fromJson(respose, ReturnResponseData.class);
        boolean bl = result = responseRes.code == 0;
        if (result) {
            CloudLicense.setLicense("");
        } else {
            CloudLicenseError.setLastError("cancelLicense response failed");
        }
        return result;
    }

    private static String getContext(String context, String prefix, String postfix) {
        int nIndex1 = context.indexOf(prefix) + prefix.length();
        int nIndex2 = context.indexOf(postfix, nIndex1);
        return context.substring(nIndex1, nIndex2);
    }
}

