/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.threeddesigner;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.DatasetType;
import com.supermap.data.Environment;
import com.supermap.data.Geometry3D;
import com.supermap.data.GeometryType;
import com.supermap.data.Recordset;
import com.supermap.realspace.threeddesigner.InternalHandle;
import com.supermap.realspace.threeddesigner.InternalResource;
import com.supermap.realspace.threeddesigner.InternalToolkitThreeDDesigner;
import com.supermap.realspace.threeddesigner.PositionMode;
import com.supermap.realspace.threeddesigner.SpatialQuery3DNative;
import java.util.ArrayList;

public abstract class SpatialQuery3D {
    private static License m_license;

    public static PositionMode getRelativePosition(Geometry3D geometry1, Geometry3D geometry2) {
        int n;
        if (null == geometry1) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry1);
        if (0L == l) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry2);
        if (l2 == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        PositionMode positionMode = new PositionMode(0, 0);
        if (geometry1.getType() == GeometryType.GEOPOINT3D) {
            n = SpatialQuery3DNative.jni_IsSupport(l2);
            if (n == 0) {
                String string = InternalResource.loadString("geometry2", "Global_ArgumentTypeInvalid", "ThreeDDesigner_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (geometry2.getType() == GeometryType.GEOPOINT3D) {
            n = SpatialQuery3DNative.jni_IsSupport(l);
            if (n == 0) {
                String string = InternalResource.loadString("geometry1", "Global_ArgumentTypeInvalid", "ThreeDDesigner_resources");
                throw new IllegalArgumentException(string);
            }
        } else {
            n = SpatialQuery3DNative.jni_IsSupport(l);
            if (n == 0) {
                String string = InternalResource.loadString("geometry1", "Global_ArgumentTypeInvalid", "ThreeDDesigner_resources");
                throw new IllegalArgumentException(string);
            }
            n = SpatialQuery3DNative.jni_IsSupport(l2) ? 1 : 0;
            if (n == 0) {
                String string = InternalResource.loadString("geometry2", "Global_ArgumentTypeInvalid", "ThreeDDesigner_resources");
                throw new IllegalArgumentException(string);
            }
        }
        n = SpatialQuery3DNative.jni_GetRelativePosition(l, l2);
        positionMode = PositionMode.parseUGCValue(n);
        return positionMode;
    }

    public static int[] spatialQuery(Geometry3D geometry, Recordset modelRecordset, PositionMode posMode) {
        if (null == geometry || null == modelRecordset) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        boolean bl = SpatialQuery3DNative.jni_IsSupport(l);
        if (geometry.getType() != GeometryType.GEOPOINT3D && !bl) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() == GeometryType.GEOPOINT3D && modelRecordset.getDataset().getType() == DatasetType.POINT3D) {
            String string = InternalResource.loadString("modelRecordset", "Global_ArgumentTypeInvalid", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelRecordset);
        return SpatialQuery3DNative.jni_SpatialQuery(l, l2, posMode.value());
    }

    static {
        Environment.LoadWrapJ();
        ArrayList<ProductType> arrayList = InternalToolkitThreeDDesigner.managerProducts(InternalToolkitThreeDDesigner.getThreeDDesignerProducts());
        m_license = InternalToolkitThreeDDesigner.verifyLicense(arrayList);
    }
}

