/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingVCTNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;

public class ImportSettingVCT
extends ImportSetting {
    public ImportSettingVCT() {
        long l = ImportSettingVCTNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingVCT(ImportSettingVCT importSettingVCT) {
        if (importSettingVCT == null) {
            String string = InternalResource.loadString("ImportSettingVCT", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingVCT);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingVCT", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingVCTNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingVCT.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingVCT.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingVCT.getTargetPrjCoordSys());
        super.setDataType(DataType.VECTOR);
        this.setImportEmptyDataset(importSettingVCT.isImportEmptyDataset());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingVCT));
    }

    public ImportSettingVCT(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public ImportSettingVCT(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
        super.setDataType(DataType.VECTOR);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingVCTNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    public void setImportEmptyDataset(boolean bImportEmptyDT) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingVCTNative.jni_SetImportEmptyDT(this.getHandle(), bImportEmptyDT);
    }

    public boolean isImportEmptyDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingVCTNative.jni_IsImportEmptyDT(this.getHandle());
    }

    public void setImportLayerName(String[] layerNames) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportLayerName()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (layerNames.length == 0) {
            return;
        }
        ImportSettingVCTNative.jni_SetImportLayerName(this.getHandle(), layerNames);
    }
}

