/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.GeoStyle3D;
import com.supermap.realspace.InternalGeoStyle3D;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Theme3DGraph;
import com.supermap.realspace.Theme3DGraphItemNative;

public class Theme3DGraphItem
extends InternalHandleDisposable {
    private GeoStyle3D m_style = null;
    private Theme3DGraph m_theme3DGraph = null;
    private boolean m_isUserThemeGraph = false;

    public Theme3DGraphItem() {
        long l = Theme3DGraphItemNative.jni_new();
        this.setHandle(l, true);
        this.reset();
        this.m_isUserThemeGraph = false;
    }

    public Theme3DGraphItem(Theme3DGraphItem theme3DItem) {
        long l;
        if (theme3DItem == null) {
            String string = InternalResource.loadString("theme3DItem", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (theme3DItem.m_isUserThemeGraph) {
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)theme3DItem.m_theme3DGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("theme3DItem", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
            int n = theme3DItem.m_theme3DGraph.getGraphItemsList().indexOf((Object)theme3DItem);
            if (n == -1) {
                String string = InternalResource.loadString("theme3DItem", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (theme3DItem.getHandle() == 0L) {
            String string = InternalResource.loadString("theme3DItem", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        l = Theme3DGraphItemNative.jni_clone(theme3DItem.getHandle());
        this.setHandle(l, true);
        this.m_isUserThemeGraph = false;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)theme3DItem));
    }

    Theme3DGraphItem(long handle, Theme3DGraph theme3DGraph) {
        this.setHandle(handle, false);
        this.m_isUserThemeGraph = true;
        this.m_theme3DGraph = theme3DGraph;
    }

    public String getCaption() {
        if (this.m_isUserThemeGraph) {
            int n = this.m_theme3DGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_theme3DGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Theme3DGraphItemNative.jni_getCaption(this.getHandle());
    }

    public void setCaption(String caption) {
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_isUserThemeGraph) {
            int n = this.m_theme3DGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_theme3DGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Theme3DGraphItemNative.jni_setCaption(this.getHandle(), caption);
    }

    public String getGraphExpression() {
        if (this.m_isUserThemeGraph) {
            int n = this.m_theme3DGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getGraphExpression()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_theme3DGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("getGraphExpression()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGraphExpression()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Theme3DGraphItemNative.jni_getGraphExpression(this.getHandle());
    }

    public void setGraphExpression(String graphExpression) {
        if (graphExpression == null || graphExpression.trim().length() == 0) {
            String string = InternalResource.loadString("graphExpression", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_isUserThemeGraph) {
            int n = this.m_theme3DGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("setGraphExpression(String graphExpression)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_theme3DGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("setGraphExpression(String graphExpression)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGraphExpression(String graphExpression)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Theme3DGraphItemNative.jni_setGraphExpression(this.getHandle(), graphExpression);
    }

    public GeoStyle3D getUniformStyle() {
        long l;
        if (this.m_isUserThemeGraph) {
            int n = this.m_theme3DGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getUniformStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_theme3DGraph);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getUniformStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getUniformStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (this.m_style == null && (l = Theme3DGraphItemNative.jni_getUniformStyle(this.getHandle())) != 0L) {
            this.m_style = InternalGeoStyle3D.createInstance(l);
        }
        return this.m_style;
    }

    public void setUniformStyle(GeoStyle3D uniformStyle) {
        if (this.m_isUserThemeGraph) {
            int n = this.m_theme3DGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("setUniformStyle(GeoStyle uniformStyle)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_theme3DGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("setUniformStyle(GeoStyle3 uniformStyle)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUniformStyle(GeoStyle3D uniformStyle)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (uniformStyle == null) {
            String string = InternalResource.loadString("uniformStyle", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)uniformStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("uniformStyle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3D geoStyle3D = uniformStyle.clone();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D);
        Theme3DGraphItemNative.jni_setUniformStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)uniformStyle);
    }

    public String toString() {
        if (this.m_isUserThemeGraph) {
            int n = this.m_theme3DGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_theme3DGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Caption = ");
        stringBuffer.append(this.getCaption());
        stringBuffer.append(",GraphExpression = ");
        stringBuffer.append(this.getGraphExpression());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public double[] getMemoryDoubleValues() {
        if (this.m_isUserThemeGraph) {
            int n = this.m_theme3DGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("getMemoryDoubleValues()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_theme3DGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("getMemoryDoubleValues()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMemoryDoubleValues()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = Theme3DGraphItemNative.jni_getDoubleMemoryValues(this.getHandle());
        return dArray;
    }

    public void setMemoryDoubleValues(double[] values) {
        if (this.m_isUserThemeGraph) {
            int n = this.m_theme3DGraph.getGraphItemsList().indexOf((Object)this);
            if (n == -1) {
                String string = InternalResource.loadString("SetMemoryDoubleValues(double[] values)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_theme3DGraph);
            if (l == 0L) {
                String string = InternalResource.loadString("SetMemoryDoubleValues(double[] values)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            if (values == null) {
                if (this.m_theme3DGraph.getMemoryKeys().length > 0) {
                    String string = InternalResource.loadString("values", "Theme3DGraph_TheLengthOfMemoryDoubleValuesShouldBeEqualsWithTheLengthOfMemoryKeys", "realspace_resources");
                    throw new IllegalArgumentException(string);
                }
            } else if (values.length != this.m_theme3DGraph.getMemoryKeys().length) {
                String string = InternalResource.loadString("values", "Theme3DGraph_TheLengthOfMemoryDoubleValuesShouldBeEqualsWithTheLengthOfMemoryKeys", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetMemoryDoubleValues(double[] values)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Theme3DGraphItemNative.jni_setDoubleMemoryValues(this.getHandle(), values);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            Theme3DGraphItemNative.jni_delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void reset() {
        if (this.getHandle() != 0L) {
            Theme3DGraphItemNative.jni_reset(this.getHandle());
        }
    }

    protected void clearHandle() {
        if (this.m_style != null) {
            InternalGeoStyle3D.clearHandle(this.m_style);
            this.m_style = null;
        }
        this.setHandle(0L);
    }

    private void changeHandle(long handle) {
        this.setHandle(handle, false);
    }

    void refreshItemAndStyle(long itemHandle, long styleHandle) {
        if (this.m_isUserThemeGraph) {
            this.changeHandle(itemHandle);
            if (this.m_style != null) {
                InternalGeoStyle3D.refreshHandle(this.m_style, styleHandle);
            }
        }
    }
}

