/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Enum;
import com.supermap.data.Geometry;
import com.supermap.realspace.InternalGeometry;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.ScreenCoordinateUnit;
import com.supermap.realspace.ScreenLayer3DAddedEvent;
import com.supermap.realspace.ScreenLayer3DAddedListener;
import com.supermap.realspace.ScreenLayer3DClearedEvent;
import com.supermap.realspace.ScreenLayer3DClearedListener;
import com.supermap.realspace.ScreenLayer3DGeometryChangedEvent;
import com.supermap.realspace.ScreenLayer3DGeometryChangedListener;
import com.supermap.realspace.ScreenLayer3DRemovedEvent;
import com.supermap.realspace.ScreenLayer3DRemovedListener;
import com.supermap.realspace.ScreenLayer3DSelectedIndexChangedEvent;
import com.supermap.realspace.ScreenLayer3DSelectedIndexChangedListener;
import com.supermap.realspace.ScreenLayer3DTagChangedEvent;
import com.supermap.realspace.ScreenLayer3DTagChangedListener;
import com.supermap.realspace.ScreenLayer3DVisibleChangedEvent;
import com.supermap.realspace.ScreenLayer3DVisibleChangedListener;
import com.supermap.realspace.ScreenLayerNative;
import com.supermap.realspace.TrackingLayer3DNative;
import java.util.Vector;

public class ScreenLayer3D
extends InternalHandle {
    private long m_sceneControlHandle = 0L;
    transient Vector m_screenLayer3DAddedListeners;
    transient Vector m_screenLayer3DRemovedListeners;
    transient Vector m_screenLayer3DClearedListeners;
    transient Vector m_screenLayer3DGeometryChangedListeners;
    transient Vector m_screenLayer3DTagChangedListeners;
    transient Vector m_screenLayer3DSelectedIndexChangedListeners;
    transient Vector m_screenLayer3DVisibleChangedListeners;
    private boolean m_isVisible;

    ScreenLayer3D(long handle, long sceneControlHandle) {
        this.setHandle(handle);
        this.m_sceneControlHandle = sceneControlHandle;
        this.m_isVisible = ScreenLayerNative.jni_IsVisible(this.getHandle());
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_GetCount(this.getHandle());
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this.m_isVisible = ScreenLayerNative.jni_IsVisible(this.getHandle());
        return this.m_isVisible;
    }

    public void setVisible(boolean isVisible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisible(Boolean isVisible)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (isVisible != this.m_isVisible) {
            ScreenLayerNative.jni_SetVisible(this.getHandle(), isVisible);
            this.m_isVisible = isVisible;
            ScreenLayer3DVisibleChangedEvent screenLayer3DVisibleChangedEvent = new ScreenLayer3DVisibleChangedEvent((Object)this, isVisible);
            this.fireScreenLayer3DVisibleChanged(screenLayer3DVisibleChangedEvent);
        }
    }

    int add(Geometry geometry, String tag, boolean isLocationFixed, boolean isSizeFixed) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Geometry geometry, String tag, boolean isLocationFixed,boolean isSizeFixed)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (tag == null) {
            tag = "";
        }
        Geometry geometry2 = geometry.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry2, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry2);
        int n = ScreenLayerNative.jni_Add(this.getHandle(), l2, tag, isLocationFixed, isSizeFixed);
        if (n != -1) {
            ScreenLayer3DAddedEvent screenLayer3DAddedEvent = new ScreenLayer3DAddedEvent((Object)this, n, geometry, tag);
            this.fireScreenLayer3DAdded(screenLayer3DAddedEvent);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry2);
        return n;
    }

    public int add(Geometry geometry, String tag) {
        return this.add(geometry, tag, false, true);
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = ScreenLayerNative.jni_Remove(this.getHandle(), index);
        if (bl) {
            ScreenLayer3DRemovedEvent screenLayer3DRemovedEvent = new ScreenLayer3DRemovedEvent((Object)this, index);
            this.fireScreenLayer3DRemoved(screenLayer3DRemovedEvent);
        }
        return bl;
    }

    public Geometry get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry = null;
        long l = ScreenLayerNative.jni_Get(this.getHandle(), index);
        if (l != 0L) {
            geometry = InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, true);
        }
        return geometry;
    }

    public boolean set(int index, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry2, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry2);
        ScreenLayerNative.jni_Set(this.getHandle(), index, l2);
        ScreenLayer3DGeometryChangedEvent screenLayer3DGeometryChangedEvent = new ScreenLayer3DGeometryChangedEvent((Object)this, index, geometry);
        this.fireScreenLayer3DGeometryChanged(screenLayer3DGeometryChangedEvent);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry2);
        return true;
    }

    public String getTag(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTag(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return TrackingLayer3DNative.jni_GetTag(this.getHandle(), index);
    }

    public boolean setTag(int index, String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTag(int index, String tag)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (tag == null) {
            tag = "";
        }
        ScreenLayerNative.jni_SetTag(this.getHandle(), index, tag);
        ScreenLayer3DTagChangedEvent screenLayer3DTagChangedEvent = new ScreenLayer3DTagChangedEvent((Object)this, index, tag);
        this.fireScreenLayer3DTagChanged(screenLayer3DTagChangedEvent);
        return true;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        ScreenLayerNative.jni_Clear(this.getHandle());
        ScreenLayer3DClearedEvent screenLayer3DClearedEvent = new ScreenLayer3DClearedEvent((Object)this);
        this.fireScreenLayer3DCleared(screenLayer3DClearedEvent);
    }

    public ScreenCoordinateUnit getXUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getXUnit()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = ScreenLayerNative.jni_GetXUnit(this.getHandle());
        return (ScreenCoordinateUnit)Enum.parse(ScreenCoordinateUnit.class, (int)n);
    }

    public ScreenCoordinateUnit getYUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getYUnit()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = ScreenLayerNative.jni_GetYUnit(this.getHandle());
        return (ScreenCoordinateUnit)Enum.parse(ScreenCoordinateUnit.class, (int)n);
    }

    public void setXUnit(ScreenCoordinateUnit unit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setXUnit(ScreenCoordinateUnit unit)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        ScreenLayerNative.jni_SetXUnit(this.getHandle(), unit.value());
    }

    public void setYUnit(ScreenCoordinateUnit unit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setYUnit(ScreenCoordinateUnit unit)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        ScreenLayerNative.jni_SetYUnit(this.getHandle(), unit.value());
    }

    public boolean isSelected(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSelected(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return ScreenLayerNative.jni_IsSelected(this.getHandle(), index);
    }

    public void setSelected(int index, boolean isSelected) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSelected(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        ScreenLayerNative.jni_SetSelected(this.getHandle(), this.m_sceneControlHandle, index, isSelected);
        ScreenLayer3DSelectedIndexChangedEvent screenLayer3DSelectedIndexChangedEvent = new ScreenLayer3DSelectedIndexChangedEvent((Object)this, index, isSelected);
        this.fireScreenLayer3DSelectedIndexChanged(screenLayer3DSelectedIndexChangedEvent);
    }

    void setEditable(boolean value) {
        ScreenLayerNative.jni_SetEditable(this.getHandle(), value);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    public synchronized void addScreenLayer3DAddedListener(ScreenLayer3DAddedListener l) {
        if (this.m_screenLayer3DAddedListeners == null) {
            this.m_screenLayer3DAddedListeners = new Vector();
        }
        if (this.m_screenLayer3DAddedListeners.contains(l)) {
            // empty if block
        }
        this.m_screenLayer3DAddedListeners.add(l);
    }

    public synchronized void removeScreenLayer3DAddedListener(ScreenLayer3DAddedListener l) {
        if (this.m_screenLayer3DAddedListeners != null && this.m_screenLayer3DAddedListeners.contains(l)) {
            this.m_screenLayer3DAddedListeners.remove(l);
        }
    }

    protected void fireScreenLayer3DAdded(ScreenLayer3DAddedEvent event) {
        if (this.m_screenLayer3DAddedListeners != null) {
            Vector vector = this.m_screenLayer3DAddedListeners;
            int n = this.m_screenLayer3DAddedListeners.size();
            for (int i = 0; i < n; ++i) {
                ((ScreenLayer3DAddedListener)vector.elementAt(i)).screenLayer3DAdded(event);
            }
        }
    }

    public synchronized void addScreenLayer3DRemovedListener(ScreenLayer3DRemovedListener l) {
        if (this.m_screenLayer3DRemovedListeners == null) {
            this.m_screenLayer3DRemovedListeners = new Vector();
        }
        if (this.m_screenLayer3DRemovedListeners.contains(l)) {
            // empty if block
        }
        this.m_screenLayer3DRemovedListeners.add(l);
    }

    public synchronized void removeScreenLayer3DRemovedListener(ScreenLayer3DRemovedListener l) {
        if (this.m_screenLayer3DRemovedListeners != null && this.m_screenLayer3DRemovedListeners.contains(l)) {
            this.m_screenLayer3DRemovedListeners.remove(l);
        }
    }

    protected void fireScreenLayer3DRemoved(ScreenLayer3DRemovedEvent event) {
        if (this.m_screenLayer3DRemovedListeners != null) {
            Vector vector = this.m_screenLayer3DRemovedListeners;
            int n = this.m_screenLayer3DRemovedListeners.size();
            for (int i = 0; i < n; ++i) {
                ((ScreenLayer3DRemovedListener)vector.elementAt(i)).screenLayer3DRemoved(event);
            }
        }
    }

    public synchronized void addScreenLayer3DClearedListener(ScreenLayer3DClearedListener l) {
        if (this.m_screenLayer3DClearedListeners == null) {
            this.m_screenLayer3DClearedListeners = new Vector();
        }
        if (this.m_screenLayer3DClearedListeners.contains(l)) {
            // empty if block
        }
        this.m_screenLayer3DClearedListeners.add(l);
    }

    public synchronized void removeScreenLayer3DClearedListener(ScreenLayer3DClearedListener l) {
        if (this.m_screenLayer3DClearedListeners != null && this.m_screenLayer3DClearedListeners.contains(l)) {
            this.m_screenLayer3DClearedListeners.remove(l);
        }
    }

    protected void fireScreenLayer3DCleared(ScreenLayer3DClearedEvent event) {
        if (this.m_screenLayer3DClearedListeners != null) {
            Vector vector = this.m_screenLayer3DClearedListeners;
            int n = this.m_screenLayer3DClearedListeners.size();
            for (int i = 0; i < n; ++i) {
                ((ScreenLayer3DClearedListener)vector.elementAt(i)).screenLayer3DCleared(event);
            }
        }
    }

    public synchronized void addScreenLayer3DGeometryChangedListener(ScreenLayer3DGeometryChangedListener l) {
        if (this.m_screenLayer3DGeometryChangedListeners == null) {
            this.m_screenLayer3DGeometryChangedListeners = new Vector();
        }
        if (this.m_screenLayer3DGeometryChangedListeners.contains(l)) {
            // empty if block
        }
        this.m_screenLayer3DGeometryChangedListeners.add(l);
    }

    public synchronized void removeScreenLayer3DGeometryChangedListener(ScreenLayer3DGeometryChangedListener l) {
        if (this.m_screenLayer3DGeometryChangedListeners != null && this.m_screenLayer3DGeometryChangedListeners.contains(l)) {
            this.m_screenLayer3DGeometryChangedListeners.remove(l);
        }
    }

    protected void fireScreenLayer3DGeometryChanged(ScreenLayer3DGeometryChangedEvent event) {
        if (this.m_screenLayer3DGeometryChangedListeners != null) {
            Vector vector = this.m_screenLayer3DGeometryChangedListeners;
            int n = this.m_screenLayer3DGeometryChangedListeners.size();
            for (int i = 0; i < n; ++i) {
                ((ScreenLayer3DGeometryChangedListener)vector.elementAt(i)).screenLayer3DGeometryChanged(event);
            }
        }
    }

    public synchronized void addScreenLayer3DTagChangedListener(ScreenLayer3DTagChangedListener l) {
        if (this.m_screenLayer3DTagChangedListeners == null) {
            this.m_screenLayer3DTagChangedListeners = new Vector();
        }
        if (this.m_screenLayer3DTagChangedListeners.contains(l)) {
            // empty if block
        }
        this.m_screenLayer3DTagChangedListeners.add(l);
    }

    public synchronized void removeScreenLayer3DTagChangedListener(ScreenLayer3DTagChangedListener l) {
        if (this.m_screenLayer3DTagChangedListeners != null && this.m_screenLayer3DTagChangedListeners.contains(l)) {
            this.m_screenLayer3DTagChangedListeners.remove(l);
        }
    }

    protected void fireScreenLayer3DTagChanged(ScreenLayer3DTagChangedEvent event) {
        if (this.m_screenLayer3DTagChangedListeners != null) {
            Vector vector = this.m_screenLayer3DTagChangedListeners;
            int n = this.m_screenLayer3DTagChangedListeners.size();
            for (int i = 0; i < n; ++i) {
                ((ScreenLayer3DTagChangedListener)vector.elementAt(i)).screenLayer3DTagChanged(event);
            }
        }
    }

    public synchronized void addScreenLayer3DSelectedIndexChangedListener(ScreenLayer3DSelectedIndexChangedListener l) {
        if (this.m_screenLayer3DSelectedIndexChangedListeners == null) {
            this.m_screenLayer3DSelectedIndexChangedListeners = new Vector();
        }
        if (this.m_screenLayer3DSelectedIndexChangedListeners.contains(l)) {
            // empty if block
        }
        this.m_screenLayer3DSelectedIndexChangedListeners.add(l);
    }

    public synchronized void removeScreenLayer3DSelectedIndexChangedListener(ScreenLayer3DSelectedIndexChangedListener l) {
        if (this.m_screenLayer3DSelectedIndexChangedListeners != null && this.m_screenLayer3DSelectedIndexChangedListeners.contains(l)) {
            this.m_screenLayer3DSelectedIndexChangedListeners.remove(l);
        }
    }

    protected void fireScreenLayer3DSelectedIndexChanged(ScreenLayer3DSelectedIndexChangedEvent event) {
        if (this.m_screenLayer3DSelectedIndexChangedListeners != null) {
            Vector vector = this.m_screenLayer3DSelectedIndexChangedListeners;
            int n = this.m_screenLayer3DSelectedIndexChangedListeners.size();
            for (int i = 0; i < n; ++i) {
                ((ScreenLayer3DSelectedIndexChangedListener)vector.elementAt(i)).screenLayer3DSelectedIndexChanged(event);
            }
        }
    }

    public synchronized void addScreenLayer3DVisibleChangedListeners(ScreenLayer3DVisibleChangedListener l) {
        if (this.m_screenLayer3DVisibleChangedListeners == null) {
            this.m_screenLayer3DVisibleChangedListeners = new Vector();
        }
        if (!this.m_screenLayer3DVisibleChangedListeners.contains(l)) {
            this.m_screenLayer3DVisibleChangedListeners.add(l);
        }
    }

    public synchronized void removeScreenLayer3DVisibleChangedListeners(ScreenLayer3DVisibleChangedListener l) {
        if (this.m_screenLayer3DVisibleChangedListeners != null && this.m_screenLayer3DVisibleChangedListeners.contains(l)) {
            this.m_screenLayer3DVisibleChangedListeners.remove(l);
        }
    }

    protected void fireScreenLayer3DVisibleChanged(ScreenLayer3DVisibleChangedEvent event) {
        if (this.m_screenLayer3DVisibleChangedListeners != null) {
            Vector vector = this.m_screenLayer3DVisibleChangedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ScreenLayer3DVisibleChangedListener)vector.elementAt(i)).visibleChanged(event);
            }
        }
    }

    public void setObjsVisibleInViewport(int[] objsVisible, boolean visible, short viewPortIndex) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setObjsVisibleInViewport()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        ScreenLayerNative.jni_SetObjsVisibleInViewport(this.getHandle(), objsVisible, visible, viewPortIndex);
    }

    public boolean getObjsVisibleInViewport(int objIndex, short viewPortIndex) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getObjsVisibleInViewport()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return ScreenLayerNative.jni_GetObjsVisibleInViewport(this.getHandle(), objIndex, viewPortIndex);
    }
}

