/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.GeoModel;
import com.supermap.data.GeoModel3D;
import com.supermap.realspace.DynamicObjectState;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DDynamicObjectNative;
import com.supermap.realspace.Layer3Ds;
import com.supermap.realspace.MotionType;
import java.util.ArrayList;

public class Layer3DDynamicObject
extends Layer3D {
    Layer3DDynamicObject(long handle, Layer3Ds layer3Ds) {
        super(handle, layer3Ds);
    }

    public void updateObject(String fileName, ArrayList<DynamicObjectState> objectStates) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[objectStates.size()];
        for (int i = 0; i < objectStates.size(); ++i) {
            lArray[i] = this.ConvertToUGDynamicObjectlState(objectStates.get(i));
        }
        Layer3DDynamicObjectNative.jni_UpdateObject(this.getHandle(), fileName, lArray);
    }

    public void updateObject(GeoModel geoModel, ArrayList<DynamicObjectState> objectStates) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geoModel == null) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[objectStates.size()];
        for (int i = 0; i < objectStates.size(); ++i) {
            lArray[i] = this.ConvertToUGDynamicObjectlState(objectStates.get(i));
        }
        Layer3DDynamicObjectNative.jni_UpdateObject(this.getHandle(), Layer3DDynamicObject.getHandle((com.supermap.data.InternalHandle)geoModel), lArray);
    }

    public void updateObject(String objectName, GeoModel3D geoModel3D, ArrayList<DynamicObjectState> objectStates) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geoModel3D == null) {
            String string = InternalResource.loadString("geoModel3D", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[objectStates.size()];
        for (int i = 0; i < objectStates.size(); ++i) {
            lArray[i] = this.ConvertToUGDynamicObjectlState(objectStates.get(i));
        }
        Layer3DDynamicObjectNative.jni_UpdateObject(this.getHandle(), objectName, InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel3D), lArray);
    }

    public void updateRibbon(String objectName, ArrayList<DynamicObjectState> objectStates) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[objectStates.size()];
        for (int i = 0; i < objectStates.size(); ++i) {
            lArray[i] = this.ConvertToUGDynamicObjectlState(objectStates.get(i));
        }
        Layer3DDynamicObjectNative.jni_UpdateRibbon(this.getHandle(), objectName, lArray);
    }

    public void removeObject(String objectName, int[] ids) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DDynamicObjectNative.jni_RemoveObject(this.getHandle(), objectName, ids);
    }

    public void removeAllObject(String objectName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DDynamicObjectNative.jni_RemoveObject(this.getHandle(), objectName);
    }

    public void setDirectionAlignTrack(String objectName, boolean bAlignTrack) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DDynamicObjectNative.jni_SetDirectionAlignTrack(this.getHandle(), objectName, bAlignTrack);
    }

    public boolean getDirectionAlignTrack(String objectName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DDynamicObjectNative.jni_GetDirectionAlignTrack(this.getHandle(), objectName);
    }

    public void setMotionType(String objectName, MotionType motionType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DDynamicObjectNative.jni_SetMotionType(this.getHandle(), objectName, motionType.value());
    }

    public MotionType getMotionType(String objectName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DDynamicObjectNative.jni_GetMotionType(this.getHandle(), objectName);
        return MotionType.parseUGCValue(n);
    }

    public float getUpdateInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DDynamicObjectNative.jni_GetUpdateInterval(this.getHandle());
    }

    public void setUpdateInterval(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DDynamicObjectNative.jni_SetUpdateInterval(this.getHandle(), value);
    }

    public boolean getBuildLOD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DDynamicObjectNative.jni_GetBuildLOD(this.getHandle());
    }

    public void setBuildLOD(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDynamicObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DDynamicObjectNative.jni_SetBuildLOD(this.getHandle(), value);
    }

    private long ConvertToUGDynamicObjectlState(DynamicObjectState objectState) {
        double[] dArray = new double[]{objectState.getScale().getX(), objectState.getScale().getY(), objectState.getScale().getZ()};
        double[] dArray2 = new double[]{objectState.getSelfRotAxis().getX(), objectState.getSelfRotAxis().getY(), objectState.getSelfRotAxis().getZ()};
        double[] dArray3 = new double[]{objectState.getOffset().getX(), objectState.getOffset().getY(), objectState.getOffset().getZ()};
        long l = Layer3DDynamicObjectNative.jni_ConvertToUGDynamicObjectlState(objectState.getID(), objectState.getLongitude(), objectState.getLatitude(), objectState.getAltitude(), dArray, objectState.getHeading(), objectState.getPitch(), dArray2, objectState.getRotationSpeed(), objectState.getObjectColor().getRGB(), objectState.getRibbonLength(), objectState.getRotationAngle(), dArray3);
        dArray = null;
        dArray2 = null;
        dArray3 = null;
        return l;
    }
}

