/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping.benchmark;

import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.data.WorkspaceConnectionInfo;
import com.supermap.data.WorkspaceType;
import com.supermap.mapping.Map;
import com.supermap.mapping.benchmark.DefaultRunner;
import com.supermap.mapping.benchmark.DynamicLayerRunner;
import com.supermap.mapping.benchmark.LogWriter;
import com.supermap.mapping.benchmark.RandomCenterRunner;
import com.supermap.mapping.benchmark.RunnerProperty;
import com.supermap.mapping.benchmark.SubprocessThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MapBenchmark {
    private static String mapName = "";
    private static final String output = "./output";
    private static Rectangle2D bounds = null;
    private static int tileSize = 256;
    static CountDownLatch finishedLatch;
    private static int timesPerThread;
    private static String format;

    private static void showHelp() {
        System.out.println("\u8bf7\u6307\u5b9a *.config\u6587\u4ef6\u4f4d\u7f6e\u4f5c\u4e3a\u552f\u4e00\u53c2\u6570. \u4ee5\u4e0b\u4e3aconfig\u6587\u4ef6\u7684\u793a\u4f8b:\r\n#workspacePath\u5de5\u4f5c\u7a7a\u95f4\u8def\u5f84\uff0c\u5fc5\u586b\u53c2\u6570\r\nworkspacePath=C:/test.smwu\r\n#timesPerThread\u6bcf\u4e2a\u6d4b\u8bd5\u7ebf\u7a0b\u7684\u6b21\u6570\uff0c\u9ed8\u8ba4\u4e3a50\u6b21\r\ntimesPerThread=50\r\n#threadArgs\u6d4b\u8bd5\u7684\u7ebf\u7a0b\u5e8f\u5217\uff0c\u6307\u5b9a\u5206\u522b\u6d4b\u8bd5\u7684\u7ebf\u7a0b\u6570\uff0c\u9ed8\u8ba4\u4e3a<1,4,8,16>\r\nthreadArgs=<1,4,8,16>\r\n#tileSize\u51fa\u56fe\u5927\u5c0f\uff0c\u9ed8\u8ba4\u4e3a256\r\ntileSize=256\r\n#mapName\u6253\u5f00\u7684\u5730\u56fe\u540d\u79f0\uff0c\u4e3a\u7a7a\u5219\u9ed8\u8ba4\u6253\u5f00\u5de5\u4f5c\u7a7a\u95f4\u7684\u7b2c\u4e00\u5e45\u5730\u56fe\r\nmapName=MAP\r\n#format\u51fa\u56fe\u683c\u5f0f\uff0c\u53ef\u9009\u4e3a[jpg,png,mem]\uff0c\u9ed8\u8ba4\u4e3apng. mem\u6307\u51fa\u56fe\u5230\u5185\u5b58\u4e0d\u5b58\u76d8\r\nformat=png [jpg,png,mem]\r\n#boundsArgs\u6307\u5b9a\u51fa\u56fe\u8303\u56f4\uff0c\u6307\u5b9a\u6709\u503c\u7684\u8303\u56f4\u907f\u514d\u65e0\u503c\u8303\u56f4\u592a\u591a\u5bfc\u81f4\u6027\u80fd\u5bf9\u6bd4\u65e0\u6548\uff0c[left,bottom,right,top]\uff0c\u4e3a\u7a7a\u5219\u4e3a\u5168\u5e45\u8303\u56f4\r\nboundsArgs=100,-100,200,100 \r\n#runner\u51fa\u56fe\u6d4b\u8bd5\u7684\u8fd0\u884c\u5668\uff0c\u53ef\u9009\u4e3a[defaultrunner(\u76f4\u63a5\u51fa\u56fe), dynamiclayerrunner(\u52a8\u6001\u5c42\u51fa\u56fe)\uff0c randomcenterrunner(\u968f\u673a\u4e2d\u5fc3\u70b9\u51fa\u56fe)]\uff0c\u9ed8\u8ba4\u4e3adefaultrunner\r\nrunner=defaultrunner \r\n#mode\u6027\u80fd\u6d4b\u8bd5\u7684\u6a21\u5f0f\uff0c\u7ebf\u7a0b\u6d4b\u8bd5\u8fd8\u662f\u8fdb\u7a0b\u6d4b\u8bd5\uff0c\u53ef\u9009\u4e3a[thread,process]\uff0c\u9ed8\u8ba4\u4e3athread\r\nmode=thread\n\n");
    }

    public static void main(String[] args) throws IOException {
        File file;
        Object object;
        Object object2;
        if (args == null || args.length < 1) {
            MapBenchmark.showHelp();
            return;
        }
        Properties properties = null;
        if (!args[0].endsWith(".config")) {
            MapBenchmark.showHelp();
            return;
        }
        properties = new Properties();
        Object object3 = new FileInputStream(args[0]);
        properties.load((InputStream)object3);
        ((FileInputStream)object3).close();
        object3 = new RunnerProperty();
        ((RunnerProperty)object3).setWorkspacePath(properties.getProperty("workspacePath"));
        ((RunnerProperty)object3).setTimesPerThread(properties.getProperty("timesPerThread"));
        ((RunnerProperty)object3).setThreadArgs(properties.getProperty("threadArgs"));
        ((RunnerProperty)object3).setTileSize(properties.getProperty("tileSize"));
        ((RunnerProperty)object3).setMapName(properties.getProperty("mapName"));
        ((RunnerProperty)object3).setFormat(properties.getProperty("format"));
        ((RunnerProperty)object3).setBoundsArgs(properties.getProperty("boundsArgs"));
        ((RunnerProperty)object3).setRunner(properties.getProperty("runner"));
        ((RunnerProperty)object3).setMode(properties.getProperty("mode"));
        String string = ((RunnerProperty)object3).getWorkspacePath();
        Workspace workspace = MapBenchmark.openWorkspace(string);
        String string2 = ((RunnerProperty)object3).getTimesPerThread();
        if (string2 != null && !string2.isEmpty()) {
            timesPerThread = Integer.valueOf(string2);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string3 = ((RunnerProperty)object3).getThreadArgs();
        if (string3 != null && !string3.isEmpty()) {
            object2 = string3.split(",");
            for (int i = 0; i < ((String[])object2).length; ++i) {
                arrayList.add(Integer.valueOf(object2[i].trim()));
            }
        } else {
            int n = Runtime.getRuntime().availableProcessors();
            do {
                arrayList.add(n);
                string3 = string3 + n + ",";
            } while ((n /= 2) != 0);
        }
        if ((object2 = ((RunnerProperty)object3).getTileSize()) != null && !((String)object2).isEmpty()) {
            tileSize = Integer.valueOf((String)object2);
        }
        String string4 = ((RunnerProperty)object3).getMapName();
        mapName = workspace.getMaps().get(0);
        if (string4 != null && !string4.isEmpty()) {
            mapName = string4;
        }
        format = ((RunnerProperty)object3).getFormat();
        Map map = new Map(workspace);
        map.open(mapName);
        map.outputMapToBitmap();
        bounds = map.getBounds();
        map.dispose();
        String string5 = ((RunnerProperty)object3).getBoundsArgs();
        if (string5 != null && !string5.isEmpty()) {
            double d;
            double d2;
            double d3;
            double d4;
            object = string5.split(",");
            if (((String[])object).length == 4) {
                d4 = Double.valueOf(object[0].trim());
                d3 = Double.valueOf(object[1].trim());
                d2 = Double.valueOf(object[2].trim());
                d = Double.valueOf(object[3].trim());
                bounds = new Rectangle2D(d4, d3, d2, d);
            } else if (((String[])object).length == 2) {
                d4 = Double.valueOf(object[0].trim());
                d3 = Double.valueOf(object[1].trim());
                d2 = d4;
                d = d3;
                bounds = new Rectangle2D(d4, d3, d2, d);
            }
        }
        object = "outputrunner";
        String string6 = ((RunnerProperty)object3).getRunner();
        if (string6 != null && !string6.isEmpty()) {
            object = string6.toLowerCase();
        }
        String string7 = "thread";
        String string8 = ((RunnerProperty)object3).getMode();
        if (string8 != null && !string8.isEmpty()) {
            string7 = string8;
        }
        if (arrayList.size() > 1) {
            System.out.println(String.format("run args workspace %s; thread %s; timesPerThread %d; tileSize %d; mapName %s; imageType %s; bounds %s; runner %s; mode %s", string, string3, timesPerThread, tileSize, mapName, format, string5, object, string7));
        }
        if (!(file = new File(output)).exists()) {
            file.mkdir();
        }
        LogWriter.setWriteToFile(true);
        if (string7.equals("thread")) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                MapBenchmark.runThread(n, workspace, (String)object);
            }
        } else if (string7.equals("process")) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                List<String> list = runtimeMXBean.getInputArguments();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add("java");
                arrayList2.addAll(list);
                arrayList2.add("-cp");
                arrayList2.add(System.getProperty("java.class.path"));
                arrayList2.add(MapBenchmark.class.getName());
                arrayList2.add(string);
                arrayList2.add(String.valueOf(timesPerThread));
                arrayList2.add("1");
                arrayList2.add(String.valueOf(tileSize));
                arrayList2.add(mapName);
                arrayList2.add(format);
                arrayList2.add(string5);
                arrayList2.add((String)object);
                arrayList2.add("thread");
                MapBenchmark.runProcess(arrayList2, n);
            }
        }
        System.exit(0);
    }

    public static void runProcess(ArrayList<String> args, int threadCount) {
        ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
        finishedLatch = new CountDownLatch(threadCount);
        ArrayList<SubprocessThread> arrayList = new ArrayList<SubprocessThread>();
        for (int i = 0; i < threadCount; ++i) {
            arrayList.add(new SubprocessThread(args, finishedLatch));
            executorService.submit((Runnable)arrayList.get(i));
        }
        try {
            finishedLatch.await();
            SubprocessThread cfr_ignored_0 = (SubprocessThread)arrayList.get(0);
            double d = SubprocessThread.cost;
            for (int i = 1; i < arrayList.size(); ++i) {
                SubprocessThread cfr_ignored_1 = (SubprocessThread)arrayList.get(i);
                double d2 = SubprocessThread.cost;
                if (!(d2 > d)) continue;
                d = d2;
            }
            System.out.println(String.format("process count %d output map avg cost %f", threadCount, d));
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static void runThread(int threadCount, Workspace workspace, String runner) {
        ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
        finishedLatch = new CountDownLatch(threadCount);
        ArrayList<DefaultRunner> arrayList = new ArrayList<DefaultRunner>();
        for (int i = 0; i < threadCount; ++i) {
            if (runner.equals("defaultrunner")) {
                arrayList.add(new DefaultRunner(workspace, mapName, timesPerThread, bounds, "thread" + i, format, tileSize, finishedLatch));
                continue;
            }
            if (runner.equals("dynamiclayerrunner")) {
                arrayList.add(new DynamicLayerRunner(workspace, mapName, timesPerThread, bounds, "thread" + i, format, tileSize, finishedLatch));
                continue;
            }
            if (!runner.equals("randomcenterrunner")) continue;
            arrayList.add(new RandomCenterRunner(workspace, mapName, timesPerThread, bounds, "thread" + i, format, tileSize, finishedLatch));
        }
        long l = System.currentTimeMillis();
        for (DefaultRunner defaultRunner : arrayList) {
            executorService.submit(defaultRunner);
        }
        try {
            finishedLatch.await();
            double d = (double)System.currentTimeMillis() - (double)l;
            double d2 = d / (double)timesPerThread;
            System.out.println(String.format("thread count %d output map avg cost %f", threadCount, d2));
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private static Workspace openWorkspace(String server) {
        Workspace workspace = new Workspace();
        WorkspaceConnectionInfo workspaceConnectionInfo = new WorkspaceConnectionInfo();
        workspaceConnectionInfo.setServer(server);
        String string = server.substring(server.lastIndexOf(".") + 1).toUpperCase();
        WorkspaceType workspaceType = (WorkspaceType)WorkspaceType.parse(WorkspaceType.class, (String)string);
        workspaceConnectionInfo.setType(workspaceType);
        if (!workspace.open(workspaceConnectionInfo)) {
            throw new IllegalArgumentException();
        }
        return workspace;
    }

    static {
        timesPerThread = 50;
        format = "png";
    }
}

