/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorGradientType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Enum;
import com.supermap.data.GeoStyle;
import com.supermap.data.JoinItems;
import com.supermap.data.Toolkit;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.RangeMode;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeRangeItem;
import com.supermap.mapping.ThemeRangeNative;
import java.util.ArrayList;

public class ThemeRange
extends Theme {
    private ArrayList m_rangeItems = null;
    private RangeMode m_rangeMode;

    public ThemeRange() {
        long l = ThemeRangeNative.jni_New();
        this.setHandle(l, true);
        this.setRangeExpression("");
        this.m_rangeItems = new ArrayList();
        this.m_rangeMode = RangeMode.NONE;
    }

    public ThemeRange(ThemeRange themeRange) {
        if (themeRange == null) {
            String string = InternalResource.loadString("themeRange", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeRange.getHandle() == 0L) {
            String string = InternalResource.loadString("themeRange", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeRangeNative.jni_Clone(themeRange.getHandle());
        this.setHandle(l, true);
        this.m_rangeItems = new ArrayList();
        int n = themeRange.getRangeItemsList().size();
        for (int i = 0; i < n; ++i) {
            ThemeRangeItem themeRangeItem = new ThemeRangeItem(this);
            this.m_rangeItems.add(themeRangeItem);
        }
        this.m_rangeMode = themeRange.getRangeMode();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeRange));
    }

    ThemeRange(long handle, boolean disposable) {
        int n;
        this.setHandle(handle, disposable);
        int n2 = ThemeRangeNative.jni_GetValueCount(this.getHandle());
        this.m_rangeItems = new ArrayList();
        int n3 = n2 - 1;
        for (n = 0; n < n3; ++n) {
            ThemeRangeItem themeRangeItem = new ThemeRangeItem(this);
            this.m_rangeItems.add(themeRangeItem);
        }
        n = ThemeRangeNative.jni_GetRangeMethod(this.getHandle());
        this.m_rangeMode = (RangeMode)RangeMode.parse(RangeMode.class, (int)n);
    }

    public ThemeRangeItem getItem(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return (ThemeRangeItem)this.m_rangeItems.get(index);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeRangeNative.jni_GetCount(this.getHandle());
        int n2 = 0;
        n2 = n == 0 || n == 1 ? 0 : n - 1;
        return n2;
    }

    public String getRangeExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRangeNative.jni_GetRangeExpression(this.getHandle());
    }

    public void setRangeExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRangeExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        this.m_lock.lock();
        ThemeRangeNative.jni_SetRangeExpression(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public boolean addToHead(ThemeRangeItem item) {
        return this.addToHead(item, false);
    }

    public boolean addToTail(ThemeRangeItem item) {
        return this.addToTail(item, false);
    }

    public boolean addToHead(ThemeRangeItem item, boolean normalize) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToHead(ThemeRangeItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("addToHead(ThemeRangeItem item, boolean normalize) ", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string);
        }
        if (item.getStart() >= item.getEnd()) {
            if (normalize) {
                if (Toolkit.isZero((double)(item.getStart() - item.getEnd()))) {
                    return false;
                }
                Double d = item.getStart();
                item.setStart(item.getEnd());
                item.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeRange_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeRangeNative.jni_GetValueAt(this.getHandle(), 0);
            double d3 = ThemeRangeNative.jni_FormatThemeRangeValue(this.getHandle(), item.getEnd());
            double d4 = d3 - d2;
            boolean bl = Toolkit.isZero((double)d4);
            if (!bl) {
                if (normalize) {
                    item.setEnd(d2);
                } else {
                    String string = InternalResource.loadString("item.getEnd()", "ThemeRange_InvalidEndOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl = Toolkit.isZero((double)(d4 = (d = ThemeRangeNative.jni_FormatThemeRangeValue(this.getHandle(), item.getStart())) - d2))) || d > d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeRangeItem themeRangeItem = new ThemeRangeItem(item);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeRangeItem.getStyle());
        boolean bl = ThemeRangeNative.jni_AddToHead(this.getHandle(), themeRangeItem.getCaption(), themeRangeItem.isVisible(), l, themeRangeItem.getStart(), themeRangeItem.getEnd());
        if (bl) {
            ThemeRangeItem themeRangeItem2 = new ThemeRangeItem(this);
            this.m_rangeItems.add(0, themeRangeItem2);
            this.refreshRangeItemStyle();
        }
        this.m_lock.unlock();
        return bl;
    }

    public boolean addToTail(ThemeRangeItem item, boolean normalize) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToTail(ThemeRangeItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("addToHead(ThemeRangeItem item, boolean normalize) ", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string);
        }
        if (item.getStart() >= item.getEnd()) {
            if (normalize) {
                if (Toolkit.isZero((double)(item.getStart() - item.getEnd()))) {
                    return false;
                }
                Double d = item.getStart();
                item.setStart(item.getEnd());
                item.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeRange_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeRangeNative.jni_GetValueAt(this.getHandle(), n);
            double d3 = ThemeRangeNative.jni_FormatThemeRangeValue(this.getHandle(), item.getStart());
            double d4 = d3 - d2;
            boolean bl = Toolkit.isZero((double)d4);
            if (!bl) {
                if (normalize) {
                    item.setStart(d2);
                } else {
                    String string = InternalResource.loadString("item.getStart()", "ThemeRange_InavlidStartOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl = Toolkit.isZero((double)(d4 = d2 - (d = ThemeRangeNative.jni_FormatThemeRangeValue(this.getHandle(), item.getEnd()))))) || d < d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeRangeItem themeRangeItem = new ThemeRangeItem(item);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeRangeItem.getStyle());
        boolean bl = ThemeRangeNative.jni_AddToTail(this.getHandle(), themeRangeItem.getCaption(), themeRangeItem.isVisible(), l, themeRangeItem.getStart(), themeRangeItem.getEnd());
        if (bl) {
            ThemeRangeItem themeRangeItem2 = new ThemeRangeItem(this);
            this.m_rangeItems.add(themeRangeItem2);
            this.refreshRangeItemStyle();
        }
        this.m_lock.unlock();
        return bl;
    }

    public boolean split(int index, double splitValue, GeoStyle style1, String caption1, GeoStyle style2, String caption2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (style1 == null) {
            String string = InternalResource.loadString("style1", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style1);
        if (l == 0L) {
            String string = InternalResource.loadString("style1", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (style2 == null) {
            String string = InternalResource.loadString("style2", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style2);
        if (l2 == 0L) {
            String string = InternalResource.loadString("style2", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        double d = ThemeRangeNative.jni_GetValueAt(this.getHandle(), index);
        double d2 = ThemeRangeNative.jni_GetValueAt(this.getHandle(), index + 1);
        if (splitValue <= d || splitValue >= d2) {
            String string = InternalResource.loadString("splitValue", "ThemeRange_InvalidSplitValue", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = style1.clone();
        GeoStyle geoStyle2 = style2.clone();
        long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        long l4 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle2);
        if (caption1 == null || caption1.trim().length() == 0) {
            String string = InternalResource.loadString("caption1", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption2 == null || caption2.trim().length() == 0) {
            String string = InternalResource.loadString("caption2", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = ThemeRangeNative.jni_Split(this.getHandle(), index, splitValue, l3, caption1, l4, caption2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle2);
        if (bl) {
            ThemeRangeItem themeRangeItem = new ThemeRangeItem(this);
            this.m_rangeItems.add(index + 1, themeRangeItem);
            this.refreshRangeItemStyle();
        }
        this.m_lock.unlock();
        return bl;
    }

    public boolean merge(int index, int count, GeoStyle style, String caption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("merge(int index, int count, GeoStyle style, String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (index + count < index || index + count > n) {
            String string = InternalResource.loadString("count", "ThemeRange_TheCountIsInvalid", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (count == 0) {
            return true;
        }
        GeoStyle geoStyle = style.clone();
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = ThemeRangeNative.jni_Merge(this.getHandle(), index, count, l2, caption);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
        if (bl) {
            ThemeRangeItem themeRangeItem = (ThemeRangeItem)this.m_rangeItems.get(index);
            double d = ThemeRangeNative.jni_GetValueAt(this.getHandle(), index + 1);
            themeRangeItem.setEnd(d);
            themeRangeItem.setCaption(caption);
            themeRangeItem.setStyle(style.clone());
            for (int i = 0; i < count - 1; ++i) {
                ThemeRangeItem themeRangeItem2 = (ThemeRangeItem)this.m_rangeItems.get(index + 1);
                themeRangeItem2.clearHandle();
                this.m_rangeItems.remove(index + 1);
            }
            this.refreshRangeItemStyle();
        }
        this.m_lock.unlock();
        return bl;
    }

    public static ThemeRange makeDefault(DatasetVector dataset, String rangeExpression, RangeMode rangeMode, double rangeParameter) {
        return ThemeRange.makeDefault(dataset, rangeExpression, rangeMode, rangeParameter, null, null);
    }

    public static ThemeRange makeDefault(DatasetVector dataset, String rangeExpression, RangeMode rangeMode, double rangeParameter, ColorGradientType colorGradientType) {
        return ThemeRange.makeDefault(dataset, rangeExpression, rangeMode, rangeParameter, colorGradientType, null);
    }

    public static ThemeRange makeDefault(DatasetVector dataset, String rangeExpression, RangeMode rangeMode, double rangeParameter, ColorGradientType colorGradientType, JoinItems joinItems) {
        return ThemeRange.makeDefault(dataset, rangeExpression, rangeMode, rangeParameter, colorGradientType, joinItems, 0.1);
    }

    public static ThemeRange makeDefault(DatasetVector dataset, String rangeExpression, RangeMode rangeMode, double rangeParameter, ColorGradientType colorGradientType, JoinItems joinItems, double precision) {
        int n;
        int n2;
        long l;
        long l2;
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l3 == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeExpression == null || rangeExpression.trim().length() == 0) {
            String string = InternalResource.loadString("rangeExpression", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (joinItems == null) {
            joinItems = new JoinItems();
        }
        if ((l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)joinItems)) == 0L) {
            String string = InternalResource.loadString("joinItems", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeMode == null) {
            String string = InternalResource.loadString("rangeMode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if ((rangeMode.equals((Object)RangeMode.EQUALINTERVAL) || rangeMode.equals((Object)RangeMode.SQUAREROOT) || rangeMode.equals((Object)RangeMode.LOGARITHM) || rangeMode.equals((Object)RangeMode.QUANTILE)) && rangeParameter < 1.0) {
            String string = InternalResource.loadString("rangeParameter", "ThemeRange_TheArgumentOfRangeParameterShouldNotBeLessThanOneRange", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeMode.equals((Object)RangeMode.CUSTOMINTERVAL) && rangeParameter < 0.0) {
            String string = InternalResource.loadString("rangeParameter", "ThemeRange_TheArgumentOfRangeParameterShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.YELLOWRED;
        }
        if ((l = ThemeRangeNative.jni_MakeDefault(l3, rangeExpression, l2, n2 = InternalEnum.getUGCValue(rangeMode), rangeParameter, n = InternalEnum.getUGCValue((Enum)colorGradientType), precision)) == 0L) {
            return null;
        }
        ThemeRange themeRange = new ThemeRange(l, true);
        themeRange.setRangeMode(rangeMode);
        return themeRange;
    }

    public double getPrecision() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrecision()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRangeNative.jni_GetPrecision(this.getHandle());
    }

    public void setPrecision(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrecision(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeRangeNative.jni_SetPrecision(this.getHandle(), value);
    }

    public int indexOf(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeRangeNative.jni_GetValueCount(this.getHandle());
        double[] dArray = new double[n];
        ThemeRangeNative.jni_GetValues(this.getHandle(), dArray);
        for (int i = 0; i < n - 1; ++i) {
            if (!(dArray[i] <= value) || !(value < dArray[i + 1])) continue;
            return i;
        }
        return -1;
    }

    public void reverseStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeRangeNative.jni_ReverseStyle(this.getHandle());
        this.m_lock.unlock();
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeRangeNative.jni_Clear(this.getHandle());
        if (this.m_rangeItems != null) {
            int n = this.m_rangeItems.size();
            for (int i = 0; i < n; ++i) {
                ThemeRangeItem themeRangeItem = (ThemeRangeItem)this.m_rangeItems.get(i);
                themeRangeItem.clearHandle();
            }
            this.m_rangeItems.clear();
        }
        this.m_lock.unlock();
    }

    @Override
    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count = ");
        stringBuffer.append(n);
        stringBuffer.append(",RangeExpression = ");
        stringBuffer.append(this.getRangeExpression());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    @Override
    public boolean fromXML(String xml) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = super.fromXML(xml);
            if (bl) {
                this.refreshRangeItemsList();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeRangeNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        if (this.m_rangeItems != null) {
            this.clearRangeItemsList();
            this.m_rangeItems = null;
        }
        this.setHandle(0L);
    }

    void changeHandle(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeRangeNative.jni_Delete(this.getHandle());
        }
        this.setHandle(handle, false);
        this.refreshRangeItemsList();
    }

    public RangeMode getRangeMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_rangeMode;
    }

    ArrayList getRangeItemsList() {
        return this.m_rangeItems;
    }

    private void clearRangeItemsList() {
        int n = this.m_rangeItems.size();
        for (int i = 0; i < n; ++i) {
            ThemeRangeItem themeRangeItem = (ThemeRangeItem)this.m_rangeItems.get(i);
            themeRangeItem.clearHandle();
        }
        this.m_rangeItems.clear();
    }

    private void refreshRangeItemsList() {
        if (this.m_rangeItems != null) {
            this.clearRangeItemsList();
        }
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeRangeItem themeRangeItem = new ThemeRangeItem(this);
            this.m_rangeItems.add(themeRangeItem);
        }
    }

    private void refreshRangeItemStyle() {
        int n = this.getCount();
        long[] lArray = new long[n];
        ThemeRangeNative.jni_GetStylesHandle(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            ThemeRangeItem themeRangeItem = this.getItem(i);
            themeRangeItem.refreshStyle(lArray[i]);
        }
    }

    private void setRangeMode(RangeMode rangeMode) {
        this.m_rangeMode = rangeMode;
    }

    public String getOffsetX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetX()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRangeNative.jni_GetOffsetX(this.getHandle());
    }

    public void setOffsetX(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetX(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        ThemeRangeNative.jni_SetOffsetX(this.getHandle(), value);
    }

    public String getOffsetY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetY()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRangeNative.jni_GetOffsetY(this.getHandle());
    }

    public void setOffsetY(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetY(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        ThemeRangeNative.jni_SetOffsetY(this.getHandle(), value);
    }

    public boolean isOffsetFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOffsetFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRangeNative.jni_GetOffsetFixed(this.getHandle());
    }

    public void setOffsetFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeRangeNative.jni_SetOffsetFixed(this.getHandle(), value);
    }

    public double getCustomInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCustomInterval()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRangeNative.jni_GetCustomInterval(this.getHandle());
    }
}

