/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Dataset;
import com.supermap.data.GeoStyle;
import com.supermap.data.TextAlignment;
import com.supermap.data.TextStyle;
import com.supermap.mapping.GraduatedMode;
import com.supermap.mapping.GraphAxesTextDisplayMode;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalTextStyle;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeGraphItem;
import com.supermap.mapping.ThemeGraphNative;
import com.supermap.mapping.ThemeGraphTextFormat;
import com.supermap.mapping.ThemeGraphType;
import java.awt.Color;
import java.util.ArrayList;

public class ThemeGraph
extends Theme {
    private ArrayList m_graphItems = null;
    private GeoStyle m_leaderLineStyle = null;
    private TextStyle m_axesTextStyle = null;
    private TextStyle m_graphTextStyle = null;

    public ThemeGraph() {
        long l = ThemeGraphNative.jni_New();
        this.setHandle(l, true);
        this.m_graphItems = new ArrayList();
    }

    public ThemeGraph(ThemeGraph themeGraph) {
        if (themeGraph == null) {
            String string = InternalResource.loadString("themeGraph", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGraph.getHandle() == 0L) {
            String string = InternalResource.loadString("themeGraph", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeGraphNative.jni_Clone(themeGraph.getHandle());
        this.setHandle(l, true);
        this.m_graphItems = new ArrayList();
        int n = themeGraph.getGraphItemsList().size();
        long[] lArray = new long[n];
        ThemeGraphNative.jni_GetItemHandles(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            long l2 = lArray[i];
            ThemeGraphItem themeGraphItem = new ThemeGraphItem(l2, this);
            this.m_graphItems.add(themeGraphItem);
        }
    }

    ThemeGraph(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
        this.m_graphItems = new ArrayList();
        int n = this.getCount();
        long[] lArray = new long[n];
        ThemeGraphNative.jni_GetItemHandles(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            ThemeGraphItem themeGraphItem = new ThemeGraphItem(l, this);
            this.m_graphItems.add(themeGraphItem);
        }
    }

    public ThemeGraphItem getItem(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return (ThemeGraphItem)((Object)this.m_graphItems.get(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItem(int index, ThemeGraphItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setItem(int index, ThemeGraphItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (item.getMemoryDoubleValues().length != this.getMemoryKeys().length) {
            String string = InternalResource.loadString("item", "ThemeGraph_TheLengthOfMemoryDoubleValuesShouldBeEqualsWithTheLengthOfMemoryKeys", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        try {
            this.m_lock.lock();
            ThemeGraphItem themeGraphItem = new ThemeGraphItem(item);
            long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)themeGraphItem);
            ThemeGraphNative.jni_SetItem(this.getHandle(), index, l);
            long l2 = ThemeGraphNative.jni_GetItem(this.getHandle(), index);
            ThemeGraphItem themeGraphItem2 = new ThemeGraphItem(l2, this);
            this.m_graphItems.set(index, themeGraphItem2);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeGraphItem));
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetCount(this.getHandle());
    }

    public boolean isGraphSizeFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsGraphSizeFixed(this.getHandle());
    }

    public void setGraphSizeFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetIsGraphSizeFixed(this.getHandle(), value);
    }

    public String getOffsetX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetOffsetX(this.getHandle());
    }

    public void setOffsetX(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        ThemeGraphNative.jni_SetOffsetX(this.getHandle(), value);
    }

    public String getOffsetY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetOffsetY(this.getHandle());
    }

    public void setOffsetY(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        ThemeGraphNative.jni_SetOffsetY(this.getHandle(), value);
    }

    public ThemeGraphType getGraphType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGraphNative.jni_GetGraphType(this.getHandle());
        return (ThemeGraphType)InternalEnum.parseUGCValue(ThemeGraphType.class, n);
    }

    public void setGraphType(ThemeGraphType themeGraphType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (themeGraphType == null) {
            String string = InternalResource.loadString("themeGraphType", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        int n = InternalEnum.getUGCValue(themeGraphType);
        ThemeGraphNative.jni_SetGraphType(this.getHandle(), n);
        this.calculateExtremum();
        this.m_lock.unlock();
    }

    @Deprecated
    public double getBarWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetBarWidth(this.getHandle());
    }

    @Deprecated
    public void setBarWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "ThemeGraph_TheArgumentOfBarWidthShoudBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetBarWidth(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public double getBarWidthRatio() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetBarWidthRatio(this.getHandle());
    }

    public void setBarWidthRatio(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "ThemeGraph_TheArgumentOfBarRatioShoudBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (value > 10.0) {
            String string = InternalResource.loadString("value", "ThemeGraph_TheArgumentOfBarRatioShoudLessThanMaxValue", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetBarWidthRatio(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public double getBarSpaceRatio() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetBarSpaceRatio(this.getHandle());
    }

    public void setBarSpaceRatio(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "ThemeGraph_TheArgumentOfBarRatioShoudBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (value > 10.0) {
            String string = InternalResource.loadString("value", "ThemeGraph_TheArgumentOfBarRatioShoudLessThanMaxValue", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetBarSpaceRatio(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public double getStartAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetStartAngle(this.getHandle());
    }

    public void setStartAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetStartAngle(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public double getRoseAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetRoseAngle(this.getHandle());
    }

    public void setRoseAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "ThemeGraph_RoseAngleShoudNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetRoseAngle(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public boolean isFlowEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsFlowEnabled(this.getHandle());
    }

    public void setFlowEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetIsFlowEnabled(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public GeoStyle getLeaderLineStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_leaderLineStyle == null && (l = ThemeGraphNative.jni_GetLeaderLineStyle(this.getHandle())) != 0L) {
            this.m_leaderLineStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_leaderLineStyle;
    }

    public void setLeaderLineStyle(GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLeaderLineStyle(GeoStyle style)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        GeoStyle geoStyle = style.clone();
        long l2 = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geoStyle);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
        ThemeGraphNative.jni_SetLeaderLineStyle(this.getHandle(), l2);
        this.m_lock.unlock();
    }

    public boolean isLeaderLineDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsLeaderLineDisplayed(this.getHandle());
    }

    public void setLeaderLineDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetIsLeaderLineDisplayed(this.getHandle(), value);
    }

    public boolean isNegativeDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsNegativeDisplayed(this.getHandle());
    }

    public void setNegativeDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetIsNegativeDisplayed(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public Color getAxesColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGraphNative.jni_GetAxesColor(this.getHandle());
        return new Color(n, true);
    }

    public void setAxesColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetAxesColor(this.getHandle(), color.getRGB());
    }

    public boolean isAxesDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsAxesDisplayed(this.getHandle());
    }

    public void setAxesDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetIsAxesDisplayed(this.getHandle(), value);
    }

    public TextStyle getAxesTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_axesTextStyle == null && (l = ThemeGraphNative.jni_GetAxesTextStyle(this.getHandle())) != 0L) {
            this.m_axesTextStyle = InternalTextStyle.createInstance(l);
            this.m_axesTextStyle.setSizeFixed(true);
            this.m_axesTextStyle.setAlignment(TextAlignment.BOTTOMRIGHT);
        }
        return this.m_axesTextStyle;
    }

    public void setAxesTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)textStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle2 = textStyle.clone();
        textStyle2.setAlignment(TextAlignment.BOTTOMRIGHT);
        long l2 = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)textStyle2);
        ThemeGraphNative.jni_SetAxesTextStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle2);
    }

    public boolean isAxesTextDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_IsShowYAxesText(this.getHandle()) || ThemeGraphNative.jni_IsShowXAxesText(this.getHandle());
    }

    public void setAxesTextDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = value;
        boolean bl2 = value;
        if (value && this.getAxesTextDisplayMode().equals((Object)GraphAxesTextDisplayMode.YAXES)) {
            bl = false;
            bl2 = true;
        }
        ThemeGraphNative.jni_SetShowYAxesText(this.getHandle(), bl2);
        ThemeGraphNative.jni_SetShowXAxesText(this.getHandle(), bl);
    }

    public boolean isAxesGridDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsAxesGridDisplayed(this.getHandle());
    }

    public void setAxesGridDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetIsAxesGridDisplayed(this.getHandle(), value);
    }

    public TextStyle getGraphTextStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_graphTextStyle == null && (l = ThemeGraphNative.jni_GetGraphTextStyle(this.getHandle())) != 0L) {
            this.m_graphTextStyle = InternalTextStyle.createInstance(l);
        }
        return this.m_graphTextStyle;
    }

    public void setGraphTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle == null) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)textStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("textStyle", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle2 = textStyle.clone();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle2);
        ThemeGraphNative.jni_SetGraphTextStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle2);
    }

    public ThemeGraphTextFormat getGraphTextFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGraphNative.jni_GetGraphTextFormat(this.getHandle());
        return (ThemeGraphTextFormat)InternalEnum.parseUGCValue(ThemeGraphTextFormat.class, n);
    }

    public void setGraphTextFormat(ThemeGraphTextFormat themeGraphTextFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (themeGraphTextFormat == null) {
            String string = InternalResource.loadString("themeGraphTextFormat", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(themeGraphTextFormat);
        ThemeGraphNative.jni_SetGraphTextFormat(this.getHandle(), n);
    }

    public boolean isGraphTextDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetIsGraphTextDisplayed(this.getHandle());
    }

    public void setGraphTextDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetIsGraphTextDisplayed(this.getHandle(), value);
    }

    public boolean isOffsetFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsOffsetFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_isOffsetFixed(this.getHandle());
    }

    public void setOffsetFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetOffsetFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_setOffsetFixed(this.getHandle(), value);
    }

    public double getMinGraphSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetMinGraphSize(this.getHandle());
    }

    public void setMinGraphSize(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "ThemeGraph_TheArgumentOfMinGraphSizeShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeGraphNative.jni_SetMinGraphSize(this.getHandle(), value);
    }

    public double getMaxGraphSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetMaxGraphSize(this.getHandle());
    }

    public void setMaxGraphSize(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "ThemeGraph_TheArgumentOfMaxGraphSizeShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeGraphNative.jni_SetMaxGraphSize(this.getHandle(), value);
    }

    public String getCustomGraphSizeExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetCustomGraphSizeExpression(this.getHandle());
    }

    public void setCustomGraphSizeExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeGraphNative.jni_SetCustomGraphSizeExpression(this.getHandle(), value);
    }

    public GraduatedMode getGraduatedMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGraphNative.jni_GetGraduatedMode(this.getHandle());
        return (GraduatedMode)InternalEnum.parseUGCValue(GraduatedMode.class, n);
    }

    public void setGraduatedMode(GraduatedMode value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        int n = InternalEnum.getUGCValue(value);
        ThemeGraphNative.jni_SetGraduateMode(this.getHandle(), n);
        this.m_lock.unlock();
    }

    public boolean isOverlapAvoided() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOverlapAvoided()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetOverlapAvoided(this.getHandle());
    }

    public void setOverlapAvoided(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapAvoided(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetOverlapAvoided(this.getHandle(), value);
    }

    public int[] getMemoryKeys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMemoryKeys()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_GetMemoryKeys(this.getHandle());
    }

    public void setMemoryKeys(int[] keys) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMemoryKeys(int[] keys)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetMemoryKeys(this.getHandle(), keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(ThemeGraphItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (item.getMemoryDoubleValues().length != this.getMemoryKeys().length) {
            String string = InternalResource.loadString("item", "ThemeGraph_TheLengthOfMemoryDoubleValuesShouldBeEqualsWithTheLengthOfMemoryKeys", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        try {
            this.m_lock.lock();
            ThemeGraphItem themeGraphItem = new ThemeGraphItem(item);
            long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)themeGraphItem);
            n = ThemeGraphNative.jni_Add(this.getHandle(), l);
            if (n != -1) {
                long l2 = ThemeGraphNative.jni_GetItem(this.getHandle(), n);
                ThemeGraphItem themeGraphItem2 = new ThemeGraphItem(l2, this);
                this.m_graphItems.add(themeGraphItem2);
                this.refreshGraphItemAndStyle();
                this.calculateExtremum();
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeGraphItem));
        }
        finally {
            this.m_lock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(int index, ThemeGraphItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index > n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (item.getMemoryDoubleValues().length != this.getMemoryKeys().length) {
            String string = InternalResource.loadString("item", "ThemeGraph_TheLengthOfMemoryDoubleValuesShouldBeEqualsWithTheLengthOfMemoryKeys", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        try {
            this.m_lock.lock();
            ThemeGraphItem themeGraphItem = new ThemeGraphItem(item);
            long l = com.supermap.data.InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)themeGraphItem);
            bl = false;
            if (index == n) {
                int n2 = ThemeGraphNative.jni_Add(this.getHandle(), l);
                if (n2 == n) {
                    bl = true;
                    long l2 = ThemeGraphNative.jni_GetItem(this.getHandle(), index);
                    ThemeGraphItem themeGraphItem2 = new ThemeGraphItem(l2, this);
                    this.m_graphItems.add(themeGraphItem2);
                    this.refreshGraphItemAndStyle();
                    this.calculateExtremum();
                }
            } else {
                int n3 = ThemeGraphNative.jni_Insert(this.getHandle(), index, l);
                if (n3 == index) {
                    bl = true;
                    long l3 = ThemeGraphNative.jni_GetItem(this.getHandle(), index);
                    ThemeGraphItem themeGraphItem3 = new ThemeGraphItem(l3, this);
                    this.m_graphItems.add(index, themeGraphItem3);
                    this.refreshGraphItemAndStyle();
                    this.calculateExtremum();
                }
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeGraphItem));
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exchangeItem(int index1, int index2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index1 < 0 || index1 >= n) {
            String string = InternalResource.loadString("index1", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (index2 < 0 || index2 >= n) {
            String string = InternalResource.loadString("index2", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = ThemeGraphNative.jni_ExchangeItem(this.getHandle(), index1, index2);
            if (bl) {
                ThemeGraphItem themeGraphItem = (ThemeGraphItem)((Object)this.m_graphItems.get(index1));
                ThemeGraphItem themeGraphItem2 = (ThemeGraphItem)((Object)this.m_graphItems.get(index2));
                long l = ThemeGraphNative.jni_GetItem(this.getHandle(), index1);
                ThemeGraphItem themeGraphItem3 = new ThemeGraphItem(l, this);
                this.m_graphItems.set(index1, themeGraphItem3);
                long l2 = ThemeGraphNative.jni_GetItem(this.getHandle(), index2);
                ThemeGraphItem themeGraphItem4 = new ThemeGraphItem(l2, this);
                this.m_graphItems.set(index2, themeGraphItem4);
                themeGraphItem.clearHandle();
                themeGraphItem2.clearHandle();
                this.calculateExtremum();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public int indexOf(String graphExpression) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (graphExpression != null && graphExpression.trim().length() != 0) {
            n = ThemeGraphNative.jni_IndexOf(this.getHandle(), graphExpression);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = ThemeGraphNative.jni_RemoveAt(this.getHandle(), index);
            if (bl) {
                ThemeGraphItem themeGraphItem = (ThemeGraphItem)((Object)this.m_graphItems.get(index));
                themeGraphItem.clearHandle();
                this.m_graphItems.remove(index);
                this.refreshGraphItemAndStyle();
                this.calculateExtremum();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        try {
            this.m_lock.lock();
            ThemeGraphNative.jni_Clear(this.getHandle());
            if (this.m_graphItems != null) {
                this.clearGraphItemsList();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        this.calculateExtremum();
    }

    @Override
    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{AxesColor = {");
        stringBuffer.append(this.getAxesColor().toString());
        stringBuffer.append("},AxesTextStyle = ");
        stringBuffer.append(this.getAxesTextStyle().toString());
        stringBuffer.append(",BarWidth = ");
        stringBuffer.append(this.getBarWidth());
        stringBuffer.append(",Count = ");
        stringBuffer.append(this.getCount());
        stringBuffer.append(",GraduatedMode = ");
        stringBuffer.append((Object)this.getGraduatedMode());
        stringBuffer.append(",GraphTextFormat = ");
        stringBuffer.append(this.getGraphTextFormat().name());
        stringBuffer.append(",GraphType = ");
        stringBuffer.append((Object)this.getGraphType());
        stringBuffer.append(",IsAxesDisplayed = ");
        stringBuffer.append(this.isAxesDisplayed());
        stringBuffer.append(",IsAxesGridDisplayed = ");
        stringBuffer.append(this.isAxesGridDisplayed());
        stringBuffer.append(",IsAxesTextDisplayed = ");
        stringBuffer.append(this.isAxesTextDisplayed());
        stringBuffer.append(",IsFlowEnabled = ");
        stringBuffer.append(this.isFlowEnabled());
        stringBuffer.append(",IsGraphSIzeFixed = ");
        stringBuffer.append(this.isGraphSizeFixed());
        stringBuffer.append(",IsGraphTextDisplayed = ");
        stringBuffer.append(this.isGraphTextDisplayed());
        stringBuffer.append(",IsLeaderLineDisplayed = ");
        stringBuffer.append(this.isLeaderLineDisplayed());
        stringBuffer.append(",IsNegativeDisplayed = ");
        stringBuffer.append(this.isNegativeDisplayed());
        stringBuffer.append(",MaxGraphSize = ");
        stringBuffer.append(this.getMaxGraphSize());
        stringBuffer.append(",MinGraphSize = ");
        stringBuffer.append(this.getMinGraphSize());
        stringBuffer.append(",OffsetX = ");
        stringBuffer.append(this.getOffsetX());
        stringBuffer.append(",OffsetY = ");
        stringBuffer.append(this.getOffsetY());
        stringBuffer.append(",RoseAngle = ");
        stringBuffer.append(this.getRoseAngle());
        stringBuffer.append(",StartAngle = ");
        stringBuffer.append(this.getStartAngle());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void setAxesTextDisplayMode(GraphAxesTextDisplayMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGraphAxesTextDisplayMode(GraphAxesTextDisplayMode mode)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        switch (mode.value()) {
            case 0: {
                ThemeGraphNative.jni_SetShowXAxesText(this.getHandle(), false);
                ThemeGraphNative.jni_SetShowYAxesText(this.getHandle(), false);
                break;
            }
            case 2: {
                ThemeGraphNative.jni_SetShowXAxesText(this.getHandle(), false);
                ThemeGraphNative.jni_SetShowYAxesText(this.getHandle(), true);
                break;
            }
            case 3: {
                ThemeGraphNative.jni_SetShowXAxesText(this.getHandle(), true);
                ThemeGraphNative.jni_SetShowYAxesText(this.getHandle(), true);
                break;
            }
        }
    }

    public GraphAxesTextDisplayMode getAxesTextDisplayMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGraphAxesTextDisplayMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        GraphAxesTextDisplayMode graphAxesTextDisplayMode = GraphAxesTextDisplayMode.NONE;
        if (this.isAxesDisplayed() && ThemeGraphNative.jni_IsShowYAxesText(this.getHandle())) {
            graphAxesTextDisplayMode = GraphAxesTextDisplayMode.YAXES;
            if (ThemeGraphNative.jni_IsShowXAxesText(this.getHandle())) {
                graphAxesTextDisplayMode = GraphAxesTextDisplayMode.ALL;
            }
        }
        return graphAxesTextDisplayMode;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeGraphNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Deprecated
    public boolean IsAllDirectionsOverlapedAvoided() {
        return this.isAllDirectionsOverlappedAvoided();
    }

    public boolean isAllDirectionsOverlappedAvoided() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_IsAllDirectionOverlap(this.getHandle());
    }

    @Deprecated
    public void setAllDirectionsOverlapedAvoided(boolean value) {
        this.setAllDirectionsOverlappedAvoided(value);
    }

    public void setAllDirectionsOverlappedAvoided(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGraphNative.jni_SetAllDirectionOverlaped(this.getHandle(), value);
        this.m_lock.unlock();
    }

    @Override
    public boolean fromXML(String xml) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = super.fromXML(xml);
            if (bl) {
                if (this.m_leaderLineStyle != null) {
                    InternalGeoStyle.clearHandle(this.m_leaderLineStyle);
                    this.m_leaderLineStyle = null;
                }
                if (this.m_axesTextStyle != null) {
                    InternalTextStyle.clearHandle(this.m_axesTextStyle);
                }
                if (this.m_graphTextStyle != null) {
                    InternalTextStyle.clearHandle(this.m_graphTextStyle);
                }
                this.refreshGraphItemsList();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    @Override
    protected void clearHandle() {
        if (this.m_graphItems != null) {
            this.clearGraphItemsList();
            this.m_graphItems = null;
        }
        if (this.m_leaderLineStyle != null) {
            InternalGeoStyle.clearHandle(this.m_leaderLineStyle);
            this.m_leaderLineStyle = null;
        }
        if (this.m_axesTextStyle != null) {
            InternalTextStyle.clearHandle(this.m_axesTextStyle);
        }
        if (this.m_graphTextStyle != null) {
            InternalTextStyle.clearHandle(this.m_graphTextStyle);
        }
        this.setHandle(0L);
    }

    ArrayList getGraphItemsList() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGraphItemsList()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_graphItems;
    }

    private void clearGraphItemsList() {
        int n = this.m_graphItems.size();
        for (int i = 0; i < n; ++i) {
            ThemeGraphItem themeGraphItem = (ThemeGraphItem)((Object)this.m_graphItems.get(i));
            themeGraphItem.clearHandle();
        }
        this.m_graphItems.clear();
    }

    private void refreshGraphItemsList() {
        if (this.m_graphItems != null) {
            this.clearGraphItemsList();
        }
        int n = this.getCount();
        long[] lArray = new long[n];
        ThemeGraphNative.jni_GetItemHandles(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            ThemeGraphItem themeGraphItem = new ThemeGraphItem(l, this);
            this.m_graphItems.add(themeGraphItem);
        }
    }

    private void refreshGraphItemAndStyle() {
        int n = this.getCount();
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        ThemeGraphNative.jni_GetItemAndStyleHandles(this.getHandle(), lArray, lArray2);
        for (int i = 0; i < n; ++i) {
            ThemeGraphItem themeGraphItem = this.getItem(i);
            themeGraphItem.refreshItemAndStyle(lArray[i], lArray2[i]);
        }
    }

    public void calculateExtremum() {
        if (this.m_layer != null && this.m_layer.getDataset() != null) {
            this.calculateExtremum(this.m_layer.getDataset());
        }
    }

    public void calculateExtremum(Dataset dataset) {
        long l;
        if (dataset != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset)) != 0L) {
            ThemeGraphNative.jni_CalculateExtremum(this.getHandle(), l);
        }
    }

    public void setGlobalMaxValueEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGraphNative.jni_SetGlobalMaxValueEnabled(this.getHandle(), value);
    }

    public boolean isGlobalMaxValueEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGraphNative.jni_IsGlobalMaxValueEnabled(this.getHandle());
    }
}

