/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.TextStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalTextStyle;
import com.supermap.mapping.ThemeLabel;
import com.supermap.mapping.ThemeLabelNative;
import java.util.ArrayList;

public class MixedTextStyle {
    private ThemeLabel m_themeLabel = null;
    private boolean m_isOwnerTheme = false;
    private TextStyle m_defaultStyle = null;
    private String m_separator = "";
    private boolean m_isSeparatorEnabled = false;
    private ArrayList m_styleList;
    private int[] m_values = new int[0];

    public MixedTextStyle() {
        this.m_isOwnerTheme = false;
        this.m_styleList = new ArrayList();
    }

    public MixedTextStyle(TextStyle[] styles, String separator) {
        this();
        this.setStyles(styles);
        this.setSeparator(separator);
    }

    public MixedTextStyle(TextStyle[] styles, int[] startIndexes) {
        this();
        this.setStyles(styles);
        this.setSplitIndexes(startIndexes);
    }

    MixedTextStyle(ThemeLabel themeLabel) {
        this.m_themeLabel = themeLabel;
        this.m_isOwnerTheme = true;
        this.m_styleList = new ArrayList();
    }

    public TextStyle getDefaultStyle() {
        long l = 0L;
        if (this.m_isOwnerTheme) {
            long l2;
            if (this.m_themeLabel == null) {
                String string = InternalResource.loadString("getDefaultStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("getStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_defaultStyle == null && (l2 = ThemeLabelNative.jni_GetDefaultStyle(l)) != 0L) {
                this.m_defaultStyle = InternalTextStyle.createInstance(l2);
            }
        } else if (this.m_defaultStyle == null) {
            this.m_defaultStyle = new TextStyle();
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_defaultStyle, false);
        }
        return this.m_defaultStyle;
    }

    public void setDefaultStyle(TextStyle style) {
        long l = 0L;
        if (this.m_isOwnerTheme) {
            if (this.m_themeLabel == null) {
                String string = InternalResource.loadString("setDefaultStyle(TextStyle style)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("getStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
        }
        if (style == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)style) == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle = style.clone();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
        if (this.m_isOwnerTheme) {
            ThemeLabelNative.jni_SetDefaultStyle(l, l2);
        } else if (this.m_defaultStyle == null) {
            this.m_defaultStyle = InternalTextStyle.createInstance(l2);
        } else {
            InternalTextStyle.changeHandle(this.m_defaultStyle, l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)textStyle);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
    }

    public String getSeparator() {
        long l = 0L;
        if (this.m_isOwnerTheme) {
            if (this.m_themeLabel == null) {
                String string = InternalResource.loadString("getSeparator()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("getStyle()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_separator = ThemeLabelNative.jni_GetSeparator(l);
        }
        return this.m_separator;
    }

    public void setSeparator(String value) {
        long l = 0L;
        if (this.m_isOwnerTheme) {
            if (this.m_themeLabel == null) {
                String string = InternalResource.loadString("setSeparator(String value) ", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("setSeparator()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (value == null) {
                String string = InternalResource.loadString("setSeparator()", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeLabelNative.jni_SetSeparator(l, value);
        }
        this.m_separator = value;
    }

    public boolean isSeparatorEnabled() {
        long l = 0L;
        if (this.m_isOwnerTheme) {
            if (this.m_themeLabel == null) {
                String string = InternalResource.loadString("isSeparatorEnabled()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("isSeparatorEnabled()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this.m_isSeparatorEnabled = ThemeLabelNative.jni_IsSeparatorEnabled(l);
        }
        return this.m_isSeparatorEnabled;
    }

    public void setSeparatorEnabled(boolean value) {
        long l = 0L;
        if (this.m_isOwnerTheme) {
            if (this.m_themeLabel == null) {
                String string = InternalResource.loadString("setSeparatorEnabled(boolean value)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("setSeparatorEnabled()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            ThemeLabelNative.jni_SetSeparatorEnabled(l, value);
        }
        this.m_isSeparatorEnabled = value;
    }

    public TextStyle[] getStyles() {
        int n;
        long l = 0L;
        if (this.m_isOwnerTheme) {
            if (this.m_themeLabel == null) {
                String string = InternalResource.loadString("getStyles()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("getStyles()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n2 = this.m_styleList.size();
            if (n2 == 0) {
                n = ThemeLabelNative.jni_GetStylesCount(l);
                long[] lArray = new long[n];
                ThemeLabelNative.jni_GetStyles(l, lArray);
                for (int i = 0; i < lArray.length; ++i) {
                    TextStyle textStyle = InternalTextStyle.createInstance(lArray[i]);
                    this.m_styleList.add(textStyle);
                }
            }
        }
        TextStyle[] textStyleArray = new TextStyle[this.m_styleList.size()];
        for (n = 0; n < textStyleArray.length; ++n) {
            textStyleArray[n] = (TextStyle)this.m_styleList.get(n);
        }
        return textStyleArray;
    }

    public void setStyles(TextStyle[] styles) {
        TextStyle textStyle;
        int n;
        long[] lArray;
        int n2;
        long l = 0L;
        if (this.m_isOwnerTheme) {
            if (this.m_themeLabel == null) {
                String string = InternalResource.loadString("setStyles(TextStyle[] styles)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("setStyles(TextStyle[] styles)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            for (n2 = 0; n2 < this.m_styleList.size() - styles.length; ++n2) {
                this.m_styleList.remove(styles.length + n2);
            }
            n2 = styles.length;
            lArray = new long[n2];
            for (n = 0; n < lArray.length; ++n) {
                textStyle = styles[n].clone();
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
                lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
                if (n < this.m_styleList.size()) {
                    InternalTextStyle.refreshHandle((TextStyle)this.m_styleList.get(n), lArray[n]);
                    continue;
                }
                this.m_styleList.add(textStyle);
            }
            ThemeLabelNative.jni_SetStylesAndIndexes(l, this.getSplitIndexes(), lArray);
        } else {
            for (n2 = 0; n2 < this.m_styleList.size() - styles.length; ++n2) {
                this.m_styleList.remove(styles.length + n2);
            }
            n2 = styles.length;
            lArray = new long[n2];
            for (n = 0; n < lArray.length; ++n) {
                textStyle = styles[n].clone();
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, false);
                lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)textStyle);
                if (n < this.m_styleList.size()) {
                    InternalTextStyle.changeHandle((TextStyle)this.m_styleList.get(n), lArray[n]);
                    continue;
                }
                this.m_styleList.add(textStyle);
            }
        }
        for (n2 = 0; n2 < styles.length; ++n2) {
            InternalHandleDisposable.makeSureNativeObjectLive((Object)styles[n2]);
        }
    }

    public int[] getSplitIndexes() {
        long l = 0L;
        if (this.m_isOwnerTheme) {
            if (this.m_themeLabel == null) {
                String string = InternalResource.loadString("getStartIndexes()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("getStartIndexes()", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n = ThemeLabelNative.jni_GetStartIndexesCount(l);
            this.m_values = new int[n];
            ThemeLabelNative.jni_GetStartIndexes(l, this.m_values);
        }
        return this.m_values;
    }

    public void setSplitIndexes(int[] indexes) {
        int n;
        long l = 0L;
        if (this.m_isOwnerTheme) {
            if (this.m_themeLabel == null) {
                String string = InternalResource.loadString("setStartIndexes(int[] indexes)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeLabel);
            if (l == 0L) {
                String string = InternalResource.loadString("setStartIndexes(int[] indexes)", "Global_OwnerHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_styleList != null) {
                Object object;
                int n2;
                n = this.m_styleList.size();
                if (n == 0) {
                    n2 = ThemeLabelNative.jni_GetStylesCount(l);
                    object = new long[n2];
                    ThemeLabelNative.jni_GetStyles(l, object);
                    for (int i = 0; i < ((long[])object).length; ++i) {
                        TextStyle textStyle = InternalTextStyle.createInstance(object[i]);
                        this.m_styleList.add(textStyle);
                    }
                }
                for (n2 = 0; n2 < this.m_styleList.size(); ++n2) {
                    object = ((TextStyle)this.m_styleList.get(n2)).clone();
                    InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)object, false);
                    InternalTextStyle.refreshHandle((TextStyle)this.m_styleList.get(n2), InternalHandle.getHandle((com.supermap.data.InternalHandle)object));
                }
            }
            n = 0;
            if (this.m_styleList != null) {
                n = this.m_styleList.size();
            }
            long[] lArray = new long[n];
            for (int i = 0; i < lArray.length; ++i) {
                if (this.m_styleList == null) continue;
                lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)((TextStyle)this.m_styleList.get(i)));
            }
            ThemeLabelNative.jni_SetStylesAndIndexes(l, indexes, lArray);
        }
        this.m_values = new int[indexes.length];
        for (n = 0; n < indexes.length; ++n) {
            this.m_values[n] = indexes[n];
        }
    }

    public void dispose() {
        if (this.m_themeLabel == null) {
            if (this.m_defaultStyle != null) {
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_defaultStyle, true);
                this.m_defaultStyle.dispose();
            }
            if (this.m_styleList != null) {
                for (int i = 0; i < this.m_styleList.size(); ++i) {
                    TextStyle textStyle = (TextStyle)this.m_styleList.get(i);
                    InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)textStyle, true);
                    textStyle.dispose();
                }
            }
            this.m_styleList = null;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    protected void clearHandle() {
        if (this.m_defaultStyle != null) {
            InternalTextStyle.clearHandle(this.m_defaultStyle);
            this.m_defaultStyle = null;
        }
        for (int i = 0; i < this.m_styleList.size(); ++i) {
            TextStyle textStyle = (TextStyle)this.m_styleList.get(i);
            InternalTextStyle.clearHandle(textStyle);
            textStyle = null;
        }
        this.m_styleList = null;
        this.m_themeLabel = null;
    }
}

