/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGroup;
import com.supermap.data.DatasetMosaic;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.MemRecordset;
import com.supermap.data.Workspace;
import com.supermap.mapping.InternalDataset;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalMapControl;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerAddedEvent;
import com.supermap.mapping.LayerAddedListener;
import com.supermap.mapping.LayerCache;
import com.supermap.mapping.LayerCacheNative;
import com.supermap.mapping.LayerCaptionChangedEvent;
import com.supermap.mapping.LayerCaptionChangedListener;
import com.supermap.mapping.LayerChart;
import com.supermap.mapping.LayerChartNative;
import com.supermap.mapping.LayerDrawingEvent;
import com.supermap.mapping.LayerDrawingListener;
import com.supermap.mapping.LayerDrawnEvent;
import com.supermap.mapping.LayerDrawnListener;
import com.supermap.mapping.LayerEPS;
import com.supermap.mapping.LayerEditableChangedEvent;
import com.supermap.mapping.LayerEditableChangedListener;
import com.supermap.mapping.LayerExtensionBase;
import com.supermap.mapping.LayerExtensionBaseNative;
import com.supermap.mapping.LayerExtensionPlugin;
import com.supermap.mapping.LayerExtensionPluginFactory;
import com.supermap.mapping.LayerGridAggregation;
import com.supermap.mapping.LayerGridAggregationNative;
import com.supermap.mapping.LayerGroup;
import com.supermap.mapping.LayerGroupAddedEvent;
import com.supermap.mapping.LayerGroupAddedListener;
import com.supermap.mapping.LayerGroupNative;
import com.supermap.mapping.LayerGroupRemovedEvent;
import com.supermap.mapping.LayerGroupRemovedListener;
import com.supermap.mapping.LayerHeatmap;
import com.supermap.mapping.LayerHeatmapNative;
import com.supermap.mapping.LayerMosaic;
import com.supermap.mapping.LayerMosaicGroup;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerRemovedEvent;
import com.supermap.mapping.LayerRemovedListener;
import com.supermap.mapping.LayerSelectableChangedEvent;
import com.supermap.mapping.LayerSelectableChangedListener;
import com.supermap.mapping.LayerSetting;
import com.supermap.mapping.LayerSnapableChangedEvent;
import com.supermap.mapping.LayerSnapableChangedListener;
import com.supermap.mapping.LayerSnapshot;
import com.supermap.mapping.LayerSnapshotAddedEvent;
import com.supermap.mapping.LayerSnapshotAddedListener;
import com.supermap.mapping.LayerSnapshotNative;
import com.supermap.mapping.LayerSnapshotRemovedEvent;
import com.supermap.mapping.LayerSnapshotRemovedListener;
import com.supermap.mapping.LayerType;
import com.supermap.mapping.LayerVisibleChangedEvent;
import com.supermap.mapping.LayerVisibleChangedListener;
import com.supermap.mapping.LayersNative;
import com.supermap.mapping.Map;
import com.supermap.mapping.MapPainter;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeDotDensity;
import com.supermap.mapping.ThemeType;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

public class Layers
extends InternalHandle {
    private Map m_map;
    protected ArrayList<Layer> m_layersList;
    transient Vector m_layerDrawingListeners;
    transient Vector m_layerDrawnListeners;
    transient Vector m_layerAddedListeners;
    transient Vector m_layerRemovedListeners;
    transient Vector m_layerCaptionChangedListener;
    transient Vector m_layerSelectableChangedListener;
    transient Vector m_layerEditableChangedListener;
    transient Vector m_layerVisibleChangedListener;
    transient Vector m_layerSnapableChangedListener;
    transient Vector<LayerGroupAddedListener> m_layerGroupAddedListenerList;
    transient Vector<LayerGroupRemovedListener> m_layerGroupRemovedListenerList;
    transient Vector<LayerSnapshotAddedListener> m_layerSnapshotAddedListenerList;
    transient Vector<LayerSnapshotRemovedListener> m_layerSnapshotRemovedListenerList;
    private boolean m_flag = true;
    ReentrantLock m_lock;

    protected Layers(long handle, Map map, ReentrantLock lock) {
        this.reset(handle, map, lock);
    }

    public void reset(long handle, Map map, ReentrantLock lock) {
        this.clearHandle();
        this.setHandle(handle);
        this.m_layersList = new ArrayList();
        this.m_map = map;
        this.m_lock = lock;
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            boolean bl;
            long l = LayersNative.jni_GetItemByIndex(this.getHandle(), i);
            if (l == 0L) continue;
            boolean bl2 = LayerNative.jni_IsChartLayer(l);
            boolean bl3 = LayerGroupNative.jni_IsLayerGroup(l);
            boolean bl4 = LayerSnapshotNative.jni_IsLayerSnapshot(l);
            boolean bl5 = LayerHeatmapNative.jni_IsLayerHeatmap(l);
            boolean bl6 = LayerGridAggregationNative.jni_IsLayerGridAggregation(l);
            boolean bl7 = LayerExtensionBaseNative.jni_IsLayerExtensionBase(l);
            boolean bl8 = LayerCacheNative.jni_IsLayerCacheNative(l);
            boolean bl9 = bl = Layer.getSubType(l) == LayerType.SUBLAYER_MOSAIC;
            if (bl2) {
                long l2 = LayerChartNative.jni_GetDatasetGroup(l);
                object = InternalToolkitMapping.toMangedDatasetGroup(this.m_map.getWorkspace(), l2);
                LayerChart layerChart = new LayerChart(l, this, this.m_map, (DatasetGroup)object);
                this.m_layersList.add(layerChart);
                continue;
            }
            if (bl4) {
                LayerSnapshot layerSnapshot = new LayerSnapshot(l, this, this.m_map);
                this.m_layersList.add(layerSnapshot);
                continue;
            }
            if (bl) {
                LayerMosaic layerMosaic = new LayerMosaic(l, this, this.m_map);
                DatasetMosaic datasetMosaic = (DatasetMosaic)layerMosaic.getDataset();
                object = new LayerMosaicGroup(l, datasetMosaic, this, this.m_map);
                this.m_layersList.add((Layer)((Object)object));
                continue;
            }
            if (bl3 && !bl) {
                LayerGroup layerGroup = new LayerGroup(l, null, this, this.m_map);
                this.m_layersList.add(layerGroup);
                continue;
            }
            if (bl5) {
                LayerHeatmap layerHeatmap = new LayerHeatmap(l, this, this.m_map);
                this.m_layersList.add(layerHeatmap);
                continue;
            }
            if (bl6) {
                LayerGridAggregation layerGridAggregation = new LayerGridAggregation(l, this, this.m_map);
                this.m_layersList.add(layerGridAggregation);
                continue;
            }
            if (bl7) {
                LayerExtensionBase layerExtensionBase = LayerExtensionBase.createUGCInstance(l, this, this.m_map);
                this.m_layersList.add(layerExtensionBase);
                continue;
            }
            if (bl8) {
                LayerCache layerCache = new LayerCache(l, this, this.m_map);
                this.m_layersList.add(layerCache);
                continue;
            }
            Layer layer = new Layer(l, this, this.m_map);
            this.m_layersList.add(layer);
            layer.getDataset();
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayersNative.jni_GetCount(this.getHandle());
    }

    int getTotalCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTotalCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayersNative.jni_GetTotalCount(this.getHandle());
    }

    public Layer get(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            name = "";
        }
        int n = this.indexOf(name);
        Layer layer = null;
        if (n != -1) {
            layer = this.m_layersList.get(n);
        }
        return layer;
    }

    public Layer get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_layersList.get(index);
    }

    public Layer addChart(DatasetGroup datasetGroup, boolean addToHead) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Dataset dataset, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (datasetGroup == null) {
            String string = InternalResource.loadString("datasetGroup", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGroup);
        if (l2 == 0L) {
            String string = InternalResource.loadString("datasetGroup", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        Workspace workspace = datasetGroup.getDatasource().getWorkspace();
        Workspace workspace2 = this.m_map.getWorkspace();
        long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
        if (l3 != (l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace2))) {
            String string = InternalResource.loadString("datasetGroup", "Layers_TheWorkspaceOfDatasetGroupShouldBeTheSameAsMap", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l4 = LayersNative.jni_AddChartLayer(this.getHandle(), l2, addToHead);
        LayerChart layerChart = null;
        if (l4 != 0L) {
            layerChart = new LayerChart(l4, this, this.m_map, datasetGroup);
            layerChart.reset();
            if (addToHead) {
                this.m_layersList.add(0, layerChart);
            } else {
                this.m_layersList.add(layerChart);
            }
            LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layerChart);
            this.fireLayerAdded(layerAddedEvent);
            if (this.m_flag) {
                this.m_map.setImageSize(this.m_map.getImageSize());
                this.m_flag = false;
            }
        }
        return layerChart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer add(Dataset dataset, boolean addToHead) {
        Layer layer = null;
        try {
            long l;
            InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("add(Dataset dataset, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (dataset == null) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (dataset.getType().equals((Object)DatasetType.TABULAR)) {
                String string = InternalResource.loadString("dataset", "Layers_TheTypeOfDatasetCanNotBeTABULAR", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            Workspace workspace = dataset.getDatasource().getWorkspace();
            Workspace workspace2 = this.m_map.getWorkspace();
            long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
            if (l3 != (l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace2))) {
                String string = InternalResource.loadString("dataset", "Layers_TheWorkspaceOfDatasetShouldBeTheSameAsMap", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l4 = LayersNative.jni_AddLayer(this.getHandle(), l2, addToHead);
            if (l4 != 0L) {
                layer = new Layer(l4, this, this.m_map);
                layer.reset();
                if (addToHead) {
                    this.m_layersList.add(0, layer);
                } else {
                    this.m_layersList.add(layer);
                }
                layer.getDataset();
                LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                this.fireLayerAdded(layerAddedEvent);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return layer;
    }

    public Layer add(java.util.Map<String, Serializable> params, boolean addToHead) {
        return this.add(params, null, addToHead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer add(java.util.Map<String, Serializable> params, Theme theme, boolean addToHead) {
        Layer layer = null;
        try {
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("add(java.util.Map<String, Serializable> params, Theme theme, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (params == null) {
                String string = InternalResource.loadString("params", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            LayerExtensionPlugin layerExtensionPlugin = LayerExtensionPluginFactory.getPlugin(params);
            if (layerExtensionPlugin != null && layerExtensionPlugin.canProcess(params) && (layer = layerExtensionPlugin.creatExtensionLayer(params)) != null) {
                layer.setExtensionPlugin(layerExtensionPlugin);
                if (theme != null) {
                    layer.setTheme(theme);
                }
                if (addToHead) {
                    this.addLayer(0, layer);
                } else {
                    this.add(layer);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.m_lock.unlock();
        }
        return layer;
    }

    public Layer add(Dataset dataset, LayerSetting layerSetting, boolean addToHead) {
        Layer layer = this.add(dataset, addToHead);
        if (layerSetting != null) {
            layer.setAdditionalSetting(layerSetting);
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer add(Dataset dataset, Theme theme, boolean addToHead) {
        Layer layer = null;
        try {
            Object object;
            long l;
            InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("add(Dataset dataset, Theme theme, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (dataset == null) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (dataset.getType().equals((Object)DatasetType.TABULAR)) {
                String string = InternalResource.loadString("dataset", "Layers_TheTypeOfDatasetCanNotBeTABULAR", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            Workspace workspace = dataset.getDatasource().getWorkspace();
            Workspace workspace2 = this.m_map.getWorkspace();
            long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
            if (l3 != (l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace2))) {
                String string = InternalResource.loadString("dataset", "Layers_TheWorkspaceOfDatasetShouldBeTheSameAsMap", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l4 = 0L;
            if (theme == null) {
                Layer layer2 = this.add(dataset, addToHead);
                return layer2;
            }
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)theme) == 0L) {
                String string = InternalResource.loadString("theme", "Layers_InvalidTheme", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            ThemeType themeType = theme.getType();
            if (!this.isDatasetMatchedThemeType(dataset, themeType)) {
                String string = InternalResource.loadString("dataset || theme", "Layers_TheTypeOfDatasetIsNotMatchingWithTheTheme", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (themeType.equals((Object)ThemeType.DOTDENSITY)) {
                object = ((ThemeDotDensity)theme).getDotExpression();
                FieldInfo fieldInfo = ((DatasetVector)dataset).getFieldInfos().get((String)object);
                if (fieldInfo != null) {
                    boolean bl;
                    FieldType fieldType = fieldInfo.getType();
                    boolean bl2 = bl = fieldType.equals((Object)FieldType.BYTE) || fieldType.equals((Object)FieldType.INT16) || fieldType.equals((Object)FieldType.INT32) || fieldType.equals((Object)FieldType.DOUBLE) || fieldType.equals((Object)FieldType.SINGLE);
                    if (!bl) {
                        String string = InternalResource.loadString("", "ThemeDotDensity_OnlySupportNumberField", "mapping_resources");
                        throw new IllegalArgumentException(string);
                    }
                }
            }
            object = Theme.clone(theme);
            InternalHandleDisposable.setIsDisposable(object, false);
            long l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)object);
            if (l5 == 0L) {
                String string = InternalResource.loadString("theme", "Layers_InvalidTheme", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            l4 = LayersNative.jni_AddLayerWithTheme(this.getHandle(), l2, l5, addToHead);
            if (l4 != 0L) {
                layer = new Layer(l4, this, this.m_map);
                layer.reset();
                if (addToHead) {
                    this.m_layersList.add(0, layer);
                } else {
                    this.m_layersList.add(layer);
                }
                layer.getDataset();
                LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                this.fireLayerAdded(layerAddedEvent);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer insert(int index, Dataset dataset) {
        Layer layer = null;
        try {
            long l;
            InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("insert(int index, Dataset dataset)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (index < 0 || index > this.getCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (dataset == null) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (dataset.getType().equals((Object)DatasetType.TABULAR)) {
                String string = InternalResource.loadString("dataset", "Layers_TheTypeOfDatasetCanNotBeTABULAR", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            Workspace workspace = dataset.getDatasource().getWorkspace();
            Workspace workspace2 = this.m_map.getWorkspace();
            long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
            if (l3 != (l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace2))) {
                String string = InternalResource.loadString("dataset", "Layers_TheWorkspaceOfDatasetShouldBeTheSameAsMap", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l4 = LayersNative.jni_Insert(this.getHandle(), l2, index);
            if (l4 != 0L) {
                layer = new Layer(l4, this, this.m_map);
                layer.reset();
                this.m_layersList.add(index, layer);
                layer.getDataset();
                LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                this.fireLayerAdded(layerAddedEvent);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return layer;
    }

    public Layer insert(int index, Dataset dataset, LayerSetting layerSetting) {
        Layer layer = this.insert(index, dataset);
        layer.setAdditionalSetting(layerSetting);
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer insert(int index, Dataset dataset, Theme theme) {
        Layer layer = null;
        try {
            Object object;
            long l;
            InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("insert(int index, Dataset dataset, Theme theme)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (index < 0 || index > this.getCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (dataset == null) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (dataset.getType().equals((Object)DatasetType.TABULAR)) {
                String string = InternalResource.loadString("dataset", "Layers_TheTypeOfDatasetCanNotBeTABULAR", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            Workspace workspace = dataset.getDatasource().getWorkspace();
            Workspace workspace2 = this.m_map.getWorkspace();
            long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
            if (l3 != (l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace2))) {
                String string = InternalResource.loadString("dataset", "Layers_TheWorkspaceOfDatasetShouldBeTheSameAsMap", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l4 = 0L;
            if (theme == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)theme) == 0L) {
                String string = InternalResource.loadString("theme", "Layers_InvalidTheme", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            ThemeType themeType = theme.getType();
            if (!this.isDatasetMatchedThemeType(dataset, themeType)) {
                String string = InternalResource.loadString("dataset || theme", "Layers_TheTypeOfDatasetIsNotMatchingWithTheTheme", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (themeType.equals((Object)ThemeType.DOTDENSITY)) {
                object = ((ThemeDotDensity)theme).getDotExpression();
                FieldInfo fieldInfo = ((DatasetVector)dataset).getFieldInfos().get((String)object);
                if (fieldInfo != null) {
                    boolean bl;
                    FieldType fieldType = fieldInfo.getType();
                    boolean bl2 = bl = fieldType.equals((Object)FieldType.BYTE) || fieldType.equals((Object)FieldType.INT16) || fieldType.equals((Object)FieldType.INT32) || fieldType.equals((Object)FieldType.DOUBLE) || fieldType.equals((Object)FieldType.SINGLE);
                    if (!bl) {
                        String string = InternalResource.loadString("", "ThemeDotDensity_OnlySupportNumberField", "mapping_resources");
                        throw new IllegalArgumentException(string);
                    }
                }
            }
            object = Theme.clone(theme);
            InternalHandleDisposable.setIsDisposable(object, false);
            long l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)object);
            if (l5 == 0L) {
                String string = InternalResource.loadString("theme", "Layers_InvalidTheme", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            l4 = LayersNative.jni_InsertWithTheme(this.getHandle(), l2, l5, index);
            if (l4 != 0L) {
                layer = new Layer(l4, this, this.m_map);
                layer.reset();
                this.m_layersList.add(index, layer);
                layer.getDataset();
                LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                this.fireLayerAdded(layerAddedEvent);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeRange(int startIndex, int count) {
        int n = 0;
        try {
            InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("removeRange(int startIndex, int count)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            int n2 = this.getCount();
            if (startIndex < 0 || startIndex >= n2) {
                String string = InternalResource.loadString("startIndex", "Global_IndexOutOfBounds", "mapping_resources");
                throw new IndexOutOfBoundsException(string);
            }
            if (startIndex + count < startIndex || startIndex + count > n2) {
                String string = InternalResource.loadString("count", "Layers_TheCountIsInvalid", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            n = LayersNative.jni_RemoveRange(this.getHandle(), startIndex, count);
            for (int i = startIndex + n - 1; i >= startIndex; --i) {
                Layer layer = this.m_layersList.get(i);
                this.m_layersList.remove(i);
                layer.clearHandle();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int index) {
        boolean bl = false;
        try {
            InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (index < 0 || index >= this.getCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
                throw new IndexOutOfBoundsException(string);
            }
            String string = this.m_layersList.get(index).getName();
            int n = LayersNative.jni_RemoveByIndex(this.getHandle(), index);
            if (n == 1) {
                Layer layer = this.m_layersList.get(index);
                this.m_layersList.remove(index);
                bl = true;
                LayerRemovedEvent layerRemovedEvent = new LayerRemovedEvent((Object)this, layer, string, index);
                this.fireLayerRemoved(layerRemovedEvent);
                layer.clearHandle();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String name) {
        boolean bl = false;
        try {
            int n;
            int n2;
            InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("remove(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (name != null && (n2 = this.indexOf(name)) != -1 && (n = LayersNative.jni_RemoveByIndex(this.getHandle(), n2)) == 1) {
                Layer layer = this.m_layersList.get(n2);
                this.m_layersList.remove(n2);
                layer.clearHandle();
                bl = true;
                LayerRemovedEvent layerRemovedEvent = new LayerRemovedEvent((Object)this, layer, name, n2);
                this.fireLayerRemoved(layerRemovedEvent);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        LayersNative.jni_Clear(this.getHandle());
        if (this.m_layersList != null) {
            int n = this.m_layersList.size();
            for (int i = 0; i < n; ++i) {
                Layer layer = this.m_layersList.get(i);
                layer.clearHandle();
            }
            this.m_layersList.clear();
        }
        this.m_lock.unlock();
    }

    public int indexOf(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        int n = -1;
        if (name != null) {
            n = LayersNative.jni_IndexOf(this.getHandle(), name);
        }
        this.m_lock.unlock();
        return n;
    }

    public boolean contains(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("contains(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (name != null) {
            bl = LayersNative.jni_Contains(this.getHandle(), name);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveToTop(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveToTop(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (index == 0) {
            bl = true;
        } else {
            try {
                this.m_lock.lock();
                Layer layer = this.m_layersList.remove(index);
                this.m_layersList.add(0, layer);
                bl = LayersNative.jni_MoveToTop(this.getHandle(), index);
            }
            finally {
                this.m_lock.unlock();
            }
        }
        return bl;
    }

    public boolean moveToBottom(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveToBottom(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (index == n - 1) {
            bl = true;
        } else {
            this.m_lock.lock();
            Layer layer = this.m_layersList.remove(index);
            this.m_layersList.add(layer);
            bl = LayersNative.jni_MoveBottom(this.getHandle(), index);
            this.m_lock.unlock();
        }
        return bl;
    }

    public boolean moveUp(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveUp(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (index == 0) {
            bl = true;
        } else {
            this.m_lock.lock();
            Layer layer = this.m_layersList.remove(index);
            this.m_layersList.add(index - 1, layer);
            bl = LayersNative.jni_MoveUp(this.getHandle(), index);
            this.m_lock.unlock();
        }
        return bl;
    }

    public boolean moveDown(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveDown(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (index == n - 1) {
            bl = true;
        } else {
            this.m_lock.lock();
            Layer layer = this.m_layersList.remove(index + 1);
            this.m_layersList.add(index, layer);
            bl = LayersNative.jni_MoveDown(this.getHandle(), index);
            this.m_lock.unlock();
        }
        return bl;
    }

    public boolean moveTo(int srcIndex, int desIndex) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveTo(int srcIndex, int desIndex)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (srcIndex < 0 || srcIndex >= n) {
            String string = InternalResource.loadString("srcIndex", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (desIndex < 0 || desIndex >= n) {
            String string = InternalResource.loadString("desIndex", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        if (srcIndex == desIndex) {
            bl = true;
        } else {
            this.m_lock.lock();
            Layer layer = this.m_layersList.remove(srcIndex);
            this.m_layersList.add(desIndex, layer);
            bl = LayersNative.jni_MoveTo(this.getHandle(), srcIndex, desIndex);
            this.m_lock.unlock();
        }
        return bl;
    }

    protected static Layers createInstance(long handle, Map map, ReentrantLock lock) {
        return new Layers(handle, map, lock);
    }

    protected void clearHandle() {
        if (this.m_layersList != null) {
            int n = this.m_layersList.size();
            for (int i = 0; i < n; ++i) {
                Layer layer = this.m_layersList.get(i);
                layer.clearHandle();
            }
            this.m_layersList.clear();
            this.m_layersList = null;
        }
        this.m_map = null;
        this.setHandle(0L);
    }

    ArrayList<Layer> getLayersList() {
        return this.m_layersList;
    }

    public ArrayList<Layer> getAllLayers(boolean isVisibleOnly) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (Layer layer : this.m_layersList) {
            layer.getContainedLayers(arrayList, isVisibleOnly);
        }
        return arrayList;
    }

    @Deprecated
    public synchronized void addDrawingListener(LayerDrawingListener l) {
        if (this.m_layerDrawingListeners == null) {
            this.m_layerDrawingListeners = new Vector();
        }
        if (!this.m_layerDrawingListeners.contains(l)) {
            this.m_layerDrawingListeners.add(l);
        }
    }

    public synchronized void addLayerDrawingListener(LayerDrawingListener l) {
        if (this.m_layerDrawingListeners == null) {
            this.m_layerDrawingListeners = new Vector();
        }
        if (this.m_layerDrawingListeners.isEmpty() && (this.m_layerDrawnListeners == null || this.m_layerDrawnListeners.isEmpty())) {
            LayersNative.jni_SetEnableLayerDrawingCallback(this.getHandle(), this, true);
        }
        if (!this.m_layerDrawingListeners.contains(l)) {
            this.m_layerDrawingListeners.insertElementAt(l, 0);
        }
    }

    @Deprecated
    public synchronized void removeDrawingListener(LayerDrawingListener l) {
        if (this.m_layerDrawingListeners != null && this.m_layerDrawingListeners.contains(l)) {
            this.m_layerDrawingListeners.remove(l);
        }
        if (this.m_layerDrawingListeners != null && this.m_layerDrawingListeners.isEmpty() && this.m_layerDrawnListeners.isEmpty()) {
            LayersNative.jni_SetEnableLayerDrawingCallback(this.getHandle(), this, false);
        }
    }

    public synchronized void removeLayerDrawingListener(LayerDrawingListener l) {
        if (this.m_layerDrawingListeners != null && this.m_layerDrawingListeners.contains(l)) {
            this.m_layerDrawingListeners.remove(l);
        }
        if ((this.m_layerDrawingListeners == null || this.m_layerDrawingListeners.isEmpty()) && (this.m_layerDrawnListeners == null || this.m_layerDrawnListeners.isEmpty())) {
            LayersNative.jni_SetEnableLayerDrawingCallback(this.getHandle(), this, false);
        }
    }

    protected void fireDrawing(LayerDrawingEvent event) {
        if (this.m_layerDrawingListeners != null) {
            Vector vector = this.m_layerDrawingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((LayerDrawingListener)vector.elementAt(i)).layerDrawing(event);
            }
        }
    }

    static void layerDrawingCallBack(Layers layers, int layerIndex, long bufferImageHandle, long graphicsHandle, long cancelHandle, String strIndexInLayers) {
        if (layers != null) {
            Layer layer = Layers.findLayerInLayers(layers, layerIndex, strIndexInLayers);
            if (layer == null) {
                return;
            }
            Boolean bl = InternalToolkitMapping.getHandleBooleanValue(cancelHandle);
            MapPainter mapPainter = new MapPainter(layers.m_map, graphicsHandle);
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)layers.m_map);
            LayerDrawingEvent layerDrawingEvent = new LayerDrawingEvent((Object)layers, layer, mapPainter, bl);
            layers.fireDrawing(layerDrawingEvent);
            InternalToolkitMapping.setHandleBooleanValue(cancelHandle, layerDrawingEvent.getCancel());
        }
    }

    @Deprecated
    public synchronized void addDrawnListener(LayerDrawnListener l) {
        this.addLayerDrawnListener(l);
    }

    public synchronized void addLayerDrawnListener(LayerDrawnListener l) {
        if (this.m_layerDrawnListeners == null) {
            this.m_layerDrawnListeners = new Vector();
        }
        if ((this.m_layerDrawingListeners == null || this.m_layerDrawingListeners.isEmpty()) && this.m_layerDrawnListeners.isEmpty()) {
            LayersNative.jni_SetEnableLayerDrawnCallback(this.getHandle(), this, true);
        }
        if (!this.m_layerDrawnListeners.contains(l)) {
            this.m_layerDrawnListeners.insertElementAt(l, 0);
        }
    }

    @Deprecated
    public synchronized void removeDrawnListener(LayerDrawnListener l) {
        this.removeLayerDrawnListener(l);
    }

    public synchronized void removeLayerDrawnListener(LayerDrawnListener l) {
        if (this.m_layerDrawnListeners != null && this.m_layerDrawnListeners.contains(l)) {
            this.m_layerDrawnListeners.remove(l);
        }
        if ((this.m_layerDrawingListeners == null || this.m_layerDrawingListeners.isEmpty()) && (this.m_layerDrawnListeners == null || this.m_layerDrawnListeners.isEmpty())) {
            LayersNative.jni_SetEnableLayerDrawnCallback(this.getHandle(), this, false);
        }
    }

    protected void fireDrawn(LayerDrawnEvent event) {
        if (this.m_layerDrawnListeners != null) {
            Vector vector = this.m_layerDrawnListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((LayerDrawnListener)vector.elementAt(i)).layerDrawn(event);
            }
        }
    }

    static Layer findLayerInLayers(Layers layers, int layerIndex, String strIndexInLayers) {
        int n = strIndexInLayers.indexOf("/");
        if (n < 0) {
            if (0 <= layerIndex && layerIndex < layers.getCount()) {
                return layers.get(layerIndex);
            }
            return null;
        }
        String string = strIndexInLayers.substring(0, n);
        String string2 = strIndexInLayers.substring(n + 1);
        int n2 = Layers.parseToInt(string);
        if (n2 < 0 || n2 >= layers.getCount()) {
            return null;
        }
        Layer layer = layers.get(n2);
        LayerGroup layerGroup = null;
        if (LayerGroupNative.jni_IsLayerGroup(Layers.getHandle(layer))) {
            layerGroup = (LayerGroup)layers.get(n2);
        }
        if (layerGroup != null) {
            return Layers.findLayerInGroup(layerGroup, string2);
        }
        return null;
    }

    static Layer findLayerInGroup(LayerGroup layerGroup, String strIndexInLayers) {
        int n = strIndexInLayers.indexOf("/");
        if (n < 0) {
            int n2 = Layers.parseToInt(strIndexInLayers);
            if (0 <= n2 && n2 < layerGroup.getCount()) {
                return layerGroup.get(n2);
            }
            return null;
        }
        String string = strIndexInLayers.substring(0, n);
        String string2 = strIndexInLayers.substring(n + 1);
        int n3 = Layers.parseToInt(string);
        if (0 <= n3 && n3 < layerGroup.getCount()) {
            Layer layer = layerGroup.get(n3);
            if (LayerGroupNative.jni_IsLayerGroup(Layers.getHandle(layer))) {
                return Layers.findLayerInGroup((LayerGroup)layer, string2);
            }
            return null;
        }
        return null;
    }

    static int parseToInt(String strNum) {
        int n = -1;
        n = Integer.parseInt(strNum);
        return n;
    }

    static void layerDrawnCallBack(Layers layers, int layerIndex, long graphicsHandle, String strIndexInLayers) {
        if (layers != null) {
            Layer layer = Layers.findLayerInLayers(layers, layerIndex, strIndexInLayers);
            if (layer == null) {
                return;
            }
            MapPainter mapPainter = new MapPainter(layers.m_map, graphicsHandle);
            LayerDrawnEvent layerDrawnEvent = new LayerDrawnEvent((Object)layers, layer, mapPainter);
            layers.fireDrawn(layerDrawnEvent);
            mapPainter.copyBufferImageToUGC();
            mapPainter.realeaseGraphics();
        }
    }

    @Deprecated
    public synchronized void addAddedListener(LayerAddedListener l) {
        this.addLayerAddedListener(l);
    }

    public synchronized void addLayerAddedListener(LayerAddedListener l) {
        if (this.m_layerAddedListeners == null) {
            this.m_layerAddedListeners = new Vector();
        }
        if (!this.m_layerAddedListeners.contains(l)) {
            this.m_layerAddedListeners.insertElementAt(l, 0);
        }
    }

    @Deprecated
    public synchronized void removeAddedListener(LayerAddedListener l) {
        this.removeLayerAddedListener(l);
    }

    public synchronized void removeLayerAddedListener(LayerAddedListener l) {
        if (this.m_layerAddedListeners != null && this.m_layerAddedListeners.contains(l)) {
            this.m_layerAddedListeners.remove(l);
        }
    }

    protected void fireLayerAdded(LayerAddedEvent event) {
        if (this.m_layerAddedListeners != null) {
            Vector vector = this.m_layerAddedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((LayerAddedListener)vector.elementAt(i)).layerAdded(event);
            }
        }
    }

    @Deprecated
    public synchronized void addRemovedListener(LayerRemovedListener l) {
        this.addLayerRemovedListener(l);
    }

    public synchronized void addLayerRemovedListener(LayerRemovedListener l) {
        if (this.m_layerRemovedListeners == null) {
            this.m_layerRemovedListeners = new Vector();
        }
        if (!this.m_layerRemovedListeners.contains(l)) {
            this.m_layerRemovedListeners.insertElementAt(l, 0);
        }
    }

    @Deprecated
    public synchronized void removeRemovedListener(LayerRemovedListener l) {
        this.removeLayerRemovedListener(l);
    }

    public synchronized void removeLayerRemovedListener(LayerRemovedListener l) {
        if (this.m_layerRemovedListeners != null && this.m_layerRemovedListeners.contains(l)) {
            this.m_layerRemovedListeners.remove(l);
        }
    }

    protected void fireLayerRemoved(LayerRemovedEvent event) {
        if (this.m_layerRemovedListeners != null) {
            Vector vector = this.m_layerRemovedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((LayerRemovedListener)vector.elementAt(i)).layerRemoved(event);
            }
        }
    }

    public synchronized void addLayerCaptionChangedListener(LayerCaptionChangedListener l) {
        if (this.m_layerCaptionChangedListener == null) {
            this.m_layerCaptionChangedListener = new Vector();
        }
        if (!this.m_layerCaptionChangedListener.contains(l)) {
            this.m_layerCaptionChangedListener.insertElementAt(l, 0);
        }
    }

    public synchronized void removeLayerCaptionChangedListener(LayerCaptionChangedListener l) {
        if (this.m_layerCaptionChangedListener != null && this.m_layerCaptionChangedListener.contains(l)) {
            this.m_layerCaptionChangedListener.remove(l);
        }
    }

    protected void fireCaptionChanged(LayerCaptionChangedEvent event) {
        if (this.m_layerCaptionChangedListener != null) {
            Vector vector = this.m_layerCaptionChangedListener;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((LayerCaptionChangedListener)vector.elementAt(i)).captionChanged(event);
            }
        }
    }

    public synchronized void addLayerSelectableChangedListener(LayerSelectableChangedListener l) {
        if (this.m_layerSelectableChangedListener == null) {
            this.m_layerSelectableChangedListener = new Vector();
        }
        if (!this.m_layerSelectableChangedListener.contains(l)) {
            this.m_layerSelectableChangedListener.insertElementAt(l, 0);
        }
    }

    public synchronized void removeLayerSelectableChangedListener(LayerSelectableChangedListener l) {
        if (this.m_layerSelectableChangedListener != null && this.m_layerSelectableChangedListener.contains(l)) {
            this.m_layerSelectableChangedListener.remove(l);
        }
    }

    protected void fireSelectableChanged(LayerSelectableChangedEvent event) {
        if (this.m_layerSelectableChangedListener != null) {
            Vector vector = this.m_layerSelectableChangedListener;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((LayerSelectableChangedListener)vector.elementAt(i)).selectableChanged(event);
            }
        }
    }

    public synchronized void addLayerEditableChangedListener(LayerEditableChangedListener l) {
        if (this.m_layerEditableChangedListener == null) {
            this.m_layerEditableChangedListener = new Vector();
        }
        if (!this.m_layerEditableChangedListener.contains(l)) {
            this.m_layerEditableChangedListener.insertElementAt(l, 0);
        }
    }

    public synchronized void removeLayerEditableChangedListener(LayerEditableChangedListener l) {
        if (this.m_layerEditableChangedListener != null && this.m_layerEditableChangedListener.contains(l)) {
            this.m_layerEditableChangedListener.remove(l);
        }
    }

    protected void fireEditableChanged(LayerEditableChangedEvent event) {
        if (this.m_map.getMapControl() != null) {
            this.m_map.getMapControl().setDrawThreadRunning(!event.isEditable());
        }
        if (this.m_layerEditableChangedListener != null) {
            Vector vector = this.m_layerEditableChangedListener;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((LayerEditableChangedListener)vector.elementAt(i)).editableChanged(event);
            }
        }
    }

    public synchronized void addLayerVisibleChangedListener(LayerVisibleChangedListener l) {
        if (this.m_layerVisibleChangedListener == null) {
            this.m_layerVisibleChangedListener = new Vector();
        }
        if (!this.m_layerVisibleChangedListener.contains(l)) {
            this.m_layerVisibleChangedListener.insertElementAt(l, 0);
        }
    }

    public synchronized void removeLayerVisibleChangedListener(LayerVisibleChangedListener l) {
        if (this.m_layerVisibleChangedListener != null && this.m_layerVisibleChangedListener.contains(l)) {
            this.m_layerVisibleChangedListener.remove(l);
        }
    }

    protected void fireVisibleChanged(LayerVisibleChangedEvent event) {
        if (this.m_layerVisibleChangedListener != null) {
            Vector vector = this.m_layerVisibleChangedListener;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((LayerVisibleChangedListener)vector.elementAt(i)).visibleChanged(event);
            }
        }
    }

    public synchronized void addLayerSnapableChangedListener(LayerSnapableChangedListener l) {
        if (this.m_layerSnapableChangedListener == null) {
            this.m_layerSnapableChangedListener = new Vector();
        }
        if (!this.m_layerSnapableChangedListener.contains(l)) {
            this.m_layerSnapableChangedListener.insertElementAt(l, 0);
        }
    }

    public synchronized void removeLayerSnapableChangedListener(LayerSnapableChangedListener l) {
        if (this.m_layerSnapableChangedListener != null && this.m_layerSnapableChangedListener.contains(l)) {
            this.m_layerSnapableChangedListener.remove(l);
        }
    }

    protected void fireSnapableChanged(LayerSnapableChangedEvent event) {
        if (this.m_layerSnapableChangedListener != null) {
            Vector vector = this.m_layerSnapableChangedListener;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((LayerSnapableChangedListener)vector.elementAt(i)).snapableChanged(event);
            }
        }
    }

    private boolean isDatasetMatchedThemeType(Dataset dataset, ThemeType themeType) {
        DatasetType datasetType = dataset.getType();
        boolean bl = true;
        if (themeType.equals((Object)ThemeType.UNIQUE) || themeType.equals((Object)ThemeType.GRADUATEDSYMBOL) || themeType.equals((Object)ThemeType.RANGE) || themeType.equals((Object)ThemeType.LABEL)) {
            if (!InternalDataset.getIsVector(dataset)) {
                bl = false;
            }
        } else if (themeType.equals((Object)ThemeType.DOTDENSITY)) {
            if (!InternalDataset.getIsVector(dataset)) {
                bl = false;
            }
            if (!datasetType.equals((Object)DatasetType.REGION)) {
                bl = false;
            }
        } else if ((themeType.equals((Object)ThemeType.GRIDRANGE) || themeType.equals((Object)ThemeType.GRIDUNIQUE)) && !datasetType.equals((Object)DatasetType.GRID)) {
            bl = false;
        }
        if (datasetType.equals((Object)DatasetType.IMAGE)) {
            bl = false;
        }
        return bl;
    }

    public int removeByDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeByDataset(Dataset dataset)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = 0;
        Layer layer = null;
        for (int i = this.m_layersList.size() - 1; i >= 0; --i) {
            layer = this.m_layersList.get(i);
            if (layer.getDataset() != dataset || !this.remove(i)) continue;
            ++n;
        }
        return n;
    }

    public LayerGroup addGroup(String groupName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addGroup(String groupName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (groupName == null) {
            groupName = "";
        }
        return this.internalInsertGroup(-1, groupName);
    }

    public LayerGroup insertGroup(int index, String groupName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertGroup(int index, String groupName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (groupName == null) {
            groupName = "";
        }
        return this.internalInsertGroup(index, groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LayerGroup internalInsertGroup(int index, String groupName) {
        LayerGroup layerGroup = null;
        try {
            this.m_lock.lock();
            long l = LayersNative.jni_InsertGroup(this.getHandle(), groupName, index);
            layerGroup = new LayerGroup(l, null, this, this.m_map);
            layerGroup.setMap(this.m_map);
            layerGroup.m_layers = this;
            if (index < 0 || index >= this.m_layersList.size()) {
                index = this.m_layersList.size();
                this.m_layersList.add(layerGroup);
            } else {
                this.m_layersList.add(index, layerGroup);
            }
            LayerGroupAddedEvent layerGroupAddedEvent = new LayerGroupAddedEvent((Object)this, layerGroup, null, index);
            this.fireLayerGroupAdded(layerGroupAddedEvent);
        }
        finally {
            this.m_lock.unlock();
        }
        return layerGroup;
    }

    public LayerSnapshot insertLayerSnapshot(int index, String snapshotName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertLayerSnapshot(int index, String snapshotName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (snapshotName == null) {
            snapshotName = "";
        }
        return this.internalInsertSnapshot(index, snapshotName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LayerSnapshot internalInsertSnapshot(int index, String snapshotName) {
        LayerSnapshot layerSnapshot = null;
        try {
            this.m_lock.lock();
            long l = LayersNative.jni_InsertSnapshot(this.getHandle(), snapshotName, index);
            layerSnapshot = new LayerSnapshot(l, this, this.m_map);
            layerSnapshot.setMap(this.m_map);
            layerSnapshot.m_layers = this;
            if (index < 0 || index >= this.m_layersList.size()) {
                index = this.m_layersList.size();
                this.m_layersList.add(layerSnapshot);
            } else {
                this.m_layersList.add(index, layerSnapshot);
            }
            LayerSnapshotAddedEvent layerSnapshotAddedEvent = new LayerSnapshotAddedEvent((Object)this, null, layerSnapshot, index);
            this.fireLayerSnapshotAdded(layerSnapshotAddedEvent);
        }
        finally {
            this.m_lock.unlock();
        }
        return layerSnapshot;
    }

    public boolean removeGroup(LayerGroup group) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGroup(LayerGroup group)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (group == null) {
            String string = InternalResource.loadString("group", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(group);
        if (l == 0L) {
            String string = InternalResource.loadString("group", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.removeLayer(group, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeLayer(Layer layer, boolean deleteLayer) {
        boolean bl = false;
        try {
            InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
            this.m_lock.lock();
            int n = this.m_layersList.indexOf((Object)layer);
            if (n < 0) {
                boolean bl2 = false;
                return bl2;
            }
            long l = InternalHandle.getHandle(layer);
            String string = layer.getName();
            bl = LayersNative.jni_Remove(this.getHandle(), l, deleteLayer);
            if (bl) {
                this.m_layersList.remove((Object)layer);
                if (layer instanceof LayerGroup) {
                    LayerGroupRemovedEvent layerGroupRemovedEvent = new LayerGroupRemovedEvent((Object)this, (LayerGroup)layer, null, n);
                    this.fireLayerGroupRemoved(layerGroupRemovedEvent);
                } else if (layer instanceof LayerSnapshot) {
                    LayerSnapshotRemovedEvent layerSnapshotRemovedEvent = new LayerSnapshotRemovedEvent((Object)this, null, (LayerSnapshot)layer, n);
                    this.fireLayerSnapshotRemoved(layerSnapshotRemovedEvent);
                } else {
                    LayerRemovedEvent layerRemovedEvent = new LayerRemovedEvent((Object)this, layer, string, n);
                    this.fireLayerRemoved(layerRemovedEvent);
                }
                if (deleteLayer) {
                    layer.clearHandle();
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addLayer(int index, Layer layer) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            int n = this.m_layersList.indexOf((Object)layer);
            if (n >= 0) {
                if (index == n) {
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl3 = this.moveTo(n, index);
                return bl3;
            }
            if (layer.getParentGroup() != null) {
                layer.getParentGroup().removeLayer(layer, false);
                layer.setParentGroup(null);
            } else if (layer.getParentSnapshot() != null) {
                layer.getParentSnapshot().removeLayer(layer, false);
                layer.setParentSnapshot(null);
            }
            layer.m_layers = this;
            layer.setMap(this.m_map);
            long l = InternalHandle.getHandle(layer);
            bl = LayersNative.jni_AddLayerFromGroup(this.getHandle(), l, index);
            if (bl) {
                LayerAddedEvent layerAddedEvent = null;
                if (index < 0 || index >= this.m_layersList.size()) {
                    this.m_layersList.add(layer);
                    layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                } else {
                    this.m_layersList.add(index, layer);
                    layerAddedEvent = new LayerAddedEvent((Object)this, layer, index);
                }
                if (layer instanceof LayerSnapshot) {
                    LayerSnapshotAddedEvent layerSnapshotAddedEvent = new LayerSnapshotAddedEvent((Object)this, null, (LayerSnapshot)layer, index);
                    this.fireLayerSnapshotAdded(layerSnapshotAddedEvent);
                } else if (layer instanceof LayerGroup) {
                    LayerGroupAddedEvent layerGroupAddedEvent = new LayerGroupAddedEvent((Object)this, (LayerGroup)layer, null, index);
                    this.fireLayerGroupAdded(layerGroupAddedEvent);
                } else {
                    this.fireLayerAdded(layerAddedEvent);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public boolean add(Layer layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGroup(LayerGroup group)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("layer", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("layer", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.m_layersList.indexOf((Object)layer);
        if (n >= 0) {
            return false;
        }
        return this.addLayer(-1, layer);
    }

    public boolean insert(int index, Layer layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGroup(LayerGroup group)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("layer", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("layer", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.m_layersList.indexOf((Object)layer);
        if (n >= 0) {
            return false;
        }
        return this.addLayer(index, layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer insertLayer(int index, String layerXml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertLayer(int index, String layerXml)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layerXml == null) {
            String string = InternalResource.loadString("layerXml", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        try {
            Object object;
            this.m_lock.lock();
            long l = LayersNative.jni_InsertLayer(this.getHandle(), layerXml, index);
            if (l == 0L) {
                String string = InternalResource.loadString("layer", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (index < 0 || index > this.getCount()) {
                String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            Layer layer = null;
            if (LayerGroupNative.jni_IsLayerGroup(l) && Layer.getSubType(l) == LayerType.SUBLAYER_MOSAIC) {
                layer = new LayerMosaicGroup(l, this, this.m_map);
            }
            layer = LayerSnapshotNative.jni_IsLayerSnapshot(l) ? new LayerSnapshot(l, this, this.m_map) : (LayerGroupNative.jni_IsLayerGroup(l) ? new LayerGroup(l, null, this, this.m_map) : new Layer(l, this, this.m_map));
            LayerAddedEvent layerAddedEvent = null;
            if (index < 0 || index >= this.m_layersList.size()) {
                this.m_layersList.add(layer);
                layerAddedEvent = new LayerAddedEvent((Object)this, layer);
            } else {
                this.m_layersList.add(index, layer);
                layerAddedEvent = new LayerAddedEvent((Object)this, layer);
            }
            layer.setMap(this.m_map);
            if (layer instanceof LayerSnapshot) {
                object = new LayerSnapshotAddedEvent((Object)this, null, (LayerSnapshot)layer, index);
                this.fireLayerSnapshotAdded((LayerSnapshotAddedEvent)object);
            } else if (layer instanceof LayerGroup) {
                object = new LayerGroupAddedEvent((Object)this, (LayerGroup)layer, null, index);
                this.fireLayerGroupAdded((LayerGroupAddedEvent)object);
            } else {
                this.fireLayerAdded(layerAddedEvent);
            }
            object = layer;
            return object;
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public boolean remove(Layer layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGroup(LayerGroup group)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("layer", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("layer", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.removeLayer(layer, true);
    }

    public synchronized void addLayerGroupAddedListener(LayerGroupAddedListener l) {
        if (this.m_layerGroupAddedListenerList == null) {
            this.m_layerGroupAddedListenerList = new Vector();
        }
        if (!this.m_layerGroupAddedListenerList.contains(l)) {
            this.m_layerGroupAddedListenerList.insertElementAt(l, 0);
        }
    }

    public synchronized void removeLayerGroupAddedListener(LayerGroupAddedListener l) {
        if (this.m_layerGroupAddedListenerList != null && this.m_layerGroupAddedListenerList.contains(l)) {
            this.m_layerGroupAddedListenerList.remove(l);
        }
    }

    protected void fireLayerGroupAdded(LayerGroupAddedEvent event) {
        if (this.m_layerGroupAddedListenerList != null) {
            Vector<LayerGroupAddedListener> vector = this.m_layerGroupAddedListenerList;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).layerGroupAdded(event);
            }
        }
    }

    public synchronized void addLayerGroupRemovedListener(LayerGroupRemovedListener l) {
        if (this.m_layerGroupRemovedListenerList == null) {
            this.m_layerGroupRemovedListenerList = new Vector();
        }
        if (!this.m_layerGroupRemovedListenerList.contains(l)) {
            this.m_layerGroupRemovedListenerList.insertElementAt(l, 0);
        }
    }

    public synchronized void removeLayerGroupRemovedListener(LayerGroupRemovedListener l) {
        if (this.m_layerGroupRemovedListenerList != null && this.m_layerGroupRemovedListenerList.contains(l)) {
            this.m_layerGroupRemovedListenerList.remove(l);
        }
    }

    protected void fireLayerGroupRemoved(LayerGroupRemovedEvent event) {
        if (this.m_layerGroupRemovedListenerList != null) {
            Vector<LayerGroupRemovedListener> vector = this.m_layerGroupRemovedListenerList;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).layerGroupRemoved(event);
            }
        }
    }

    public synchronized void addLayerSnapshotAddedListener(LayerSnapshotAddedListener l) {
        if (this.m_layerSnapshotAddedListenerList == null) {
            this.m_layerSnapshotAddedListenerList = new Vector();
        }
        if (!this.m_layerSnapshotAddedListenerList.contains(l)) {
            this.m_layerSnapshotAddedListenerList.insertElementAt(l, 0);
        }
    }

    public synchronized void removeLayerSnapshotAddedListener(LayerSnapshotAddedListener l) {
        if (this.m_layerSnapshotAddedListenerList != null && this.m_layerSnapshotAddedListenerList.contains(l)) {
            this.m_layerSnapshotAddedListenerList.remove(l);
        }
    }

    protected void fireLayerSnapshotAdded(LayerSnapshotAddedEvent event) {
        if (this.m_layerSnapshotAddedListenerList != null) {
            Vector<LayerSnapshotAddedListener> vector = this.m_layerSnapshotAddedListenerList;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).layerSnapshotAdded(event);
            }
        }
    }

    public synchronized void addLayerSnapshotRemovedListener(LayerSnapshotRemovedListener l) {
        if (this.m_layerSnapshotRemovedListenerList == null) {
            this.m_layerSnapshotRemovedListenerList = new Vector();
        }
        if (!this.m_layerSnapshotRemovedListenerList.contains(l)) {
            this.m_layerSnapshotRemovedListenerList.insertElementAt(l, 0);
        }
    }

    public synchronized void removeLayerSnapshotRemovedListener(LayerSnapshotRemovedListener l) {
        if (this.m_layerSnapshotRemovedListenerList != null && this.m_layerSnapshotRemovedListenerList.contains(l)) {
            this.m_layerSnapshotRemovedListenerList.remove(l);
        }
    }

    protected void fireLayerSnapshotRemoved(LayerSnapshotRemovedEvent event) {
        if (this.m_layerSnapshotRemovedListenerList != null) {
            Vector<LayerSnapshotRemovedListener> vector = this.m_layerSnapshotRemovedListenerList;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).layerSnapshotRemoved(event);
            }
        }
    }

    public String getAvailableCaption(String layerCaption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAvailableCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layerCaption == null || layerCaption.trim().isEmpty()) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return LayersNative.jni_FindAvailableCaption(this.getHandle(), layerCaption);
    }

    public Layer findLayer(String layerName) {
        for (int i = 0; i < this.m_layersList.size(); ++i) {
            Layer layer = this.m_layersList.get(i);
            Layer layer2 = layer.findLayer(layerName);
            if (layer2 == null) continue;
            return layer2;
        }
        return null;
    }

    public Layer findLayer(long handle) {
        for (int i = 0; i < this.m_layersList.size(); ++i) {
            Layer layer = this.m_layersList.get(i);
            Layer layer2 = layer.findLayer(handle);
            if (layer2 == null) continue;
            return layer2;
        }
        return null;
    }

    public LayerCache AddCache(String sciFile, boolean addToHead) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Add()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (sciFile == null || sciFile.trim().isEmpty()) {
            String string = InternalResource.loadString("layerName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = LayersNative.jni_AddLayerByFile(this.getHandle(), sciFile, addToHead);
        LayerCache layerCache = null;
        if (l != 0L) {
            layerCache = new LayerCache(l, this, this.m_map);
            layerCache.reset();
            if (addToHead) {
                this.m_layersList.add(0, layerCache);
            } else {
                this.m_layersList.add(layerCache);
            }
            LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layerCache);
            this.fireLayerAdded(layerAddedEvent);
        }
        return layerCache;
    }

    public LayerCache AddCache(String server, String database, String name, boolean addToHead) {
        return this.AddCache(server, database, name, addToHead, "", "");
    }

    public LayerCache AddCache(String server, String database, String name, boolean addToHead, String user, String pwd) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Add()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = LayersNative.jni_AddLayerByInfo(this.getHandle(), server, database, name, addToHead, user, pwd);
        LayerCache layerCache = null;
        if (l != 0L) {
            layerCache = new LayerCache(l, this, this.m_map);
            layerCache.reset();
            if (addToHead) {
                this.m_layersList.add(0, layerCache);
            } else {
                this.m_layersList.add(layerCache);
            }
            LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layerCache);
            this.fireLayerAdded(layerAddedEvent);
        }
        return layerCache;
    }

    public LayerHeatmap AddHeatmap(Dataset dataset, int kernelRadius) {
        Color color = Color.red;
        Color color2 = new Color(0, 0, 255, 255);
        return this.AddHeatmap(dataset, kernelRadius, color, color2);
    }

    public LayerHeatmap AddHeatmap(Dataset dataset, int kernelRadius, Color maxColor, Color minColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddHeatmap()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = LayersNative.jni_AddHeatmap(this.getHandle(), l, kernelRadius, maxColor.getRGB(), minColor.getRGB());
        LayerHeatmap layerHeatmap = null;
        if (l2 != 0L) {
            layerHeatmap = new LayerHeatmap(l2, this, this.m_map);
            layerHeatmap.reset();
            this.m_layersList.add(0, layerHeatmap);
            LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layerHeatmap);
            this.fireLayerAdded(layerAddedEvent);
        }
        return layerHeatmap;
    }

    public LayerHeatmap AddHeatmap(MemRecordset recordset, int kernelRadius) {
        Color color = Color.red;
        Color color2 = new Color(0, 0, 255, 255);
        return this.AddHeatmap(recordset, kernelRadius, color, color2);
    }

    public LayerHeatmap AddHeatmap(MemRecordset recordset, int kernelRadius, Color maxColor, Color minColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddHeatmap()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = LayersNative.jni_AddMemRecordsetHeatmap(this.getHandle(), l, kernelRadius, maxColor.getRGB(), minColor.getRGB());
        LayerHeatmap layerHeatmap = null;
        if (l2 != 0L) {
            layerHeatmap = new LayerHeatmap(l2, this, this.m_map);
            layerHeatmap.setMemRecordset(recordset);
            layerHeatmap.reset();
            this.m_layersList.add(0, layerHeatmap);
            LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layerHeatmap);
            this.fireLayerAdded(layerAddedEvent);
        }
        return layerHeatmap;
    }

    public LayerGridAggregation AddGridAggregation(Dataset dataset) {
        Color color = new Color(154, 21, 48, 230);
        Color color2 = new Color(211, 211, 149, 230);
        return this.AddGridAggregation(dataset, color, color2);
    }

    public LayerGridAggregation AddGridAggregation(Dataset dataset, Color maxColor, Color minColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddGridAggregation()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = LayersNative.jni_AddGridAggregation(this.getHandle(), l, maxColor.getRGB(), minColor.getRGB());
        LayerGridAggregation layerGridAggregation = null;
        if (l2 != 0L) {
            layerGridAggregation = new LayerGridAggregation(l2, this, this.m_map);
            layerGridAggregation.reset();
            this.m_layersList.add(0, layerGridAggregation);
            LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layerGridAggregation);
            this.fireLayerAdded(layerAddedEvent);
        }
        return layerGridAggregation;
    }

    public LayerGridAggregation AddGridAggregation(MemRecordset recordset) {
        Color color = new Color(154, 21, 48, 230);
        Color color2 = new Color(211, 211, 149, 230);
        return this.AddGridAggregation(recordset, color, color2);
    }

    public LayerGridAggregation AddGridAggregation(MemRecordset recordset, Color maxColor, Color minColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddGridAggregation()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = LayersNative.jni_AddMemRecordsetGridAggregation(this.getHandle(), l, maxColor.getRGB(), minColor.getRGB());
        LayerGridAggregation layerGridAggregation = null;
        if (l2 != 0L) {
            layerGridAggregation = new LayerGridAggregation(l2, this, this.m_map);
            layerGridAggregation.setMemRecordset(recordset);
            layerGridAggregation.reset();
            this.m_layersList.add(0, layerGridAggregation);
            LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layerGridAggregation);
            this.fireLayerAdded(layerAddedEvent);
        }
        return layerGridAggregation;
    }

    public LayerMosaicGroup addMosaicGroup(DatasetMosaic datasetMosaic, Boolean addToHead) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addLayerMosaicGroup()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (datasetMosaic == null || Layers.getHandle((com.supermap.data.InternalHandle)datasetMosaic) == 0L) {
            String string = InternalResource.loadString("addLayerMosaicGroup()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (datasetMosaic.getFootprintDataset() == null) {
            String string = InternalResource.loadString("addLayerMosaicGroup()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.m_map.getLayers().getCount();
        long l = LayersNative.jni_AddMosaicGroup(this.getHandle(), Layers.getHandle((com.supermap.data.InternalHandle)datasetMosaic), addToHead);
        if (l == 0L) {
            return null;
        }
        LayerMosaicGroup layerMosaicGroup = LayerMosaicGroup.createUGCManagedIntance(l, datasetMosaic, this, this.m_map);
        if (addToHead.booleanValue()) {
            this.m_layersList.add(0, layerMosaicGroup);
        } else {
            this.m_layersList.add(this.m_layersList.size(), layerMosaicGroup);
        }
        n = this.m_map.getLayers().getCount();
        LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layerMosaicGroup);
        this.fireLayerAdded(layerAddedEvent);
        n = this.m_map.getLayers().getCount();
        com.supermap.data.InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)layerMosaicGroup));
        return layerMosaicGroup;
    }

    public LayerMosaicGroup insertMosaicGroup(int index, DatasetMosaic datasetMosaic) {
        boolean bl;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertLayerMosaicGroup()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (datasetMosaic == null || Layers.getHandle((com.supermap.data.InternalHandle)datasetMosaic) == 0L) {
            String string = InternalResource.loadString("addLayerMosaicGroup()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (datasetMosaic.getFootprintDataset() == null) {
            String string = InternalResource.loadString("addLayerMosaicGroup()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("insertLayerMosaicGroup()", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        LayerMosaicGroup layerMosaicGroup = this.addMosaicGroup(datasetMosaic, true);
        if (layerMosaicGroup != null && !(bl = this.moveTo(0, index))) {
            this.remove(0);
            layerMosaicGroup = null;
        }
        if (layerMosaicGroup != null) {
            LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layerMosaicGroup);
            this.fireLayerAdded(layerAddedEvent);
        }
        com.supermap.data.InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)layerMosaicGroup));
        return layerMosaicGroup;
    }

    void removeAllDrawReleatedListeners() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeAllDrawReleatedListeners", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layerDrawingListeners != null && !this.m_layerDrawingListeners.isEmpty()) {
            this.m_layerDrawingListeners.clear();
            LayersNative.jni_SetEnableLayerDrawingCallback(this.getHandle(), null, true);
        }
        if (this.m_layerDrawnListeners != null && this.m_layerDrawnListeners.isEmpty()) {
            this.m_layerDrawnListeners.clear();
            LayersNative.jni_SetEnableLayerDrawnCallback(this.getHandle(), null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer add(Dataset dataset, boolean addToHead, int extensionTypeWhenCreateLayer) {
        Layer layer = null;
        try {
            long l;
            this.m_lock.lock();
            LayersNative.jni_SetExtensionTypeWhenCreateLayer(this.getHandle(), extensionTypeWhenCreateLayer);
            if (this.getHandle() == 0L) {
                LayersNative.jni_SetExtensionTypeWhenCreateLayer(this.getHandle(), 0);
                String string = InternalResource.loadString("add(Dataset dataset, boolean addToHead)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (dataset == null) {
                LayersNative.jni_SetExtensionTypeWhenCreateLayer(this.getHandle(), 0);
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l2 == 0L) {
                LayersNative.jni_SetExtensionTypeWhenCreateLayer(this.getHandle(), 0);
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            if (dataset.getType().equals((Object)DatasetType.TABULAR)) {
                LayersNative.jni_SetExtensionTypeWhenCreateLayer(this.getHandle(), 0);
                String string = InternalResource.loadString("dataset", "Layers_TheTypeOfDatasetCanNotBeTABULAR", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            Workspace workspace = dataset.getDatasource().getWorkspace();
            Workspace workspace2 = this.m_map.getWorkspace();
            long l3 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
            if (l3 != (l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace2))) {
                LayersNative.jni_SetExtensionTypeWhenCreateLayer(this.getHandle(), 0);
                String string = InternalResource.loadString("dataset", "Layers_TheWorkspaceOfDatasetShouldBeTheSameAsMap", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l4 = LayersNative.jni_AddLayer(this.getHandle(), l2, addToHead);
            if (l4 != 0L) {
                layer = extensionTypeWhenCreateLayer == 10001 ? new LayerEPS(l4, this, this.m_map) : new Layer(l4, this, this.m_map);
                layer.reset();
                if (addToHead) {
                    this.m_layersList.add(0, layer);
                } else {
                    this.m_layersList.add(layer);
                }
                layer.getDataset();
                LayerAddedEvent layerAddedEvent = new LayerAddedEvent((Object)this, layer);
                this.fireLayerAdded(layerAddedEvent);
            }
        }
        finally {
            LayersNative.jni_SetExtensionTypeWhenCreateLayer(this.getHandle(), 0);
            this.m_lock.unlock();
        }
        return layer;
    }
}

