/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGridCollection;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetImageCollection;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.GeoCompound;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoText;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.TimeSpan;
import com.supermap.data.Workspace;
import com.supermap.mapping.ElementDrawingEvent;
import com.supermap.mapping.ElementDrawingListener;
import com.supermap.mapping.FieldValuesDisplayFilter;
import com.supermap.mapping.FillMarkerOrderMode;
import com.supermap.mapping.GridFunctionType;
import com.supermap.mapping.InternalDataset;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoCompound;
import com.supermap.mapping.InternalGeoRegion;
import com.supermap.mapping.InternalGeoText;
import com.supermap.mapping.InternalGeometry;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalMapControl;
import com.supermap.mapping.InternalQueryParameter;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.LayerCaptionChangedEvent;
import com.supermap.mapping.LayerCaptionChangedListener;
import com.supermap.mapping.LayerEditableChangedEvent;
import com.supermap.mapping.LayerEditableChangedListener;
import com.supermap.mapping.LayerExtensionPlugin;
import com.supermap.mapping.LayerExtensionPluginFactory;
import com.supermap.mapping.LayerGroup;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerSelectableChangedEvent;
import com.supermap.mapping.LayerSelectableChangedListener;
import com.supermap.mapping.LayerSetting;
import com.supermap.mapping.LayerSettingGrid;
import com.supermap.mapping.LayerSettingImage;
import com.supermap.mapping.LayerSettingNetCDF;
import com.supermap.mapping.LayerSettingType;
import com.supermap.mapping.LayerSettingVector;
import com.supermap.mapping.LayerSnapableChangedEvent;
import com.supermap.mapping.LayerSnapableChangedListener;
import com.supermap.mapping.LayerSnapshot;
import com.supermap.mapping.LayerType;
import com.supermap.mapping.LayerVisibleChangedEvent;
import com.supermap.mapping.LayerVisibleChangedListener;
import com.supermap.mapping.Layers;
import com.supermap.mapping.Map;
import com.supermap.mapping.Selection;
import com.supermap.mapping.Theme;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

public class Layer
extends com.supermap.data.InternalHandle {
    protected Layers m_layers = null;
    protected Map m_map = null;
    protected Selection m_selection = null;
    private Dataset m_dataset = null;
    private Theme m_theme = null;
    private LayerSetting m_layerSetting = null;
    private QueryParameter m_queryParameter = null;
    private GeoRegion m_clipRegion = null;
    private String[] m_valueExpressions = null;
    transient Vector m_elementDrawingListeners;
    @Deprecated
    transient Vector m_layerCaptionChangedListener;
    @Deprecated
    transient Vector m_layerSelectableChangedListener;
    @Deprecated
    transient Vector m_layerEditableChangedListener;
    @Deprecated
    transient Vector m_layerVisibleChangedListener;
    @Deprecated
    transient Vector m_layerSnapableChangedListener;
    protected long m_selfEventHandle = 0L;
    protected ReentrantLock m_lock;
    LayerGroup m_parentGroup;
    LayerSnapshot m_parentSnapshot;
    private Layer m_displayControledLayer;
    private FieldValuesDisplayFilter m_fieldFilter;
    private LayerExtensionPlugin m_extensionPlugin = null;

    public Layer() {
        this.m_displayControledLayer = null;
        this.m_fieldFilter = null;
        this.m_selfEventHandle = LayerNative.jni_NewSelfEventHandle(this);
    }

    Layer(long handle, Layers layers, Map map) {
        this.setHandle(handle);
        this.m_map = map;
        this.m_layers = layers;
        this.m_displayControledLayer = null;
        this.m_fieldFilter = null;
        this.m_selfEventHandle = LayerNative.jni_NewSelfEventHandle(this);
        this.m_lock = map.m_lock;
    }

    void setMap(Map map) {
        this.m_map = map;
        this.m_lock = map.m_lock;
    }

    public boolean isCompleteLineSymbolDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCompleteLineSymbolDisplayed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsCompleteLineSymbolDisplayed(this.getHandle());
    }

    public void setCompleteLineSymbolDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCompleteLineSymbolDisplayed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetCompleteLineSymbolDisplayed(this.getHandle(), value);
    }

    public boolean isClipRegionEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isClipRegionEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsClipRegionEnabled(this.getHandle());
    }

    public void setClipRegionEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegionEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        LayerNative.jni_SetClipRegionEnabled(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetName(this.getHandle());
    }

    public String getCaption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetCaption(this.getHandle());
    }

    public void setCaption(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCaption(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        String string = this.getCaption();
        LayerNative.jni_SetCaption(this.getHandle(), value);
        if (this.m_layers != null) {
            LayerCaptionChangedEvent layerCaptionChangedEvent = new LayerCaptionChangedEvent((Object)this, this, string, value);
            this.fireCaptionChanged(layerCaptionChangedEvent);
            this.m_layers.fireCaptionChanged(layerCaptionChangedEvent);
        }
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDescription(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        LayerNative.jni_SetDescription(this.getHandle(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset getDataset() {
        try {
            this.m_lock.lock();
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            long l = LayerNative.jni_GetDataset(this.getHandle());
            if (l != 0L) {
                Workspace workspace = this.m_map.getWorkspace();
                this.m_dataset = InternalToolkitMapping.toMangedDataset(workspace, l);
            } else {
                this.m_dataset = null;
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return this.m_dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString(" setDataset(Dataset dataset)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        try {
            this.m_lock.lock();
            boolean bl = false;
            if (dataset == null) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
            if (l == 0L) {
                String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            boolean bl2 = bl = dataset.getDatasource().getWorkspace() == this.m_map.getWorkspace();
            if (!bl) {
                String string = InternalResource.loadString("setDataset(Dataset dataset)", "Layer_WorkspaceNoContainTheDataset(-100~100)", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = LayerNative.jni_SetDataset(this.getHandle(), l);
            if (this.getHandle() != l2) {
                this.setHandle(l2);
            }
            if (this.m_selection != null) {
                this.m_selection.clearHandle();
                this.m_selection = null;
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public QueryParameter getDisplayFilter() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayFilter()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_queryParameter == null && (l = LayerNative.jni_GetDisplayFilter(this.getHandle())) != 0L) {
            this.m_queryParameter = InternalQueryParameter.createInstance(l);
        }
        return this.m_queryParameter;
    }

    public void setDisplayFilter(QueryParameter queryParameter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayFilter(QueryParameter value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter == null) {
            String string = InternalResource.loadString("queryParameter", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)queryParameter);
        if (l == 0L) {
            String string = InternalResource.loadString("queryParameter", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        QueryParameter queryParameter2 = new QueryParameter(queryParameter);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)queryParameter2);
        this.m_lock.lock();
        LayerNative.jni_SetDisplayFilter(this.getHandle(), l2);
        InternalQueryParameter.identicalJavaObject(this.getDisplayFilter(), queryParameter2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)queryParameter2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)queryParameter);
        this.m_lock.unlock();
    }

    public LayerSetting getAdditionalSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAddtionalSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.getTheme() == null && this.m_layerSetting == null) {
            Dataset dataset = this.getDataset();
            if (dataset != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset) != 0L) {
                Class<?> clazz = dataset.getClass();
                if (clazz.equals(DatasetVector.class)) {
                    this.m_layerSetting = new LayerSettingVector(this, this.m_layers);
                } else if (clazz.equals(DatasetImage.class) || clazz.equals(DatasetImageCollection.class)) {
                    this.m_layerSetting = new LayerSettingImage(this, this.m_layers);
                } else if (clazz.equals(DatasetGrid.class) || clazz.equals(DatasetGridCollection.class)) {
                    this.m_layerSetting = new LayerSettingGrid(this, this.m_layers);
                }
            } else {
                this.m_layerSetting = new LayerSettingVector(this, this.m_layers);
            }
        }
        return this.m_layerSetting;
    }

    public void setAdditionalSetting(LayerSetting layerSetting) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAddtionalSetting(LayerSetting layerSetting)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.getAdditionalSetting() == null) {
            String string = InternalResource.loadString("setAddtionalSetting(LayerSetting layerSetting)", "Layer_UnsupportedOperationOfSetAdditionalSetting", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (layerSetting == null) {
            String string = InternalResource.loadString("layerSetting", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerSettingType layerSettingType = this.getAdditionalSetting().getType();
        if (layerSettingType.equals((Object)layerSetting.getType())) {
            if (layerSettingType.equals((Object)LayerSettingType.VECTOR)) {
                LayerSettingVector layerSettingVector = (LayerSettingVector)layerSetting;
                ((LayerSettingVector)this.m_layerSetting).setStyle(layerSettingVector.getStyle());
            } else if (layerSettingType.equals((Object)LayerSettingType.GRID)) {
                LayerSettingGrid layerSettingGrid = (LayerSettingGrid)layerSetting;
                ((LayerSettingGrid)this.m_layerSetting).setColorTable(layerSettingGrid.getColorTable());
                ((LayerSettingGrid)this.m_layerSetting).setColorDictionary(layerSettingGrid.getColorDictionary());
                ((LayerSettingGrid)this.m_layerSetting).setSpecialValueColor(layerSettingGrid.getSpecialValueColor());
                if (!((LayerSettingGrid)layerSetting).isOwnerLayer && !((LayerSettingGrid)layerSetting).is_set) {
                    ((LayerSettingGrid)this.m_layerSetting).setSpecialValue(((DatasetGrid)this.getDataset()).getNoValue());
                } else {
                    ((LayerSettingGrid)this.m_layerSetting).setSpecialValue(layerSettingGrid.getSpecialValue());
                }
                ((LayerSettingGrid)this.m_layerSetting).setBrightness(layerSettingGrid.getBrightness());
                ((LayerSettingGrid)this.m_layerSetting).setContrast(layerSettingGrid.getContrast());
                ((LayerSettingGrid)this.m_layerSetting).setOpaqueRate(layerSettingGrid.getOpaqueRate());
                ((LayerSettingGrid)this.m_layerSetting).setSpecialValueTransparent(layerSettingGrid.isSpecialValueTransparent());
                ((LayerSettingGrid)this.m_layerSetting).setImageInterpolationMode(layerSettingGrid.getImageInterpolationMode());
            } else if (layerSettingType.equals((Object)LayerSettingType.IMAGE)) {
                LayerSettingImage layerSettingImage = (LayerSettingImage)layerSetting;
                ((LayerSettingImage)this.m_layerSetting).setOpaqueRate(layerSettingImage.getOpaqueRate());
                ((LayerSettingImage)this.m_layerSetting).setTransparent(layerSettingImage.isTransparent());
                ((LayerSettingImage)this.m_layerSetting).setTransparentColor(layerSettingImage.getTransparentColor());
                ((LayerSettingImage)this.m_layerSetting).setBrightness(layerSettingImage.getBrightness());
                ((LayerSettingImage)this.m_layerSetting).setContrast(layerSettingImage.getContrast());
                ((LayerSettingImage)this.m_layerSetting).setTransparentColorTolerance(layerSettingImage.getTransparentColorTolerance());
                ((LayerSettingImage)this.m_layerSetting).setImageBackgroundReplace(layerSettingImage.isImageBackgroundReplace());
                ((LayerSettingImage)this.m_layerSetting).setBackgroundTransparent(layerSettingImage.isBackgroundTransparent());
                ((LayerSettingImage)this.m_layerSetting).setBackgroundColor(layerSettingImage.getBackgroundColor());
                ((LayerSettingImage)this.m_layerSetting).setBackgroundValue(layerSettingImage.getBackgroundValue());
                ((LayerSettingImage)this.m_layerSetting).setImageSpecialValueReplace(layerSettingImage.isImageSpecialValueReplace());
                ((LayerSettingImage)this.m_layerSetting).setSpecialValue(layerSettingImage.getSpecialValue());
                ((LayerSettingImage)this.m_layerSetting).setSpecialValueColor(layerSettingImage.getSpecialValueColor());
                ((LayerSettingImage)this.m_layerSetting).setSpecialValueTransparent(layerSettingImage.isSpecialValueTransparent());
                ((LayerSettingImage)this.m_layerSetting).setColorDictionary(layerSettingImage.getColorDictionary());
                if (layerSettingImage.getDisplayBandIndexes() != null) {
                    ((LayerSettingImage)this.m_layerSetting).setDisplayColorSpace(layerSettingImage.getDisplayColorSpace());
                    ((LayerSettingImage)this.m_layerSetting).setDisplayBandIndexes(layerSettingImage.getDisplayBandIndexes());
                }
                ((LayerSettingImage)this.m_layerSetting).setImageInterpolationMode(layerSettingImage.getImageInterpolationMode());
            } else if (layerSettingType.equals((Object)LayerSettingType.NetCDF)) {
                LayerSettingNetCDF layerSettingNetCDF = (LayerSettingNetCDF)layerSetting;
                ((LayerSettingNetCDF)this.m_layerSetting).setColorTable(layerSettingNetCDF.getColorTable());
                ((LayerSettingNetCDF)this.m_layerSetting).setBrightness(layerSettingNetCDF.getBrightness());
                ((LayerSettingNetCDF)this.m_layerSetting).setContrast(layerSettingNetCDF.getContrast());
                ((LayerSettingNetCDF)this.m_layerSetting).setSpecialValueColor(layerSettingNetCDF.getSpecialValueColor());
                if (!((LayerSettingNetCDF)layerSetting).isOwnerLayer && !((LayerSettingNetCDF)layerSetting).is_set) {
                    ((LayerSettingNetCDF)this.m_layerSetting).setSpecialValue(((DatasetGrid)this.getDataset()).getNoValue());
                } else {
                    ((LayerSettingNetCDF)this.m_layerSetting).setSpecialValue(layerSettingNetCDF.getSpecialValue());
                }
                ((LayerSettingNetCDF)this.m_layerSetting).setOpaqueRate(layerSettingNetCDF.getOpaqueRate());
                ((LayerSettingNetCDF)this.m_layerSetting).setSpecialValueTransparent(layerSettingNetCDF.isSpecialValueTransparent());
                ((LayerSettingNetCDF)this.m_layerSetting).setXDimension(layerSettingNetCDF.getXDimension());
                ((LayerSettingNetCDF)this.m_layerSetting).setXStartIndex(layerSettingNetCDF.getXStartIndex());
                ((LayerSettingNetCDF)this.m_layerSetting).setXEndIndex(layerSettingNetCDF.getXEndIndex());
                ((LayerSettingNetCDF)this.m_layerSetting).setYDimension(layerSettingNetCDF.getYDimension());
                ((LayerSettingNetCDF)this.m_layerSetting).setYStartIndex(layerSettingNetCDF.getYStartIndex());
                ((LayerSettingNetCDF)this.m_layerSetting).setYEndIndex(layerSettingNetCDF.getYEndIndex());
                ((LayerSettingNetCDF)this.m_layerSetting).setOptionalDimension(layerSettingNetCDF.getOptionalDimension());
                ((LayerSettingNetCDF)this.m_layerSetting).setOptionalDimIndex(layerSettingNetCDF.getOptionalDimIndex());
            }
        } else {
            String string = InternalResource.loadString("layerSetting", "Layer_TheArgumentOfLayerSettingIsInvalidLayerSettingType", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public Theme getTheme() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTheme()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_theme == null && (l = LayerNative.jni_GetTheme(this.getHandle())) != 0L) {
            this.m_theme = Theme.createInstance(l, this);
        }
        return this.m_theme;
    }

    public Selection getSelection() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelection()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Dataset dataset = this.getDataset();
        if (InternalDataset.getIsVector(dataset) && this.m_selection == null && (l = LayerNative.jni_GetSelection(this.getHandle())) != 0L) {
            this.m_selection = new Selection(l, this);
        }
        return this.m_selection;
    }

    public void setSelection(Selection selection) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSelection(Selection selection)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (selection == null) {
            String string = InternalResource.loadString("selection", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)selection) == 0L) {
            String string = InternalResource.loadString("selection", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.getDataset());
        if (selection.getDataset() == null) {
            String string = InternalResource.loadString("selection", "Layer_TheDatasetOfSelectionShouldNotBeNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)selection.getDataset());
        if (l2 == 0L) {
            String string = InternalResource.loadString("selection", "Layer_TheDatasetOfSelectionHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (l != l2) {
            String string = InternalResource.loadString("selection", "Layer_TheDatasetShouldBeIdentical", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)selection);
        LayerNative.jni_SetSelection(this.getHandle(), l3, selection.isDefaultStyleEnabled());
        this.m_lock.unlock();
    }

    public boolean isSelectable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsSelectable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetSelectable(this.getHandle());
    }

    public void setSelectable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsSelectable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetSelectable(this.getHandle(), value);
        LayerSelectableChangedEvent layerSelectableChangedEvent = new LayerSelectableChangedEvent((Object)this, this, value);
        this.fireSelectableChanged(layerSelectableChangedEvent);
        this.m_layers.fireSelectableChanged(layerSelectableChangedEvent);
    }

    public boolean isSnapable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsSnapable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetIsSnapable(this.getHandle());
    }

    public void setSnapable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsSnapable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetIsSnapable(this.getHandle(), value);
        LayerSnapableChangedEvent layerSnapableChangedEvent = new LayerSnapableChangedEvent((Object)this, this, value);
        this.fireSnapableChanged(layerSnapableChangedEvent);
        this.m_layers.fireSnapableChanged(layerSnapableChangedEvent);
    }

    public boolean isSymbolScalable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsSymbolScalable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetIsSymbolScalable(this.getHandle());
    }

    public void setSymbolScalable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsSymbolScalable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetIsSymbolScalable(this.getHandle(), value);
    }

    public double getSymbolScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetSymbolScale(this.getHandle());
    }

    public void setSymbolScale(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("", "Layer_SymbolScaleShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerNative.jni_SetSymbolScale(this.getHandle(), value);
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetIsVisible(this.getHandle());
    }

    public void setVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetIsVisible(this.getHandle(), value);
        LayerVisibleChangedEvent layerVisibleChangedEvent = new LayerVisibleChangedEvent((Object)this, this, value);
        this.fireVisibleChanged(layerVisibleChangedEvent);
        this.m_layers.fireVisibleChanged(layerVisibleChangedEvent);
    }

    public boolean isAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetIsAntialias(this.getHandle());
    }

    public void setAntialias(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsAntialias(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetIsAntialias(this.getHandle(), value);
    }

    public double getMaxVisibleScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxVisibleScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetMaxVisibleScale(this.getHandle());
    }

    public void setMaxVisibleScale(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxVisibleScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Layer_MaxVisibleScaleShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerNative.jni_SetMaxVisibleScale(this.getHandle(), value);
    }

    public double getMinVisibleScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinVisibleScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetMinVisibleScale(this.getHandle());
    }

    public void setMinVisibleScale(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinVisibleScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Layer_MinVisibleScaleShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerNative.jni_SetMinVisibleScale(this.getHandle(), value);
    }

    public double getMinVisibleGeometrySize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinVisibleGeometrySize()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetMinVisibleGeometrySize(this.getHandle());
    }

    public void setMinVisibleGeometrySize(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinVisibleGeometrySize(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "Layer_MinVisibleGeometrySizeShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerNative.jni_SetMinVisibleGeometrySize(this.getHandle(), value);
    }

    public boolean isEditable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEditable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetIsEditable(this.getHandle());
    }

    public void setEditable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEditable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetIsEditable(this.getHandle(), 0, value);
        LayerEditableChangedEvent layerEditableChangedEvent = new LayerEditableChangedEvent((Object)this, this, value);
        this.fireEditableChanged(layerEditableChangedEvent);
        this.m_layers.fireEditableChanged(layerEditableChangedEvent);
    }

    public String[] getValueExpressions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getValueExpressions()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String[] stringArray = null;
        if (this.m_valueExpressions == null && this.getTheme() != null) {
            String string = LayerNative.jni_GetValueExpressions(this.getHandle());
            stringArray = InternalToolkitMapping.splitString(string, ";");
            this.m_valueExpressions = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_valueExpressions[i] = stringArray[i];
            }
        }
        return this.m_valueExpressions;
    }

    public void setValueExpressions(String[] value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setValueExpressions(String[] value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = new String[]{};
        }
        this.m_valueExpressions = new String[value.length];
        for (int i = 0; i < value.length; ++i) {
            this.m_valueExpressions[i] = value[i];
        }
        String string = ";";
        if (this.getTheme() != null) {
            string = InternalToolkitMapping.joinString(value, ";");
            LayerNative.jni_SetValueExpressions(this.getHandle(), string);
        }
    }

    public GeoRegion getClipRegion() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_clipRegion == null && (l = LayerNative.jni_GetClipRegion(this.getHandle())) != 0L) {
            this.m_clipRegion = (GeoRegion)InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_clipRegion, false);
            if (this.m_clipRegion.isEmpty()) {
                this.m_clipRegion = null;
            }
        }
        return this.m_clipRegion;
    }

    public void setClipRegion(GeoRegion geoRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegion(GeoRegion geoRegion)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoRegion == null) {
            LayerNative.jni_SetClipRegion(this.getHandle(), 0L);
            this.m_clipRegion = null;
        } else {
            long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
            if (l == 0L) {
                String string = InternalResource.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            LayerNative.jni_SetClipRegion(this.getHandle(), l);
            if (this.m_clipRegion != null) {
                this.m_clipRegion.fromXML(geoRegion.toXML());
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
    }

    public int getOpaqueRate() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOpaqueRate()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetOpaqueRate(this.getHandle());
    }

    public void setOpaqueRate(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOpaqueRate(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            value = 0;
        }
        if (value > 100) {
            value = 100;
        }
        LayerNative.jni_SetOpaqueRate(this.getHandle(), value);
    }

    public void setFillMarkerOrder(FillMarkerOrderMode value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillMarkerOrder(FillMarkerOrderMode fillMarkerOrderMode)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(value);
        LayerNative.jni_SetFillMarkerOrderMode(this.getHandle(), n);
    }

    public FillMarkerOrderMode getFillMarkerOrder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillMarkerOrderMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = LayerNative.jni_GetFillMarkerOrderMode(this.getHandle());
        return n == 0 ? FillMarkerOrderMode.LayerTopLeft : FillMarkerOrderMode.GeometryTopLeft;
    }

    public boolean removeThemeElementPosition(int geometryID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeThemeElementPosition(int geometryID)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_RemoveThemeElementPosition(this.getHandle(), geometryID);
    }

    public Point2D getThemeElementPosition(int geometryID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getThemeElementPosition(int geometryID)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        LayerNative.jni_GetThemeElementPosition(this.getHandle(), geometryID, dArray);
        Point2D point2D = new Point2D();
        point2D.setX(dArray[0]);
        point2D.setY(dArray[1]);
        return point2D;
    }

    public void setThemeElementPosition(int geometryID, Point2D position) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setThemeElementPosition(int geometryID, Point2D position)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double d = position.getX();
        double d2 = position.getY();
        LayerNative.jni_SetThemeElementPosition(this.getHandle(), geometryID, d, d2);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        LayerNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void clearThemeElementPositions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clearThemeElementPositions()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_ClearThemeElementPositions(this.getHandle());
    }

    public boolean hitTest(Point2D pt, double tolerance, ArrayList<GeoText> testResult) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D pt, double tolerance, ArrayList<GeoText> testResult)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
        if (testResult == null) {
            testResult = new ArrayList();
        } else {
            testResult.clear();
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Layer_InvalidTolerance", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map);
        String string = "";
        long[] lArray = LayerNative.jni_GetGeoTextHitTest(this.getHandle(), pt.getX(), pt.getY(), tolerance, l, string);
        boolean bl = false;
        if (lArray != null && lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                GeoText geoText = InternalGeoText.createInstance(lArray[i]);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoText, true);
                testResult.add(geoText);
            }
            bl = true;
        }
        return bl;
    }

    public boolean hitTest(Point2D pt, double tolerance, String resultExpression, ArrayList<GeoText> testResult) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D pt, double tolerance, String resultExpression, ArrayList<GeoText> testResult)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (testResult == null) {
            String string = InternalResource.loadString("testResult", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string);
        }
        InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
        testResult.clear();
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Layer_InvalidTolerance", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map);
        long[] lArray = LayerNative.jni_GetGeoTextHitTest(this.getHandle(), pt.getX(), pt.getY(), tolerance, l, resultExpression);
        boolean bl = false;
        if (lArray != null && lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                GeoText geoText = InternalGeoText.createInstance(lArray[i]);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoText, true);
                testResult.add(geoText);
            }
            bl = true;
        }
        return bl;
    }

    public boolean hitTestGeoCompound(Point2D pt, double tolerance, String resultExpression, ArrayList<GeoCompound> testResult) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D pt, double tolerance, String resultExpression, ArrayList<GeoText> testResult)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (testResult == null) {
            String string = InternalResource.loadString("testResult", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string);
        }
        InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
        testResult.clear();
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "Layer_InvalidTolerance", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map);
        long[] lArray = LayerNative.jni_GetGeoCompoundHitTest(this.getHandle(), pt.getX(), pt.getY(), tolerance, l, resultExpression);
        boolean bl = false;
        if (lArray != null && lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                GeoCompound geoCompound = InternalGeoCompound.createInstance(lArray[i]);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoCompound, true);
                testResult.add(geoCompound);
            }
            bl = true;
        }
        return bl;
    }

    public Selection hitTest(Point2D point, double tolerance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D point, double tolerance)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        InternalMapControl.waitDrawingCompleted(this.m_map.getMapControl());
        Dataset dataset = this.getDataset();
        Selection selection = null;
        if (InternalDataset.getIsVector(dataset)) {
            if (tolerance < 0.0) {
                String string = InternalResource.loadString("tolerance", "Layer_InvalidTolerance", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map);
            long l2 = LayerNative.jni_HitTest(this.getHandle(), point.getX(), point.getY(), tolerance, l);
            if (l2 != 0L) {
                selection = new Selection(l2, this);
                InternalHandleDisposable.setIsDisposable(selection, true);
            }
        }
        return selection;
    }

    public boolean isVisibleScale(double dScale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVisibleScale(double dScale)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsVisibleScale(this.getHandle(), dScale);
    }

    public String getRepresentationField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRepresentationField()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetRepresentationField(this.getHandle());
    }

    public void setRepresentationField(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRepresentationField(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        LayerNative.jni_SetRepresentationField(this.getHandle(), value);
    }

    public boolean isRepresentationEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isRepresentationEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsRepresentationEnabled(this.getHandle());
    }

    public void setRepresentationEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRepresentationEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetRepresentationEnabled(this.getHandle(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetVector themeToDatasetVector(Datasource datasource, String datasetName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("themeToDatasetVector(Datasource datasource, String datasetName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (l == 0L) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(datasetName)) {
            String string = InternalResource.loadString("datasetName", "Layer_ArgumentOfDatasetNameIsIllegal", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVector datasetVector = null;
        try {
            this.m_lock.lock();
            if (this.getTheme() != null) {
                DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo(datasetName, DatasetType.CAD);
                datasetVector = datasource.getDatasets().create(datasetVectorInfo);
                long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
                long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map);
                if (this.m_map.getViewBounds().equals(new Rectangle2D(0.0, 0.0, 0.0, 0.0))) {
                    this.m_map.setViewBounds(this.getDataset().getBounds());
                }
                double d = this.m_map.getImageSize().getWidth();
                double d2 = this.m_map.getImageSize().getHeight();
                if (d < 2.0 && d2 < 2.0) {
                    this.m_map.setImageSize(new Dimension(256, 256));
                } else {
                    this.m_map.setImageSize(new Dimension((int)d, (int)d2));
                }
                boolean bl = false;
                if (l2 != 0L && l3 != 0L) {
                    bl = LayerNative.jni_ThemeToDatasetVector(this.getHandle(), l2, l3);
                }
                if (!bl) {
                    datasource.getDatasets().delete(datasetName);
                    datasetVector = null;
                }
                this.m_map.setImageSize(new Dimension((int)d, (int)d2));
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return datasetVector;
    }

    @Deprecated
    public Geometry[] themeSymbolsToGeometrys(Recordset recordset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("themeSymbolsToGeometrys(Recordset recordset)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l == 0L) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_map);
        if (l2 == 0L) {
            String string = InternalResource.loadString("map", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = LayerNative.jni_ThemeSymbolsToGeometrys(this.getHandle(), l, l2);
        int n = lArray.length;
        Geometry[] geometryArray = new Geometry[n];
        for (int i = 0; i < n; ++i) {
            geometryArray[i] = InternalGeometry.createInstance(lArray[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        return geometryArray;
    }

    public Geometry[] themeSymbolsToGeometries(Recordset recordset) {
        return this.themeSymbolsToGeometrys(recordset);
    }

    @Deprecated
    public boolean isDiposed() {
        return this.isDisposed();
    }

    public boolean isDisposed() {
        boolean bl = false;
        if (this.getHandle() == 0L) {
            bl = true;
        }
        return bl;
    }

    protected void clearHandle() {
        this.m_lock.lock();
        if (this.m_selection != null) {
            this.m_selection.clearHandle();
            this.m_selection = null;
        }
        if (this.m_queryParameter != null) {
            InternalQueryParameter.clearHandle(this.m_queryParameter);
            this.m_queryParameter = null;
        }
        if (this.m_layerSetting != null) {
            this.m_layerSetting.clearHandle();
            this.m_layerSetting = null;
        }
        if (this.m_dataset != null) {
            this.m_dataset = null;
        }
        if (this.m_theme != null) {
            this.m_theme.clearHandle();
            this.m_theme = null;
        }
        this.m_layers = null;
        this.m_map = null;
        if (this.m_selfEventHandle != 0L) {
            LayerNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
        if (this.m_clipRegion != null) {
            InternalGeoRegion.clearHandle(this.m_clipRegion);
            this.m_clipRegion = null;
        }
        this.setHandle(0L);
        if (this.m_fieldFilter != null) {
            this.m_fieldFilter.clearHandle();
        }
        this.m_lock.unlock();
    }

    void reset() {
        LayerNative.jni_Reset(this.getHandle());
    }

    public synchronized void addElementDrawingListener(ElementDrawingListener l) {
        if (this.m_elementDrawingListeners == null) {
            this.m_elementDrawingListeners = new Vector();
        }
        if (this.m_elementDrawingListeners.isEmpty()) {
            LayerNative.jni_RegisterElementDrawingCallBack(this.getHandle(), this.m_selfEventHandle);
        }
        if (!this.m_elementDrawingListeners.contains(l)) {
            this.m_elementDrawingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeElementDrawingListener(ElementDrawingListener l) {
        if (this.m_elementDrawingListeners != null && this.m_elementDrawingListeners.contains(l)) {
            this.m_elementDrawingListeners.remove(l);
        }
        if (this.m_elementDrawingListeners == null || this.m_elementDrawingListeners.isEmpty()) {
            LayerNative.jni_UnRegisterElementDrawingCallBack(this.getHandle(), this.m_selfEventHandle);
        }
    }

    protected void fireElementDrawing(ElementDrawingEvent event) {
        if (this.m_elementDrawingListeners != null) {
            Vector vector = this.m_elementDrawingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                ((ElementDrawingListener)vector.elementAt(i)).elementDrawing(event);
            }
        }
    }

    @Deprecated
    public synchronized void addCaptionChangedListener(LayerCaptionChangedListener l) {
        if (this.m_layerCaptionChangedListener == null) {
            this.m_layerCaptionChangedListener = new Vector();
        }
        if (!this.m_layerCaptionChangedListener.contains(l)) {
            this.m_layerCaptionChangedListener.add(l);
        }
    }

    @Deprecated
    public synchronized void removeCaptionChangedListener(LayerCaptionChangedListener l) {
        if (this.m_layerCaptionChangedListener != null && this.m_layerCaptionChangedListener.contains(l)) {
            this.m_layerCaptionChangedListener.remove(l);
        }
    }

    @Deprecated
    protected void fireCaptionChanged(LayerCaptionChangedEvent event) {
        if (this.m_layerCaptionChangedListener != null) {
            Vector vector = this.m_layerCaptionChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerCaptionChangedListener)vector.elementAt(i)).captionChanged(event);
            }
        }
    }

    @Deprecated
    public synchronized void addSelectableChangedListener(LayerSelectableChangedListener l) {
        if (this.m_layerSelectableChangedListener == null) {
            this.m_layerSelectableChangedListener = new Vector();
        }
        if (!this.m_layerSelectableChangedListener.contains(l)) {
            this.m_layerSelectableChangedListener.add(l);
        }
    }

    @Deprecated
    public synchronized void removeSelectableChangedListener(LayerSelectableChangedListener l) {
        if (this.m_layerSelectableChangedListener != null && this.m_layerSelectableChangedListener.contains(l)) {
            this.m_layerSelectableChangedListener.remove(l);
        }
    }

    @Deprecated
    protected void fireSelectableChanged(LayerSelectableChangedEvent event) {
        if (this.m_layerSelectableChangedListener != null) {
            Vector vector = this.m_layerSelectableChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerSelectableChangedListener)vector.elementAt(i)).selectableChanged(event);
            }
        }
    }

    @Deprecated
    public synchronized void addEditableChangedListener(LayerEditableChangedListener l) {
        if (this.m_layerEditableChangedListener == null) {
            this.m_layerEditableChangedListener = new Vector();
        }
        if (!this.m_layerEditableChangedListener.contains(l)) {
            this.m_layerEditableChangedListener.add(l);
        }
    }

    @Deprecated
    public synchronized void removeEditableChangedListener(LayerEditableChangedListener l) {
        if (this.m_layerEditableChangedListener != null && this.m_layerEditableChangedListener.contains(l)) {
            this.m_layerEditableChangedListener.remove(l);
        }
    }

    @Deprecated
    protected void fireEditableChanged(LayerEditableChangedEvent event) {
        if (this.m_layerEditableChangedListener != null) {
            Vector vector = this.m_layerEditableChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerEditableChangedListener)vector.elementAt(i)).editableChanged(event);
            }
        }
    }

    @Deprecated
    public synchronized void addVisibleChangedListener(LayerVisibleChangedListener l) {
        if (this.m_layerVisibleChangedListener == null) {
            this.m_layerVisibleChangedListener = new Vector();
        }
        if (!this.m_layerVisibleChangedListener.contains(l)) {
            this.m_layerVisibleChangedListener.add(l);
        }
    }

    @Deprecated
    public synchronized void removeVisibleChangedListener(LayerVisibleChangedListener l) {
        if (this.m_layerVisibleChangedListener != null && this.m_layerVisibleChangedListener.contains(l)) {
            this.m_layerVisibleChangedListener.remove(l);
        }
    }

    @Deprecated
    protected void fireVisibleChanged(LayerVisibleChangedEvent event) {
        if (this.m_layerVisibleChangedListener != null) {
            Vector vector = this.m_layerVisibleChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerVisibleChangedListener)vector.elementAt(i)).visibleChanged(event);
            }
        }
    }

    @Deprecated
    public synchronized void addSnapableChangedListener(LayerSnapableChangedListener l) {
        if (this.m_layerSnapableChangedListener == null) {
            this.m_layerSnapableChangedListener = new Vector();
        }
        if (!this.m_layerSnapableChangedListener.contains(l)) {
            this.m_layerSnapableChangedListener.add(l);
        }
    }

    @Deprecated
    public synchronized void removeSnapableChangedListener(LayerSnapableChangedListener l) {
        if (this.m_layerSnapableChangedListener != null && this.m_layerSnapableChangedListener.contains(l)) {
            this.m_layerSnapableChangedListener.remove(l);
        }
    }

    @Deprecated
    protected void fireSnapableChanged(LayerSnapableChangedEvent event) {
        if (this.m_layerSnapableChangedListener != null) {
            Vector vector = this.m_layerSnapableChangedListener;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((LayerSnapableChangedListener)vector.elementAt(i)).snapableChanged(event);
            }
        }
    }

    static void elementDrawingCallBack(Layer layer, long geometryHandle, Object[] fieldValues, long elementHandle, long cancelHandle) {
        if (layer != null) {
            Geometry geometry = null;
            if (geometryHandle != 0L) {
                geometry = InternalGeometry.createInstance(geometryHandle);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, false);
            }
            GeoCompound geoCompound = null;
            if (elementHandle != 0L) {
                geoCompound = InternalGeoCompound.createInstance(elementHandle);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoCompound, false);
            }
            Boolean bl = false;
            if (cancelHandle != 0L) {
                bl = InternalToolkitMapping.getHandleBooleanValue(cancelHandle);
            }
            ElementDrawingEvent elementDrawingEvent = new ElementDrawingEvent((Object)layer, geoCompound, geometry, fieldValues, bl);
            layer.fireElementDrawing(elementDrawingEvent);
            if (cancelHandle != 0L) {
                InternalToolkitMapping.setHandleBooleanValue(cancelHandle, elementDrawingEvent.getCancel());
            }
        }
    }

    public boolean isCrossroadOptimized() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCrossroadOptimized()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsCrossroadOptimized(this.getHandle());
    }

    public void setCrossroadOptimized(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCrossroadOptimized(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetCrossroadOptimized(this.getHandle(), value);
    }

    public void setExternalInfo(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExternalInfo(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetExternalInfo(this.getHandle(), value);
    }

    public String getExternalInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExternalInfo()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetExternalInfo(this.getHandle());
    }

    public LayerGroup getParentGroup() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParentGroup()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_parentGroup;
    }

    public LayerSnapshot getParentSnapshot() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParentSnapshot()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this.m_parentSnapshot;
    }

    void setParentGroup(LayerGroup parentGroup) {
        this.m_parentGroup = parentGroup;
    }

    void setParentSnapshot(LayerSnapshot parentSnapshot) {
        this.m_parentSnapshot = parentSnapshot;
    }

    public boolean setDisplayControledLayer(Layer layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayControledLayer(Layer layer)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = true;
        bl = layer != null ? LayerNative.jni_SetDisplayControledLayer(this.getHandle(), layer.getHandle()) : LayerNative.jni_SetDisplayControledLayer(this.getHandle(), 0L);
        this.m_displayControledLayer = layer;
        return bl;
    }

    public Layer getDisplayControledLayer() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayControledLayer()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_displayControledLayer == null && (l = LayerNative.jni_GetDisplayControledLayer(this.getHandle())) != 0L) {
            this.m_displayControledLayer = this.m_layers.findLayer(l);
        }
        return this.m_displayControledLayer;
    }

    public Layer findLayer(String layerName) {
        if (this.getName().equals(layerName)) {
            return this;
        }
        return null;
    }

    Layer findLayer(long handle) {
        if (this.getHandle() == handle) {
            return this;
        }
        return null;
    }

    public FieldValuesDisplayFilter getFieldValuesDisplayFilter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFieldValuesDisplayFilter()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_fieldFilter == null) {
            this.m_fieldFilter = new FieldValuesDisplayFilter(this.getHandle());
        }
        return this.m_fieldFilter;
    }

    public LayerType getSubLayerType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSubLayerType()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = LayerNative.jni_GetSubType(this.getHandle());
        return (LayerType)InternalEnum.parseUGCValue(LayerType.class, n);
    }

    void getContainedLayers(ArrayList<Layer> allLayers, boolean isVisibleOnly) {
        if (!isVisibleOnly || this.isVisible()) {
            allLayers.add(this);
        }
    }

    public java.util.Map<String, Object> getExtensionUserInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExtensionUserInfo()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = LayerNative.jni_GetExtensionUserInfoCount(this.getHandle());
        HashMap<String, Integer> hashMap = null;
        if (n > 0) {
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            LayerNative.jni_GetExtensionUserInfo(this.getHandle(), stringArray, stringArray2);
            hashMap = new HashMap<String, Integer>();
            Object object = null;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                String string2 = stringArray2[i];
                int n2 = string.indexOf(":");
                if (n2 < 0) continue;
                String string3 = string.substring(0, n2);
                String string4 = string.substring(n2 + 1);
                if (string4.equalsIgnoreCase("Int32") || string4.equalsIgnoreCase("int")) {
                    object = Integer.parseInt(string2);
                } else if (string4.equalsIgnoreCase("Double")) {
                    object = Double.parseDouble(string2);
                } else if (string4.equalsIgnoreCase("String")) {
                    object = string2;
                } else if (string4.equalsIgnoreCase("Boolean")) {
                    object = Boolean.parseBoolean(string2);
                } else if (string4.equalsIgnoreCase("Byte")) {
                    object = Byte.parseByte(string2);
                } else if (string4.equalsIgnoreCase("Color")) {
                    object = new Color(Integer.parseInt(string2));
                } else if (string4.equalsIgnoreCase("Int64")) {
                    object = Long.parseLong(string2);
                } else if (string4.equalsIgnoreCase("Int16")) {
                    object = Short.parseShort(string2);
                } else if (string4.equalsIgnoreCase("Single")) {
                    object = Double.parseDouble(string2);
                }
                hashMap.put(string, (Integer)object);
            }
        }
        return hashMap;
    }

    public void setExtensionUserInfo(java.util.Map<String, Object> map) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExtensionUserInfo(java.util.Map<String, String> map)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (map == null) {
            LayerNative.jni_SetExtensionUserInfo(this.getHandle(), null, null);
        } else {
            Object[] objectArray = map.keySet().toArray();
            int n = objectArray.length;
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)objectArray[i];
                stringArray2[i] = (String)map.get(stringArray[i].toString());
            }
            LayerNative.jni_SetExtensionUserInfo(this.getHandle(), stringArray, stringArray2);
        }
    }

    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExtensionUserInfo(java.util.Map<String, String> map)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (xml == null || xml.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return LayerNative.jni_FromXML(this.getHandle(), xml);
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExtensionUserInfo(java.util.Map<String, String> map)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.isDisposed()) {
            String string = InternalResource.loadString("Layer_AddLayerToLayersFirst)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return LayerNative.jni_ToXML(this.getHandle());
    }

    public static LayerType getSubType(long layerHndle) {
        int n = LayerNative.jni_GetSubType(layerHndle);
        return (LayerType)InternalEnum.parseUGCValue(LayerType.class, n);
    }

    public int addGridFunction(GridFunctionType type, java.util.Map<String, String> args) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addGridFunction(GridFunctionType type, java.util.Map<String, String> args)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (args == null || args.isEmpty()) {
            return LayerNative.jni_AddGridFunction(this.getHandle(), type.value(), null, null);
        }
        String[] stringArray = new String[args.size()];
        String[] stringArray2 = new String[args.size()];
        args.keySet().toArray(stringArray);
        args.values().toArray(stringArray2);
        return LayerNative.jni_AddGridFunction(this.getHandle(), type.value(), stringArray, stringArray2);
    }

    public void removeGridFunction(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeGridFunction(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_RemoveGridFunction(this.getHandle(), index);
    }

    public GridFunctionType getGridFunctionType(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridFunctionType(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = LayerNative.jni_GetGridFunctionType(this.getHandle(), index);
        return new GridFunctionType(n, n);
    }

    public java.util.Map<String, String> getGridFunctionArgs(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridFunctionArgs(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = LayerNative.jni_GetGridFunctionArgsCount(this.getHandle(), index);
        if (n > 0) {
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            LayerNative.jni_GetGridFunctionArgs(this.getHandle(), index, stringArray, stringArray2);
            for (int i = 0; i < n; ++i) {
                hashMap.put(stringArray[i], stringArray2[i]);
            }
        }
        return hashMap;
    }

    public int getGridFunctonCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGridFunctonCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetGridFunctonCount(this.getHandle());
    }

    public boolean IsTimeFilterEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsTimeFilterEnable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsTimeFilterEnable(this.getHandle());
    }

    public void setTimeFilterEnable(boolean bEnable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeFilterEnable(boolean bEnable)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetTimeFilterEnable(this.getHandle(), bEnable);
    }

    public String getTimeStartField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimeStartField()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetStartTimeField(this.getHandle());
    }

    public void setTimeStartField(String strField) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeStartField(String strField)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetStartTimeField(this.getHandle(), strField);
    }

    public String getTimeEndField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimeEndField()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetEndTimeField(this.getHandle());
    }

    public void setTimeEndField(String strField) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeEndField(String strField)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetEndTimeField(this.getHandle(), strField);
    }

    public Date getTimeFilterStarting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimeFilterStarting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = LayerNative.jni_GetStartFilterTime(this.getHandle());
        String[] stringArray = string.trim().split(" ");
        String[] stringArray2 = stringArray[0].trim().split("-");
        String[] stringArray3 = stringArray[1].trim().split(":");
        int n = Integer.parseInt(stringArray2[0]);
        int n2 = Integer.parseInt(stringArray2[1]);
        int n3 = Integer.parseInt(stringArray2[2]);
        int n4 = Integer.parseInt(stringArray3[0]);
        int n5 = Integer.parseInt(stringArray3[1]);
        int n6 = Integer.parseInt(stringArray3[2]);
        Date date = new Date(n - 1900, n2 - 1, n3, n4, n5, n6);
        return date;
    }

    public void setTimeFilterStarting(Date startTime) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeFilterStarting(Date startTime)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = String.format("%1$tY-%1$tm-%1$td %1$tT", startTime);
        LayerNative.jni_SetStartFilterTime(this.getHandle(), string);
    }

    public Date getTimeFilterEnding() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimeFilterEnding()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = LayerNative.jni_GetEndFilterTime(this.getHandle());
        String[] stringArray = string.trim().split(" ");
        String[] stringArray2 = stringArray[0].trim().split("-");
        String[] stringArray3 = stringArray[1].trim().split(":");
        int n = Integer.parseInt(stringArray2[0]);
        int n2 = Integer.parseInt(stringArray2[1]);
        int n3 = Integer.parseInt(stringArray2[2]);
        int n4 = Integer.parseInt(stringArray3[0]);
        int n5 = Integer.parseInt(stringArray3[1]);
        int n6 = Integer.parseInt(stringArray3[2]);
        Date date = new Date(n - 1900, n2 - 1, n3, n4, n5, n6);
        return date;
    }

    public void setTimeFilterEnding(Date endTime) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeFilterEnding(Date endTime)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = String.format("%1$tY-%1$tm-%1$td %1$tT", endTime);
        LayerNative.jni_SetEndFilterTime(this.getHandle(), string);
    }

    public TimeSpan getTimeStepInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimeStepInterval()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        TimeSpan timeSpan = new TimeSpan();
        timeSpan.setTimeSpan(LayerNative.jni_GetTimeStep(this.getHandle()));
        return timeSpan;
    }

    public void setTimeStepInterval(TimeSpan timeSpan) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeStepInterval(TimeSpan timeSpan)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = timeSpan.getTimeSpan();
        LayerNative.jni_SetTimeStep(this.getHandle(), l);
    }

    public void setSwipeEnabled(Boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSwipeEnabled", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetSwipeEnabled(this.getHandle(), value);
    }

    public Boolean isSwipeEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSwipeEnabled", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsSwipeEnabled(this.getHandle());
    }

    public void setDeduplicateEnabled(Boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDeduplicateEnabled", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetDeduplicateEnabled(this.getHandle(), value);
    }

    public Boolean isDeduplicateEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDeduplicateEnabled", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsDeduplicateEnabled(this.getHandle());
    }

    public void setDeduplicateTolerance(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDeduplicateTolerance", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetDeduplicateTolerance(this.getHandle(), value);
    }

    public double getDeduplicateTolerance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDeduplicateTolerance", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetDeduplicateTolerance(this.getHandle());
    }

    public void setDeduplicateThreshold(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDeduplicateThreshold", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetDeduplicateThreshold(this.getHandle(), value);
    }

    public int getDeduplicateThreshold() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDeduplicateThreshold", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetDeduplicateThreshold(this.getHandle());
    }

    public boolean isOverlapDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetIsOverlapDisplayed(this.getHandle());
    }

    public void setOverlapDisplayed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetIsOverlapDisplayed(this.getHandle(), value);
    }

    public void setOverlapGeometryEnabled(Boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OverlapGeometryEnabled", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetOverlapGeometryEnabled(this.getHandle(), value);
    }

    public Boolean isOverlapGeometryEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("OverlapGeometryEnabled", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsOverlapGeometryEnabled(this.getHandle());
    }

    public void setOverlapGeometryThreshold(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapGeometryThreshold", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetOverlapGeometryThreshold(this.getHandle(), value);
    }

    public double getOverlapGeometryThreshold() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOverlapGeometryThreshold", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetOverlapGeometryThreshold(this.getHandle());
    }

    public void setOverlapGeometryPixel(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapGeometryPixel", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetOverlapGeometryPixel(this.getHandle(), value);
    }

    public int getOverlapGeometryPixel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOverlapGeometryPixel", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetOverlapGeometryPixel(this.getHandle());
    }

    protected void setTheme(Theme theme) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTheme(Theme theme)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (theme == null) {
            String string = InternalResource.loadString("setTheme(Theme theme)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.getTheme() != null) {
            String string = InternalResource.loadString("setTheme(Theme theme)", "Global_SpecifiedNameAlreadyExist", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)theme);
        LayerNative.jni_SetTheme(this.getHandle(), l);
        this.m_theme = theme;
        this.m_theme.m_layer = this;
        this.m_theme.m_lock = this.m_lock;
    }

    protected void setExtensionPlugin(LayerExtensionPlugin plugin) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExtensionPlugin(LayerExtensionPlugin plugin)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        String string = plugin == null ? "" : plugin.getPluginName();
        LayerNative.jni_SetExtensionPluginName(this.getHandle(), string);
        this.m_extensionPlugin = plugin;
    }

    public LayerExtensionPlugin getExtensionPlugin() {
        if (this.m_extensionPlugin == null) {
            if (this.getHandle() == 0L) {
                String string = InternalResource.loadString("getExtensionPlugin()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            String string = LayerNative.jni_GetExtensionPluginName(this.getHandle());
            if (!string.isEmpty()) {
                HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
                hashMap.put(LayerExtensionPluginFactory.PLUGIN_NAME.name, (Serializable)((Object)string));
                try {
                    this.m_extensionPlugin = LayerExtensionPluginFactory.getPlugin(hashMap);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return this.m_extensionPlugin;
    }

    public boolean isLayerCacheEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOverlapGeometryPixel", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsLayerCacheEnabled(this.getHandle());
    }

    public void SetLayerCacheEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOverlapGeometryPixel", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetLayerCacheEnabled(this.getHandle(), value);
    }

    public boolean isModified() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsModified()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_GetIsModified(this.getHandle());
    }

    public void setModified(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setModified(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetIsModified(this.getHandle(), value);
    }

    public boolean isFullLabelEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFullLabelEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LayerNative.jni_IsFullLabelEnabled(this.getHandle());
    }

    public void setFullLabelEnabled(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFullLabelEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        LayerNative.jni_SetFullLabelEnabled(this.getHandle(), value);
    }
}

