/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.LabelAvoidWeightInfosNative;

public class LabelAvoidWeightInfos
extends InternalHandleDisposable {
    LabelAvoidWeightInfos(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
    }

    LabelAvoidWeightInfos() {
        long l = LabelAvoidWeightInfosNative.jni_New();
        this.setHandle(l, true);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            LabelAvoidWeightInfosNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    boolean setLayerGeoWeight(String layerName, int weight) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLayerGeoWeight(String layerName, int weight)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layerName == null || layerName.isEmpty()) {
            String string = InternalResource.loadString("layerName", "Layer_ArgumentOfDatasetNameIsIllegal", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (weight < 0 || weight > 1000) {
            String string = InternalResource.loadString("weight", "LayerFeatureWeightIsIllegal", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return LabelAvoidWeightInfosNative.jni_SetGeoWeight(this.getHandle(), layerName, weight);
    }

    boolean setRgnBorderWeight(String layerName, int weight) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRgnBorderWeight(String layerName, int weight)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layerName == null || layerName.isEmpty()) {
            String string = InternalResource.loadString("layerName", "Layer_ArgumentOfDatasetNameIsIllegal", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (weight < 0 || weight > 1000) {
            String string = InternalResource.loadString("weight", "LayerFeatureWeightIsIllegal", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return LabelAvoidWeightInfosNative.jni_SetRgnBorderWeight(this.getHandle(), layerName, weight);
    }

    public int getLayerGeoWeight(String layerName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLayerGeoWeight(String layerName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layerName == null || layerName.isEmpty()) {
            String string = InternalResource.loadString("layerName", "Layer_ArgumentOfDatasetNameIsIllegal", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return LabelAvoidWeightInfosNative.jni_GetGeoWeight(this.getHandle(), layerName);
    }

    public int getRgnBorderWeight(String layerName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRgnBorderWeight(String layerName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layerName == null || layerName.isEmpty()) {
            String string = InternalResource.loadString("layerName", "Layer_ArgumentOfDatasetNameIsIllegal", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return LabelAvoidWeightInfosNative.jni_GetRgnBorderWeight(this.getHandle(), layerName);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRgnBorderWeight(String layerName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return LabelAvoidWeightInfosNative.jni_GetCount(this.getHandle());
    }
}

