/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.mapping.BookMark;
import com.supermap.mapping.BookMarksNative;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Map;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class BookMarks
extends InternalHandle {
    private ArrayList<BookMark> m_listBookMarks;
    private Map m_map;
    ReentrantLock m_lock;

    BookMarks(long handle, Map map) {
        this.setHandle(handle);
        this.m_map = map;
        this.m_lock = this.m_map.m_lock;
        this.m_listBookMarks = new ArrayList();
        this.refreshItemList();
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return BookMarksNative.jni_GetCount(this.getHandle());
    }

    public int add(BookMark bookMark) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (bookMark == null) {
            String string = InternalResource.loadString("bookMark", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)bookMark);
        if (l == 0L) {
            String string = InternalResource.loadString("bookMark", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        if (this.indexOf(bookMark) > -1) {
            return n;
        }
        n = BookMarksNative.jni_Add(this.getHandle(), l);
        if (n > -1) {
            InternalHandleDisposable.setIsDisposable(bookMark, false);
            this.m_listBookMarks.add(bookMark);
        }
        return n;
    }

    public boolean insert(int index, BookMark bookMark) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (bookMark == null) {
            String string = InternalResource.loadString("bookMark", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)bookMark);
        if (l == 0L) {
            String string = InternalResource.loadString("bookMark", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(bookMark) > -1) {
            return false;
        }
        boolean bl = BookMarksNative.jni_Insert(this.getHandle(), index, l);
        if (bl) {
            InternalHandleDisposable.setIsDisposable(bookMark, false);
            this.m_listBookMarks.add(index, bookMark);
        }
        return bl;
    }

    public BookMark get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_listBookMarks.get(index);
    }

    public BookMark get(String name) {
        if (name == null || name.equals("")) {
            String string = InternalResource.loadString("bookMark", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.indexOf(name);
        return this.m_listBookMarks.get(n);
    }

    public boolean set(int index, BookMark bookMark) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (bookMark == null) {
            String string = InternalResource.loadString("bookMark", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)bookMark);
        if (BookMarksNative.jni_Set(this.getHandle(), index, l)) {
            BookMark bookMark2 = this.get(index);
            InternalHandleDisposable.setIsDisposable(bookMark2, true);
            this.m_listBookMarks.set(index, bookMark);
            return true;
        }
        return false;
    }

    public int indexOf(BookMark bookMark) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (bookMark == null) {
            String string = InternalResource.loadString("bookMark", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)bookMark);
        if (l == 0L) {
            String string = InternalResource.loadString("bookMark", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_listBookMarks.indexOf((Object)bookMark);
    }

    public int indexOf(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            String string = InternalResource.loadString("bookMark", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return BookMarksNative.jni_IndexOf(this.getHandle(), name);
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (BookMarksNative.jni_Remove(this.getHandle(), index)) {
            BookMark bookMark = this.m_listBookMarks.get(index);
            InternalHandleDisposable.setIsDisposable(bookMark, true);
            this.m_listBookMarks.remove(index);
            return true;
        }
        return false;
    }

    public boolean remove(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            String string = InternalResource.loadString("bookMark", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.indexOf(name);
        if (BookMarksNative.jni_Remove(this.getHandle(), name)) {
            BookMark bookMark = this.m_listBookMarks.get(n);
            InternalHandleDisposable.setIsDisposable(bookMark, true);
            this.m_listBookMarks.remove(n);
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        BookMarksNative.jni_RemoveAll(this.getHandle());
        if (this.m_listBookMarks != null) {
            for (BookMark bookMark : this.m_listBookMarks) {
                if (bookMark == null) continue;
                bookMark.clearHandle();
            }
            this.m_listBookMarks.clear();
        }
    }

    public boolean isAvailableName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isNameExisted(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            String string = InternalResource.loadString("isNameExisted", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return BookMarksNative.jni_IsAvailableName(this.getHandle(), name);
    }

    public String getAvailableName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isNameExisted(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            String string = InternalResource.loadString("isNameExisted", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return BookMarksNative.jni_GetAvailableName(this.getHandle(), name);
    }

    protected void refreshItemList() {
        for (BookMark bookMark : this.m_listBookMarks) {
            bookMark.clearHandle();
        }
        this.m_listBookMarks.clear();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            long l = BookMarksNative.jni_Get(this.getHandle(), i);
            BookMark bookMark = new BookMark(l);
            this.m_listBookMarks.add(bookMark);
        }
    }

    protected void cleanHandle() {
        if (this.m_listBookMarks != null) {
            for (BookMark bookMark : this.m_listBookMarks) {
                if (bookMark == null) continue;
                bookMark.clearHandle();
            }
            this.m_listBookMarks.clear();
        }
        this.setHandle(0L);
    }

    protected static BookMarks createInstance(long handle, Map map) {
        return new BookMarks(handle, map);
    }
}

