/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy;

import com.supermap.data.Workspace;
import com.supermap.jsuperpy.license.LoginResult;
import com.supermap.jsuperpy.license.PythonLicense;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class RegisterWorkspace {
    private static Workspace m_default;
    private static boolean m_createdByPython;

    private RegisterWorkspace() {
    }

    public static Workspace getWorkspace() {
        return m_default;
    }

    public static void setWorkspace(Workspace workspace) {
        m_default = workspace;
        m_createdByPython = false;
    }

    public static Workspace newPythonWorkspace() {
        LoginResult licResult = PythonLicense.check();
        if (licResult.code() != LoginResult.OK().code()) {
            throw new RuntimeException(licResult.message());
        }
        m_default = new Workspace();
        String caption = RegisterWorkspace.getUniqueName("workspace");
        m_default.setCaption(caption);
        m_createdByPython = true;
        System.out.println(RegisterWorkspace.now() + ": Create new workspace object from python side: " + caption);
        return m_default;
    }

    public static boolean isCreatedByPython() {
        return m_createdByPython;
    }

    public static boolean closeWorkspace() {
        if (m_default != null) {
            try {
                String caption = m_default.getCaption();
                m_default.close();
                m_default = null;
                System.out.println(RegisterWorkspace.now() + ": close workspace : " + caption);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean closePythonWorkspace() {
        if (RegisterWorkspace.isCreatedByPython()) {
            return RegisterWorkspace.closeWorkspace();
        }
        return false;
    }

    private static String now() {
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(now);
    }

    private static String getUniqueName(String caption) {
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("MMddHH");
        return String.format("%s_%s_%d", caption, df.format(now), Thread.currentThread().getId());
    }

    static {
        m_createdByPython = false;
    }
}

